/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.AliasMapper;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.OutgoingMailHeaderMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.mail.MailAttachment;
import com.inet.helpdesk.core.mail.MailUtilities;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.mail.reader.EmailReader_HDProcessing;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.api.EmailAddressUtils;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.MailDataSource;
import com.inet.mail.api.MailEncryption;
import com.inet.persistence.PersistenceEntry;
import com.inet.usersandgroups.api.user.UserAccountScope;
import jakarta.mail.Address;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.mail.AutoMail;
import srv.mail.HelpDeskBaseEmail;
import srv.pool.ThreadPool;

public class Mail
extends HelpDeskBaseEmail
implements Runnable {
    public static final int AUTO_ESCALATION = 1;
    public static final int AUTORISIEREN = 2;
    public static final int AUTORISIEREN_USER_DEFAULT_CHANGE = 14;
    @Deprecated
    public static final int AUTORISIEREN2 = 15;
    public static final int MANU_ESCALATION = 3;
    public static final int BEENDEN = 4;
    public static final int BEENDEN_USER_DEFAULT_CHANGE = 16;
    public static final int WIEDERVORLAGE = 5;
    public static final int ANFRAGE = 6;
    public static final int ERROR = 7;
    public static final int AUTO_MAHNUNG = 8;
    public static final int AUTORISIEREN_RES = 9;
    public static final int SIGNIFICANT_CHANGE_RES = 10;
    public static final int ANFRAGEUSER = 20;
    public static final int ESCA_WARN_YELLOW = 21;
    public static final int ESCA_WARN_RED = 22;
    public static final int DEAD_WARN_YELLOW = 23;
    public static final int DEAD_WARN_RED = 24;
    public static final String CHAR_SET = "UTF-8";
    public static final String CHAR_SET_HTML = "text/html; charset=UTF-8";
    public static final String XMAILER = "X-Mailer";
    public static final String HD_XMAILER_STRING = "i-net HelpDesk";
    public static final String HD_TICKET_IDENT_STRING = "X-SendIdent";
    public static final String HD_TICKET_REF_STRING = "X-SendReference";
    public static final String FORIGN_KEY = "foreign key";
    public static final String LOCAL_KEY = "local key";
    public static final String HEADER_MESSAGE_ID = "Message-ID";
    public static final String HEADER_IN_REPLY_TO = "In-Reply-To";
    public static final String HEADER_REFERENCES = "References";
    private String theIdentID;
    private String foreignKey = null;
    private static ThreadPool threadpool;
    private int msgTyp;
    private int buendelid;
    private int rea;
    private String derBetreff;
    private String theText;
    private boolean html;
    private String empfaenger;
    private String cc;
    private String bc;
    InternetAddress[] to = null;
    InternetAddress[] ccs = null;
    InternetAddress[] bccs = null;
    private String absender;
    private String absenderAlias;
    private Vector<Object> attachments;
    private Vector<Object> fileNames;
    private static final ConfigValue<Boolean> TICKET_ID_FIRST;
    private static final ConfigValue<String> MAIL_FROM;
    private static final ConfigValue<String> FOREIGN_KEY_COLUMN;
    private static final ConfigValue<Boolean> MAIL_MAILEINGANG_RES;
    private static final ConfigValue<Boolean> MAIL_MAILEINGANG_DISP;
    private static final ConfigValue<Boolean> MAIL_MANU_ESCA_DISP;
    private static final ConfigValue<Boolean> MAIL_MANU_ESCA_NEWRES;
    private static final ConfigValue<Boolean> MAIL_ANFRAGE_DISP;
    private static final ConfigValue<Boolean> MAIL_DEADLINE_DISP;
    private static final ConfigValue<Boolean> MAIL_DEADLINE_RES;
    private static final ConfigValue<Boolean> MAIL_AUTORISIERUNG_RES;
    private static final ConfigValue<Boolean> MAIL_AUTORISIERUNG_USER;
    private static final ConfigValue<Boolean> MAIL_WIEDERVORLAGE_RES;
    private static final ConfigValue<Boolean> MAIL_AUTO_ESCA_DISP;
    private static final ConfigValue<Boolean> MAIL_AUTO_ESCA_NEWRES;
    private static final ConfigValue<Boolean> MAIL_BEENDEN_USER;
    private static final ConfigValue<Boolean> MAIL_ESCA_WARN_YELLOW;
    private static final ConfigValue<Boolean> MAIL_ESCA_WARN_RED;
    private static final ConfigValue<Boolean> MAIL_DEAD_WARN_YELLOW;
    private static final ConfigValue<Boolean> MAIL_DEAD_WARN_RED;
    private static final ConfigValue<OutgoingMailHeaderMap> MAIL_HEADERS;
    private MailDataSource[] attachmentDatasources;
    private String subjectToSend;
    private String inReplyTo;
    private String reference;

    public Mail() {
    }

    protected Mail(int buendelid, int rea, String theText, boolean html, String derBetreff, String empfaenger, String cc, String bc, String absender, String absenderAlias, Vector<Object> attachments, Vector<Object> fileNames, String inReplyTo, String reference) {
        this.buendelid = buendelid;
        this.rea = rea;
        this.theText = theText;
        this.html = html;
        this.inReplyTo = inReplyTo;
        this.reference = reference;
        this.theIdentID = Tickets.getTicketIDForEmailSubject(buendelid);
        this.derBetreff = derBetreff != null && derBetreff.indexOf(this.theIdentID) == -1 ? (((Boolean)TICKET_ID_FIRST.get()).booleanValue() ? this.theIdentID + " " + derBetreff : derBetreff + " " + this.theIdentID) : derBetreff;
        this.empfaenger = empfaenger;
        this.cc = cc;
        this.bc = bc;
        this.absender = absender;
        String account = TicketManager.getReaderForSystem().getTicket(buendelid).getEmailEingang();
        if (account != null && StringFunctions.isEmpty((String)absenderAlias)) {
            EmailAccount emailAccount;
            if (account.startsWith("er_")) {
                account = account.substring(3);
            }
            if ((emailAccount = ((EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get()).get(account)) != null) {
                absenderAlias = emailAccount.getFromName();
            }
        }
        this.absenderAlias = absenderAlias;
        this.attachments = attachments;
        this.fileNames = fileNames;
    }

    public static void init() {
        threadpool = new ThreadPool("EMail", 3);
    }

    public static void send(int idx, int rea, String theText, boolean html, String derBetreff, String empfaenger, String cc, String bc, String absender, @Nullable String absenderAlias, Vector<Object> attachments, Vector<Object> fileNames, @Nullable Integer producingReaStepId) {
        if (threadpool == null) {
            Mail.init();
        }
        List<String> header = Mail.buildReferencesHeader(idx, producingReaStepId);
        threadpool.start(new Mail(idx, rea, theText, html, derBetreff, empfaenger, cc, bc, absender, absenderAlias, attachments, fileNames, header.get(0), header.get(1)));
    }

    public static void send(Map<String, String> table, int typ, String producer) {
        int idx;
        List<String> header;
        if (threadpool == null) {
            Mail.init();
        }
        if (table.get("aufid") != null && (header = Mail.buildReferencesHeader(idx = Integer.valueOf(table.get("aufid")).intValue(), null)).get(0) != null && !table.containsKey(HEADER_IN_REPLY_TO)) {
            table.put(HEADER_IN_REPLY_TO, header.get(0));
            if (header.get(1) != null) {
                table.put(HEADER_REFERENCES, header.get(1));
            }
        }
        threadpool.start(new AutoMail(table, typ, producer));
    }

    private static void sendIntern(int id, int typ, String producer) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("aufid", String.valueOf(id));
        Mail.send(table, typ, producer);
    }

    public static void sendWV(String aufID, String wv) {
        if (((Boolean)MAIL_WIEDERVORLAGE_RES.get()).booleanValue()) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("aufid", aufID);
            table.put("wvzeit", wv);
            Mail.send(table, 6, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void send(int typ, int id, String producerEM) {
        standard = true;
        switch (typ) {
            case 1: {
                if (((Boolean)Mail.MAIL_AUTO_ESCA_DISP.get()).booleanValue()) {
                    Mail.sendIntern(id, 9, producerEM);
                }
                if (!((Boolean)Mail.MAIL_AUTO_ESCA_NEWRES.get()).booleanValue()) break;
                Mail.sendIntern(id, 10, producerEM);
                break;
            }
            case 14: {
                standard = false;
            }
            case 2: 
            case 15: {
                if ((!standard || !((Boolean)Mail.MAIL_AUTORISIERUNG_USER.get()).booleanValue()) && (standard || ((Boolean)Mail.MAIL_AUTORISIERUNG_USER.get()).booleanValue())) ** GOTO lbl15
                Mail.sendIntern(id, 3, producerEM);
                ** GOTO lbl17
lbl15:
                // 1 sources

                if (((Boolean)Mail.MAIL_AUTORISIERUNG_USER.get()).booleanValue()) {
                    HDLogger.info("Suppress user authorize mail ticket " + id);
                }
            }
lbl17:
            // 5 sources

            case 9: {
                if (!((Boolean)Mail.MAIL_AUTORISIERUNG_RES.get()).booleanValue()) break;
                Mail.sendIntern(id, 4, producerEM);
                break;
            }
            case 10: {
                if (((Boolean)Mail.MAIL_MAILEINGANG_RES.get()).booleanValue()) {
                    Mail.sendIntern(id, 5, producerEM);
                }
                if (!((Boolean)Mail.MAIL_MAILEINGANG_DISP.get()).booleanValue()) break;
                Mail.sendIntern(id, 21, producerEM);
                break;
            }
            case 3: {
                if (((Boolean)Mail.MAIL_MANU_ESCA_DISP.get()).booleanValue()) {
                    Mail.sendIntern(id, 7, producerEM);
                }
                if (!((Boolean)Mail.MAIL_MANU_ESCA_NEWRES.get()).booleanValue()) break;
                Mail.sendIntern(id, 8, producerEM);
                break;
            }
            case 16: {
                standard = false;
            }
            case 4: {
                if (standard && ((Boolean)Mail.MAIL_BEENDEN_USER.get()).booleanValue() || !standard && !((Boolean)Mail.MAIL_BEENDEN_USER.get()).booleanValue()) {
                    Mail.sendIntern(id, 13, producerEM);
                    break;
                }
                if (!((Boolean)Mail.MAIL_BEENDEN_USER.get()).booleanValue()) break;
                HDLogger.info("Suppress user finish mail ticket " + id);
                break;
            }
            case 6: {
                if (!((Boolean)Mail.MAIL_ANFRAGE_DISP.get()).booleanValue()) break;
                Mail.sendIntern(id, 2, producerEM);
                break;
            }
            case 8: {
                if (((Boolean)Mail.MAIL_DEADLINE_DISP.get()).booleanValue()) {
                    Mail.sendIntern(id, 11, producerEM);
                }
                if (!((Boolean)Mail.MAIL_DEADLINE_RES.get()).booleanValue()) break;
                Mail.sendIntern(id, 12, producerEM);
                break;
            }
            case 21: {
                if (!((Boolean)Mail.MAIL_ESCA_WARN_YELLOW.get()).booleanValue()) break;
                Mail.sendIntern(id, 17, producerEM);
                break;
            }
            case 22: {
                if (!((Boolean)Mail.MAIL_ESCA_WARN_RED.get()).booleanValue()) break;
                Mail.sendIntern(id, 18, producerEM);
                break;
            }
            case 23: {
                if (!((Boolean)Mail.MAIL_DEAD_WARN_YELLOW.get()).booleanValue()) break;
                Mail.sendIntern(id, 19, producerEM);
                break;
            }
            case 24: {
                if (!((Boolean)Mail.MAIL_DEAD_WARN_RED.get()).booleanValue()) break;
                Mail.sendIntern(id, 20, producerEM);
            }
        }
    }

    protected static HashSet<String> generateMailFilter() {
        int addpos;
        String absenderMail;
        EmailAccountList emailAccounts = (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
        HashSet<String> filter = new HashSet<String>();
        for (int i = 0; i < emailAccounts.size(); ++i) {
            EmailAccount emailAccount = (EmailAccount)emailAccounts.get(i);
            filter.add(emailAccount.getAccount().toLowerCase());
            absenderMail = emailAccount.getFrom();
            if (absenderMail == null || (addpos = absenderMail.indexOf(64)) <= -1) continue;
            filter.add(absenderMail.substring(addpos + 1).toLowerCase());
            filter.add(absenderMail.substring(0, addpos).toLowerCase());
        }
        absenderMail = (String)MAIL_FROM.get();
        addpos = absenderMail.indexOf(64);
        if (addpos > -1) {
            filter.add(absenderMail.substring(0, addpos).toLowerCase());
            filter.add(absenderMail.substring(addpos + 1).toLowerCase());
        }
        return filter;
    }

    @Override
    public void run() {
        try {
            InternetAddress from = new EmailAddressUtils().getEmailAddress(this.absender, ex -> {
                throw new IllegalStateException("Send E-Mail: Auftrag " + this.buendelid + " Schritt " + this.rea + " hatte keinen g\u00fcltigen Absender: " + this.absender, (Throwable)ex);
            });
            if (from == null) {
                throw new IllegalArgumentException("Send E-Mail: Auftrag " + this.buendelid + " Schritt " + this.rea + " hatte keinen g\u00fcltigen Absender: " + this.absender);
            }
            from.setPersonal(this.absenderAlias, CHAR_SET);
            if (this.empfaenger.length() > 0) {
                this.empfaenger = Mail.checkRecipientString(this.empfaenger);
                if (this.empfaenger.indexOf(59) > -1) {
                    this.to = this.getRecipients(this.empfaenger);
                } else {
                    InternetAddress toAdress = Mail.getEmailAddress(this.empfaenger);
                    if (toAdress != null) {
                        this.to = new InternetAddress[]{toAdress};
                    }
                }
            }
            if (this.cc.length() > 0) {
                this.cc = Mail.checkRecipientString(this.cc);
                if (this.cc.indexOf(59) > -1) {
                    this.ccs = this.getRecipients(this.cc);
                } else {
                    InternetAddress ccAdress = Mail.getEmailAddress(this.cc);
                    if (ccAdress != null) {
                        this.ccs = new InternetAddress[]{ccAdress};
                    }
                }
            }
            if (this.bc.length() > 0) {
                this.bc = Mail.checkRecipientString(this.bc);
                if (this.bc.indexOf(59) > -1) {
                    this.bccs = this.getRecipients(this.bc);
                } else {
                    InternetAddress bccAdress = Mail.getEmailAddress(this.bc);
                    if (bccAdress != null) {
                        this.bccs = new InternetAddress[]{bccAdress};
                    }
                }
            }
            if (this.to == null && this.ccs == null) {
                throw new IllegalStateException("Send E-Mail: Auftrag " + this.buendelid + " Schritt " + this.rea + " hatte keinen g\u00fcltigen Empf\u00e4nger.");
            }
            String foreignKeyColumn = (String)FOREIGN_KEY_COLUMN.get();
            TicketField<String> customField = AliasMapper.getCustomTicketFieldForKey(foreignKeyColumn);
            if (customField != null) {
                this.foreignKey = TicketManager.getReaderForSystem().getTicket(this.buendelid).getValue(customField);
            }
            ArrayList<MailAttachment> dataToAttach = new ArrayList<MailAttachment>();
            for (int i = 0; i < this.fileNames.size(); ++i) {
                String inlineName;
                String fn = (String)this.attachments.elementAt(i);
                String name = this.fileNames.elementAt(i).toString();
                boolean inline = this.html ? this.theText.indexOf(inlineName = "src=\"cid:" + BaseEmail.encodeMIMEText((String)name) + "\"") > -1 : false;
                PersistenceEntry path = AppDataLocation.getAttachmentDirectory();
                String nameToUse = MailUtilities.addToList(path.resolve(fn.substring(1)), name, inline, dataToAttach);
                if (Objects.equals(name, nameToUse) || !this.html || !inline) continue;
                String inlineNameOld = "src=\"cid:" + BaseEmail.encodeMIMEText((String)name) + "\"";
                String inlineNameNew = "src=\"cid:" + BaseEmail.encodeMIMEText((String)nameToUse) + "\"";
                this.theText = this.theText.replace(inlineNameOld, inlineNameNew);
            }
            this.attachmentDatasources = dataToAttach.toArray(new MailDataSource[0]);
            this.subjectToSend = this.derBetreff;
            if (this.foreignKey != null && this.foreignKey.length() > 3 && this.derBetreff.indexOf(this.foreignKey) == -1) {
                this.subjectToSend = this.foreignKey + " " + this.derBetreff;
            }
            this.send(from);
        }
        catch (Throwable ex2) {
            LogManager.getLogger((String)"Mail").warn((Object)(EmailReader_HDProcessing.EMAIL_MESSAGES.getMsg("MAILerr2", new Object[0]) + " Subject: " + this.derBetreff));
            this.fehler(ex2);
            LogManager.getLogger((String)"Mail").error(ex2);
        }
    }

    private void sendMail(InternetAddress from, String host, Integer port, String pop3Host, String pop3Port, MailAuthenticationMethod authMode, String user, String password, MailEncryption encryption) throws MessagingException {
    }

    protected static final boolean nonascii(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char b = s.charAt(i);
            if (b < '\u007f' && (b >= ' ' || b == '\r' || b == '\n' || b == '\t')) continue;
            return true;
        }
        return false;
    }

    private void fehler(Throwable e) {
        String description = e.getLocalizedMessage();
        if (StringFunctions.isEmpty((String)description)) {
            description = e.toString();
        }
        Mail.addRealisierung(this.buendelid, null, -11, null, null, null, null, description);
    }

    protected static int addRealisierung(int bid, String txt, int aktID, String versender, String an, String cc, String bcc, String description) {
        MutableReaStepData d = new MutableReaStepData();
        if (an != null) {
            d.put(ReaStepVO.FIELD_EMAIL_AN, an);
        }
        if (cc != null) {
            d.put(ReaStepVO.FIELD_EMAIL_CC, cc);
        }
        if (bcc != null) {
            d.put(ReaStepVO.FIELD_EMAIL_BCC, bcc);
        }
        if (versender != null) {
            d.put(ReaStepVO.FIELD_EMAIL_IN, versender);
        }
        if (((String)description).length() > 255) {
            String dots = "...";
            description = ((String)description).substring(0, 255 - dots.length()) + dots;
        }
        d.put(ReaStepVO.FIELD_DESC, description);
        d.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(System.currentTimeMillis()));
        ReaStepTextVO t = ReaStepTextVO.of(txt, false);
        ActionVO a = (ActionVO)ActionManager.getInstance().get(aktID);
        ExtensionArguments e = ExtensionArguments.create();
        if (aktID == -14) {
            d.put(ReaStepVO.FIELD_USER_DISPLAY_NAME, null);
        }
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            int n = TicketManager.getManipulator().applyAction(bid, d, t, a, e);
            return n;
        }
    }

    protected static String checkRecipientString(String addressString) {
        if (addressString.indexOf(44) > -1) {
            char[] signs = addressString.toCharArray();
            boolean addPos = false;
            for (int i = 0; i < signs.length; ++i) {
                if (signs[i] == '@') {
                    addPos = true;
                    continue;
                }
                if (signs[i] != ',' || !addPos) continue;
                signs[i] = 59;
                addPos = false;
            }
            addressString = new String(signs);
        }
        return addressString;
    }

    protected InternetAddress[] getRecipients(String an) {
        StringTokenizer eimailTokens = new StringTokenizer(an, ";");
        Vector<InternetAddress> anWen = new Vector<InternetAddress>();
        while (eimailTokens.hasMoreTokens()) {
            String test = eimailTokens.nextToken().trim();
            if ((this.msgTyp == 2 || this.msgTyp == 11) && test.equalsIgnoreCase(this.theText)) {
                LogManager.getLogger((String)"Mail").warn((Object)("No Mail back to Ressource. " + test));
                continue;
            }
            InternetAddress address = Mail.getEmailAddress(test);
            if (address != null) {
                if (anWen.indexOf(address) != -1) continue;
                anWen.addElement(address);
                continue;
            }
            LogManager.getLogger((String)"Mail").info((Object)("Addresse Error: " + test));
        }
        if (anWen.size() == 0) {
            return null;
        }
        return anWen.toArray(new InternetAddress[anWen.size()]);
    }

    public static boolean testEmailAddressString(String in) {
        return Mail.getEmailAddress(in) != null;
    }

    public static InternetAddress getEmailAddress(String addr) {
        return new EmailAddressUtils().getEmailAddress(addr, ex -> HDLogger.warn(ex));
    }

    public static String[] convertToAddressArray(String in) {
        if (in != null && in.length() > 0) {
            if (in.indexOf(59) > -1 || in.indexOf(44) > -1) {
                StringTokenizer eimailTokens = new StringTokenizer(in, ";,");
                Vector<String> allAdresses = new Vector<String>();
                while (eimailTokens.hasMoreTokens()) {
                    String test = eimailTokens.nextToken().trim();
                    if (!Mail.testEmailAddressString(test)) continue;
                    allAdresses.addElement(test.toLowerCase());
                }
                if (allAdresses.size() > 0) {
                    return allAdresses.toArray(new String[allAdresses.size()]);
                }
            } else if (Mail.testEmailAddressString((in = in.trim()).toLowerCase())) {
                return new String[]{in};
            }
        }
        return new String[0];
    }

    public static String getAddressString(Address[] allAdrs) {
        Object stringRet = null;
        if (allAdrs != null) {
            for (Address allAdr : allAdrs) {
                String addr = ((InternetAddress)allAdr).getAddress();
                if (((String)(stringRet = stringRet == null ? addr : (String)stringRet + ";" + addr)).length() > 200) break;
            }
        }
        return stringRet;
    }

    @Override
    public String getSubject() throws MessagingException {
        return this.subjectToSend;
    }

    @Override
    public InternetAddress[] getTo() throws MessagingException {
        return this.to;
    }

    @Nullable
    protected InternetAddress[] getCc() throws MessagingException {
        return this.ccs;
    }

    @Nullable
    protected InternetAddress[] getBcc() throws MessagingException {
        return this.bccs;
    }

    @Override
    @Nullable
    public Properties getHeaders() {
        return Mail.getHeaders(this.theIdentID, this.foreignKey, this.inReplyTo, this.reference);
    }

    protected static Properties getHeaders(String theID, String fork, String inReplyTo, String reference) {
        OutgoingMailHeaderMap mailHeaderMap;
        Properties result = new Properties();
        result.setProperty(XMAILER, HD_XMAILER_STRING);
        if (theID != null && theID.length() > 0) {
            result.setProperty(HD_TICKET_IDENT_STRING, theID);
        }
        if (fork != null && fork.length() > 0) {
            result.setProperty(HD_TICKET_REF_STRING, fork);
        }
        if (!StringFunctions.isEmpty((String)inReplyTo)) {
            result.setProperty(HEADER_IN_REPLY_TO, inReplyTo);
        }
        if (!StringFunctions.isEmpty((String)reference)) {
            result.setProperty(HEADER_REFERENCES, reference);
        }
        if ((mailHeaderMap = (OutgoingMailHeaderMap)MAIL_HEADERS.get()) != null) {
            Set entrySet = mailHeaderMap.entrySet();
            for (Map.Entry entry : entrySet) {
                result.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return result;
    }

    @Override
    public String getMessage() throws MessagingException {
        return this.theText;
    }

    @Nonnull
    protected String getMessageMime() throws MessagingException {
        return this.html ? "HTML" : "plain";
    }

    @Nullable
    protected MailDataSource[] getFiles() throws MessagingException {
        return this.attachmentDatasources;
    }

    @Nonnull
    protected Logger getLogger() {
        return LogManager.getLogger((String)"Mail");
    }

    private static List<String> buildReferencesHeader(int ticketId, @Nullable Integer producingReaStepId) {
        ReaStepVO stepWeAnswerOn = null;
        if (producingReaStepId != null) {
            stepWeAnswerOn = TicketManager.getReaderForSystem().getReaStep(producingReaStepId);
        } else {
            List<ReaStepVO> reaStepsForTicket = TicketManager.getReaderForSystem().getReaStepsForTicket(ticketId);
            for (ReaStepVO step : reaStepsForTicket) {
                if (step.getValue(ReaStepVO.FIELD_EMAIL_MESSAGE_ID) == null) continue;
                stepWeAnswerOn = step;
                break;
            }
        }
        String messageId = null;
        Object references = null;
        if (stepWeAnswerOn != null) {
            messageId = stepWeAnswerOn.getValue(ReaStepVO.FIELD_EMAIL_MESSAGE_ID);
            references = stepWeAnswerOn.getValue(ReaStepVO.FIELD_EMAIL_REFERENCE);
        }
        if (messageId != null) {
            references = references == null ? messageId : (String)references + "\r\n " + messageId;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(messageId);
        result.add((String)references);
        return result;
    }

    static {
        TICKET_ID_FIRST = new ConfigValue(HDConfigKeys.TICKET_ID_FIRST);
        MAIL_FROM = new ConfigValue(ConfigKey.MAIL_SENDER);
        FOREIGN_KEY_COLUMN = new ConfigValue(HDConfigKeys.FOREIGN_KEY_COLUMN);
        MAIL_MAILEINGANG_RES = new ConfigValue(HDConfigKeys.MAIL_MAILEINGANG_RES);
        MAIL_MAILEINGANG_DISP = new ConfigValue(HDConfigKeys.MAIL_MAILEINGANG_DISP);
        MAIL_MANU_ESCA_DISP = new ConfigValue(HDConfigKeys.MAIL_MANU_ESCA_DISP);
        MAIL_MANU_ESCA_NEWRES = new ConfigValue(HDConfigKeys.MAIL_MANU_ESCA_NEWRES);
        MAIL_ANFRAGE_DISP = new ConfigValue(HDConfigKeys.MAIL_ANFRAGE_DISP);
        MAIL_DEADLINE_DISP = new ConfigValue(HDConfigKeys.MAIL_DEADLINE_DISP);
        MAIL_DEADLINE_RES = new ConfigValue(HDConfigKeys.MAIL_DEADLINE_RES);
        MAIL_AUTORISIERUNG_RES = new ConfigValue(HDConfigKeys.MAIL_AUTORISIERUNG_RES);
        MAIL_AUTORISIERUNG_USER = new ConfigValue(HDConfigKeys.MAIL_AUTORISIERUNG_USER);
        MAIL_WIEDERVORLAGE_RES = new ConfigValue(HDConfigKeys.MAIL_WIEDERVORLAGE_RES);
        MAIL_AUTO_ESCA_DISP = new ConfigValue(HDConfigKeys.MAIL_AUTO_ESCA_DISP);
        MAIL_AUTO_ESCA_NEWRES = new ConfigValue(HDConfigKeys.MAIL_AUTO_ESCA_NEWRES);
        MAIL_BEENDEN_USER = new ConfigValue(HDConfigKeys.MAIL_BEENDEN_USER);
        MAIL_ESCA_WARN_YELLOW = new ConfigValue(HDConfigKeys.AUTOMAIL_WHEN_YELLOW_ESCALATION_THRESHOLD_PASSED);
        MAIL_ESCA_WARN_RED = new ConfigValue(HDConfigKeys.AUTOMAIL_WHEN_RED_ESCALATION_THRESHOLD_PASSED);
        MAIL_DEAD_WARN_YELLOW = new ConfigValue(HDConfigKeys.AUTOMAIL_WHEN_YELLOW_DEADLINE_THRESHOLD_PASSED);
        MAIL_DEAD_WARN_RED = new ConfigValue(HDConfigKeys.AUTOMAIL_WHEN_RED_DEADLINE_THRESHOLD_PASSED);
        MAIL_HEADERS = new ConfigValue(HDConfigKeys.OUTGOING_MAIL_HEADERS);
    }
}

