/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.config.EmailAccount;
import java.util.Hashtable;
import java.util.Iterator;
import srv.automatic.Timer;

public class CombinationCheck {
    private static final long MAX_AGE_MILLIS = 60000L;
    private Hashtable<String, Entry> emailsCurrentLoop = new Hashtable();
    private static final String[] PREFIXES_TO_NEGLECT = new String[]{"aw: ", "re: ", "fw: ", "wg: ", "fwd: "};

    public Integer gotTheSameBefore(String subject, EmailAccount account, String senderAddress, long emailReceiveDate) {
        String key;
        Entry result = null;
        if (this.bundleAllowedTest(account, senderAddress.toLowerCase()) && (result = this.emailsCurrentLoop.get(key = this.getKey(senderAddress, account, subject))) != null && emailReceiveDate - result.emailReceiveDate < 60000L) {
            result.emailReceiveDate = Math.max(emailReceiveDate, result.emailReceiveDate);
            return result.ticketId;
        }
        return null;
    }

    protected boolean bundleAllowedTest(EmailAccount account, String senderAddress) {
        String test = account.getNoBundles();
        if (test != null) {
            if ((test = test.toLowerCase()).equalsIgnoreCase("*")) {
                return false;
            }
            if (test.equals(senderAddress) || test.startsWith(senderAddress + ";") || test.endsWith(";" + senderAddress) || test.indexOf(";" + senderAddress + ";") > -1) {
                return false;
            }
        }
        return true;
    }

    private String getKey(String senderAddress, EmailAccount account, String subject) {
        if (subject == null) {
            subject = "";
        } else {
            subject = subject.toLowerCase();
            for (String element : PREFIXES_TO_NEGLECT) {
                if (!subject.startsWith(element)) continue;
                subject = subject.substring(element.length());
                break;
            }
        }
        return senderAddress + " " + account.getAccount() + " " + subject;
    }

    public void noticeNewTicket(String subject, EmailAccount account, String senderAddress, long emailReceiveDate, Integer ticketId) {
        this.emailsCurrentLoop.put(this.getKey(senderAddress, account, subject), new Entry(ticketId, emailReceiveDate));
    }

    public void cleanUp() {
        Iterator<Entry> iterator = this.emailsCurrentLoop.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().emailReceiveDate >= System.currentTimeMillis() - (long)((Integer)Timer.MAIL_TIMER.get()).intValue() * 60L * 1000L) continue;
            iterator.remove();
        }
    }

    private class Entry {
        Integer ticketId;
        long emailReceiveDate;

        private Entry(Integer ticketId, long emailReceiveDate) {
            this.ticketId = ticketId;
            this.emailReceiveDate = emailReceiveDate;
        }
    }
}

