/*
 * Decompiled with CFR 0.152.
 */
package srv.controller.ticket.attributes;

import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.shared.model.user.HelpDeskUser;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagLoginSettings;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import srv.mail.Mail;

@Deprecated
public class User
implements HelpDeskUser {
    private int usrID;
    private GUID userUUID;

    public User(int id) {
        this.usrID = id;
        this.userUUID = this.getUserAccount(id).getID();
    }

    public User(UserAccount userAccount) {
        this(HDUsersAndGroups.getUserID(userAccount));
    }

    public UserAccount getUserAccount() {
        UserManager um = UserManager.getInstance();
        UserAccount account = um.getUserAccount(this.userUUID);
        if (account == null) {
            throw new RuntimeException("No account for user id: " + this.usrID);
        }
        return account;
    }

    private UserAccount getUserAccount(int id) {
        UserAccount account = HDUsersAndGroups.getUserAccount(id);
        if (account == null) {
            throw new RuntimeException("No account for user id: " + this.usrID);
        }
        return account;
    }

    public void setData(String name, String nachname, String vorname, String email, String sprache, boolean isValid) {
        UserManager um = UserManager.getInstance();
        UserAccount userAccount = this.getUserAccount();
        List logins = userAccount.getLoginSettings();
        String systemLoginSettingsToken = SearchTagLoginSettings.settingsAsToken((String)"system", (String)name);
        Predicate<LoginSettings> matchesSystemLoginSettings = settings -> systemLoginSettingsToken.equals(SearchTagLoginSettings.settingsAsToken((String)settings.getLoginSource(), (String)settings.getLoginID()));
        if (logins.stream().noneMatch(matchesSystemLoginSettings)) {
            um.updateLoginSettings(this.userUUID, Arrays.asList(new LoginSettings("system", name, "")), logins);
        }
        MutableUserData userData = new MutableUserData();
        userData.put((UserField)UsersAndGroups.FIELD_LASTNAME, (Object)(nachname != null ? nachname : ""));
        userData.put((UserField)UsersAndGroups.FIELD_FIRSTNAME, (Object)(vorname != null ? vorname : ""));
        userData.put((UserField)UsersAndGroups.FIELD_EMAIL, (Object)(email != null ? email : ""));
        userData.put((UserField)HDUsersAndGroups.FIELD_LANGUAGE, (Object)(sprache != null ? sprache : (String)HDUsersAndGroups.FIELD_LANGUAGE.getDefaultValue()));
        um.updateUserData(this.userUUID, userData);
        if (isValid) {
            um.setUserAccountActive(this.userUUID);
        } else {
            um.setUserAccountInactive(this.userUUID);
        }
    }

    public int getUsrID() {
        return this.usrID;
    }

    public GUID getUserUUID() {
        return this.userUUID;
    }

    public String getName() {
        UserAccount userAccount = this.getUserAccount();
        List logins = userAccount.getLoginSettings();
        return logins.size() > 0 ? ((LoginSettings)logins.get(0)).getLoginID() : this.getDisplayName();
    }

    public String getEmail() {
        String[] emailAdressen = this.getAllEmailAddresses();
        if (emailAdressen.length > 0) {
            return emailAdressen[0];
        }
        return "";
    }

    public String[] getAllEmailAddresses() {
        String email = (String)this.getUserAccount().getValue((UserField)UsersAndGroups.FIELD_EMAIL);
        return Mail.convertToAddressArray(email);
    }

    public String getSprache() {
        return (String)this.getUserAccount().getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE);
    }

    public String getComputername() {
        return (String)this.getUserAccount().getValue((UserField)HDUsersAndGroups.FIELD_COMPUTER_NAME);
    }

    public String getVorname() {
        return (String)this.getUserAccount().getValue((UserField)UsersAndGroups.FIELD_FIRSTNAME);
    }

    public String getNachname() {
        return (String)this.getUserAccount().getValue((UserField)UsersAndGroups.FIELD_LASTNAME);
    }

    public LocationVO getLocation() {
        Integer locationID = (Integer)this.getUserAccount().getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        if (locationID == null) {
            return null;
        }
        return (LocationVO)LocationManager.getInstance().get(locationID);
    }

    public UserClassVO getBenutzergruppe() {
        Integer groupID = (Integer)this.getUserAccount().getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
        if (groupID == null) {
            return null;
        }
        return (UserClassVO)UserClassManager.getInstance().get(groupID);
    }

    @Override
    public String getDisplayName() {
        return this.getUserAccount().getDisplayName();
    }

    @Override
    public String getUsername() {
        return this.getName();
    }
}

