/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.lib.util.IOFunctions;
import com.inet.usersandgroups.api.user.UserAccount;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.Nonnull;
import srv.controller.ClientSession;
import srv.controller.UserMessage;

public class UserSession
extends ClientSession {
    private static final String MESSAGE_TO_DELIVER = "MESSAGE_TO_DELIVER";
    private static final String AUTO_PROCESS_ERROR_MESSAGE = "AUTO_PROCESS_ERROR_MESSAGE";
    private static final String SESSION_CLOSE_COMMAND = "SESSION_CLOSE_COMMAND";
    private static final String IGNOREABLE_VERSION_CHANGE = "IGNOREABLE_VERSION_CHANGE";
    private boolean closed = false;
    private boolean hdMobile = false;
    private boolean deliverAutoProcessError = false;
    private boolean clientClose;
    private int checkedVersion = 0;
    private int deviceInfoVersion = -1;
    private long lastContact = System.currentTimeMillis();
    private Integer lockedRequest;
    private ArrayList<UserMessage> messagesToDeliver;
    private UserSession nextSession = null;
    private Properties properties;
    private Path tempAttachmentsDir;
    private String ignoreVersions;

    public UserSession(@Nonnull UserAccount owner, int key) {
        super(owner, key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserSession) {
            return this.getSessionID() == ((UserSession)obj).getSessionID();
        }
        return false;
    }

    public boolean isHdMobile() {
        return this.hdMobile;
    }

    public void setHdMobile(boolean hdMobile) {
        this.hdMobile = hdMobile;
    }

    public void checkForMessage(Properties data) {
        if (this.clientClose) {
            data.setProperty(SESSION_CLOSE_COMMAND, SESSION_CLOSE_COMMAND);
            return;
        }
        if (this.deliverAutoProcessError) {
            data.setProperty(AUTO_PROCESS_ERROR_MESSAGE, AUTO_PROCESS_ERROR_MESSAGE);
        }
        if (this.messagesToDeliver != null && this.messagesToDeliver.size() > 0) {
            for (int n = this.messagesToDeliver.size() - 1; n >= 0; --n) {
                UserMessage message = this.messagesToDeliver.remove(n);
                data.setProperty(MESSAGE_TO_DELIVER + n, message.toString());
            }
        }
        if (this.ignoreVersions != null) {
            data.setProperty(IGNOREABLE_VERSION_CHANGE, this.ignoreVersions);
            this.ignoreVersions = null;
        }
    }

    public void setTempAttachmentsDir(Path tempAttachmentsDir) {
        this.tempAttachmentsDir = tempAttachmentsDir;
    }

    public void setMessage(int orderReferenz, int senderSession, int msgTyp, long activationTime, String orginator, String message) {
        if (this.messagesToDeliver == null) {
            this.messagesToDeliver = new ArrayList();
        }
        this.messagesToDeliver.add(new UserMessage(senderSession, orderReferenz, msgTyp, activationTime, orginator, message));
    }

    public void addMessage(UserMessage userMsg) {
        if (this.messagesToDeliver == null) {
            this.messagesToDeliver = new ArrayList();
        }
        this.messagesToDeliver.add(userMsg);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed() {
        File file;
        if (this.tempAttachmentsDir != null && (file = this.tempAttachmentsDir.toFile()).exists()) {
            IOFunctions.deleteDir((File)file);
        }
        this.closed = true;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setDeliverAutoProcessError(boolean deliverServerErrorMessage) {
        this.deliverAutoProcessError = deliverServerErrorMessage;
    }

    public long getLastContact() {
        return this.lastContact;
    }

    protected void setLastContact(long lastContact) {
        this.lastContact = lastContact;
    }

    public UserSession getNextSession() {
        return this.nextSession;
    }

    public void setNextSession(UserSession nextSession) {
        this.nextSession = nextSession;
    }

    public Integer getLockedRequest() {
        return this.lockedRequest;
    }

    public void setLockedRequest(Integer lockedRequest) {
        this.lockedRequest = lockedRequest;
    }

    protected int getDeviceInfoVersion() {
        return this.deviceInfoVersion;
    }

    protected void setDeviceInfoVersion(int deviceInfoVersion) {
        this.deviceInfoVersion = deviceInfoVersion;
    }

    public int getCheckedVersion() {
        return this.checkedVersion;
    }

    public void setCheckedVersion(int checkedVersion) {
        this.checkedVersion = checkedVersion;
    }

    protected void setClientClose(boolean clientClose) {
        this.clientClose = clientClose;
    }

    protected void ignoreTicketChange(int ticket, int priviousVersion, int currentVersion) {
        this.ignoreVersions = ticket + "," + priviousVersion + "," + currentVersion;
    }
}

