/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.helpdesk.config.stopwatch.StopWatchSetting;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformations;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.server.tickets.SetTicketReadAfterAccess;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.thread.EventDispatcher;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import srv.controller.ClientSession;

public class TicketAccessController
implements TicketAccessInformationsProvider,
TicketEventListener {
    private static final int REQUEST_READ = 1;
    private static final int REQUEST_WRITE = 2;
    private static long STOP_THRESHOLD = 30000L;
    private TypespecificIntMap<OpenedBuendel> theOpenedTickets;
    private final EventDispatcher<TicketAccessInformationsProvider.TicketAccessChangedListener> eventDispatcher = new EventDispatcher();
    private final Map<String, ClientSession> clientSessions = Collections.synchronizedMap(new HashMap());
    private static final byte STOP_MANUALLY = 1;
    private static final byte STOP_AUTOMATIC = 2;
    private final Map<String, ActiveStopWatch> stopWatches = Collections.synchronizedMap(new HashMap());

    public TicketAccessController() {
        this.theOpenedTickets = new TypespecificIntMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean buendelAccess(ClientSession session, int orderID, int request) {
        TicketVO t = TicketManager.getReaderForSystem().getTicket(orderID);
        if (t == null) {
            HDLogger.error("Ticket not found: " + orderID);
            return false;
        }
        int bunId = t.getBundleID();
        OpenedBuendel ob = this.theOpenedTickets.get(bunId);
        if (ob == null) {
            ob = new OpenedBuendel(bunId);
            this.theOpenedTickets.put(bunId, ob);
        }
        try {
            boolean bl = ob.addSession(session, request);
            return bl;
        }
        finally {
            if (ob.occupantsCount() == 0) {
                this.theOpenedTickets.remove(bunId);
            }
        }
    }

    private int aufIdToBunId(int aufId) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(aufId);
        if (ticket == null) {
            return aufId;
        }
        return ticket.getBundleID();
    }

    private boolean checkWriteAccess(UserAccount user, int ticketId) {
        try (UserAccountScope scope = UserAccountScope.create((GUID)user.getID());){
            boolean bl = TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticketId);
            return bl;
        }
    }

    private boolean checkSupporterWriteAccess(UserAccount user, int ticketId) {
        try (UserAccountScope scope = UserAccountScope.create((GUID)user.getID());){
            TicketPermissionContext info = TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticketId);
            boolean bl = info != null && info.hasSupporterWriteAccessToTicket();
            return bl;
        }
    }

    @Override
    public TicketAccessInformations getTicketAccessInformations(int ticketId) {
        return this.theOpenedTickets.get(this.aufIdToBunId(ticketId));
    }

    @Override
    public void accessTicketRead(String clientID, int ticket) {
        ClientSession session = this.findOrCreateClientSessionForCurrentUser(clientID);
        this.buendelAccess(session, ticket, 1);
        this.updateSessionOpenedTicketsCountAndDropIfZero(clientID, session);
    }

    @Override
    public boolean accessTicketWrite(String clientID, int ticket) {
        ClientSession session = this.findOrCreateClientSessionForCurrentUser(clientID);
        boolean writeAccess = this.buendelAccess(session, ticket, 2);
        this.updateSessionOpenedTicketsCountAndDropIfZero(clientID, session);
        return writeAccess;
    }

    @Override
    public synchronized void leaveTickets(String clientID, int ... tickets) {
        ClientSession session = this.clientSessions.get(clientID);
        if (session == null) {
            return;
        }
        for (int ticket : tickets) {
            int bunId = this.aufIdToBunId(ticket);
            OpenedBuendel ob = this.theOpenedTickets.get(bunId);
            if (ob == null) continue;
            boolean changed = ob.removeSession(session);
            if (ob.occupantsCount() == 0) {
                this.theOpenedTickets.remove(bunId);
            }
            if (!changed) continue;
            this.sendTicketAccessChangedEvent(bunId);
            this.stopStopWatchIfIsLastSessionOfUser(session, bunId);
        }
        this.updateSessionOpenedTicketsCountAndDropIfZero(clientID, session);
    }

    private void updateSessionOpenedTicketsCountAndDropIfZero(String clientID, ClientSession session) {
        session.setCountOfOpenOrders((int)this.theOpenedTickets.getValueList().stream().filter(ob -> ob.existsInBundle(session) != -1).count());
        if (session.getCountOfOpenOrders() == 0) {
            this.clientSessions.remove(clientID);
        }
    }

    @Override
    public void leaveAllTickets(String clientID) {
        this.leaveTickets(clientID, this.theOpenedTickets.getAllKeys());
    }

    @Override
    public TicketAccessInfo getTicketAccessInfo(int ticketID) {
        return this.getTicketAccessInfo_BunID(this.aufIdToBunId(ticketID));
    }

    @Override
    public TicketAccessInformationsProvider.StopWatch getStopWatchInfo(int ticketID, String clientID) {
        ClientSession session = this.clientSessions.get(clientID);
        if (session == null) {
            return null;
        }
        ActiveStopWatch activeStopWatch = this.stopWatches.get(this.stopWatchKey(session, this.aufIdToBunId(ticketID)));
        if (activeStopWatch != null) {
            return activeStopWatch.watch;
        }
        return null;
    }

    private TicketAccessInfo getTicketAccessInfo_BunID(int bunId) {
        OpenedBuendel cache = this.theOpenedTickets.get(bunId);
        if (cache == null) {
            return null;
        }
        TicketAccessInfo.TicketAccessor writeSession = cache.ownerSession == null ? null : this.createTicketAccessor(cache.ownerSession);
        ArrayList<ClientSession> otherSessions = new ArrayList<ClientSession>(cache.otherSessions);
        List<TicketAccessInfo.TicketAccessor> readSessions = otherSessions.stream().filter(Objects::nonNull).map(this::createTicketAccessor).collect(Collectors.toList());
        return new TicketAccessInfo(writeSession, readSessions);
    }

    @Override
    public void addTicketAccessChangedListener(TicketAccessInformationsProvider.TicketAccessChangedListener listener) {
        this.eventDispatcher.registerListener((Object)listener);
    }

    @Override
    public void removeTicketAccessChangedListener(TicketAccessInformationsProvider.TicketAccessChangedListener listener) {
        this.eventDispatcher.unregisterListener((Object)listener);
    }

    @Nonnull
    private ClientSession findOrCreateClientSessionForCurrentUser(@Nonnull String clientID) {
        ClientSession session = this.clientSessions.get(clientID);
        if (session == null) {
            session = ClientSession.create(UserManager.getInstance().getCurrentUserAccount(), clientID);
            this.clientSessions.put(clientID, session);
        }
        return session;
    }

    private TicketAccessInfo.TicketAccessor createTicketAccessor(ClientSession session) {
        return new TicketAccessInfo.TicketAccessor(session.getOwner().getID(), session.getSessionID(), session.getOwner().getDisplayName(), session.getClientID());
    }

    @Override
    public synchronized boolean startStopWatch(GUID userId, int ticketId) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(userId);
        int bunId = this.aufIdToBunId(ticketId);
        if (!this.checkSupporterWriteAccess(userAccount, ticketId)) {
            throw new AccessDeniedException();
        }
        OpenedBuendel openedBuendel = this.theOpenedTickets.get(bunId);
        if (openedBuendel == null || !openedBuendel.userHasOpenedTicket(userAccount)) {
            throw new IllegalStateException("User is not logged into ticket");
        }
        String key = this.stopWatchKey(userId, bunId);
        ActiveStopWatch existingWatch = this.stopWatches.get(key);
        if (existingWatch != null) {
            return false;
        }
        if (TicketAccessInformationsProvider.stopWatchIsActiveFor(userAccount, bunId)) {
            this.startStopWatchNow(userId, bunId);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void stopStopWatch(GUID userId, int ticketId) {
        int bunId = this.aufIdToBunId(ticketId);
        String key = this.stopWatchKey(userId, bunId);
        ActiveStopWatch existingWatch = this.stopWatches.get(key);
        if (existingWatch == null) {
            return;
        }
        this.stopStopWatch(userId, bunId, existingWatch, System.currentTimeMillis(), (byte)1);
    }

    @Override
    public synchronized void cancelStopWatch(GUID userId, int ticketId) {
        int bunId = this.aufIdToBunId(ticketId);
        String key = this.stopWatchKey(userId, bunId);
        ActiveStopWatch existingWatch = this.stopWatches.get(key);
        if (existingWatch == null) {
            return;
        }
        this.stopWatches.remove(key);
        TicketAccessInformationsProvider.TicketStopWatchChangedEvent event = new TicketAccessInformationsProvider.TicketStopWatchChangedEvent(bunId, null, userId);
        this.eventDispatcher.dispatchEvent(l -> l.ticketStopWatchChanged(event));
    }

    private void autoStartStopWatch(ClientSession userSession, int bunId) {
        if (!this.checkSupporterWriteAccess(userSession.getOwner(), bunId)) {
            return;
        }
        String key = this.stopWatchKey(userSession, bunId);
        ActiveStopWatch existingWatch = this.stopWatches.get(key);
        if (existingWatch == null) {
            if (this.mustAutoStartStopWatch(userSession.getOwner(), bunId)) {
                this.startStopWatchNow(userSession.getOwner().getID(), bunId);
            }
        } else if (existingWatch.coolDownTask != null) {
            existingWatch.coolDownTask.cancel();
            existingWatch.coolDownTask = null;
        }
    }

    private void startStopWatchNow(GUID userId, int bunId) {
        String stopWatchKey = this.stopWatchKey(userId, bunId);
        long startTime = System.currentTimeMillis();
        long delay = (Integer)CONFIG_WATCH_START_THRESHOLD.get() * 1000;
        TicketAccessInformationsProvider.StopWatch stopWatch = new TicketAccessInformationsProvider.StopWatch(startTime, startTime + delay);
        this.stopWatches.put(stopWatchKey, new ActiveStopWatch(stopWatch));
        TicketAccessInformationsProvider.TicketStopWatchChangedEvent event = new TicketAccessInformationsProvider.TicketStopWatchChangedEvent(bunId, stopWatch, userId);
        this.eventDispatcher.dispatchEvent(l -> l.ticketStopWatchChanged(event));
    }

    private boolean mustAutoStartStopWatch(UserAccount owner, int bunId) {
        return TicketAccessInformationsProvider.getStopWatchSettingFor(owner, TicketManager.getReader().getTicket(bunId)) == StopWatchSetting.AUTOMATIC;
    }

    private String stopWatchKey(GUID ownerId, int bunId) {
        return bunId + "_" + ownerId.toString();
    }

    private String stopWatchKey(ClientSession userSession, int bunId) {
        return this.stopWatchKey(userSession.getOwner().getID(), bunId);
    }

    private void stopStopWatchIfIsLastSessionOfUser(final ClientSession session, final int bunId) {
        OpenedBuendel openedBuendel = this.theOpenedTickets.get(bunId);
        ActiveStopWatch activeStopWatch = this.stopWatches.get(this.stopWatchKey(session, bunId));
        if (!(activeStopWatch == null || openedBuendel != null && openedBuendel.userHasOpenedTicket(session.getOwner()))) {
            DefaultTimerTask stopTask;
            final long watchEndTime = System.currentTimeMillis();
            activeStopWatch.coolDownTask = stopTask = new DefaultTimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runImpl() throws Throwable {
                    TicketAccessController ticketAccessController = TicketAccessController.this;
                    synchronized (ticketAccessController) {
                        OpenedBuendel openedBuendel2;
                        ActiveStopWatch watch = TicketAccessController.this.stopWatches.get(TicketAccessController.this.stopWatchKey(session, bunId));
                        if (!(watch == null || (openedBuendel2 = TicketAccessController.this.theOpenedTickets.get(bunId)) != null && openedBuendel2.userHasOpenedTicket(session.getOwner()))) {
                            TicketAccessController.this.stopStopWatch(session.getOwner().getID(), bunId, watch, watchEndTime, (byte)2);
                        }
                    }
                }
            };
            DefaultTimer.getInstance().schedule(stopTask, STOP_THRESHOLD);
        }
    }

    private void stopStopWatch(GUID user, int bunId, ActiveStopWatch watch, long watchEndTime, byte whoStops) {
        this.stopWatches.remove(this.stopWatchKey(user, bunId));
        if (whoStops != 2 || watchEndTime > watch.watch.getActiveTime()) {
            try (UserAccountScope scope = UserAccountScope.create((GUID)user);){
                MutableReaStepData reaData = new MutableReaStepData();
                reaData.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.of(watch.watch.getStartTime(), watchEndTime));
                TicketManager.getManipulator().applyAction(bunId, reaData, ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(-16), null);
            }
        }
        TicketAccessInformationsProvider.TicketStopWatchChangedEvent event = new TicketAccessInformationsProvider.TicketStopWatchChangedEvent(bunId, null, user);
        this.eventDispatcher.dispatchEvent(l -> l.ticketStopWatchChanged(event));
    }

    private void sendTicketAccessChangedEvent(int bunId) {
        TicketAccessInformationsProvider.TicketAccessChangedEvent event = new TicketAccessInformationsProvider.TicketAccessChangedEvent(bunId, this.getTicketAccessInfo_BunID(bunId));
        this.eventDispatcher.dispatchEvent(listener -> {
            try {
                listener.ticketAccessChanged(event);
            }
            catch (Exception ex) {
                HDLogger.error(ex);
            }
        });
    }

    @Override
    public void handleEvent(TicketEvent event) {
        for (ChangedTicketVO changedTicketVO : event.getChangedTickets()) {
            TicketVO newTicket = changedTicketVO.getNewTicket();
            TicketVO oldTicket = changedTicketVO.getOldTicket();
            if (newTicket == null || oldTicket == null) continue;
            if (newTicket.getBundleID() != oldTicket.getBundleID() && oldTicket.getBundleID() == oldTicket.getID()) {
                this.handleBundling(newTicket, oldTicket);
            }
            this.handleTicketChange(newTicket, oldTicket);
        }
    }

    private synchronized void handleTicketChange(TicketVO newTicket, TicketVO oldTicket) {
        OpenedBuendel openedBuendel = this.theOpenedTickets.get(newTicket.getBundleID());
        if (openedBuendel != null) {
            Consumer<ClientSession> check = session -> {
                ActiveStopWatch watch;
                StopWatchSetting oldS = TicketAccessInformationsProvider.getStopWatchSettingFor(session.getOwner(), oldTicket);
                StopWatchSetting newS = TicketAccessInformationsProvider.getStopWatchSettingFor(session.getOwner(), newTicket);
                if (oldS != StopWatchSetting.AUTOMATIC && newS == StopWatchSetting.AUTOMATIC) {
                    this.autoStartStopWatch((ClientSession)session, newTicket.getBundleID());
                }
                if ((watch = this.stopWatches.get(this.stopWatchKey((ClientSession)session, newTicket.getBundleID()))) != null && newS == StopWatchSetting.OFF) {
                    this.stopStopWatch(session.getOwner().getID(), newTicket.getBundleID(), watch, System.currentTimeMillis(), (byte)2);
                }
            };
            if (openedBuendel.ownerSession != null) {
                check.accept(openedBuendel.ownerSession);
            }
            for (ClientSession s : openedBuendel.otherSessions) {
                check.accept(s);
            }
        }
    }

    private synchronized void handleBundling(TicketVO newTicket, TicketVO oldTicket) {
        OpenedBuendel openedBuendel = this.theOpenedTickets.get(oldTicket.getBundleID());
        if (openedBuendel != null) {
            OpenedBuendel newOpenedBundle = this.theOpenedTickets.get(newTicket.getBundleID());
            if (newOpenedBundle == null) {
                openedBuendel.bunId = newTicket.getBundleID();
                this.theOpenedTickets.put(newTicket.getBundleID(), openedBuendel);
            } else {
                newOpenedBundle.otherSessions.addAll(openedBuendel.otherSessions);
                if (newOpenedBundle.ownerSession == null) {
                    newOpenedBundle.ownerSession = openedBuendel.ownerSession;
                }
            }
            this.theOpenedTickets.remove(oldTicket.getBundleID());
            this.sendTicketAccessChangedEvent(oldTicket.getBundleID());
            this.sendTicketAccessChangedEvent(newTicket.getBundleID());
        }
        HashSet<String> keySet = new HashSet<String>(this.stopWatches.keySet());
        for (String watchKey : keySet) {
            if (!watchKey.startsWith(oldTicket.getBundleID() + "_")) continue;
            String userId = watchKey.substring((oldTicket.getBundleID() + "_").length());
            String newKey = newTicket.getBundleID() + "_" + userId;
            ActiveStopWatch stopWatch = this.stopWatches.remove(watchKey);
            TicketAccessInformationsProvider.TicketStopWatchChangedEvent watchEvent = new TicketAccessInformationsProvider.TicketStopWatchChangedEvent(oldTicket.getBundleID(), null, GUID.valueOf((String)userId));
            this.eventDispatcher.dispatchEvent(l -> l.ticketStopWatchChanged(watchEvent));
            if (this.stopWatches.get(newKey) != null) continue;
            this.stopWatches.put(newKey, stopWatch);
            TicketAccessInformationsProvider.TicketStopWatchChangedEvent watchEvent2 = new TicketAccessInformationsProvider.TicketStopWatchChangedEvent(newTicket.getBundleID(), stopWatch.watch, GUID.valueOf((String)userId));
            this.eventDispatcher.dispatchEvent(l -> l.ticketStopWatchChanged(watchEvent2));
        }
    }

    private class OpenedBuendel
    implements TicketAccessInformations {
        private int bunId;
        private ClientSession ownerSession;
        private ArrayList<ClientSession> otherSessions = new ArrayList();

        private OpenedBuendel(int bunId) {
            this.bunId = bunId;
        }

        private void setOwnerSession(ClientSession userSession) {
            if (userSession != null) {
                boolean exists;
                boolean bl = exists = this.existsInBundle(userSession) > 0;
                if (exists) {
                    this.otherSessions.remove(userSession);
                }
            }
            this.ownerSession = userSession;
        }

        private boolean addSession(ClientSession userSession, int request) {
            boolean isOwner = this.ownerSession == userSession;
            boolean changed = false;
            boolean newTicketAccess = false;
            if ((request & 2) > 0 && this.ownerSession == null && TicketAccessController.this.checkWriteAccess(userSession.getOwner(), this.bunId)) {
                isOwner = true;
                changed = true;
                newTicketAccess = this.existsInBundle(userSession) == -1;
                this.setOwnerSession(userSession);
            } else if (request == 1 && this.existsInBundle(userSession) < 1) {
                this.otherSessions.add(userSession);
                if (isOwner) {
                    this.setOwnerSession(null);
                } else {
                    newTicketAccess = true;
                }
                changed = true;
            }
            if (changed) {
                if (!isOwner) {
                    SetTicketReadAfterAccess.setTicketReadIfReadAccessedBySupporter(this.bunId, this.otherSessions.stream().filter(Objects::nonNull).map(cs -> cs.getOwner().getID()).collect(Collectors.toList()));
                }
                TicketAccessController.this.sendTicketAccessChangedEvent(this.bunId);
                if (newTicketAccess) {
                    TicketAccessController.this.autoStartStopWatch(userSession, this.bunId);
                }
            }
            return isOwner;
        }

        private int existsInBundle(ClientSession userSession) {
            if (userSession.equals(this.ownerSession)) {
                return 0;
            }
            if (this.otherSessions != null) {
                int index = this.otherSessions.indexOf(userSession);
                if (index > -1) {
                    ++index;
                }
                return index;
            }
            return -1;
        }

        private boolean userHasOpenedTicket(UserAccount account) {
            if (this.ownerSession != null && this.ownerSession.getOwner().getID().equals((Object)account.getID())) {
                return true;
            }
            return this.otherSessions.stream().anyMatch(s -> s.getOwner().getID().equals((Object)account.getID()));
        }

        private boolean removeSession(ClientSession sessionToRemove) {
            boolean changed = false;
            if (sessionToRemove.equals(this.ownerSession)) {
                this.setOwnerSession(null);
                changed = true;
            }
            if (this.otherSessions != null && this.otherSessions.remove(sessionToRemove)) {
                changed = true;
            }
            return changed;
        }

        private int occupantsCount() {
            int count;
            int n = count = this.ownerSession != null ? 1 : 0;
            if (this.otherSessions != null) {
                count += this.otherSessions.size();
            }
            return count;
        }

        @Override
        public boolean isInTicket(int sessionId) {
            if (this.ownerSession != null && this.ownerSession.getSessionID() == sessionId) {
                return true;
            }
            if (this.otherSessions != null) {
                for (int i = 0; i < this.otherSessions.size(); ++i) {
                    ClientSession clientSession = this.otherSessions.get(i);
                    if (clientSession == null || clientSession.getSessionID() != sessionId) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getTicketOwnerName() {
            if (this.ownerSession != null) {
                return this.ownerSession.getOwner().getDisplayName();
            }
            return "";
        }

        @Override
        public int getTicketOwnerSessionId() {
            if (this.ownerSession != null) {
                return this.ownerSession.getSessionID();
            }
            return 0;
        }
    }

    private class ActiveStopWatch {
        public DefaultTimerTask coolDownTask;
        private TicketAccessInformationsProvider.StopWatch watch;

        public ActiveStopWatch(TicketAccessInformationsProvider.StopWatch watch) {
            this.watch = watch;
        }
    }
}

