/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.SwingClientActiveUsersInfo;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import srv.controller.TicketAccessController;
import srv.controller.UserSession;
import srv.mail.AutoMailSender;

public class MetaController
implements TicketEventListener,
SwingClientActiveUsersInfo {
    private static final String NULL_STRING = "0";
    private static int[] eskalationsStatus = new int[]{100, 101};
    private static String eskalationsString = null;
    private static HashSet<Integer> escalationCheckedStatus = new HashSet();
    public static final int CHANGED_KATEGORIE = 0;
    public static final int CHANGED_RESSOURCE = 1;
    public static final int CHANGED_ORT = 2;
    public static final int CHANGED_PRIORITAET = 3;
    public static final int CHANGED_IMAP = 4;
    public static final int CHANGED_AKTION = 5;
    public static final int CHANGED_KLASSE = 6;
    public static final int CHANGED_ANFRAGEN = 7;
    public static final int CHANGED_BENUTZERGRUPPE = 8;
    public static final int CHANGED_STATUS = 9;
    public static final int CHANGED_ITIL = 10;
    public static final int CHANGED_GERAETE_TYPEN = 11;
    public static final int CHANGED_SLA = 12;
    public static final int CHANGED_LIZENZEN = 13;
    public static final int CHANGED_VERKAEUFER = 14;
    public static final int CHANGED_DEVICES = 15;
    public static final String[] NAMES = new String[]{"CHANGED_KATEGORIE", "CHANGED_RESSOURCE", "CHANGED_ORT", "CHANGED_PRIORITAET", "CHANGED_IMAP", "CHANGED_AKTION", "CHANGED_KLASSE", "CHANGED_ANFRAGEN", "CHANGED_BENUTZERGRUPPE", "CHANGED_STATUS", "CHANGED_ITIL", "CHANGED_GERAETE_TYPEN", "CHANGED_SLA", "CHANGED_LIZENZEN", "CHANGED_VERKAEUFER", "CHANGED_DEVICES"};
    public static final int STATUS_BIT = 1;
    public static final int ORTE_BIT = 2;
    public static final int AKTIONEN_BIT = 4;
    public static final int KATEGORIE_BIT = 8;
    public static final int KLASSIFIZIERUNG_BIT = 16;
    public static final int PRIORITAET_BIT = 32;
    public static final int RESOURCE_BIT = 64;
    public static final int GERAETE_TYPEN_BIT = 128;
    public static final int VERKAEUFER_BIT = 256;
    public static final int LIZENZEN_BIT = 512;
    public static final int SLA_BIT = 1024;
    public static final int ITIL_BIT = 2048;
    public static final int BENUTZERGRUPPEN_BIT = 4096;
    private int deviceChangeVersion;
    private int katChange;
    private int resChange;
    private int ortChange;
    private int priChange;
    private int imapChange;
    private int aktChange;
    private int klassChange;
    private int anfragenChange;
    private int bgrChange;
    private int statusChange;
    private int itilChange;
    private int gerTypenChange;
    private int slaChange;
    private int lizChange;
    private int verkChange;
    private ArrayList<String[]> aktualisierungsDaten;
    private TypespecificIntMap<UserSession> sessions;
    private Map<Integer, UserSession> lockedSessionPerAnfrage = new HashMap<Integer, UserSession>();
    private Map<Integer, Boolean> exclusiveLockFlagPerAnfrage = new HashMap<Integer, Boolean>();
    private TicketAccessController orderAccess = new TicketAccessController();
    private Map<Integer, UserSession> firstSessionForUser = new HashMap<Integer, UserSession>();

    public MetaController() {
        this.aktualisierungsDaten = new ArrayList();
        this.sessions = new TypespecificIntMap();
        for (String element : NAMES) {
            String[] reihe = new String[]{element, NULL_STRING};
            this.aktualisierungsDaten.add(reihe);
        }
        this.verkChange = 0;
        this.lizChange = 0;
        this.slaChange = 0;
        this.gerTypenChange = 0;
        this.itilChange = 0;
        this.statusChange = 0;
        this.bgrChange = 0;
        this.anfragenChange = 0;
        this.klassChange = 0;
        this.aktChange = 0;
        this.imapChange = 0;
        this.priChange = 0;
        this.ortChange = 0;
        this.resChange = 0;
        this.katChange = 0;
        this.deviceChangeVersion = 0;
        LocationManager.getInstance().addDataChangeListener(() -> this.setChanged(2, false));
        PriorityManager.getInstance().addDataChangeListener(() -> this.setChanged(3, false));
        ClassificationManager.getInstance().addDataChangeListener(() -> this.setChanged(6, false));
        CategoryManager.getInstance().addDataChangeListener(() -> this.setChanged(0, false));
        StatusManager.getInstance().addDataChangeListener(() -> this.setChanged(9, false));
        ItilManager.getInstance().addDataChangeListener(() -> this.setChanged(10, false));
    }

    public TicketAccessController getTicketAccessController() {
        return this.orderAccess;
    }

    public void setChanged(int index, boolean relevant) {
        int val = 0;
        switch (index) {
            case 0: {
                CategoryManager.getInstance().reloadFromDatabase();
                val = ++this.katChange;
                break;
            }
            case 1: {
                val = ++this.resChange;
                break;
            }
            case 2: {
                if (relevant) {
                    LocationManager.getInstance().reloadFromDatabase();
                }
                val = ++this.ortChange;
                break;
            }
            case 3: {
                PriorityManager.getInstance().reloadFromDatabase();
                val = ++this.priChange;
                break;
            }
            case 4: {
                val = ++this.imapChange;
                break;
            }
            case 9: {
                StatusManager.getInstance().reloadFromDatabase();
                val = ++this.statusChange;
                break;
            }
            case 5: {
                val = ++this.aktChange;
                ActionManager.getInstance().reloadFromDatabase();
                break;
            }
            case 6: {
                ClassificationManager.getInstance().reloadFromDatabase();
                val = ++this.klassChange;
                break;
            }
            case 7: {
                val = ++this.anfragenChange;
                break;
            }
            case 8: {
                UserClassManager.getInstance().reloadFromDatabase();
                val = ++this.bgrChange;
                break;
            }
            case 10: {
                ItilManager.getInstance().reloadFromDatabase();
                val = ++this.itilChange;
                break;
            }
            case 11: {
                val = ++this.gerTypenChange;
                break;
            }
            case 12: {
                val = ++this.slaChange;
                break;
            }
            case 13: {
                val = ++this.lizChange;
                break;
            }
            case 14: {
                val = ++this.verkChange;
                break;
            }
            case 15: {
                val = ++this.deviceChangeVersion;
            }
        }
        String[] reihe = this.aktualisierungsDaten.get(index);
        reihe[1] = String.valueOf(val);
    }

    public void noticeClientChanges(int bits) {
        if ((bits & 1) != 0) {
            this.setChanged(9, true);
        }
        if ((bits & 2) != 0) {
            this.setChanged(2, true);
        }
        if ((bits & 4) != 0) {
            this.setChanged(5, true);
        }
        if ((bits & 8) != 0) {
            this.setChanged(0, true);
        }
        if ((bits & 0x10) != 0) {
            this.setChanged(6, true);
        }
        if ((bits & 0x20) != 0) {
            this.setChanged(3, true);
        }
        if ((bits & 0x40) != 0) {
            this.setChanged(1, true);
        }
        if ((bits & 0x80) != 0) {
            this.setChanged(11, true);
        }
        if ((bits & 0x100) != 0) {
            this.setChanged(14, true);
        }
        if ((bits & 0x200) != 0) {
            this.setChanged(13, true);
        }
        if ((bits & 0x400) != 0) {
            this.setChanged(12, true);
        }
        if ((bits & 0x800) != 0) {
            this.setChanged(10, true);
        }
        if ((bits & 0x1000) != 0) {
            this.setChanged(8, true);
        }
    }

    public static boolean isEscalatableStatus(int status) {
        for (int eskalationsStatu : eskalationsStatus) {
            if (eskalationsStatu != status) continue;
            return true;
        }
        return false;
    }

    public static void setEscalationCheckedState(int status) {
        escalationCheckedStatus.add(status);
    }

    public static boolean isEscalationCheckedState(int status) {
        return escalationCheckedStatus.contains(status);
    }

    public static void checkEscalationStates(int status) {
        for (int eskalationsStatu : eskalationsStatus) {
            if (eskalationsStatu != status) continue;
            return;
        }
        MetaController.setEscalationCheckedState(status);
        int[] newEskalations = new int[eskalationsStatus.length + 1];
        System.arraycopy(eskalationsStatus, 0, newEskalations, 0, eskalationsStatus.length);
        newEskalations[MetaController.eskalationsStatus.length] = status;
        eskalationsStatus = newEskalations;
        HDLogger.debug("New escalation status: " + status);
        eskalationsString = null;
    }

    public void checkOpenOrders(boolean vollesProgram, Connection con) {
        if (vollesProgram) {
            this.checkSessions();
        }
    }

    public int changeInRequest(int aufid, int currentStatus, int user, int sessionID, int flag) {
        int BIT_LOCK = 3;
        int BIT_RELOAD = 8;
        int BIT_ANFRAGE = 16;
        int success = 0;
        if (aufid > -1) {
            if (currentStatus >= 100) {
                UserSession userSession = this.lockedSessionPerAnfrage.get(aufid);
                TicketVO request = this.getRequest(aufid);
                if (userSession != null && request != null) {
                    this.unlockSession(userSession);
                }
            } else {
                boolean lock;
                boolean reload = (flag & 8) > 0;
                boolean bl = lock = (flag & 3) > 0;
                if (reload && this.getRequest(aufid) == null) {
                    HDLogger.warn("Anfrage nicht gefunden: " + aufid);
                }
                if ((flag & 0x10) > 0) {
                    AutoMailSender.sendIfNeeded(aufid, 6, (String)null);
                }
                TicketVO anfrage = this.getRequest(aufid);
                UserSession session = this.aktualisiereUserSession(sessionID, user);
                this.unlockSession(session);
                if (lock) {
                    if (anfrage != null) {
                        this.lockSessionAndAuftrag(aufid, session);
                        this.exclusiveLockFlagPerAnfrage.put(aufid, (flag & 2) != 0);
                    } else {
                        HDLogger.debug("Anfrage nicht vorhanden (lock)");
                    }
                }
            }
        } else {
            UserSession session = this.aktualisiereUserSession(sessionID, user);
            this.unlockSession(session);
        }
        return success;
    }

    private void lockSessionAndAuftrag(int aufid, UserSession session) {
        this.lockedSessionPerAnfrage.put(aufid, session);
        session.setLockedRequest(aufid);
    }

    private void unlockSession(UserSession session) {
        if (session.getLockedRequest() != null) {
            UserSession userSession = this.lockedSessionPerAnfrage.get(session.getLockedRequest());
            if (userSession == session) {
                this.lockedSessionPerAnfrage.remove(session.getLockedRequest());
                this.exclusiveLockFlagPerAnfrage.put(session.getLockedRequest(), false);
            }
            session.setLockedRequest(null);
        }
    }

    public TicketVO getRequest(int id) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(id);
        return ticket == null ? null : (ticket.isInquiry() ? ticket : null);
    }

    private void checkSessions() {
        int[] keys = this.sessions.getAllKeys();
        long compareTime = System.currentTimeMillis() - 10000L;
        HDLogger.debug("Current SessionObject count: " + keys.length);
        for (int key : keys) {
            try {
                UserSession testSession = this.sessions.get(key);
                if (testSession.isHdMobile() || testSession.getLastContact() >= compareTime) continue;
                this.instanceClose(HDUsersAndGroups.getUserID(testSession.getOwner()), key);
            }
            catch (Throwable er) {
                HDLogger.error(er);
            }
        }
    }

    public boolean instanceClose(int usrid, int hdsession) {
        UserSession session = this.sessions.get(hdsession);
        if (session != null) {
            session.setClosed();
            if (session.getLockedRequest() != null) {
                this.unlockSession(session);
            }
            this.sessions.remove(hdsession);
            this.removeSessionFromUser(hdsession, usrid);
        }
        return true;
    }

    public UserSession getUserSession(int hdsession) {
        return this.sessions.get(hdsession);
    }

    public TypespecificIntMap<UserSession> getCurrentConnectedSessions() {
        return this.sessions;
    }

    public UserSession aktualisiereUserSession(int hdsession, int usrid) {
        UserSession session = this.getSessionForUser(hdsession, usrid);
        if (session == null) {
            this.checkSessions();
            UserSession testSession = this.sessions.get(hdsession);
            if (testSession != null) {
                this.instanceClose(HDUsersAndGroups.getUserID(testSession.getOwner()), hdsession);
            }
            session = this.addSessionForUser(hdsession, usrid);
            this.sessions.put(hdsession, session);
        } else {
            session.setLastContact(System.currentTimeMillis());
        }
        return session;
    }

    @Override
    public void handleEvent(TicketEvent event) {
    }

    @Override
    public Set<GUID> getGUIDsOfCurrentlyActiveSwingClientUsers() {
        TypespecificIntMap<UserSession> currentSwingSessions = this.getCurrentConnectedSessions();
        return currentSwingSessions.getValueList().stream().map(s -> s.getOwner().getID()).collect(Collectors.toSet());
    }

    @Nullable
    public ArrayList<UserSession> getSessionsForUser(int userId) {
        long compareTime = System.currentTimeMillis() - 10000L;
        ArrayList<UserSession> allMySessions = null;
        for (UserSession session = this.firstSessionForUser.get(userId); session != null; session = session.getNextSession()) {
            if (session.getLastContact() > compareTime && !session.isClosed()) {
                if (allMySessions == null) {
                    allMySessions = new ArrayList<UserSession>();
                }
                allMySessions.add(session);
                continue;
            }
            HDLogger.debug("ERROR found invalid Session-Object");
        }
        return allMySessions;
    }

    @Nullable
    public UserSession getSessionForUser(int key, int userId) {
        UserSession session;
        for (session = this.firstSessionForUser.get(userId); session != null && session.getSessionID() != key; session = session.getNextSession()) {
        }
        return session;
    }

    public UserSession addSessionForUser(int key, int userId) {
        int count = 1;
        UserAccount account = HDUsersAndGroups.getUserAccount(userId);
        UserSession session = new UserSession(account, key);
        UserSession firstSession = this.firstSessionForUser.get(userId);
        if (firstSession == null) {
            firstSession = session;
            this.firstSessionForUser.put(userId, firstSession);
        } else {
            UserSession someSession = firstSession;
            while (someSession.getNextSession() != null) {
                ++count;
                someSession = someSession.getNextSession();
            }
            someSession.setNextSession(session);
        }
        if (count % 10 == 0) {
            HDLogger.debug(count + ". SessionObject erzeugt. User " + userId + " " + count);
        }
        return session;
    }

    private void removeSessionFromUser(int key, int userId) {
        UserSession firstSession = this.firstSessionForUser.get(userId);
        if (firstSession == null) {
            return;
        }
        if (firstSession.getSessionID() == key) {
            firstSession = firstSession.getNextSession();
            this.firstSessionForUser.put(userId, firstSession);
        } else {
            UserSession session;
            UserSession prev = firstSession;
            for (session = firstSession.getNextSession(); session != null && session.getSessionID() != key; session = session.getNextSession()) {
                prev = session;
            }
            if (session != null) {
                this.unlockSession(session);
                prev.setNextSession(session.getNextSession());
            } else {
                HDLogger.debug("ERROR can not remove the Session-Object");
            }
        }
    }
}

