/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientSession {
    private final int sessionId;
    @Nonnull
    private UserAccount owner;
    @Nullable
    private String clientID;
    private int countOfOpenOrders = 0;

    public static ClientSession create(@Nonnull UserAccount owner, String clientID) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner cannot be null!");
        }
        if (clientID == null) {
            throw new IllegalArgumentException("ClientID cannot be null here!");
        }
        ClientSession clientSession = new ClientSession(owner, ClientSession.generateNewSessionID(owner, clientID));
        clientSession.clientID = clientID;
        return clientSession;
    }

    protected ClientSession(@Nonnull UserAccount owner, int sessionId) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner cannot be null!");
        }
        this.owner = owner;
        this.sessionId = sessionId;
    }

    private static int generateNewSessionID(UserAccount owner, String clientID) {
        long ses = System.currentTimeMillis() + (long)clientID.hashCode() + (long)HDUsersAndGroups.getUserID(owner);
        return (int)(ses & Integer.MAX_VALUE);
    }

    public int getCountOfOpenOrders() {
        return this.countOfOpenOrders;
    }

    protected void setCountOfOpenOrders(int countOfOpenOrders) {
        this.countOfOpenOrders = countOfOpenOrders;
    }

    public int getSessionID() {
        return this.sessionId;
    }

    @Nonnull
    public UserAccount getOwner() {
        return this.owner;
    }

    public String getClientID() {
        return this.clientID;
    }
}

