/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.trigger;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.ticketmanager.trigger.StatusAndItilChangeTrigger;
import com.inet.logging.LogManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.SuppressFBWarnings;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import srv.mail.Mail;

public class Trigger {
    String scriptContent;
    boolean valid = false;
    Object problem = null;
    Object[] keineDaten = new Object[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="input file is user defined")
    public Trigger(String scriptContent, int type) {
        Context cx = null;
        try {
            this.scriptContent = scriptContent;
            cx = Context.enter();
            ScriptableObject scope = cx.initStandardObjects();
            cx.evaluateString((Scriptable)scope, scriptContent, "<cmd>", 1, null);
            Object fObj = scope.get("checkData", (Scriptable)scope);
            if (fObj instanceof Function) {
                if (type == 3) {
                    fObj = scope.get("getStatus", (Scriptable)scope);
                    if (fObj instanceof Function) {
                        Function f = (Function)fObj;
                        Object result = f.call(cx, (Scriptable)scope, (Scriptable)scope, this.keineDaten);
                        String report = Context.toString((Object)result);
                        this.valid = true;
                        StatusAndItilChangeTrigger.readStatusWhenStatusTriggerMustRun(report);
                        if (!this.valid) {
                            this.problem = "invalid status value";
                        }
                    } else {
                        this.problem = "function getStatus is not implemented!";
                        this.valid = false;
                    }
                } else {
                    this.valid = true;
                }
            } else {
                this.problem = "function checkData is not implemented!";
                this.valid = false;
            }
        }
        catch (Throwable er) {
            this.problem = er;
            HDLogger.debug(er);
        }
        finally {
            if (cx != null) {
                Context.exit();
            }
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected Object getProblem() {
        return this.problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Exception checkData(Map<String, String> table, boolean checkMail) {
        Exception ex = null;
        Context cx = Context.enter();
        try {
            Hashtable<String, String> jsTable;
            if (table instanceof Hashtable) {
                jsTable = (Hashtable<String, String>)table;
            } else {
                this.dropAllNullValues(table);
                jsTable = new Hashtable<String, String>(table);
            }
            ScriptableObject scope = cx.initStandardObjects();
            cx.evaluateString((Scriptable)scope, this.scriptContent, "<cmd>", 1, null);
            Object fObj = scope.get("checkData", (Scriptable)scope);
            Object[] functionArgs = new Object[]{jsTable, LogManager.getLogStream()};
            Function f = (Function)fObj;
            f.call(cx, (Scriptable)scope, (Scriptable)scope, functionArgs);
            this.checkExecutable(jsTable, checkMail);
            if (table instanceof Hashtable) {
            } else {
                table.clear();
                table.putAll(jsTable);
            }
        }
        catch (Exception er) {
            ex = er;
            HDLogger.error(er);
        }
        finally {
            Context.exit();
        }
        return ex;
    }

    private void dropAllNullValues(Map<String, String> table) {
        ArrayList toDrop = new ArrayList();
        table.forEach((key, val) -> {
            if (val == null) {
                toDrop.add(key);
            }
        });
        toDrop.forEach(key -> {
            HDLogger.debug(String.format("Drop key %s from table for trigger because value is null", key));
            table.remove(key);
        });
    }

    private void checkExecutable(Map<String, String> table, boolean checkMail) {
        String dummy = table.get("templatename");
        if (checkMail && dummy != null && dummy.length() > 0) {
            Mail.send(new Hashtable<String, String>(table), 666, null);
        }
    }
}

