/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.FieldMapping;
import com.inet.helpdesk.config.FieldMappingEntry;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.DataImportJob;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserIterator;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.image.UserAvatar;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import srv.HdLicenseObserver;
import srv.ServerUtilities;
import srv.automatic.CIHashMap;
import srv.automatic.FieldImportRules;
import srv.automatic.LdapFormatHandler;
import srv.automatic.LdapUtilities;
import srv.automatic.StringIntHashMap;
import srv.automatic.userimport.ImportUserDataStates;
import srv.automatic.userimport.UserImportData;

public class UserImporter {
    static final char[] BUCHSTABEN = new char[]{'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 't', 'v', 'w', 'x', 'y', 'z'};
    private boolean userAccountControlAvailable;
    private boolean userHideFromListAvailable;
    private String photoAttribute = null;
    private List<FieldMappingEntry> neededAttributesOrColumns = new ArrayList<FieldMappingEntry>();
    private FieldMappingEntry usernameEntry;
    private FieldMappingEntry alternativeUsernameEntry;
    private FieldMappingEntry supervisorEntry;
    private FieldMappingEntry surnameEntry;
    private FieldMappingEntry givennameEntry;
    private static final int PAGE_SIZE = 500;
    private static long ATTRIBUTE_BUFFER_TIME = 10000L;
    private static String bufferKey;
    private static ArrayList<String> bufferdAttributes;
    private static long lastRequested;
    private UserImportConfigInfo importConfigInfo;
    private boolean supervisorDaten;
    private int userUpdateCounter;
    private static boolean killed;
    private int locationInsertCounter;
    private int bgrInsertCounter;
    private String[] attrListe;
    private int userCount;
    private int bufferedData;
    private StringIntHashMap entrysPerImport;
    private HashMap<String, UserImportData> userLogins;
    private UserField<Object> importNameField;
    private StringIntHashMap locations;
    private StringIntHashMap benutzergruppen;
    private int standardGeb;
    private int standardBenGr;
    private String standardSprache;
    private boolean needSpezialDN;
    private String spezialDNadd;
    private static ConfigValue<UserImportConfigInfoMap> USER_IMPORT_CONFIGS;
    private static final ConfigValue<LdapConnectionInfoMap> LDAP_CONNECTION_INFOS;
    private static final ConfigValue<DatabaseConfigInfoList> DB_INFOS;
    private static final Logger logger;
    private static final Object MONITOR_OBJECT;
    private static final I18nMessages MSG;

    public UserImporter() {
        killed = false;
    }

    public UserImporter(UserImportConfigInfo userImportConfigInfo) {
        this.importConfigInfo = userImportConfigInfo;
        userImportConfigInfo.setAlle(true);
        killed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserImporter(boolean zeitTest, UserImportConfigInfo userImportConfigInfo, DataImportJob dataImportJob) {
        try {
            this.importConfigInfo = userImportConfigInfo;
            DataImportConnector dataImportConnector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
            if (zeitTest && !dataImportConnector.isTimeForJob(userImportConfigInfo.getUid(), userImportConfigInfo.getSchedule(), ServerUtilities.getCalendar())) {
                return;
            }
            logger.info((Object)"Start User Import");
            if (userImportConfigInfo.isLdap()) {
                LdapConnectionInfoMap ldapConns = (LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get();
                LdapConnectionInfo ldapConn = ldapConns.get(userImportConfigInfo.getConnectionName());
                if (ldapConn == null) {
                    throw new IllegalArgumentException(MSG.getMsg("dataImport.noConnectionFound", new Object[]{userImportConfigInfo.getConnectionName()}));
                }
                this.runForLdap(dataImportJob, new ReadAndImportRecordStateFactory(), ldapConn);
                return;
            }
            DatabaseConfigInfoList list = (DatabaseConfigInfoList)DB_INFOS.get();
            DatabaseConfigInfo dbConn = list.get(userImportConfigInfo.getConnectionName());
            if (dbConn == null) {
                throw new IllegalArgumentException(MSG.getMsg("dataImport.noConnectionFound", new Object[]{userImportConfigInfo.getConnectionName()}));
            }
            this.runForSqlDb(dataImportJob, new ReadAndImportRecordStateFactory(), dbConn);
        }
        catch (Throwable t) {
            logger.error(t);
            String error = StringFunctions.getUserFriendlyErrorMessage((Throwable)t);
            if (error.isEmpty()) {
                error = MSG.getMsg("dataImport.userImport.importFailed", new Object[0]);
            }
            dataImportJob.setError(error);
        }
        finally {
            if (dataImportJob != null) {
                if (dataImportJob.getStartTime() == 0L) {
                    dataImportJob.setStartTime(System.currentTimeMillis());
                }
                if (dataImportJob.getEndTime() == 0L) {
                    dataImportJob.setEndTime(System.currentTimeMillis());
                }
            }
            HdLicenseObserver.resetLicenseCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="The SQL for ther query is internally created")
    public ReadRecordState runForSqlDb(DataImportJob dataImportJob, ReadRecordStateFactory readRecordStateFactory, DatabaseConfigInfo dbConn) {
        if (dataImportJob == null) {
            dataImportJob = new DataImportJob();
        }
        long start = System.currentTimeMillis();
        StringBuffer sql = new StringBuffer("SELECT ");
        try {
            dataImportJob.setStartTime(start);
            logger.debug((Object)"SQL Import called");
            Statement stQuelle = null;
            ResultSet rsQuelle = null;
            try (Connection conQuelle = UserImporter.getConnection(dbConn);){
                Object uid;
                this.setImportOptions(false);
                if (this.usernameEntry.getSelectedColumn().length() == 0) {
                    ReadRecordState readRecordState = null;
                    return readRecordState;
                }
                this.fetchStartData(UserManager.getInstance(), this.importConfigInfo.getUid());
                String tableName = this.importConfigInfo.getTable();
                if (tableName != null && tableName.startsWith("Procedure: ")) {
                    String procedureName = tableName.substring("Procedure: ".length());
                    CallableStatement stm = conQuelle.prepareCall("{call " + procedureName + "}");
                    stQuelle = stm;
                    rsQuelle = stm.executeQuery();
                } else {
                    String quotString = conQuelle.getMetaData().getIdentifierQuoteString();
                    sql.append(quotString).append(this.attrListe[0]).append(quotString);
                    for (int i = 1; i < this.attrListe.length; ++i) {
                        sql.append(", ").append(quotString).append(this.attrListe[i]).append(quotString);
                    }
                    sql.append(" FROM ");
                    if (DatabaseConfigInfo.DatabaseType.odbc.equals((Object)dbConn.getDriver())) {
                        sql.append(quotString).append(tableName).append(quotString);
                    } else {
                        sql.append(tableName);
                    }
                    String query = DatabaseConfigInfo.DatabaseType.inetora.equals((Object)dbConn.getDriver()) ? sql.toString().toUpperCase() : sql.toString();
                    stQuelle = conQuelle.createStatement();
                    rsQuelle = stQuelle.executeQuery(query);
                }
                while (rsQuelle.next() && !killed) {
                    uid = this.readUserData(this.importConfigInfo.getUid(), this.usernameEntry.getSelectedColumn(), this.alternativeUsernameEntry.getSelectedColumn(), rsQuelle);
                    if (!this.relevantForImport((UserImportData)uid, dataImportJob)) continue;
                    try {
                        ReadRecordState readRecordState = readRecordStateFactory.createReadRecordState(dataImportJob, this.importConfigInfo.getUid(), (UserImportData)uid).invoke();
                        if (!readRecordStateFactory.isFinished(true)) continue;
                        ReadRecordState dauer = readRecordState;
                        return dauer;
                    }
                    catch (Throwable e) {
                        logger.error(e);
                        String message = StringFunctions.getUserFriendlyErrorMessage((Throwable)e);
                        dataImportJob.setError(message);
                        dataImportJob.incrementErrorsCount();
                    }
                }
                if (readRecordStateFactory.isFinished(false)) {
                    uid = readRecordStateFactory.getLastState();
                    return uid;
                }
                if (this.importConfigInfo.isLoeschen() && !killed) {
                    this.delete(dataImportJob, this.importConfigInfo.isSupporterLoeschen(), this.importConfigInfo.getUid());
                }
                logger.info((Object)("Add " + dataImportJob.getEntriesAdded() + " count " + dataImportJob.getEntriesCount() + " errors " + dataImportJob.getEntriesError()));
                if (this.supervisorDaten) {
                    logger.info((Object)("Supervisor add " + dataImportJob.getEntriesAddedSupervisors() + " supervisor remove " + dataImportJob.getEntriesDeletedSupervisors()));
                }
                if (dataImportJob.getEntriesMissingLicense() > 0) {
                    String errorMessage = MSG.getMsg("dataImport.userImport.licenseCount", new Object[]{dataImportJob.getEntriesMissingLicense()});
                    logger.error((Object)errorMessage);
                    dataImportJob.setError(errorMessage);
                }
            }
            catch (Throwable e) {
                logger.error((Object)("SQL: " + sql.toString()));
                logger.error(e);
                String message = StringFunctions.getUserFriendlyErrorMessage((Throwable)e);
                dataImportJob.setError(message);
            }
            finally {
                try {
                    rsQuelle.close();
                }
                catch (Throwable throwable) {}
                try {
                    stQuelle.close();
                }
                catch (Throwable throwable) {}
            }
            if (this.bgrInsertCounter > 0) {
                ServerUtilities.conti.setChanged(8, true);
            }
            if (this.locationInsertCounter <= 0) return null;
            ServerUtilities.conti.setChanged(2, true);
            return null;
        }
        finally {
            long endZeit = System.currentTimeMillis();
            long dauer = endZeit - start;
            dataImportJob.setEndTime(endZeit);
            logger.info((Object)("User-Import fertig: " + dauer + "ms " + this.userUpdateCounter + " updates  " + dataImportJob.getEntriesAdded() + " imports!"));
        }
    }

    public void work() {
        UserImportConfigInfoMap userImportConfigs = (UserImportConfigInfoMap)USER_IMPORT_CONFIGS.get();
        DataImportConnector dataImportConnector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        HashMap<String, DataImportJob> jobs = new HashMap<String, DataImportJob>();
        for (String userImportConfigKey : userImportConfigs.keySet()) {
            UserImportConfigInfo userImportConfigInfo = (UserImportConfigInfo)userImportConfigs.get(userImportConfigKey);
            if (dataImportConnector.getJobs(userImportConfigInfo.getUid()).stream().filter(DataImportJob::isRunning).count() > 0L || !dataImportConnector.isTimeForJob(userImportConfigInfo.getUid(), userImportConfigInfo.getSchedule(), ServerUtilities.getCalendar())) continue;
            jobs.put(userImportConfigKey, dataImportConnector.createJob(userImportConfigInfo.getUid()));
        }
        new Thread(() -> {
            Object object = MONITOR_OBJECT;
            synchronized (object) {
                for (String userImportConfigKey : userImportConfigs.keySet()) {
                    try {
                        UserImportConfigInfo userImportConfigInfo = (UserImportConfigInfo)userImportConfigs.get(userImportConfigKey);
                        new UserImporter(true, userImportConfigInfo, (DataImportJob)jobs.get(userImportConfigKey));
                    }
                    catch (Throwable e) {
                        logger.error(e);
                    }
                }
            }
        }, "UserImport - Scheduled").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow(UserImportConfigInfo userImportConfigInfo, DataImportJob dataImportJob) {
        Object object = MONITOR_OBJECT;
        synchronized (object) {
            logger.info((Object)"Start manual User Import");
            try {
                new UserImporter(false, userImportConfigInfo, dataImportJob);
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public ReadRecordState runForLdap(DataImportJob dataImportJob, ReadRecordStateFactory readRecordStateFactory, LdapConnectionInfo ldapConn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="The LDAP statement is genrerated internally")
    private ReadRecordState executeLdapSearch(InitialLdapContext ctx, String[] searchItems, DataImportJob dataImportJob, LdapConnectionInfo ldapConn, ReadRecordStateFactory readRecordStateFactory, LdapSearchOptions lso) throws NamingException, IOException {
        for (String searchContext : lso.searchContextValues) {
            if (searchContext.length() > 0 && this.needSpezialDN) {
                this.spezialDNadd = "," + searchContext;
            }
            for (String searchItem : searchItems) {
                if (killed) {
                    return null;
                }
                logger.debug((Object)("SEARCH: " + searchContext + " - " + searchItem));
                byte[] cookie = null;
                if (lso.pagedSearch) {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(500, true)});
                }
                do {
                    NamingEnumeration<SearchResult> enumeration = ctx.search(searchContext, searchItem, LdapUtilities.getSearchControls(this.attrListe));
                    ++lso.searchExecutions;
                    while (LdapUtilities.enumerationHasMore(enumeration)) {
                        Object uhfl;
                        Object uac;
                        Attribute attr;
                        SearchResult sr = (SearchResult)enumeration.nextElement();
                        Attributes attrs = sr.getAttributes();
                        String invalidReason = "";
                        if (this.userAccountControlAvailable && (attr = attrs.get("userAccountControl")) != null && (uac = attr.get()) != null && (Integer.parseInt(uac.toString()) & 2) != 0) {
                            invalidReason = "Disabled";
                        }
                        if (this.userHideFromListAvailable && (attr = attrs.get("msExchHideFromAddressLists")) != null && (uhfl = attr.get()) != null && "TRUE".equals(uhfl)) {
                            invalidReason = "Hidden";
                        }
                        if (invalidReason.length() == 0) {
                            UserImportData uid = this.readUserData(lso.importName, this.usernameEntry.getSelectedColumn(), this.alternativeUsernameEntry.getSelectedColumn(), attrs, sr);
                            if (!this.relevantForImport(uid, dataImportJob)) continue;
                            try {
                                String uName = uid.getData(this.usernameEntry);
                                if (uName != null && uName.length() > 0) {
                                    uid.addData(this.usernameEntry, this.plusDomain(uName));
                                }
                                ReadRecordState recordState = readRecordStateFactory.createReadRecordState(dataImportJob, lso.importName, uid).invoke();
                                if (!readRecordStateFactory.isFinished(true)) continue;
                                return recordState;
                            }
                            catch (Exception e) {
                                logger.error((Throwable)e);
                                String message = StringFunctions.getUserFriendlyErrorMessage((Throwable)e);
                                dataImportJob.setError(message);
                                dataImportJob.incrementErrorsCount();
                                continue;
                            }
                        }
                        attr = attrs.get(this.usernameEntry.getSelectedColumn());
                        logger.debug((Object)(invalidReason + " Account: " + (attr != null ? attr.get().toString() : "Unknown")));
                    }
                    try {
                        enumeration.close();
                    }
                    catch (Exception sr) {
                        // empty catch block
                    }
                    if (readRecordStateFactory.isFinished(false)) {
                        return readRecordStateFactory.getLastState();
                    }
                    if (!lso.pagedSearch) continue;
                    Control[] controls = ctx.getResponseControls();
                    if (controls != null) {
                        for (Control control : controls) {
                            if (!(control instanceof PagedResultsResponseControl)) continue;
                            PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
                            cookie = prrc.getCookie();
                        }
                    }
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(500, cookie, true)});
                } while (cookie != null);
            }
        }
        return null;
    }

    protected String uppercasePlusDomain(String username) {
        username = this.plusDomain(username);
        return username.toUpperCase();
    }

    private String plusDomain(String username) {
        if (((String)(username = ((String)username).replace('/', '\\'))).indexOf(92) == -1) {
            username = this.getDomain() + (String)username;
        }
        return username;
    }

    private String getDomain() {
        LdapConnectionInfo ldapConn = this.getCurrentLdapConnectionInfo();
        if (ldapConn != null && ldapConn.getDomaene() != null && ldapConn.getDomaene().length() > 0) {
            return ldapConn.getDomaene() + "\\";
        }
        return "";
    }

    protected LdapConnectionInfo getCurrentLdapConnectionInfo() {
        if (this.importConfigInfo.isLdap()) {
            LdapConnectionInfoMap ldapConns = (LdapConnectionInfoMap)LDAP_CONNECTION_INFOS.get();
            return ldapConns.get(this.importConfigInfo.getConnectionName());
        }
        return null;
    }

    private void reaktivieren(DataImportJob dataImportJob, String importName, UserImportData bufferedData) {
        String username = bufferedData.getData(this.usernameEntry);
        if (this.update(dataImportJob, importName, bufferedData, true)) {
            ++this.userCount;
            if (logger.isDebug()) {
                logger.debug((Object)("User: " + username + " reactivation."));
            }
        } else {
            logger.debug((Object)("User: " + username + " no reactivation."));
            dataImportJob.incrementMissingLicenseCount();
        }
    }

    private boolean update(DataImportJob dataImportJob, String importName, UserImportData bufferedData, boolean reaktivieren) throws IllegalStateException {
        boolean changedFlag = false;
        try {
            UserAccount userAccount = bufferedData.getAccount();
            GUID accountId = userAccount.getID();
            if (reaktivieren) {
                if (userAccount.getValue((UserField)UsersAndGroups.FIELD_USER_LOCKED) != null) {
                    logger.warn((Object)("Account " + accountId.toString() + " is locked and can not be reactivated!"));
                    return false;
                }
                if (!userAccount.isActive()) {
                    UserManager.getInstance().setUserAccountActive(userAccount.getID());
                    changedFlag = true;
                    dataImportJob.incrementReactivatedCount();
                }
            }
            MutableUserData userData = new MutableUserData();
            boolean dataChanges = false;
            for (Map.Entry<FieldMappingEntry, String> entry : bufferedData.getDataEntrySet()) {
                UserField field;
                Object oldValue;
                String value = entry.getValue();
                if ("GebID".equals(entry.getKey().getDefininitionColumn())) {
                    if (value.trim().length() == 0) continue;
                    int neuerWert = this.getGebID(value);
                    UserField locationField = UserManager.getInstance().getField("location");
                    if ((Integer)userAccount.getValue(locationField) == neuerWert) continue;
                    userData.put(locationField, (Object)neuerWert);
                    dataChanges = true;
                    continue;
                }
                if ("BgrID".equals(entry.getKey().getDefininitionColumn())) {
                    if (value.trim().length() == 0) continue;
                    int neuerWert = this.getBgrID(value);
                    UserField usergroupField = UserManager.getInstance().getField("groupid");
                    if ((Integer)userAccount.getValue(usergroupField) == neuerWert) continue;
                    userData.put(usergroupField, (Object)neuerWert);
                    dataChanges = true;
                    continue;
                }
                if ("Username".equals(entry.getKey().getDefininitionColumn())) {
                    changedFlag = this.handleSystemLogin(userAccount, value, false) || changedFlag;
                    continue;
                }
                if ("SecondUsername".equals(entry.getKey().getDefininitionColumn())) {
                    changedFlag = this.handleSystemLogin(userAccount, value, true) || changedFlag;
                    continue;
                }
                if ("Supervisor".equals(entry.getKey().getDefininitionColumn()) || this.compareEquals(value, oldValue = userAccount.getValue(field = (UserField)HDFieldLocator.getUserFieldForDBKey(entry.getKey().getDefininitionColumn())))) continue;
                userData.put(field, (Object)value);
                dataChanges = true;
            }
            Object importNameObject = userAccount.getValue(this.importNameField);
            if (!importName.equals(importNameObject)) {
                userData.put(this.importNameField, (Object)importName);
                dataChanges = true;
            }
            if (this.importConfigInfo.isPictureImport() && this.handleAvatarImage(userAccount.getID(), bufferedData.getImageData(), true)) {
                dataChanges = true;
            }
            if (dataChanges) {
                UserManager.getInstance().updateUserData(accountId, userData);
                changedFlag = true;
            }
            if (changedFlag) {
                dataImportJob.incrementUpdatedCount();
                ++this.userUpdateCounter;
            }
            if (this.supervisorDaten) {
                this.handleSupervisedGroups(dataImportJob, importName, bufferedData);
            }
            dataImportJob.incrementImportedCount();
            bufferedData.setState(ImportUserDataStates.ALREADY_TREATED);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            dataImportJob.setError(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean handleSystemLogin(UserAccount userAccount, String value, boolean isAlternativeLogin) {
        String username;
        if (isAlternativeLogin && (value == null || value.trim().length() == 0)) {
            return false;
        }
        GUID accountId = userAccount.getID();
        List logins = userAccount.getLoginSettingsFor("system");
        for (LoginSettings ls : logins) {
            String loginName = ls.getLoginID();
            if (!this.normalizeForMap(value).equals(this.normalizeForMap(loginName))) continue;
            return false;
        }
        if (isAlternativeLogin && this.userLogins.get(username = this.normalizeForMap(value)) != null) {
            return false;
        }
        ArrayList<LoginSettings> settingsToAdd = new ArrayList<LoginSettings>();
        settingsToAdd.add(new LoginSettings("system", value, null));
        ArrayList settingsToRemove = new ArrayList();
        UserManager.getInstance().updateLoginSettings(accountId, settingsToAdd, settingsToRemove);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleAvatarImage(GUID userAccountID, byte[] image, boolean update) {
        if (image != null) {
            block23: {
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream(image);
                    BufferedImage bImage = ImageIO.read(bis);
                    int height = bImage.getHeight();
                    int width = bImage.getWidth();
                    if (height != width) {
                        if (height > width) {
                            diff = height - width;
                            bImage = bImage.getSubimage(0, diff / 3, width, height - diff);
                        } else {
                            diff = width - height;
                            bImage = bImage.getSubimage(diff / 2, 0, width - diff, height);
                        }
                    }
                    Image tmp = bImage.getScaledInstance(300, 300, 4);
                    bImage = new BufferedImage(300, 300, 2);
                    Graphics2D g2d = bImage.createGraphics();
                    g2d.drawImage(tmp, 0, 0, null);
                    g2d.dispose();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bImage, "png", baos);
                    image = baos.toByteArray();
                    if (!update) break block23;
                    try (InputStream avatarStream = UserManager.getInstance().getBinaryData(userAccountID, UserAvatar.BINARYKEY_USERAVATAR);){
                        byte[] tocompare;
                        if (avatarStream != null && Arrays.equals(image, tocompare = IOFunctions.readBytes((InputStream)avatarStream))) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            logger.debug((Object)"Change avatar image");
            UserManager.getInstance().storeBinaryData(userAccountID, UserAvatar.BINARYKEY_USERAVATAR, (InputStream)new ByteArrayInputStream(image), image.length);
            return true;
        }
        if (!update) return false;
        try (InputStream avatarStream = UserManager.getInstance().getBinaryData(userAccountID, UserAvatar.BINARYKEY_USERAVATAR);){
            if (avatarStream == null) return false;
            logger.debug((Object)"Remove avatar image");
            UserManager.getInstance().deleteBinaryData(userAccountID, UserAvatar.BINARYKEY_USERAVATAR);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean compareEquals(@Nonnull String str, Object compare) {
        if (str.length() == 0 && compare == null) {
            return true;
        }
        return str.equals(compare);
    }

    private void bufferImportableData(String importName, UserImportData insertableUser, DataImportJob dataImportJob) {
        if (this.handleNonImportableUser(insertableUser, dataImportJob)) {
            this.userLogins.put(this.normalizeForMap(insertableUser.getData(this.usernameEntry)), insertableUser);
        }
    }

    private boolean handleNonImportableUser(UserImportData possibleUser, DataImportJob dataImportJob) {
        dataImportJob.incrementMissingLicenseCount();
        int currentAvailable = this.entrysPerImport.get(possibleUser.getImportKey()) - dataImportJob.getEntriesCount();
        logger.debug((Object)("User: " + possibleUser.getData(this.usernameEntry) + " buffer data! Unknown Licence count " + currentAvailable + " imported " + this.entrysPerImport.get(possibleUser.getImportKey())));
        if (this.bufferedData <= currentAvailable) {
            ++this.bufferedData;
            return true;
        }
        return false;
    }

    protected boolean loginNotOfThisImport(String username) {
        String domain = this.getDomain();
        return domain.length() > 0 && !username.startsWith(domain.toUpperCase());
    }

    private UserImportData getUserDataByName(String name) {
        String currentDomain;
        String username = this.normalizeForMap(name);
        UserImportData theUser = this.userLogins.get(username);
        if (theUser == null && (currentDomain = this.getDomain().toUpperCase()).length() > 0) {
            username = username.startsWith(currentDomain) ? username.substring(currentDomain.length()) : this.uppercasePlusDomain(username);
            theUser = this.userLogins.get(username);
        }
        return theUser;
    }

    private void delete(DataImportJob dataImportJob, boolean supporterLoeschen, String importName) throws SQLException {
        UserImportData currentUser;
        for (Map.Entry<String, UserImportData> e : this.userLogins.entrySet()) {
            currentUser = e.getValue();
            if (currentUser.getState() != ImportUserDataStates.VALID || !importName.equals(currentUser.getImportKey()) || currentUser.isSupporter() && !supporterLoeschen) continue;
            UserAccount userAccount = currentUser.getAccount();
            if (currentUser.getLoginCount() == 1 && this.loginNotOfThisImport(e.getKey())) {
                MutableUserData userData = new MutableUserData();
                userData.put(this.importNameField, (Object)"");
                UserManager.getInstance().updateUserData(userAccount.getID(), userData);
                continue;
            }
            for (UserClassManager.SupervisorMemberShip sms : currentUser.getSupervisorMemberShips()) {
                UserClassManager.getInstance().removeSupervisorMemberShip(sms.getUserID(), sms.getTeamID());
                dataImportJob.incrementDeletedSupervisorsCount();
            }
            UserManager.getInstance().setUserAccountInactive(userAccount.getID());
            dataImportJob.incrementDeletedCount();
            --this.userCount;
            currentUser.setState(ImportUserDataStates.ALREADY_TREATED);
        }
        if (dataImportJob.getEntriesDeleted() > 0) {
            logger.info((Object)("Von " + this.userCount + " Benutzern wurden " + dataImportJob.getEntriesDeleted() + " gel\u00f6scht!"));
            if (dataImportJob.getEntriesError() > 0 && this.userCount < HdLicenseObserver.getMaxUsers() && HdLicenseObserver.getMaxUsers() != -1) {
                for (Map.Entry<String, UserImportData> e : this.userLogins.entrySet()) {
                    currentUser = e.getValue();
                    if (currentUser.getState() != ImportUserDataStates.UNKNOWN && currentUser.getState() != ImportUserDataStates.INACTIVE_FOUND) continue;
                    if (currentUser.getState() == ImportUserDataStates.UNKNOWN) {
                        this.insert(dataImportJob, importName, currentUser);
                        currentUser = this.userLogins.get(e.getKey());
                    } else if (currentUser.getState() == ImportUserDataStates.INACTIVE_FOUND) {
                        this.reaktivieren(dataImportJob, importName, currentUser);
                    }
                    if (currentUser.getState() == ImportUserDataStates.ALREADY_TREATED) {
                        dataImportJob.decrementMissingLicenseCount();
                    }
                    if (this.userCount != HdLicenseObserver.getMaxUsers()) continue;
                    break;
                }
            }
        }
    }

    private void handleSupervisedGroups(DataImportJob dataImportJob, String importName, UserImportData currentUser) {
        String supervisionGroup = currentUser.getData(this.supervisorEntry);
        if (currentUser.hasSupervisorData() || FieldImportRules.hasContent(supervisionGroup)) {
            if (supervisionGroup != null && supervisionGroup.length() > 0) {
                StringTokenizer tokens = new StringTokenizer(supervisionGroup, ";,");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    int bgrID = this.benutzergruppen.get(token.trim().toLowerCase());
                    if (bgrID <= -1) continue;
                    List<UserClassManager.SupervisorMemberShip> smsList = currentUser.getSupervisorMemberShips();
                    Optional<UserClassManager.SupervisorMemberShip> findFirst = smsList.stream().filter(s -> s.getTeamID() == bgrID && s.getUserID() == currentUser.getId()).findFirst();
                    if (findFirst.isPresent()) {
                        UserClassManager.SupervisorMemberShip sms = findFirst.get();
                        if (!(importName.equals(sms.getSource()) || sms.getSource() != null && sms.getSource().length() != 0)) {
                            UserClassManager.getInstance().addOrUpdateSupervisorMemberShip(currentUser.getId(), bgrID, importName);
                        }
                        logger.debug((Object)("User " + currentUser.getId() + " is already supervisor from usergroup " + token));
                        smsList.remove(sms);
                        continue;
                    }
                    logger.info((Object)("Add User " + currentUser.getId() + " as supervisor to usergroup " + token));
                    UserClassManager.getInstance().addOrUpdateSupervisorMemberShip(currentUser.getId(), bgrID, importName);
                    dataImportJob.incrementAddedSuperviorsCount();
                }
            }
            for (UserClassManager.SupervisorMemberShip sms : currentUser.getSupervisorMemberShips()) {
                if (!importName.equals(sms.getSource())) continue;
                logger.info((Object)("Remove User " + currentUser.getId() + " as supervisor from usergroup " + sms.getTeamID()));
                UserClassManager.getInstance().removeSupervisorMemberShip(sms.getUserID(), sms.getTeamID());
                dataImportJob.incrementDeletedSupervisorsCount();
            }
        }
    }

    private void insert(DataImportJob dataImportJob, String importName, UserImportData bufferedData) {
        MutableUserData userData = new MutableUserData();
        userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("GebID"), (Object)this.standardGeb);
        userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("BgrID"), (Object)this.standardBenGr);
        String secondLogin = null;
        for (Map.Entry<FieldMappingEntry, String> entry : bufferedData.getDataEntrySet()) {
            String value = entry.getValue();
            if (value == null || value.length() <= 0) continue;
            if ("GebID".equals(entry.getKey().getDefininitionColumn())) {
                userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("GebID"), (Object)this.getGebID(value));
                continue;
            }
            if ("BgrID".equals(entry.getKey().getDefininitionColumn())) {
                userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("BgrID"), (Object)this.getBgrID(value));
                continue;
            }
            if ("SecondUsername".equals(entry.getKey().getDefininitionColumn())) {
                secondLogin = value;
                continue;
            }
            if ("Username".equals(entry.getKey().getDefininitionColumn()) || "Supervisor".equals(entry.getKey().getDefininitionColumn())) continue;
            userData.put((UserField)HDFieldLocator.getUserFieldForDBKey(entry.getKey().getDefininitionColumn()), (Object)value);
        }
        userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("SprID"), (Object)this.standardSprache);
        userData.put((UserField)HDFieldLocator.getUserFieldForDBKey("ImpName"), (Object)importName);
        String normalizedUsername = this.plusDomain(bufferedData.getData(this.usernameEntry)).toUpperCase();
        LoginSettings loginSettings = new LoginSettings("system", normalizedUsername, null);
        UserAccount userAccount = UserManager.getInstance().createUserAccount(UserAccountType.Standard, userData, loginSettings);
        if (this.importConfigInfo.isPictureImport()) {
            this.handleAvatarImage(userAccount.getID(), bufferedData.getImageData(), false);
        }
        bufferedData.setAccount(userAccount);
        ++this.userCount;
        dataImportJob.incrementAddedCount();
        if (this.supervisorDaten) {
            this.handleSupervisedGroups(dataImportJob, importName, bufferedData);
        }
        this.handleSystemLogin(userAccount, secondLogin, true);
        bufferedData.setState(ImportUserDataStates.ALREADY_TREATED);
        this.userLogins.put(normalizedUsername, bufferedData);
        dataImportJob.incrementImportedCount();
    }

    private int getGebID(String name) {
        int id = this.locations.get(name.toLowerCase());
        if (id == -1) {
            try {
                id = LocationManager.getInstance().add(new LocationVO(-1, name, null, null, null, 0, false));
                this.locations.put(name.toLowerCase(), id);
            }
            catch (SQLException sql) {
                logger.error((Throwable)sql);
                return this.standardGeb;
            }
            ++this.locationInsertCounter;
            return id;
        }
        return id;
    }

    private int getBgrID(String name) {
        int id = this.benutzergruppen.get(name.toLowerCase());
        if (id == -1) {
            try {
                id = UserClassManager.getInstance().add(new UserClassVO(-1, name, 0, 0, false));
                this.benutzergruppen.put(name.toLowerCase(), id);
            }
            catch (SQLException sql) {
                logger.error((Throwable)sql);
                return this.standardBenGr;
            }
            ++this.bgrInsertCounter;
            return id;
        }
        return id;
    }

    private UserImportData checkAvailability(String importKey, String username) {
        if (username == null || username.length() == 0) {
            return null;
        }
        UserImportData theUser = this.getUserDataByName(username);
        if (theUser == null) {
            theUser = new UserImportData(importKey);
            if (!this.importConfigInfo.isAlle()) {
                theUser.setState(ImportUserDataStates.NOT_RELEVANT);
            }
        } else if ((importKey.equals(theUser.getImportKey()) || !FieldImportRules.hasContent(theUser.getImportKey())) && theUser.getState() == ImportUserDataStates.VALID) {
            theUser.setState(ImportUserDataStates.IN_PROGRESS);
        } else if (FieldImportRules.hasContent(theUser.getImportKey()) && !importKey.equals(theUser.getImportKey()) && theUser.getState() == ImportUserDataStates.VALID) {
            theUser.setState(ImportUserDataStates.NOT_RELEVANT);
        } else if (theUser.getState() == ImportUserDataStates.IN_PROGRESS || theUser.getState() == ImportUserDataStates.ALREADY_TREATED) {
            theUser.setState(ImportUserDataStates.DUPLICATE);
        } else if (theUser.getState() == ImportUserDataStates.INACTIVE) {
            if (this.importConfigInfo.isReaktivieren()) {
                theUser.setState(ImportUserDataStates.INACTIVE_FOUND);
            } else {
                theUser.setState(ImportUserDataStates.NOT_RELEVANT);
            }
        }
        return theUser;
    }

    private boolean neededForImport(UserImportData currentUser) {
        return currentUser != null && (currentUser.getState() == ImportUserDataStates.IN_PROGRESS || currentUser.getState() == ImportUserDataStates.UNKNOWN || currentUser.getState() == ImportUserDataStates.INACTIVE_FOUND);
    }

    private boolean relevantForImport(UserImportData currentUser, DataImportJob dataImportJob) {
        dataImportJob.incrementDataCount();
        if (currentUser == null) {
            logger.debug((Object)"No username available!");
        } else {
            logger.debug((Object)currentUser);
            if (currentUser.getState() == ImportUserDataStates.DUPLICATE) {
                dataImportJob.incrementDuplicatesCount();
            }
        }
        return this.neededForImport(currentUser);
    }

    private UserImportData readUserData(String importKey, String usernameKey, String alternativeUsernameKey, ResultSet rs) throws SQLException {
        UserImportData currentUser;
        String uName = rs.getString(usernameKey);
        if ((uName == null || uName.length() == 0) && alternativeUsernameKey != null && alternativeUsernameKey.length() > 0) {
            uName = rs.getString(alternativeUsernameKey);
        }
        if ((currentUser = this.checkAvailability(importKey, uName)) == null || currentUser.getState() == ImportUserDataStates.DUPLICATE) {
            return currentUser;
        }
        for (FieldMappingEntry fm : this.neededAttributesOrColumns) {
            try {
                currentUser.addData(fm, rs.getString(fm.getSelectedColumn()));
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
        FieldImportRules.areUserNamesValid(this.surnameEntry, this.givennameEntry, currentUser);
        return currentUser;
    }

    private UserImportData readUserData(String importKey, String usernameKey, String alternativeUsernameKey, Attributes attrs, SearchResult sr) {
        Object theUser = null;
        try {
            Object alternativeUser;
            Attribute attr = attrs.get(usernameKey);
            if (attr != null) {
                theUser = this.checkAvailability(importKey, attr.get().toString());
            }
            if (alternativeUsernameKey != null && alternativeUsernameKey.length() > 0 && (theUser == null || ((UserImportData)theUser).getAccount() == null) && (attr = attrs.get(alternativeUsernameKey)) != null && (alternativeUser = this.checkAvailability(importKey, attr.get().toString())) != null && ((UserImportData)alternativeUser).getAccount() != null) {
                theUser = alternativeUser;
            }
            if (theUser == null) {
                return null;
            }
            for (FieldMappingEntry fm : this.neededAttributesOrColumns) {
                Object str;
                if (this.needSpezialDN && "dnX".equals(fm.getSelectedColumn())) {
                    str = this.spezialDNadd == null ? sr.getName() : sr.getName() + this.spezialDNadd;
                } else {
                    attr = attrs.get(fm.getSelectedColumn());
                    if (attr != null) {
                        str = attr.get().toString();
                        str = LdapFormatHandler.handleLdapFormat(fm.getDefininitionColumn(), (String)str);
                    } else {
                        str = "";
                    }
                }
                ((UserImportData)theUser).addData(fm, (String)str);
            }
            FieldImportRules.areUserNamesValid(this.surnameEntry, this.givennameEntry, (UserImportData)theUser);
            if (this.neededForImport((UserImportData)theUser) && this.importConfigInfo.isPictureImport() && (attr = attrs.get(this.photoAttribute)) != null) {
                Object obj = attr.get();
                byte[] imageData = (byte[])obj;
                ((UserImportData)theUser).setImageData(imageData);
            }
            return theUser;
        }
        catch (Throwable e) {
            logger.error(e);
            return null;
        }
    }

    private void setImportOptions(boolean ldap) throws SQLException, IllegalStateException {
        this.neededAttributesOrColumns = this.importConfigInfo.getFieldMapping();
        this.neededAttributesOrColumns = this.neededAttributesOrColumns == null ? FieldMapping.createFieldList(this.importConfigInfo.getSelektionList()) : FieldMapping.validateFieldList(this.neededAttributesOrColumns);
        this.usernameEntry = this.neededAttributesOrColumns.stream().filter(a -> a.getDefininitionColumn().equals("Username")).findFirst().get();
        this.alternativeUsernameEntry = this.neededAttributesOrColumns.stream().filter(a -> a.getDefininitionColumn().equals("SecondUsername")).findFirst().get();
        this.surnameEntry = this.neededAttributesOrColumns.stream().filter(a -> a.getDefininitionColumn().equals("Nachname")).findFirst().get();
        this.givennameEntry = this.neededAttributesOrColumns.stream().filter(a -> a.getDefininitionColumn().equals("Vorname")).findFirst().get();
        String supervisorColumn = this.importConfigInfo.getSupervisorColumn();
        boolean bl = this.supervisorDaten = supervisorColumn != null && supervisorColumn.length() > 0;
        if (this.supervisorDaten) {
            this.supervisorEntry = new FieldMappingEntry("Supervisor", supervisorColumn);
            this.neededAttributesOrColumns.add(this.supervisorEntry);
        }
        this.neededAttributesOrColumns = this.neededAttributesOrColumns.stream().filter(a -> a.getSelectedColumn().length() > 0).collect(Collectors.toList());
        this.needSpezialDN = this.neededAttributesOrColumns.stream().filter(a -> a.getDefininitionColumn().equals("dnX")).count() > 0L;
        Set<String> attrs = this.neededAttributesOrColumns.stream().map(a -> a.getSelectedColumn()).collect(Collectors.toSet());
        this.needSpezialDN = attrs.remove("dnX");
        if (ldap) {
            LdapConnectionInfo ldapConn = this.getCurrentLdapConnectionInfo();
            Vector<String> data = new Vector<String>();
            try {
                UserImporter.getLdapAttributs(data, ldapConn, "organizationalPerson", this.importConfigInfo.isUseUserSyntax(), this.importConfigInfo.getUserSyntax());
                if (data.contains("userAccountControl")) {
                    attrs.add("userAccountControl");
                    this.userAccountControlAvailable = true;
                }
                if (data.contains("msExchHideFromAddressLists") && this.importConfigInfo.isUseHideFromAddresslists()) {
                    attrs.add("msExchHideFromAddressLists");
                    this.userHideFromListAvailable = true;
                }
                if (this.importConfigInfo.isPictureImport()) {
                    if (data.contains("jpegPhoto")) {
                        attrs.add("jpegPhoto");
                        this.photoAttribute = "jpegPhoto";
                    }
                    if (data.contains("thumbnailPhoto")) {
                        attrs.add("thumbnailPhoto");
                        this.photoAttribute = "thumbnailPhoto";
                    }
                    if (this.importConfigInfo.isPictureImport() && this.photoAttribute == null) {
                        this.importConfigInfo.setPictureImport(false);
                    }
                }
            }
            catch (NamingException e) {
                logger.error((Throwable)e);
            }
        }
        logger.debug((Object)("LDAP key attributes available: msExchHideFromAddressLists " + this.userHideFromListAvailable + "  userAccountControl " + this.userAccountControlAvailable + "  Photo attribute: " + this.photoAttribute));
        if (this.importConfigInfo.getDefaultSnColumn().length() > 0) {
            this.neededAttributesOrColumns.remove(this.neededAttributesOrColumns.stream().filter(f -> f.getDefininitionColumn().equals("Username")).findFirst().get());
            this.neededAttributesOrColumns.add(new FieldMappingEntry("Username", this.importConfigInfo.getDefaultSnColumn()));
        }
        this.attrListe = attrs.toArray(new String[attrs.size()]);
        if (this.attrListe.length == 0) {
            throw new IllegalStateException("Keine Attribute f\u00fcr den Import ausgew\u00e4hlt!");
        }
    }

    private void fetchStartData(UserManager manager, String currentImpName) throws SQLException {
        String name;
        this.entrysPerImport = new StringIntHashMap();
        this.userLogins = new HashMap();
        this.importNameField = manager.getField("importname");
        AndSearchExpression and = new AndSearchExpression();
        and.add((SearchExpression)new SearchCondition("loginsettings", SearchCondition.SearchTermOperator.GT, (Object)""));
        List<UserIterator.AccountLogins> accountLoginsList = new UserIterator().getUserSystemLogins(manager, (List<SearchExpression>)and);
        for (UserIterator.AccountLogins accountLogins : accountLoginsList) {
            this.handleData(accountLogins);
        }
        this.standardSprache = "xx";
        this.standardGeb = (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue();
        if (this.neededAttributesOrColumns.stream().filter(a -> a.getDefininitionColumn().equals("GebID")).count() > 0L) {
            this.locations = new StringIntHashMap();
            List locationVOs = LocationManager.getInstance().getAll(false);
            for (LocationVO locationVO : locationVOs) {
                name = locationVO.getDisplayValue();
                if (name == null) continue;
                this.locations.put(name.toLowerCase(), locationVO.getId());
            }
            this.locations.put("", this.standardGeb);
        } else {
            this.locations = null;
        }
        if (this.neededAttributesOrColumns.stream().filter(a -> a.getDefininitionColumn().equals("BgrID")).count() > 0L || this.supervisorDaten) {
            this.benutzergruppen = new StringIntHashMap();
            List usergroupVOs = UserClassManager.getInstance().getAll(false);
            for (UserClassVO usergroupVO : usergroupVOs) {
                name = usergroupVO.getDisplayValue();
                if (name == null) continue;
                this.benutzergruppen.put(name.toLowerCase(), usergroupVO.getId());
            }
            this.benutzergruppen.put("", 0);
        } else {
            this.benutzergruppen = null;
        }
        if (this.supervisorDaten) {
            UserClassManager.getInstance().reloadFromDatabase();
            List<UserClassManager.SupervisorMemberShip> memberShips = UserClassManager.getInstance().getAllSupervisorMemberShips();
            block3: for (UserClassManager.SupervisorMemberShip sms : memberShips) {
                UserAccount ua = HDUsersAndGroups.getUserAccountSave(sms.getUserID());
                for (LoginSettings login : ua.getLoginSettings()) {
                    UserImportData uds;
                    if (!"system".equals(login.getLoginSource()) || (uds = this.getUserDataByName(login.getLoginID())) == null) continue;
                    uds.addSupervisorDataSet(sms);
                    continue block3;
                }
            }
        }
        this.standardBenGr = 0;
    }

    public void handleData(UserIterator.AccountLogins accountLogins) {
        UserAccount userAccount = accountLogins.getUserAccount();
        List<UserIterator.LoginData> systemLogins = accountLogins.getSystemLogins();
        UserImportData currentUser = new UserImportData(userAccount, userAccount.getValue(this.importNameField), systemLogins.size());
        if (userAccount.isActive() && currentUser.getImportKey() != null && currentUser.getImportKey().length() > 0) {
            int count = this.entrysPerImport.get(currentUser.getImportKey());
            count = count == -1 ? 1 : ++count;
            this.entrysPerImport.put(currentUser.getImportKey(), count);
        }
        this.userCount = HdLicenseObserver.getCurrentActiveUserCount();
        if (systemLogins.size() > 0) {
            for (UserIterator.LoginData systemLogin : systemLogins) {
                this.userLogins.put(systemLogin.getNormalizedUserName(), currentUser);
            }
        } else {
            this.userLogins.put("UsrID" + currentUser.getId(), currentUser);
        }
    }

    private String normalizeForMap(String userName) {
        return userName.toUpperCase().replace('/', '\\');
    }

    private static boolean testStringChars(String data) {
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) >= ' ' || data.charAt(i) == '\n' || data.charAt(i) == '\r') continue;
            return false;
        }
        return true;
    }

    @SuppressFBWarnings(value={"LDAP_INJECTION"}, justification="The LDAP statement is created internally")
    public static void getLdapAttributs(Vector<String> attibutesBuffer, LdapConnectionInfo ldapConnectionInfo, String objectClass, boolean useUserSyntax, String userSyntax) throws NamingException {
        ArrayList<Object> attributes;
        block48: {
            int[] statistics;
            String[] previewVals;
            String[] searchContextValues;
            String[] stringArray;
            String dataBufferKey;
            block47: {
                dataBufferKey = ldapConnectionInfo.getHost() + ldapConnectionInfo.getSearchContext() + objectClass + (useUserSyntax ? userSyntax : "");
                if (bufferdAttributes == null || !dataBufferKey.equals(bufferKey) || lastRequested <= System.currentTimeMillis() - ATTRIBUTE_BUFFER_TIME) break block47;
                attributes = bufferdAttributes;
                break block48;
            }
            attributes = new ArrayList();
            boolean foundDN = false;
            if (useUserSyntax && userSyntax != null && !userSyntax.isEmpty()) {
                stringArray = UserImporter.getUserDefinedSyntax(userSyntax);
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "objectClass=" + (objectClass != null && !objectClass.isEmpty() ? objectClass : "organizationalPerson");
            }
            String[] searchItems = stringArray;
            StringIntHashMap mainAttributes = new StringIntHashMap();
            LdapUtilities.initLDAPmainAttributes(mainAttributes);
            int count = 0;
            String attrValue = null;
            String additional = null;
            CIHashMap columnStatistik = new CIHashMap();
            Hashtable<String, String[]> columnPreview = new Hashtable<String, String[]>();
            NamingEnumeration<SearchResult> enumeration = null;
            InitialLdapContext ctx = LdapUtilities.getDirContext(ldapConnectionInfo);
            for (String searchContext : searchContextValues = LdapUtilities.getSearchContext(ctx, ldapConnectionInfo.getSearchContext())) {
                additional = searchContext.length() > 0 ? "," + searchContext : null;
                for (String searchItem : searchItems) {
                    logger.debug((Object)("Suche: " + searchItem));
                    try {
                        boolean searchSuccess = true;
                        try {
                            enumeration = ctx.search(searchContext, searchItem, LdapUtilities.getSearchControls(null));
                            searchSuccess = enumeration.hasMore();
                        }
                        catch (NamingException ex) {
                            searchSuccess = false;
                        }
                        while (searchSuccess) {
                            ++count;
                            Attributes attrs = null;
                            SearchResult si = (SearchResult)enumeration.nextElement();
                            attrs = si.getAttributes();
                            NamingEnumeration<String> enum2 = attrs.getIDs();
                            boolean doAgain = enum2.hasMore();
                            while (doAgain) {
                                block50: {
                                    int n;
                                    block49: {
                                        int xy;
                                        String attrName = enum2.next();
                                        if (attrName.equalsIgnoreCase("distinguishedName") || attrName.equalsIgnoreCase("dn")) {
                                            logger.debug((Object)attrs.get(attrName).get().toString());
                                            foundDN = true;
                                        }
                                        if ((previewVals = (String[])columnPreview.get(attrName)) == null) {
                                            previewVals = new String[10];
                                            statistics = new int[6];
                                            for (n = 0; n < 10; ++n) {
                                                previewVals[n] = null;
                                                if (n >= 6) continue;
                                                statistics[n] = 0;
                                            }
                                            columnPreview.put(attrName, previewVals);
                                            columnStatistik.put(attrName, statistics);
                                        } else {
                                            statistics = columnStatistik.get(attrName);
                                        }
                                        if (statistics[4] != 0 && mainAttributes.get(attrName) == -1) break block49;
                                        int attributeCount = attrs.get(attrName).size();
                                        statistics[0] = statistics[0] + 1;
                                        statistics[1] = statistics[1] + attributeCount;
                                        if (attributeCount > 1) {
                                            if (mainAttributes.get(attrName) > -1) {
                                                Attribute attrCN = attrs.get("cn");
                                                logger.debug((Object)("cn: " + (attrCN != null ? attrCN.get().toString() : "null")));
                                                logger.debug((Object)(" Nicht Eindeutiges Attribut " + attrName + ":"));
                                                for (int x = 0; x < attributeCount; ++x) {
                                                    attrValue = attrs.get(attrName).get(x).toString();
                                                    logger.debug((Object)("-" + attrValue));
                                                }
                                            } else {
                                                attrValue = attrs.get(attrName).get().toString();
                                            }
                                            statistics[2] = statistics[2] + 1;
                                        } else {
                                            attrValue = attributeCount == 1 ? attrs.get(attrName).get().toString() : "";
                                        }
                                        statistics[3] = statistics[3] + attrValue.length();
                                        if (attrValue.length() > 50) {
                                            attrValue = attrValue.substring(0, 50);
                                        }
                                        if (!UserImporter.testStringChars(attrValue)) {
                                            if (mainAttributes.get(attrName) > -1) {
                                                logger.debug((Object)(attrName + " enth\u00e4lt nicht darstellbare Zeichen!"));
                                            }
                                            statistics[4] = statistics[4] + 1;
                                        }
                                        if (statistics[5] >= 10) break block50;
                                        for (xy = 0; xy < statistics[5] && !attrValue.equals(previewVals[xy]); ++xy) {
                                        }
                                        if (xy != statistics[5]) break block50;
                                        int n2 = statistics[5];
                                        statistics[5] = n2 + 1;
                                        previewVals[n2] = attrValue;
                                        break block50;
                                    }
                                    if (previewVals[0] != null) {
                                        for (n = 0; n < 10; ++n) {
                                            previewVals[n] = null;
                                        }
                                    }
                                }
                                try {
                                    doAgain = enum2.hasMore();
                                }
                                catch (NamingException ex) {
                                    doAgain = false;
                                }
                            }
                            enum2.close();
                            if (!foundDN) {
                                Object dn = additional == null ? si.getName() : si.getName() + additional;
                                previewVals = (String[])columnPreview.get("dnX");
                                if (previewVals == null) {
                                    previewVals = new String[10];
                                    statistics = new int[6];
                                    for (int n = 0; n < 10; ++n) {
                                        previewVals[n] = null;
                                        if (n >= 6) continue;
                                        statistics[n] = 0;
                                    }
                                    columnPreview.put("dnX", previewVals);
                                    columnStatistik.put("dnX", statistics);
                                } else {
                                    statistics = columnStatistik.get("dnX");
                                }
                                statistics[0] = statistics[0] + 1;
                                statistics[1] = statistics[1] + 1;
                                statistics[3] = statistics[3] + ((String)dn).length();
                                if (statistics[5] < 10) {
                                    if (((String)dn).length() > 50) {
                                        dn = ((String)dn).substring(0, 50);
                                    }
                                    int n = statistics[5];
                                    statistics[5] = n + 1;
                                    previewVals[n] = dn;
                                }
                            }
                            try {
                                searchSuccess = enumeration.hasMore();
                            }
                            catch (NamingException ex) {
                                searchSuccess = false;
                            }
                        }
                        if (!searchSuccess) continue;
                        enumeration.close();
                    }
                    catch (NamingException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
            try {
                ctx.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.debug((Object)("Untersuchte Objekte: " + count));
            Enumeration enumCols = columnPreview.keys();
            while (enumCols.hasMoreElements()) {
                boolean isMainAttr;
                String key = (String)enumCols.nextElement();
                previewVals = (String[])columnPreview.get(key);
                statistics = columnStatistik.get(key);
                int relativeHaeufigkeit = statistics[0] * 100 / count;
                boolean bl = isMainAttr = mainAttributes.get(key) != -1;
                if (statistics[4] == 0 || isMainAttr) {
                    if (statistics[2] == 0 || isMainAttr) {
                        int differntValueCount = 0;
                        int geschweiftKlammer = 0;
                        int eckKlammer = 0;
                        for (int i = 0; i < 10 && previewVals[i] != null; ++i) {
                            if (previewVals[i].length() > 0) {
                                if (previewVals[i].charAt(0) == '{') {
                                    ++geschweiftKlammer;
                                }
                                if (previewVals[i].charAt(0) == '[') {
                                    ++eckKlammer;
                                }
                            }
                            ++differntValueCount;
                        }
                        if (!(isMainAttr || geschweiftKlammer != differntValueCount && eckKlammer != differntValueCount)) {
                            logger.debug((Object)("Attribut: " + key + " scheint nicht f\u00fcr Import geeignet!"));
                            continue;
                        }
                        if (("jpegPhoto".equals(key) || "thumbnailPhoto".equals(key)) && relativeHaeufigkeit == 0) {
                            logger.debug((Object)("Picture Attribut: " + key + " keine Werte!"));
                            continue;
                        }
                        logger.debug((Object)(key + " ist OK Haeufikeit: " + relativeHaeufigkeit + "% mehrfach: " + statistics[2] + " Durchschnitt-Laenge: " + statistics[3] / statistics[0] + " Zeichenfehler: " + statistics[4]));
                        attributes.add(key);
                        Vector<String> pevVals = new Vector<String>();
                        for (int i = 0; i < 10 && previewVals[i] != null; ++i) {
                            pevVals.addElement(previewVals[i]);
                        }
                        continue;
                    }
                    logger.debug((Object)("Attribut: " + key + " ist nicht eindeutig!"));
                    continue;
                }
                logger.debug((Object)("Attribut: " + key + " enth\u00e4lt nicht darstellbare Sonderzeichen!"));
            }
            bufferKey = dataBufferKey;
            bufferdAttributes = attributes;
            lastRequested = System.currentTimeMillis();
        }
        attibutesBuffer.addAll(attributes);
    }

    private String[] getSearchQuery() {
        Object additionalSyntax = this.importConfigInfo.getLdapAndSyntax();
        if (((String)additionalSyntax).length() > 0 && ((String)additionalSyntax).charAt(0) != '(') {
            additionalSyntax = "(" + (String)additionalSyntax + ")";
        }
        logger.debug((Object)("LDAP search query: " + (String)additionalSyntax));
        String[] result = new String[]{((String)additionalSyntax).length() > 0 ? "(&(objectClass=organizationalPerson)" + (String)additionalSyntax + ")" : "(objectClass=organizationalPerson)"};
        return result;
    }

    private static String[] getUserDefinedSyntax(String input) {
        if (input == null) {
            input = "";
        }
        StringTokenizer stok = new StringTokenizer(input, "\n");
        ArrayList<String> ausdruecke = new ArrayList<String>();
        while (stok.hasMoreElements()) {
            String line = stok.nextToken().trim();
            if (line.startsWith("//") || line.startsWith("(") && line.length() == 1) continue;
            ausdruecke.add(line);
        }
        return ausdruecke.toArray(new String[ausdruecke.size()]);
    }

    private static String[] getNonPagedSearchArray(String[] baseSearchQueries) {
        String[] result = new String[51 * baseSearchQueries.length];
        for (int n = 0; n < baseSearchQueries.length; ++n) {
            int i;
            Object additionalSyntax = baseSearchQueries[n];
            if (((String)additionalSyntax).startsWith("(&")) {
                additionalSyntax = ((String)additionalSyntax).substring(2, ((String)additionalSyntax).length() - 1);
            }
            int offset = n * 51;
            if (((String)additionalSyntax).length() > 0 && ((String)additionalSyntax).charAt(0) != '(') {
                additionalSyntax = "(" + (String)additionalSyntax + ")";
            }
            result[offset] = "(&(|(sn=a*)(sn=A*)(sn=\u00c4*)(sn=\u00e4*))" + (String)additionalSyntax + ")";
            result[offset + 1] = "(&(|(sn=o*)(sn=O*)(sn=\u00d6*)(sn=\u00f6*))" + (String)additionalSyntax + ")";
            result[offset + 2] = "(&(|(sn=u*)(sn=U*)(sn=\u00dc*)(sn=\u00fc*))" + (String)additionalSyntax + ")";
            for (i = 0; i < BUCHSTABEN.length; ++i) {
                result[offset + i + 3] = "(&(|(sn=" + BUCHSTABEN[i] + "*)(sn=" + Character.toUpperCase(BUCHSTABEN[i]) + "*))" + (String)additionalSyntax + ")";
            }
            for (i = 0; i < BUCHSTABEN.length; ++i) {
                result[offset + i + 3 + UserImporter.BUCHSTABEN.length] = "(&(|(sn=s" + BUCHSTABEN[i] + "*)(sn=S" + BUCHSTABEN[i] + "*))" + (String)additionalSyntax + ")";
            }
            result[offset + 47] = "(&(|(sn=Sa*)(sn=S\u00e4*))" + (String)additionalSyntax + ")";
            result[offset + 48] = "(&(|(sn=So*)(sn=S\u00f6*))" + (String)additionalSyntax + ")";
            result[offset + 49] = "(&(|(sn=Su*)(sn=S\u00fc*))" + (String)additionalSyntax + ")";
            result[offset + 50] = "(&(|(sn=0*)(sn=1*)(sn=2*)(sn=3*)(sn=4*)(sn=6*)(sn=7*)(sn=8*)(sn=9*))" + (String)additionalSyntax + ")";
        }
        return result;
    }

    public static Connection getConnection(DatabaseConfigInfo dbConn) throws SQLException {
        DriverManager.setLoginTimeout(10);
        logger.debug((Object)("DriverManager url: " + dbConn.getUrl() + " user " + dbConn.getUser()));
        return DriverManager.getConnection(dbConn.getUrl(), dbConn.getUser(), dbConn.getDecodedPassword());
    }

    static {
        USER_IMPORT_CONFIGS = new ConfigValue(HDConfigKeys.USER_IMPORT_CONFIGS);
        LDAP_CONNECTION_INFOS = new ConfigValue(HDConfigKeys.LDAP_CONNECTION_INFOS);
        DB_INFOS = new ConfigValue(HDConfigKeys.DB_CONFIGS);
        logger = LogManager.getLogger((String)"Data Import");
        MONITOR_OBJECT = new Object();
        MSG = new I18nMessages("com.inet.helpdesk.data.i18n.LanguageResources", UserImporter.class);
    }

    private class ReadAndImportRecordStateFactory
    implements ReadRecordStateFactory {
        private ReadRecordStateImpl lastState;

        private ReadAndImportRecordStateFactory() {
        }

        @Override
        public ReadRecordState createReadRecordState(DataImportJob dataImportJob, String importName, UserImportData dataBuffer) {
            this.lastState = new ReadRecordStateImpl(dataImportJob, importName, dataBuffer);
            return this.lastState;
        }

        @Override
        public boolean isFinished(boolean inProgress) {
            return false;
        }

        @Override
        public ReadRecordState getLastState() {
            return this.lastState;
        }
    }

    private static interface ReadRecordStateFactory {
        public ReadRecordState createReadRecordState(DataImportJob var1, String var2, UserImportData var3);

        public boolean isFinished(boolean var1);

        public ReadRecordState getLastState();
    }

    private static interface ReadRecordState {
        public ReadRecordState invoke();
    }

    private class LdapSearchOptions {
        private int searchExecutions = 0;
        private boolean pagedSearch = true;
        private String importName;
        private String[] searchContextValues;

        private LdapSearchOptions() {
        }
    }

    private class ReadRecordStateImpl
    implements ReadRecordState {
        private final String importName;
        private UserImportData bufferedData;
        private DataImportJob dataImportJob;

        private ReadRecordStateImpl(DataImportJob dataImportJob, String importName, UserImportData bufferedData) {
            this.dataImportJob = dataImportJob;
            this.importName = importName;
            this.bufferedData = bufferedData;
        }

        @Override
        public ReadRecordState invoke() {
            if (this.bufferedData.getState() == ImportUserDataStates.IN_PROGRESS) {
                UserImporter.this.update(this.dataImportJob, this.importName, this.bufferedData, false);
            } else if (this.bufferedData.getState() == ImportUserDataStates.UNKNOWN) {
                if (UserImporter.this.userCount - this.dataImportJob.getEntriesDeleted() < HdLicenseObserver.getMaxUsers() || HdLicenseObserver.getMaxUsers() == -1) {
                    UserImporter.this.insert(this.dataImportJob, this.importName, this.bufferedData);
                } else {
                    UserImporter.this.bufferImportableData(this.importName, this.bufferedData, this.dataImportJob);
                }
            } else if (this.bufferedData.getState() == ImportUserDataStates.INACTIVE_FOUND) {
                if (UserImporter.this.userCount - this.dataImportJob.getEntriesDeleted() < HdLicenseObserver.getMaxUsers() || HdLicenseObserver.getMaxUsers() == -1) {
                    UserImporter.this.reaktivieren(this.dataImportJob, this.importName, this.bufferedData);
                } else {
                    UserImporter.this.handleNonImportableUser(this.bufferedData, this.dataImportJob);
                }
            } else {
                logger.warn((Object)("SYNCHRONISATION TYPE ERROR: " + String.valueOf(this.bufferedData)));
            }
            return this;
        }
    }

    public static class ReadSampleRecordStateImpl
    implements ReadRecordStateWithSamples {
        private UserImportData latestBufferedData;
        private ArrayList<Map<String, String>> samples = new ArrayList();

        @Override
        public ReadRecordState invoke() {
            HashMap<String, CallSite> values = new HashMap<String, CallSite>();
            this.latestBufferedData.getDataEntrySet().stream().forEach(e -> {
                if (e.getValue() != null && ((String)e.getValue()).length() > 0) {
                    values.put(((FieldMappingEntry)e.getKey()).getDefininitionColumn(), (CallSite)((Object)((String)e.getValue())));
                }
            });
            byte[] imageData = this.latestBufferedData.getImageData();
            if (imageData == null) {
                String displayname = UtilityFunctions.getDisplayNameFor((String)values.get("Username"), (String)values.get("Nachname"), (String)values.get("Vorname"));
                imageData = UserAvatar.getGeneratedCircleAvatar((String)displayname, (int)300);
            }
            values.put("IMAGE", (CallSite)((Object)("data:image/png;base64," + Base64.getEncoder().encodeToString(imageData))));
            this.samples.add(values);
            return this;
        }

        public boolean isFinished() {
            return this.samples.size() == 20;
        }

        public void receivedNewRow(UserImportData bufferedData) {
            this.latestBufferedData = bufferedData;
        }

        @Override
        public ArrayList<Map<String, String>> getSamples() {
            return this.samples;
        }
    }

    public static interface ReadRecordStateWithSamples
    extends ReadRecordState {
        public ArrayList<Map<String, String>> getSamples();
    }

    public static class ReadSampleRecordStateFactory
    implements ReadRecordStateFactory {
        private ReadSampleRecordStateImpl sampleCollectorState = new ReadSampleRecordStateImpl();

        @Override
        public ReadRecordStateWithSamples createReadRecordState(DataImportJob dataImportJob, String importName, UserImportData dataBuffer) {
            this.sampleCollectorState.receivedNewRow(dataBuffer);
            return this.sampleCollectorState;
        }

        @Override
        public boolean isFinished(boolean inProgress) {
            return !inProgress || this.sampleCollectorState.isFinished();
        }

        @Override
        public ReadRecordStateWithSamples getLastState() {
            return this.sampleCollectorState;
        }
    }
}

