/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import srv.ServerUtilities;
import srv.automatic.GeraeteImporter;
import srv.automatic.ResubmissionExecuter;
import srv.automatic.UserImporter;
import srv.controller.ticket.timeline.TimelineJobExecuter;

public class AutoProcess
implements Runnable {
    static final long MILLIS_PER_DAY = 86400000L;
    static final long TEN_MINUTES = 600000L;
    private static final ConfigValue<Boolean> MAIL_WIEDERVORLAGE_RES = new ConfigValue(HDConfigKeys.MAIL_WIEDERVORLAGE_RES);
    private static final ConfigValue<DatabaseConfigInfoList> DATABASE_CONFIG_INFO_LIST = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    private long tStart;
    private UserImporter usimp;
    private GeraeteImporter gerimp;
    private boolean finish = false;
    private ResultSet rsRea = null;
    private Statement stRea = null;
    private Thread autoProcess = null;
    private int counter;
    private Timestamp zeitpunkt;
    private Connection con;

    public AutoProcess(int counter, Connection connection) {
        this.counter = counter;
        this.con = connection;
        this.autoProcess = new Thread((Runnable)this, "AutoProcess");
        try {
            this.autoProcess.setPriority(1);
        }
        catch (Exception e) {
            ServerUtilities.systemOut("AutoProcess", e, "Could not set the priority of this thread");
            HDLogger.error(new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR));
        }
        try {
            this.autoProcess.setName("AutoProcess");
        }
        catch (Exception e) {
            ServerUtilities.systemOut("AutoProcess", e, "Could not set the name of this thread");
            HDLogger.error(new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR));
        }
        this.tStart = System.currentTimeMillis();
        this.autoProcess.start();
    }

    @Override
    public void run() {
        int maxProcessTime = 10;
        do {
            try {
                Thread.sleep(4000L);
            }
            catch (Throwable er) {
                HDLogger.error(new HelpDeskServerException(er, (ErrorCode)HelpDeskErrorCodes.TIMER_THREAD_ERROR));
            }
        } while (!this.finish && this.tStart + (long)(60000 * maxProcessTime) > System.currentTimeMillis());
        if (!this.finish) {
            try {
                this.con.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            HDLogger.error(new HelpDeskServerException("Autoprocess: AutoProcess nach 10 min nicht beendet!", (ErrorCode)HelpDeskErrorCodes.UNFINISHED_PROCESS_ERROR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        this.zeitpunkt = new Timestamp(System.currentTimeMillis());
        Statement st = null;
        try {
            st = this.con.createStatement(1005, 1008);
            if (this.counter % 48 == 0) {
                try (UserAccountScope scope = UserAccountScope.createPrivileged();){
                    TicketManager.getMaintenance().closeAutoFinishableTickets(System.currentTimeMillis());
                }
                this.wait300();
            }
            this.wiederVorlage(this.con);
            this.wait300();
            if (this.counter % 3 == 0) {
                this.usimp = new UserImporter();
                this.usimp.work();
                this.usimp = null;
                try {
                    this.gerimp = new GeraeteImporter();
                    this.gerimp.work();
                }
                catch (Throwable e) {
                    HDLogger.error(new HelpDeskServerException(e, (ErrorCode)HelpDeskErrorCodes.UNFINISHED_PROCESS_ERROR));
                }
                this.gerimp = null;
            }
            this.wait300();
            this.wait300();
            if (this.counter % 6 == 0) {
                st.execute("TRUNCATE TABLE tblSearchresult");
                this.wait300();
            }
            ServerUtilities.systemOut(String.valueOf(this.counter + 1) + ". Autoprocess", null, null);
            HDLogger.info("Unique Users: " + WebSocketEventHandler.getInstance().getAllConnectedUserIDs().size() + " | All Clients: " + WebSocketEventHandler.getInstance().getAllConnections().size() + " | AutoProcess runtime: " + (System.currentTimeMillis() - this.tStart) + " ms");
        }
        catch (Exception e) {
            ServerUtilities.systemOut("AutoProcess abgebrochen", e, "Exception in AutoProcess - Methode");
            HDLogger.error(new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.UNFINISHED_PROCESS_ERROR));
        }
        finally {
            if (this.stRea != null) {
                try {
                    this.rsRea.close();
                }
                catch (Throwable throwable) {}
                try {
                    this.stRea.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.finish = true;
    }

    private void wait300() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            ServerUtilities.systemOut("AutoProcess - wait300", e, "Sleep in AutoProcess durch anderen Thread unterbrochen.");
        }
    }

    private void wiederVorlage(Connection con) throws SQLException {
        String queryExecution = "SELECT tblBuendel.BunID, tblBuendel.WiedervorlageDatum FROM tblBuendel INNER JOIN tblAuftraege ON tblBuendel.BunID = tblAuftraege.AufID WHERE tblBuendel.Status = 150 AND tblAuftraege.Master <> 0 AND WiedervorlageDatum < ?";
        PreparedStatement pst = null;
        ResultSet rs = null;
        pst = con.prepareStatement(queryExecution);
        pst.setTimestamp(1, new Timestamp(this.tStart + 600000L));
        rs = pst.executeQuery();
        while (rs.next()) {
            ResubmissionExecuter executer = new ResubmissionExecuter(rs.getInt("BunID"), rs.getTimestamp("WiedervorlageDatum"));
            TimelineJobExecuter.getInstance().addJob(executer);
        }
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            pst.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

