/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.classloader.I18nMessages;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.swing.ListResultSet;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.DuplicateRange;
import com.inet.helpdesk.shared.model.Actions;
import com.inet.helpdesk.ticketmanager.TicketManipulatorSync;
import com.inet.helpdesk.ticketmanager.dupcontent.DuplicateContentFinder;
import com.inet.helpdesk.ticketmanager.dupcontent.DuplicatedContentTicketActionExtension;
import com.inet.helpdesk.ticketmanager.dupcontent.IdContent;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.ServerLock;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.FileInputStream;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import srv.ServerInterface;
import srv.automatic.trigger.TriggerHandler;
import srv.controller.MetaController;
import srv.controller.ticket.timeline.ResourceTimelineManager;

public class ServerUtilities {
    public static final int DB_UNKNOWN = 0;
    public static final int SQL_SERVER_DB = 2;
    public static final int ORACLE_DB = 3;
    public static final int MYSQL_DB = 4;
    private static final int[] TYPEN_NAME_VALUE = new int[]{12, 12};
    private static final String[] COLUMNS_NAME_VALUE = new String[]{"Name", "Value"};
    private static final int[] EIN_STRING = new int[]{12};
    private static final String[] EIN_NAME = new String[]{"Name"};
    private static final int[] EIN_INTEGER = new int[]{4};
    private static final int[] TYPEN_DEADLINE = new int[]{93};
    private static final String[] COLUMNS_DEADLINE = new String[]{"newDeadLine"};
    private static final String EMPTY_STR = "";
    private static String currencyPattern = null;
    public static TriggerHandler TRIGGERS = new TriggerHandler();
    private static final int[] TYPEN_FILE = new int[]{-2};
    private static final String[] COLUMNS_FILE = new String[]{"Filename"};
    private static final ConfigValue<Boolean> DRIVER_LOG = new ConfigValue<Boolean>(ConfigKey.LOG_DRIVER){

        protected void setValue(String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            DriverManager.setLogStream((Boolean)super.get() != false ? System.out : null);
        }
    };
    public static final ConfigValue<Boolean> CLIENT_ENDUSER_SHOWBEARBEITER = new ConfigValue(HDConfigKeys.CLIENT_ENDUSER_SHOWBEARBEITER);
    public static boolean linuxServer = false;
    public static final String HELPDESK_DB = "HDS";
    public static final String SMS_DB = "SMS";
    public static boolean isSMSavailable = false;
    public static boolean isImportZeit = false;
    public static final String sprache_Standard = "xx";
    private static int TIMER_COUNTER = 0;
    public static final ConfigValue<Integer> GUI_PORT = new ConfigValue<Integer>(ConfigKey.LISTENER_PORT){

        protected Integer convert(String strValue) throws IllegalArgumentException {
            try {
                return Integer.valueOf(strValue);
            }
            catch (Exception e) {
                return new Integer(8002);
            }
        }
    };
    public static MetaController conti = new MetaController();
    public static ServerInterface serverInterface;
    public static Locale serverLocale;
    public static I18nMessages hdsMessages;
    public static final Integer NULL_AS_USER_ID;
    private static final Map<String, String> urlToConnectionCollation;
    private static final List<String> COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT;

    public static String getLangMsg(String msgID, Object ... msgParameter) {
        return hdsMessages.getMsg(msgID, msgParameter);
    }

    public static int getCurrentRelease() {
        return 265;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String testDB(String theUrl, String pwd, String theUser, String driverClassName, String name, boolean logOnErrorLevel) {
        block43: {
            block42: {
                dbCon = null;
                st = null;
                rs = null;
                isOracle = driverClassName.equals("com.inet.ora.OraDriver");
                origTimeout = DriverManager.getLoginTimeout();
                DriverManager.setLoginTimeout(10);
                dbCon = DriverManager.getConnection(theUrl, theUser, pwd);
                if (!"HDS".equals(name)) ** GOTO lbl38
                st = dbCon.createStatement();
                rs = st.executeQuery("SELECT * FROM tblOptionen");
                hadNext = rs.next();
                release = hadNext != false ? rs.getInt("Release") : -1;
                if (release == (shouldBeRelease = 265)) break block42;
                var14_23 = ServerUtilities.hdsMessages.getMsg("FalscheDB", new Object[0]);
                DriverManager.setLoginTimeout(origTimeout);
                try {
                    rs.close();
                }
                catch (Throwable var15_27) {
                    // empty catch block
                }
                try {
                    st.close();
                }
                catch (Throwable var15_28) {
                    // empty catch block
                }
                try {
                    dbCon.close();
                }
                catch (Throwable var15_29) {
                    // empty catch block
                }
                return var14_23;
            }
            break block43;
lbl38:
            // 1 sources

            dbMeta = dbCon.getMetaData();
            HDLogger.info(dbMeta.getDatabaseProductName() + " " + dbMeta.getDriverName());
            break block43;
            {
                catch (Throwable var16_30) {
                    throw var16_30;
                }
            }
            finally {
                DriverManager.setLoginTimeout(origTimeout);
            }
        }
        dbMeta = null;
        try {
            rs.close();
        }
        catch (Throwable release) {
            // empty catch block
        }
        try {
            st.close();
        }
        catch (Throwable release) {
            // empty catch block
        }
        try {
            dbCon.close();
        }
        catch (Throwable release) {
            // empty catch block
        }
        return dbMeta;
        catch (Throwable er) {
            try {
                msg = er.getMessage();
                if (er.getCause() instanceof UnknownHostException) {
                    msg = ServerUtilities.hdsMessages.getMsg("UnknownHost", new Object[0]);
                } else if (er instanceof SQLInvalidAuthorizationSpecException || er.getMessage() != null && er.getMessage().contains("Access denied for user")) {
                    msg = ServerUtilities.hdsMessages.getMsg(isOracle != false ? "InvalidAuthorizationDb" : "InvalidAuthorization", new Object[0]);
                } else if (msg != null && msg.contains("TLS10")) {
                    msg = (String)msg + "\n" + ServerUtilities.hdsMessages.getMsg("DatabaseTLSUpdateNeeded", new Object[0]);
                }
                if (msg == null || msg.length() == 0) {
                    msg = er.toString();
                }
                exception = new HelpDeskServerException(er, (ErrorCode)HelpDeskErrorCodes.SQL_CONNECTION_TEST_ERROR);
                if (logOnErrorLevel) {
                    HDLogger.error(exception);
                } else {
                    HDLogger.debug(exception);
                }
                var13_22 = msg;
                return var13_22;
            }
            catch (Throwable var17_31) {
                throw var17_31;
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable var14_24) {}
                try {
                    st.close();
                }
                catch (Throwable var14_25) {}
                try {
                    dbCon.close();
                }
                catch (Throwable var14_26) {}
            }
        }
    }

    private static boolean isSameUDS(Properties existingUds, String theUrl, String pwd, String theUser) {
        boolean same = Objects.equals(theUrl, existingUds.getProperty("url"));
        same &= Objects.equals(pwd, existingUds.getProperty("password"));
        return same &= Objects.equals(theUser, existingUds.getProperty("user"));
    }

    public static Properties generateConnectionProperties(String theUrl, String user, String pw, String driverClassName) {
        Properties info = new Properties();
        info.put("user", user);
        info.put("password", pw);
        if ("com.mysql.cj.jdbc.Driver".equals(driverClassName)) {
            info.put("sessionVariables", "sql_mode = 'NO_BACKSLASH_ESCAPES'");
            String collation = urlToConnectionCollation.get(theUrl);
            if (collation == null) {
                try (Connection conn = DriverManager.getConnection(theUrl, info);){
                    collation = ServerUtilities.getMySQLCollation(conn);
                    info.put("connectionCollation", collation);
                    urlToConnectionCollation.put(theUrl, collation);
                }
                catch (Throwable th) {
                    HDLogger.debug(th);
                }
            } else {
                info.put("connectionCollation", collation);
            }
        }
        return info;
    }

    public static String getMySQLCollation(@Nonnull Connection conn) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SHOW VARIABLES WHERE Variable_name = 'collation_database'");
        rs.next();
        String collation = rs.getString("Value");
        rs.close();
        return collation;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getDefault());
    }

    public static void systemOut(String sqlQueryID, Throwable e, String msg) {
        ServerUtilities.systemOut(sqlQueryID, e, msg, HDLogger.LOG);
    }

    public static void systemOut(String problem, Throwable e, String msg, Logger logger) {
        logger.info((Object)(problem + "\t" + Runtime.getRuntime().totalMemory() + "\t" + Runtime.getRuntime().freeMemory()));
        if (msg != null) {
            StringBuffer msgBuffer = new StringBuffer();
            msgBuffer.append("\t");
            msgBuffer.append(msg);
            msgBuffer.append("\n");
            logger.info((Object)msgBuffer.toString());
        }
        if (e != null) {
            logger.error(e);
            while (e != null) {
                if (e instanceof SQLException) {
                    logger.warn((Object)("\tSQL State:" + ((SQLException)e).getSQLState() + "\tError Code:" + ((SQLException)e).getErrorCode()));
                    e = ((SQLException)e).getNextException();
                    continue;
                }
                e = null;
            }
        }
    }

    public static ResultSet getDeadline(String resID, String priID, Timestamp ts) throws Exception {
        ListResultSet theRS = new ListResultSet();
        theRS.setColumns(COLUMNS_DEADLINE);
        theRS.setColumnTypes(TYPEN_DEADLINE);
        Timestamp deadlineTS = ServerUtilities.calcDeadline(Integer.valueOf(resID), Integer.valueOf(priID), ts);
        return theRS.setSingleValue(deadlineTS, true);
    }

    public static Timestamp calcDeadline(int resID, int priID, Timestamp ts) {
        ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
        Date deadlineTime = rtm.calcTargetTime(resID, priID, ts);
        return deadlineTime != null ? new Timestamp(deadlineTime.getTime()) : null;
    }

    public static void setDeadline(Connection con, String resID, String bunID, String aufID, String priID, boolean force) {
        Timestamp deadline = ServerUtilities.calcDeadline(Integer.valueOf(resID), Integer.valueOf(priID), new Timestamp(System.currentTimeMillis()));
        ServerUtilities.setDeadline(con, Integer.valueOf(bunID), Integer.valueOf(aufID), deadline, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="only int can be passed in")
    public static void setDeadline(Connection con, int bunID, int aufID, @Nullable Timestamp deadline, boolean force) {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement(1005, 1008);
            if (deadline != null) {
                rs = st.executeQuery("SELECT AufID, DeadLineZeit FROM tblAuftraege WHERE AufID = " + aufID);
                rs.next();
                if (force || rs.getObject("DeadLineZeit") == null) {
                    rs.updateObject("DeadLineZeit", (Object)deadline);
                    rs.updateRow();
                    st.execute("UPDATE tblBuendel SET DeadLine = 0 WHERE BunID = " + bunID);
                }
            } else if (force) {
                st.execute("UPDATE tblAuftraege SET DeadLineZeit = Null WHERE AufID = " + aufID);
            }
        }
        catch (SQLException sqlex) {
            ServerUtilities.systemOut("Protokoll", sqlex, "Konnte Deadline nicht setzen!");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            try {
                st.close();
            }
            catch (Throwable throwable) {}
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Internal API, Input can only be fixed files")
    public static ResultSet getFile(String fileName) throws Throwable {
        Path filePath = Paths.get(fileName, new String[0]);
        if (!filePath.isAbsolute()) {
            filePath = AppDataLocation.getBaseLocationPath().resolve(filePath);
        }
        ListResultSet theRS = new ListResultSet();
        FileInputStream fs = new FileInputStream(filePath.toFile());
        byte[] Inputtext = new byte[fs.available()];
        fs.read(Inputtext);
        fs.close();
        theRS.setColumns(COLUMNS_FILE);
        theRS.setColumnTypes(TYPEN_FILE);
        return theRS.setSingleValue(Inputtext, true);
    }

    public static void realizeImapChange() {
        conti.setChanged(4, false);
    }

    public static synchronized int addRealisierungAndUpdateTicketManagerCache(Connection con, ResultSet rs, int bID, int auf, int aktID, Timestamp zeitpunkt, @Nullable Integer userID, String theName2, String emailAddr, String an, String cc, String bcc, int attAufID, String was, int textTyp, String description) throws SQLException {
        return TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(auf, () -> ServerUtilities.addRealisierung(con, rs, bID, auf, aktID, 0, zeitpunkt, zeitpunkt, null, userID, theName2, emailAddr, an, cc, bcc, attAufID, was, textTyp, description, null));
    }

    public static synchronized int addRealisierung(@Nullable Connection con, @Nullable ResultSet rs, int bID, int auf, int aktID, int resource, Timestamp zeitStart, Timestamp zeitEnde, Object stundensatz, @Nullable Integer userID, String theName2, String emailAddr, String an, String cc, String bcc, int attAufID, String was, int textTyp, String description, Object pauschale) throws SQLException {
        int reaID = TicketManipulatorBackdoor.getBackdoor().getIDGenerator().generateNewReaStepID();
        Statement st = null;
        if (userID != null && userID == -1) {
            userID = null;
        }
        try {
            TicketVO ticket;
            if (rs == null) {
                st = con.createStatement(1005, 1008);
                rs = st.executeQuery("SELECT * FROM tblRealisierung WHERE 1=0");
            }
            rs.moveToInsertRow();
            if (Actions.isMoveReaStepWithActionFromBundleSlaveToMaster(aktID)) {
                rs.updateInt("BunID", bID);
            } else {
                rs.updateInt("BunID", auf);
            }
            rs.updateInt("ReaID", reaID);
            rs.updateInt("OrgBunID", auf);
            rs.updateInt("AktID", aktID);
            rs.updateObject("StartZeit", (Object)zeitStart);
            rs.updateObject("EndZeit", (Object)zeitEnde);
            if (stundensatz != null) {
                rs.updateObject("Stundensatz", stundensatz);
            }
            if (pauschale != null) {
                rs.updateObject("Pauschale", pauschale);
            }
            if (description != null && ((String)description).length() > 250) {
                description = ((String)description).substring(0, 245) + "...";
            }
            rs.updateString("Description", (String)description);
            rs.updateString("was", was);
            rs.updateInt("ishtml", textTyp);
            if (userID == null) {
                rs.updateNull("UserID");
            } else {
                rs.updateInt("UserID", (int)userID);
            }
            ServerUtilities.updateLastChangedBy(auf, userID, con);
            rs.updateString("DisplayName", theName2);
            rs.updateString("EmailIn", emailAddr);
            rs.updateString("EmailAn", ServerUtilities.cutEmails(an));
            rs.updateString("EmailCC", ServerUtilities.cutEmails(cc));
            rs.updateString("EmailBCC", ServerUtilities.cutEmails(bcc));
            rs.updateInt("RessID", resource);
            if (attAufID > 0) {
                rs.updateInt("AttAufID", attAufID);
            }
            if (Actions.isVisibleForBundleEnduser(aktID) && (con != null && con.getAutoCommit() || rs != null && rs.getStatement().getConnection().getAutoCommit()) && (ticket = TicketManager.getReaderForSystem().getTicket(auf)) != null && ticket.isMasterInBundle()) {
                rs.updateBoolean("bundleVisible", true);
            }
            rs.insertRow();
            rs.last();
            ServerUtilities.checkforDuplicatedContents(auf, reaID);
        }
        catch (SQLException sqlex) {
            HDLogger.error(new HelpDeskServerException((Throwable)sqlex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR));
            throw sqlex;
        }
        finally {
            if (st != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
                try {
                    st.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return reaID;
    }

    private static void checkforDuplicatedContents(final int ticketId, final int reaID) {
        DefaultTimer.getInstance().schedule(new DefaultTimerTask(){

            public void runImpl() throws Throwable {
                try (UserAccountScope p = UserAccountScope.createPrivileged();
                     ServerLock l = TicketManipulatorSync.getTicketLock(ticketId);){
                    TicketReaderForSystem reader = TicketManager.getReaderForSystem();
                    ReaStepTextVO stepText = reader.getReaStepText(reaID);
                    if (stepText == null) {
                        HDLogger.error("Cannot find the reaStep " + reaID + ". Duplicate content may not be detected.");
                        return;
                    }
                    Stream<IdContent> stream1 = reader.getReaStepsForTicket(ticketId).stream().filter(step -> step.hasText() && step.getID() < reaID).map(step -> {
                        int id = step.getID();
                        ReaStepTextVO vo = reader.getReaStepText(id);
                        return new IdContent(id, vo.getText(), vo.hasHtmlContent());
                    });
                    Iterator<IdContent> it = stream1.iterator();
                    List<DuplicateRange> duplicateRanges = new DuplicateContentFinder().findDuplicatePositions(stepText.getText(), stepText.hasHtmlContent(), it, DuplicatedContentTicketActionExtension.IMAGE_NORMALIZER);
                    if (duplicateRanges != null) {
                        MutableReaStepData data = new MutableReaStepData();
                        data.put(ReaStepVO.FIELD_DUPLICATED_CONTENT, duplicateRanges);
                        TicketManipulatorBackdoor.getBackdoor().updateReaStepFields(reaID, data);
                    }
                }
            }
        }, 3000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLastChangedBy(Integer ticketId, Integer userID, Connection con) throws SQLException {
        boolean closeConnection = false;
        if (con == null) {
            con = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
            closeConnection = true;
        }
        try (PreparedStatement stm = con.prepareStatement("Update tblBuendel SET LastChangedByID = ? WHERE BunID = ?");){
            if (userID == null) {
                stm.setNull(1, 4);
            } else {
                stm.setInt(1, userID);
            }
            stm.setInt(2, ticketId);
            stm.executeUpdate();
        }
        finally {
            if (closeConnection) {
                con.close();
            }
        }
    }

    public static String cutEmails(String in) {
        if (in != null && in.length() > 1020) {
            int last = in.lastIndexOf(59, 1023);
            if (last == -1) {
                last = 1023;
            }
            in = in.substring(0, last);
        }
        return in;
    }

    public static void setLoopCount(int counter) {
        TIMER_COUNTER = counter;
    }

    public static ListResultSet getSingleStringResultSet() {
        ListResultSet theRS = new ListResultSet();
        theRS.setColumns(EIN_NAME);
        theRS.setColumnTypes(EIN_STRING);
        return theRS;
    }

    @Deprecated
    public static boolean isDatabaseConnectionValid() {
        return ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).isHelpDeskDatabaseConnectionValid();
    }

    static {
        serverLocale = Locale.getDefault();
        hdsMessages = new I18nMessages("com.inet.helpdesk.i18n.HDSMsg", ServerUtilities.class);
        NULL_AS_USER_ID = null;
        LoaderUtils.getUpdateableClassLoader();
        urlToConnectionCollation = Collections.synchronizedMap(new HashMap());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT = new ArrayList<String>();
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add("ticketid");
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_ATTACHMENTS.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_SUBJECT.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_STATUS_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_RESOURCE_GUID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_INQUIRY_DATE.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CATEGORY_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_PRIORITY_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CLASSIFICATION_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_ITIL_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_DEADLINE.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_IDENTIFIER.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_LAST_EDITOR_GUID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_LAST_CHANGED.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add("custom1");
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add("custom2");
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add("custom3");
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add("custom4");
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add("custom6");
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add("custom7");
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_SUM_TIME.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_TARGET_TIME.getKey());
    }
}

