/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchID;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ForkJoinPool;
import srv.ServerInitializer;
import srv.ServerUtilities;
import srv.automatic.Timer;

public class ServerInitializerFullHD
extends ServerInitializer {
    private static final ConfigValue<ArrayList<HashMap<String, String>>> JAVASCRIPT_TRIGGERS = new ConfigValue(HDConfigKeys.JAVASCRIPT_TRIGGERS);
    private static final ConfigValue<DatabaseConfigInfoList> DB_LIST = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    private Timer timer;

    protected ServerInitializerFullHD() {
    }

    public static void createFullInstance() {
        if (instance == null) {
            instance = new ServerInitializerFullHD();
        }
    }

    @Override
    public void interruptExecution() {
        if (this.timer != null) {
            this.timer.stopTimer();
        }
        super.interruptExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startAdditionalParts() {
        if (this.serverInterrupted) {
            return;
        }
        super.startAdditionalParts();
        this.startServerComponents();
        try {
            Class<ServerInitializerFullHD> clazz = ServerInitializerFullHD.class;
            synchronized (ServerInitializerFullHD.class) {
                if (this.serverInterrupted) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            HDLogger.error(e);
            ServerUtilities.systemOut("Fehler bei startAdditionalParts ", e, "");
            ServerUtilities.serverInterface.errorExit(616, "No Client Socket");
            return;
        }
        {
            if (this.serverInterrupted) {
                return;
            }
            ForkJoinPool.commonPool().execute(() -> HelpDeskUserManager.getRecoveryEnabledInstance().search("", new ArrayList(), new ArrayList(), 100, new SearchID((Object)this)));
            return;
        }
    }

    private void startServerComponents() {
        HDLogger.warn(ServerUtilities.getLangMsg("HDSgestartet", new Object[0]));
        try {
            ArrayList triggers = (ArrayList)JAVASCRIPT_TRIGGERS.get();
            HashMap<String, String> triggerMap = new HashMap<String, String>();
            for (HashMap trigger : triggers) {
                String name = (String)trigger.get("name");
                String content = (String)trigger.get("content");
                if (name == null || content == null) continue;
                triggerMap.put(name, content);
            }
            ServerUtilities.TRIGGERS.readTriggers(triggerMap);
        }
        catch (Exception e) {
            ServerUtilities.systemOut("Initialisieren Trigger", e, "Trigger Initialisierung fehlgeschlagen");
        }
        this.timer = new Timer();
        ConnectionFactory cf = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection conSmS = cf.getConnection("SMS");){
            if (conSmS.getMetaData() != null) {
                ServerUtilities.isSMSavailable = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

