/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.annotations.JsonData;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKeyParser;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.shared.LicenceInfo;
import com.inet.id.GUID;
import com.inet.notification.Notification;
import com.inet.notification.PermissionNotificationGenerator;
import com.inet.plugin.ServerPluginManager;
import java.util.Calendar;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.HdLicenseObserver;
import srv.ServerUtilities;

@JsonData
public class HdLicenseErrorNotificationGenerator
extends PermissionNotificationGenerator {
    public static final GUID LICENSE_ERROR_NOTIFICATION_ID = GUID.valueOf((String)"lfjvirn43459ns23jfm");

    public HdLicenseErrorNotificationGenerator() {
        super(HdPermissions.getNamedUserLicensePermissions());
    }

    @Nullable
    public String getPeriodKey() {
        return String.valueOf(Calendar.getInstance().get(6));
    }

    @Nonnull
    public GUID getId() {
        return LICENSE_ERROR_NOTIFICATION_ID;
    }

    public String getGroupingKey() {
        return "hdlicenseerror";
    }

    public Notification createNotification() {
        Properties licenseProps = new Properties();
        HdLicenseObserver.addLicenseData(licenseProps, null);
        LicenceInfo licenseInfo = LicenceInfo.getInstance();
        licenseInfo.updateLicenceInformations(licenseProps);
        if (!licenseInfo.gotLicenceProblem()) {
            HDLogger.debug(new Throwable("No license problem but the notification is still active...???"));
        }
        int count = licenseInfo.getLicenceCount();
        int used = licenseInfo.getUsedLicences();
        I18nMessages msg = ServerUtilities.hdsMessages;
        String errorMsgToDisplay = msg.getMsg("LicenseProblemNotification.message", new Object[]{String.valueOf(count), String.valueOf(used)});
        String errorTitleToDisplay = msg.getMsg("LicenseProblemNotification.title", new Object[0]);
        if (ConfigKeyParser.getCurrent().hasExpiredDate()) {
            errorMsgToDisplay = ((LocalizationBundle)ServerPluginManager.getInstance().getSingleInstance(LocalizationBundle.class)).getTranslation("TestversionEnds");
            errorTitleToDisplay = ((LocalizationBundle)ServerPluginManager.getInstance().getSingleInstance(LocalizationBundle.class)).getTranslation("TestversionEnds.title");
        }
        Notification notification = new Notification(errorTitleToDisplay, errorMsgToDisplay);
        notification.setCritical(true);
        return notification;
    }
}

