/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.json.Json;
import com.inet.logging.LogLevel;
import com.inet.logging.LogLevelsDefaults;
import java.util.HashMap;

public class ConfigurationInitializer {
    public void initConfiguration() {
        ConfigurationInitializer.setDefaultProperties();
    }

    private static void setDefaultConfigValue(String key, String value) {
        ConfigKey configKey = ConfigKey.valueOf((String)key);
        if (configKey != null) {
            configKey.setDefault(value);
        }
    }

    public static void setDefaultProperties() {
        HashMap<String, Boolean> activated = new HashMap<String, Boolean>();
        activated.put("taskplanner", Boolean.TRUE);
        activated.put("taskplanner.reporting", Boolean.TRUE);
        activated.put("datasource", Boolean.FALSE);
        activated.put("collaboration", Boolean.TRUE);
        ConfigKey.SYSTEMPERMISSION_ENABLED.setDefault("true");
        ConfigKey.PLUGINS_ACTIVATED.setDefault(new Json().toJson(activated));
        ConfigKey.REPOSITORY.setDefault("attachment:");
        Configuration config = ConfigurationManager.getInstance().getCurrent();
        if (!ConfigurationManager.isRecoveryMode()) {
            config.put(ConfigKey.SYSTEMPERMISSION_ENABLED, "true");
        }
        ConfigKey.LOG_FILE.setDefault("srvlog.txt");
        if (config.get(ConfigKey.LOG_FILE.getKey()) == null) {
            config.put(ConfigKey.LOG_FILE, "srvlog.txt");
        }
        ConfigKey.LOG_LEVELS.setDefault(new Json().toJson((Object)new LogLevelsDefaults(){
            {
                this.put("Reporting", LogLevel.ERROR.getValue());
                this.put("Config", LogLevel.INFO.getValue());
                this.put("HelpDesk", LogLevel.INFO.getValue());
            }
        }));
        ConfigKey.USE_CLIENT_TIMEZONE.setDefault("true");
        ConfigKey.AUTHENTICATION_SETTINGS.setDefault("[{'provider':'system'}]");
        ConfigurationInitializer.setDefaultConfigValue("usersandgroups.deleteusersinmanager", "false");
        ConfigurationInitializer.setDefaultConfigValue("usersandgroups.usercandeactivatethemself", "false");
        ConfigurationInitializer.setDefaultConfigValue("usersandgroups.usercandeletethemself", "false");
    }
}

