/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.util;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIAttachmentsHelper;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.SessionStore;
import com.inet.http.upload.AttachmentDescription;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class HelpDeskWebAPIHelper {
    public static final String REQUEST_REQUIRES_ENCODED_TICKET_ID = "com.inet.helpdesk.webapi.ticketid.required";

    public static boolean requestRequiresEncodedTicketId() {
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        return httpServletRequest != null && null != httpServletRequest.getAttribute(REQUEST_REQUIRES_ENCODED_TICKET_ID);
    }

    public static void setRequestRequiresEncodedTicketId() {
        HttpServletRequest httpServletRequest = SessionStore.getHttpServletRequest();
        if (httpServletRequest != null) {
            httpServletRequest.setAttribute(REQUEST_REQUIRES_ENCODED_TICKET_ID, new Object());
        }
    }

    @Nullable
    public static Object getValidAPIObject(@Nullable Object value) {
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        if (value instanceof String || value instanceof Boolean || value instanceof Number) {
            return value;
        }
        if (value.getClass().getAnnotation(JsonData.class) != null) {
            return value;
        }
        HelpDeskTicketWebAPIExtension.LOGGER.debug((Object)("Object of type '" + value.getClass().toString() + "' is not a valid value for the HelpDesk Web API."));
        return null;
    }

    public static MutableTicketData createMutableTicketData(@Nonnull Map<String, String> fields, @Nullable TicketVO ticketToChange) {
        MutableTicketData mutableTicketData = new MutableTicketData();
        List ticketFieldDefinition = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            Optional<TicketFieldDefinition> field = ticketFieldDefinition.stream().filter(f -> f.getKey().equals(entry.getKey()) || f.getDisplayName().equals(entry.getKey())).findFirst();
            if (!field.isPresent()) {
                HelpDeskTicketWebAPIExtension.LOGGER.debug((Object)("The ticket field was not found for the key or label: '" + entry.getKey() + "'; The following keys are available: " + String.join((CharSequence)", ", ticketFieldDefinition.stream().map(TicketFieldDefinition::getKey).collect(Collectors.toList()))));
                throw new ClientMessageException("The ticket field was not found for the key or label: '" + entry.getKey() + "'; Check the WebAPI Debug log for available action argument keys.");
            }
            FieldEditDefinition editDefinition = field.get().getEditDefinition();
            if (editDefinition == null || !editDefinition.isAvailable(ticketToChange == null ? null : List.of(ticketToChange))) {
                throw new ClientMessageException("The ticket field '" + entry.getKey() + "' is not editable.");
            }
            String value = editDefinition.convertStringValueToRequiredValueFormat(entry.getValue());
            editDefinition.updateTicketData(mutableTicketData, Collections.singletonMap(editDefinition.getFieldKey(), value));
        }
        return mutableTicketData;
    }

    public static ExtensionArguments createActionArguments(@Nonnull Map<String, String> arguments) {
        ExtensionArguments args = ExtensionArguments.create();
        List extensionArguments = ServerPluginManager.getInstance().get(ExtensionArguments.ExtArg.class);
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            Optional<ExtensionArguments.ExtArg> argument = extensionArguments.stream().filter(e -> e.getKey().equals(entry.getKey())).findFirst();
            if (!argument.isPresent()) {
                HelpDeskTicketWebAPIExtension.LOGGER.debug((Object)("The ticket argument was not found for the key: '" + entry.getKey() + "'; The following keys are available: " + String.join((CharSequence)", ", extensionArguments.stream().map(ExtensionArguments.ExtArg::getKey).collect(Collectors.toList()))));
                throw new ClientMessageException("The ticket argument was not found for the key: '" + entry.getKey() + "'; Check the WebAPI Debug log for available action argument keys.");
            }
            ExtensionArguments.ExtArg extArg = argument.get();
            Class valueType = extArg.getValueType();
            try {
                Object value = HelpDeskWebAPIHelper.resolvePrimitiveType(valueType, entry.getValue());
                if (value == null) {
                    value = extArg.fromJson(entry.getValue());
                }
                args.put(extArg, value);
            }
            catch (JsonException | ClassCastException e2) {
                Object possibleValues = "";
                if (valueType.isEnum() && valueType.getEnumConstants() != null) {
                    possibleValues = ". Possible values are: " + String.join((CharSequence)", ", Arrays.asList(valueType.getEnumConstants()).stream().map(Object::toString).collect(Collectors.toList()));
                }
                throw new ClientMessageException("The ticket argument value can not be resolved for the key: '" + entry.getKey() + "' with the message: " + StringFunctions.getUserFriendlyErrorMessage((Throwable)e2) + (String)possibleValues);
            }
        }
        return args;
    }

    public static void addAttachmentsToActionArguments(ExtensionArguments extensionArgs, HttpServletRequest request, List<AttachmentDescription> attachments) {
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            HelpDeskWebAPIAttachmentsHelper.addAttachmentsToExtensionArguments(extensionArgs, request, attachments);
        }
    }

    public static MutableReaStepData createMutableReaStepData(Map<String, String> fields) {
        MutableReaStepData reaStepData = new MutableReaStepData();
        List fieldsReaStep = ServerPluginManager.getInstance().get(ReaStepField.class);
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            Optional<ReaStepField> field = fieldsReaStep.stream().filter(f -> f.getKey().equals(entry.getKey())).findFirst();
            if (!field.isPresent()) {
                throw new ClientMessageException("The ticket step field was not found for the key: '" + entry.getKey() + "'");
            }
            try {
                Class valueType = field.get().getValueType();
                Object value = HelpDeskWebAPIHelper.resolvePrimitiveType(valueType, entry.getValue());
                if (value == null) {
                    value = new Json().fromJson(entry.getValue(), valueType);
                }
                field.get().validate(value);
                reaStepData.put(field.get(), value);
            }
            catch (JsonException | ClassCastException e) {
                throw new ClientMessageException("The ticket step value can not be resolved for the key: '" + entry.getKey() + "' with the message: " + StringFunctions.getUserFriendlyErrorMessage((Throwable)e));
            }
        }
        return reaStepData;
    }

    private static <T> T resolvePrimitiveType(Class<T> clazz, String value) {
        PropertyEditor editor;
        if ((clazz.isPrimitive() || clazz.isAssignableFrom(String.class)) && (editor = PropertyEditorManager.findEditor(clazz)) != null) {
            editor.setAsText(value);
            return (T)editor.getValue();
        }
        return null;
    }

    public static List<String> getRequestedFields(HttpServletRequest request, Consumer<List<String>> allowAllFieldsConsumer) {
        ArrayList<String> requestedFields = new ArrayList();
        String[] fields = request.getParameterValues("fields");
        if (fields != null) {
            if (fields.length == 1) {
                fields = fields[0].split(",");
            }
            requestedFields = Arrays.asList(fields);
            requestedFields.forEach(e -> e.trim());
        } else {
            UserManager userManager = UserManager.getInstance();
            UserAccount currentUserAccount = userManager.getCurrentUserAccount();
            if (currentUserAccount != null && !currentUserAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID)) {
                allowAllFieldsConsumer.accept(requestedFields);
            }
        }
        return requestedFields;
    }

    @Nonnull
    public static Integer checkTicketReadAccessOrThrow(@Nullable Integer ticketId, HttpServletResponse response) {
        if (ticketId == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.ticketIdNotGiven", new Object[0]));
        }
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketId)) {
            ResponseWriter.forbidden((HttpServletResponse)response);
            throw new AccessDeniedException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.accessDenied", new Object[0]));
        }
        return ticketId;
    }

    @Nonnull
    public static Integer checkTicketWriteAccessOrThrow(@Nullable Integer ticketId, HttpServletResponse response) {
        if (ticketId == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.ticketIdNotGiven", new Object[0]));
        }
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticketId)) {
            ResponseWriter.forbidden((HttpServletResponse)response);
            throw new AccessDeniedException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.accessDenied", new Object[0]));
        }
        return ticketId;
    }

    @Nonnull
    public static Integer checkReaStepReadAccessOrThrow(@Nullable Integer reaStepId, HttpServletResponse response) {
        if (reaStepId == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.notGiven", new Object[0]));
        }
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadReaStep(reaStepId)) {
            ResponseWriter.forbidden((HttpServletResponse)response);
            throw new AccessDeniedException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.accessDenied", new Object[0]));
        }
        return reaStepId;
    }
}

