/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Tag(name="Tickets", description="Operations for managing HelpDesk tickets")
public class HelpDeskTicketActionListHandler
extends RequestHandler.WithParentPathToken<Void, Map<String, String>, Integer> {
    public static final String ACTIONS_REQUEST_HANDLER_NAME = "actions";

    public HelpDeskTicketActionListHandler() {
        super(new String[]{ACTIONS_REQUEST_HANDLER_NAME});
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id.actions";
    }

    @Operation(summary="Get available actions for a ticket", description="Returns a list of all possible actions that can be performed on the specified ticket", responses={@ApiResponse(responseCode="200", description="List of available actions retrieved successfully", content={@Content(schema=@Schema(description="Map of action IDs to their display values"), examples={@ExampleObject(name="Actions available to ticket", value="{\"1\":\"Bearbeiten\",\"2\":\"Beenden\",\"3\":\"Priorit\u00e4t \u00e4ndern\",\"7\":\"Anfrage/Auftrag l\u00f6schen\",\"8\":\"Weiterleiten\",\"9\":\"\u00dcbernehmen\",\"10\":\"Termin vereinbaren\",\"-30\":\"Sollzeit \u00e4ndern\",\"-31\":\"Betreff \u00e4ndern\",\"-32\":\"Automatisch Beenden\",\"-10\":\"Benutzer \u00e4ndern\",\"-33\":\"Quick-Ticket anwenden\",\"-35\":\"Tickets verkn\u00fcpfen\",\"-15\":\"ITIL \u00e4ndern\",\"-38\":\"Freigaben \u00e4ndern\",\"-16\":\"Stoppuhr verwenden\",\"-39\":\"Betroffene Assets \u00e4ndern\",\"-17\":\"Deadline \u00e4ndern\",\"-19\":\"Prozess starten\",\"-1\":\"Auftrag b\u00fcndeln\",\"-3\":\"Wieder vorlegen\",\"-40\":\"Ticket bewerten\",\"-6\":\"Anlage l\u00f6schen\",\"-41\":\"Formulardaten anwenden\",\"-21\":\"Anlage manuell hinzuf\u00fcgen\",\"-22\":\"Text eines Bearbeitungsschrittes ver\u00e4ndern\",\"-145\":\"Fixed\",\"-26\":\"Kategorie \u00e4ndern\",\"-144\":\"Won't fix\",\"-27\":\"Kennung \u00e4ndern\",\"-147\":\"Comment\",\"-28\":\"Klassifizierung \u00e4ndern\",\"-146\":\"Verified\",\"-29\":\"Ticket-Feld \u00e4ndern\",\"-143\":\"Duplicate\",\"-142\":\"Invalid\"}")})}), @ApiResponse(responseCode="400", description="Invalid ticket ID or ticket not found"), @ApiResponse(responseCode="401", description="User not authorized to view ticket actions")})
    public Map<String, String> handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void inputObject, @Nullable Integer ticketId, boolean previewModeEnabled) throws IOException {
        ticketId = HelpDeskWebAPIHelper.checkTicketReadAccessOrThrow(ticketId, response);
        List<ActionVO> allPossibleActionsForTicket = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticketId);
        if (allPossibleActionsForTicket == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicket", new Object[0]));
        }
        Map<String, String> responseObject = allPossibleActionsForTicket.stream().collect(Collectors.groupingBy(e -> e.getUniqueID())).entrySet().stream().map(e -> (ActionVO)((List)e.getValue()).get(0)).collect(Collectors.toMap(ActionVO::getUniqueID, ActionVO::getDisplayValue));
        return responseObject;
    }
}

