/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data.step;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;

@JsonData
@Schema(description="Basic response data for a ticket reaction step")
public class TicketStepEntryResponseData {
    @Schema(description="The unique identifier of the reaction step")
    private int id;
    @Schema(description="The identifier of the action that was performed")
    private int actionID;
    @Schema(description="The GUID of the user who performed the action")
    private GUID userGUID;
    @Schema(description="The timestamp when the reaction step was last modified")
    private long lastModified;

    protected TicketStepEntryResponseData() {
    }

    public TicketStepEntryResponseData(ReaStepVO reaStepVO) {
        this.id = reaStepVO.getID();
        this.actionID = reaStepVO.getActionID();
        this.userGUID = reaStepVO.getUserID();
        this.lastModified = reaStepVO.getEndDate();
    }

    public static List<TicketStepEntryResponseData> from(List<ReaStepVO> reaStepsForTicket) {
        return reaStepsForTicket.stream().map(r -> new TicketStepEntryResponseData((ReaStepVO)r)).collect(Collectors.toList());
    }
}

