/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data;

import com.inet.annotations.JsonData;
import com.inet.http.upload.AttachmentDescription;
import com.inet.id.GUID;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonData
@Schema(description="Request data for applying an action to a ticket")
public class HelpDeskTicketApplyActionRequestData {
    @Schema(description="The text content to be added with the action", required=true)
    private String text;
    @Schema(description="Whether the text content is in HTML format", defaultValue="false")
    private boolean htmlContent = false;
    @Schema(description="The unique identifier of the action to apply", required=true)
    private String actionId;
    @Schema(description="The GUID of the user who will perform the action. Only valid when executed with privileged rights")
    private GUID userGUID = null;
    @Schema(description="Additional fields to be set on the reaction step")
    private Map<String, String> stepFields = new HashMap<String, String>();
    @Schema(description="Additional fields to be updated on the ticket")
    private Map<String, String> ticketFields = new HashMap<String, String>();
    @Schema(description="Additional arguments for the action execution")
    private Map<String, String> actionArguments = new HashMap<String, String>();
    @Schema(description="List of attachments to be added with the action")
    private List<AttachmentDescription> attachments = new ArrayList<AttachmentDescription>();

    private HelpDeskTicketApplyActionRequestData() {
    }

    public String getText() {
        return this.text;
    }

    public boolean isHtmlContent() {
        return this.htmlContent;
    }

    public String getActionId() {
        return this.actionId;
    }

    public GUID getUserGUID() {
        return this.userGUID;
    }

    public Map<String, String> getStepFields() {
        return this.stepFields;
    }

    public Map<String, String> getTicketFields() {
        return this.ticketFields;
    }

    public Map<String, String> getActionArguments() {
        return this.actionArguments;
    }

    public List<AttachmentDescription> getAttachments() {
        return this.attachments;
    }
}

