/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.persistence;

import com.inet.config.ConfigurationManager;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.core.utils.SubListTaskExecutor;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.ConnectionFactoryHolder;
import com.inet.helpdesk.usersandgroups.HDFieldLocator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.user.persistence.HelpDeskUserDetails;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.permissions.Permission;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.user.persistence.UserPersistenceUnit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class HelpDeskUserPersistence
implements UserPersistence {
    private static String TBLUSER = "tblUser";
    private static String TBLUSERBINARY = "tblUserBinary";
    private static String TBLUSERDICTIONARY = "tblUserDictionary";
    private static String TBLGERAETEBESTAND = "tblGeraeteBestand";
    private static final String TBLUSER_GELOESCHT = "geloescht";
    private static final String TBLUSER_AENDERUNG = "Aenderung";
    private static final String KEY_USERDETAILS = "useraccountdetails";
    private final ConnectionFactoryHolder conFactoryHolder = new ConnectionFactoryHolder();
    private static final String[] COLUMNS_FOR_PROFILE_SIZE = new String[]{"UsrID", "Nachname", "Vorname", "Nachname", "Telefon", "Email", "Zimmer", "Computername", "GebID", "Abteilung", "Kostenstelle", "geloescht", "SprID", "Version", "BgrID", "Frei1", "Frei2", "Frei3", "Frei4", "Frei5", "Frei6", "Pauschale1", "Pauschale2", "Pauschale3", "Aenderung", "ImpName", "UserUUID"};

    public void connectionCreated(ConnectionFactory connectionFactory) {
        this.conFactoryHolder.setConnectionFactory(connectionFactory);
    }

    public void init() {
    }

    private List<UserField<Object>> getBaseUserFields() {
        List userFields = UserManager.getAllFields();
        ArrayList<Object> fieldsTblUser = new ArrayList<Object>();
        fieldsTblUser.add(UsersAndGroups.FIELD_FIRSTNAME);
        fieldsTblUser.add(UsersAndGroups.FIELD_LASTNAME);
        fieldsTblUser.add(UsersAndGroups.FIELD_EMAIL);
        fieldsTblUser.add(UsersAndGroups.FIELD_TELEPHONE);
        fieldsTblUser.add(UsersAndGroups.FIELD_NOTE);
        fieldsTblUser.addAll(HDUsersAndGroups.getFieldsWithValuesInTblUser());
        fieldsTblUser.retainAll(userFields);
        return Collections.unmodifiableList(fieldsTblUser);
    }

    private List<UserField<Object>> getAdditionaluserFields() {
        ArrayList fields = new ArrayList(UserManager.getAllFields());
        fields.removeAll(this.getBaseUserFields());
        return Collections.unmodifiableList(fields);
    }

    public UserAccount saveNew(GUID accountID, UserAccountType type, long lastModified, long lastAccess, boolean active, MutableUserData userData) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                this.insertIntoTblUser(connection, accountID, lastModified, active, userData);
                HelpDeskUserDetails details = this.createDetailsFrom(type, lastAccess, userData, Collections.emptyList(), Collections.emptySet());
                this.saveUserDetails(connection, accountID, details);
                return null;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        return this.load(accountID);
    }

    private HelpDeskUserDetails createDetailsFrom(UserAccountType type, long lastAccess, MutableUserData userData, List<LoginSettings> loginSettings, Set<String> permissions) {
        Set includedAdditionalFields = userData.getIncludedFields();
        includedAdditionalFields.retainAll(this.getAdditionaluserFields());
        HashMap<String, String> jsonizedValues = new HashMap<String, String>(includedAdditionalFields.size());
        for (UserField field : includedAdditionalFields) {
            Object value = userData.get(field);
            String jsonData = new Json().toJson(value);
            jsonizedValues.put(field.getKey(), jsonData);
        }
        return new HelpDeskUserDetails(type, lastAccess, jsonizedValues, loginSettings, permissions);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    private void insertIntoTblUser(Connection connection, GUID accountID, long lastModified, boolean active, MutableUserData userData) throws SQLException {
        String sql = "SELECT * FROM " + TBLUSER + " WHERE 1 = 0";
        DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
            try (Statement stm = connection.createStatement(1005, 1008);
                 ResultSet rs = stm.executeQuery(sql);){
                rs.moveToInsertRow();
                rs.updateString("UserUUID", accountID.toString());
                rs.updateTimestamp(TBLUSER_AENDERUNG, new Timestamp(lastModified));
                rs.updateInt(TBLUSER_GELOESCHT, active ? 0 : 1);
                for (UserField field : userData.getIncludedFields()) {
                    this.updateFieldValue(rs, field, userData.get(field));
                }
                rs.insertRow();
            }
            return null;
        });
    }

    private void saveUserDetails(Connection connection, GUID accountID, HelpDeskUserDetails details) throws SQLException {
        String jsonData = new Json().toJson((Object)details);
        byte[] bytes = jsonData.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        this.saveBinaryData(connection, accountID, KEY_USERDETAILS, inputStream, bytes.length);
    }

    /*
     * Loose catch block
     */
    private HelpDeskUserDetails loadUserDetails(Connection connection, GUID accountID) throws SQLException {
        String sql = String.format("SELECT Data FROM %s WHERE UserUUID = ? AND DataKey = ?", TBLUSERBINARY);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            HelpDeskUserDetails helpDeskUserDetails;
            block19: {
                ResultSet rs;
                block17: {
                    HelpDeskUserDetails helpDeskUserDetails2;
                    block18: {
                        pstm.setQueryTimeout(30);
                        pstm.setString(1, accountID.toString());
                        pstm.setString(2, KEY_USERDETAILS);
                        rs = pstm.executeQuery();
                        if (rs.next()) break block17;
                        UsersAndGroups.LOGGER.warn((Object)("Missing user details of account with ID: " + String.valueOf(accountID)));
                        helpDeskUserDetails2 = HelpDeskUserDetails.createReplacementForCorruptedData();
                        if (rs == null) break block18;
                        rs.close();
                    }
                    return helpDeskUserDetails2;
                }
                InputStream inputStream = rs.getBinaryStream(1);
                helpDeskUserDetails = (HelpDeskUserDetails)new Json().fromJson(inputStream, HelpDeskUserDetails.class);
                if (rs == null) break block19;
                {
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JsonException | IOException ex) {
                            UsersAndGroups.LOGGER.error((Object)("Could not read user details of account with ID: " + String.valueOf(accountID)));
                            UsersAndGroups.LOGGER.error(ex);
                            HelpDeskUserDetails helpDeskUserDetails3 = HelpDeskUserDetails.createReplacementForCorruptedData();
                            return helpDeskUserDetails3;
                        }
                    }
                }
                rs.close();
            }
            return helpDeskUserDetails;
        }
    }

    public UserAccount updateData(GUID accountID, long lastModified, MutableUserData userData) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                HelpDeskUserDetails details = this.loadUserDetails(connection, accountID);
                this.updateTblUser(connection, accountID, lastModified, rs -> {
                    for (UserField field : userData.getIncludedFields()) {
                        this.updateFieldValue(rs, field, userData.get(field));
                    }
                });
                Set includedAdditionalFields = userData.getIncludedFields();
                includedAdditionalFields.retainAll(this.getAdditionaluserFields());
                HashMap<String, String> jsonizedValues = new HashMap<String, String>(details.getFields());
                for (UserField field : includedAdditionalFields) {
                    Object value = userData.get(field);
                    String jsonData = new Json().toJson(value);
                    jsonizedValues.put(field.getKey(), jsonData);
                }
                HelpDeskUserDetails updatedDetails = new HelpDeskUserDetails(details.getAccountType(), details.getLastAccess(), jsonizedValues, details.getLoginSettings(), details.getPermissions());
                this.saveUserDetails(connection, accountID, updatedDetails);
                return null;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        return this.load(accountID);
    }

    public void removeData(GUID accountID, List<UserField<?>> fields) {
        this.conFactoryHolder.throwIfNoConnection();
        try (Connection connection = this.conFactoryHolder.getFactory().getConnection();){
            HelpDeskUserDetails details = this.loadUserDetails(connection, accountID);
            HashMap<String, String> jsonizedValues = new HashMap<String, String>(details.getFields());
            for (UserField<?> userField : fields) {
                jsonizedValues.remove(userField.getKey());
            }
            HelpDeskUserDetails updatedDetails = new HelpDeskUserDetails(details.getAccountType(), details.getLastAccess(), jsonizedValues, details.getLoginSettings(), details.getPermissions());
            this.saveUserDetails(connection, accountID, updatedDetails);
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
    }

    public Iterator<GUID> getIteratorOverIDsOfUserAccountWithValuesForSpecifiedFields(List<UserField<?>> fields) {
        this.conFactoryHolder.throwIfNoConnection();
        ArrayList<GUID> matchedAccountIDs = new ArrayList<GUID>();
        try (Connection connection = this.conFactoryHolder.getFactory().getConnection();){
            String sql = String.format("SELECT UserUUID, Data FROM %s WHERE DataKey = ?", TBLUSERBINARY);
            try (PreparedStatement pstm = connection.prepareStatement(sql);){
                pstm.setFetchSize(1000);
                pstm.setQueryTimeout(30);
                pstm.setString(1, KEY_USERDETAILS);
                try (ResultSet rs = pstm.executeQuery();){
                    block21: while (rs.next()) {
                        HelpDeskUserDetails details;
                        GUID accountID;
                        try {
                            accountID = GUID.valueOf((String)rs.getString(1));
                        }
                        catch (IllegalArgumentException ex) {
                            HDLogger.error("Found user account with invalid ID:");
                            HDLogger.error(ex);
                            continue;
                        }
                        try {
                            InputStream inputStream = rs.getBinaryStream(2);
                            details = (HelpDeskUserDetails)new Json().fromJson(inputStream, HelpDeskUserDetails.class);
                        }
                        catch (JsonException | IOException ex) {
                            UsersAndGroups.LOGGER.error((Object)("Could not read user details of account with ID: " + String.valueOf(accountID)));
                            UsersAndGroups.LOGGER.error(ex);
                            continue;
                        }
                        HashMap<String, String> currentData = details.getFields();
                        for (UserField<?> userField : fields) {
                            if (!currentData.containsKey(userField.getKey())) continue;
                            matchedAccountIDs.add(accountID);
                            continue block21;
                        }
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        return matchedAccountIDs.iterator();
    }

    public UserAccount updateLoginSettings(GUID accountID, long lastModified, List<LoginSettings> settingsToAdd, List<LoginSettings> settingsToRemove) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                HelpDeskUserDetails details = this.loadUserDetails(connection, accountID);
                this.updateTblUser(connection, accountID, lastModified, rs -> {});
                List updatedLoginSettings = UserPersistenceUnit.updateLoginSettings(details.getLoginSettings(), (List)settingsToAdd, (List)settingsToRemove);
                HelpDeskUserDetails updatedDetails = new HelpDeskUserDetails(details.getAccountType(), details.getLastAccess(), details.getFields(), updatedLoginSettings, details.getPermissions());
                this.saveUserDetails(connection, accountID, updatedDetails);
                return null;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        return this.load(accountID);
    }

    public UserAccount updatePermissions(GUID accountID, long lastModified, Set<String> permissionsToAdd, Set<String> permissionsToRemove) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                HelpDeskUserDetails details = this.loadUserDetails(connection, accountID);
                this.updateTblUser(connection, accountID, lastModified, rs -> {});
                HashSet<String> updatedPermissions = new HashSet<String>(details.getPermissions());
                updatedPermissions.addAll(permissionsToAdd);
                updatedPermissions.removeAll(permissionsToRemove);
                HelpDeskUserDetails updatedDetails = new HelpDeskUserDetails(details.getAccountType(), details.getLastAccess(), details.getFields(), details.getLoginSettings(), updatedPermissions);
                this.saveUserDetails(connection, accountID, updatedDetails);
                return null;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        return this.load(accountID);
    }

    public UserAccount setAccountActive(GUID accountID, long lastModified, boolean active) {
        UserAccount userAccount;
        block8: {
            this.conFactoryHolder.throwIfNoConnection();
            Connection connection = this.conFactoryHolder.getFactory().getConnection();
            try {
                this.updateTblUser(connection, accountID, lastModified, rs -> rs.updateInt(TBLUSER_GELOESCHT, active ? 0 : 1));
                userAccount = this.load(connection, accountID);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException | SQLException ex) {
                    throw new PersistenceException(ex);
                }
            }
            connection.close();
        }
        return userAccount;
    }

    public UserAccount setLastModified(GUID accountID, long lastModified) {
        UserAccount userAccount;
        block8: {
            this.conFactoryHolder.throwIfNoConnection();
            Connection connection = this.conFactoryHolder.getFactory().getConnection();
            try {
                this.updateTblUser(connection, accountID, lastModified, rs -> {});
                userAccount = this.load(connection, accountID);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException | SQLException ex) {
                    throw new PersistenceException(ex);
                }
            }
            connection.close();
        }
        return userAccount;
    }

    public UserAccount setLastAccess(GUID accountID, long lastAccess) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                HelpDeskUserDetails details = this.loadUserDetails(connection, accountID);
                HelpDeskUserDetails updatedDetails = new HelpDeskUserDetails(details.getAccountType(), lastAccess, details.getFields(), details.getLoginSettings(), details.getPermissions());
                this.saveUserDetails(connection, accountID, updatedDetails);
                return null;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        return this.load(accountID);
    }

    public void delete(GUID accountID) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                Integer userID = this.getUserID(connection, accountID);
                if (userID == null) {
                    return null;
                }
                String sql = String.format("DELETE FROM %s WHERE UserUUID = ?", TBLUSER);
                try (Connection con = this.conFactoryHolder.getFactory().getConnection();
                     PreparedStatement pstm = con.prepareStatement(sql);){
                    pstm.setQueryTimeout(30);
                    pstm.setString(1, accountID.toString());
                    DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                        pstm.executeUpdate();
                        return null;
                    });
                }
                return null;
            });
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    private Integer getUserID(Connection con, GUID accountID) throws SQLException {
        String sql = String.format("SELECT UsrID FROM %s WHERE UserUUID = ?", TBLUSER);
        try (PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setString(1, accountID.toString());
            try (ResultSet rs = pstm.executeQuery();){
                if (rs.next()) {
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
            Integer n = null;
            return n;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    private boolean hasAssociatedDevices(Connection con, int userID) {
        String sql = "SELECT 1 FROM " + TBLGERAETEBESTAND + " WHERE UserID = ?";
        try (PreparedStatement pstm = con.prepareStatement(sql);){
            boolean bl;
            block14: {
                pstm.setInt(1, userID);
                ResultSet rs = pstm.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            UsersAndGroups.LOGGER.debug((Object)e);
            return false;
        }
    }

    public void deleteAll() {
        throw new UnsupportedOperationException("This method was intended to be called by tests only. Currently it should never be called in case of Help Desk.");
    }

    public UserAccount load(GUID accountID) {
        this.conFactoryHolder.throwIfNoConnection();
        boolean closeAfterwards = false;
        Connection connection = ConnectionFactory.getCurrentConnectionWithTransaction();
        try {
            if (connection == null) {
                closeAfterwards = true;
                connection = this.conFactoryHolder.getFactory().getConnection();
            }
            UserAccount userAccount = this.load(connection, accountID);
            return userAccount;
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        finally {
            if (closeAfterwards) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    private UserAccount load(Connection connection, GUID accountID) throws SQLException {
        String s1 = String.format("SELECT * FROM %s LEFT JOIN %s", TBLUSER, TBLUSERBINARY);
        String s2 = String.format(" ON %s.UserUUID = %s.UserUUID", TBLUSER, TBLUSERBINARY);
        String s3 = String.format(" AND DataKey = '%s' WHERE %s.UserUUID = ?", KEY_USERDETAILS, TBLUSER);
        String sql = s1 + s2 + s3;
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            UserAccount userAccount;
            block12: {
                pstm.setString(1, accountID.toString());
                ResultSet rs = pstm.executeQuery();
                try {
                    userAccount = this.loadFromResultSet(rs);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return userAccount;
        }
    }

    private UserAccount loadFromResultSet(ResultSet rs) throws SQLException, PersistenceException {
        HelpDeskUserDetails details;
        GUID userUUID;
        if (!rs.next()) {
            return null;
        }
        int userIntID = rs.getInt("UsrID");
        try {
            userUUID = GUID.valueOf((String)rs.getString("UserUUID"));
        }
        catch (IllegalArgumentException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        Timestamp timestamp = rs.getTimestamp(TBLUSER_AENDERUNG);
        long lastModified = timestamp != null ? timestamp.getTime() : System.currentTimeMillis();
        boolean active = rs.getInt(TBLUSER_GELOESCHT) <= 0;
        HashMap<Object, Object> deserializedFields = new HashMap<Object, Object>();
        List<UserField<Object>> baseUserFields = this.getBaseUserFields();
        if (baseUserFields.contains((Object)HDUsersAndGroups.FIELD_USER_ID)) {
            deserializedFields.put((Object)HDUsersAndGroups.FIELD_USER_ID, userIntID);
        }
        for (UserField<Object> field : baseUserFields) {
            Field oldField = HDFieldLocator.getOldDbFieldForNewField(field);
            if (oldField == null) continue;
            String columnName = oldField.getKey();
            Object object = this.getFieldValue(rs, field, columnName);
            deserializedFields.put(field, object);
        }
        try {
            InputStream inputStream = rs.getBinaryStream("Data");
            if (inputStream == null) {
                UsersAndGroups.LOGGER.warn((Object)("Missing user details of account with ID: " + String.valueOf(userUUID)));
                details = HelpDeskUserDetails.createReplacementForCorruptedData();
            } else {
                details = (HelpDeskUserDetails)new Json().fromJson(inputStream, HelpDeskUserDetails.class);
            }
        }
        catch (JsonException | IOException ex) {
            UsersAndGroups.LOGGER.error((Object)("Could not read user details of account with ID: " + String.valueOf(userUUID)));
            UsersAndGroups.LOGGER.error(ex);
            details = HelpDeskUserDetails.createReplacementForCorruptedData();
        }
        HashMap<String, String> persistedAdditionalFields = details.getFields();
        List<UserField<Object>> additionalUserFields = this.getAdditionaluserFields();
        for (UserField userField : additionalUserFields) {
            String fieldKey = userField.getKey();
            if (!persistedAdditionalFields.containsKey(fieldKey)) continue;
            String jsonData = persistedAdditionalFields.get(fieldKey);
            try {
                Object value = new Json().fromJson(jsonData, userField.getValueType());
                deserializedFields.put(userField, value);
            }
            catch (JsonException ex) {
                String msg = String.format("Could not deserialize value of field \"%s\" defined for user account with ID \"%s\". Default value will be used instead.", fieldKey, userUUID);
                UsersAndGroups.LOGGER.warn((Object)msg);
                UsersAndGroups.LOGGER.warn((Object)ex);
            }
        }
        ArrayList<UserField<Object>> allFields = new ArrayList<UserField<Object>>();
        allFields.addAll(baseUserFields);
        allFields.addAll(additionalUserFields);
        MutableUserData mutableUserData = MutableUserData.createAndFillWithValidValues((GUID)userUUID, allFields, deserializedFields);
        HashSet<Permission> permissions = new HashSet<Permission>();
        for (String key : details.getPermissions()) {
            permissions.add(Permission.valueOfExistingOrCreate((String)key));
        }
        return UserAccount.create((GUID)userUUID, (UserAccountType)details.getAccountType(), (long)lastModified, (long)details.getLastAccess(), (MutableUserData)mutableUserData, details.getLoginSettings(), permissions, (boolean)active);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is built from GUID-parameters")
    public List<UserAccount> load(List<GUID> accountIDs, int limit) {
        this.conFactoryHolder.throwIfNoConnection();
        ArrayList<UserAccount> plainResult = new ArrayList<UserAccount>();
        List result = Collections.synchronizedList(plainResult);
        SubListTaskExecutor.SubListExecutionTask task = subList -> {
            Object ids = subList.stream().map(id -> "'" + String.valueOf(id) + "'").collect(Collectors.toList()).toString();
            ids = "(" + ((String)ids).substring(1, ((String)ids).length() - 1) + ")";
            String s1 = String.format("SELECT * FROM %s LEFT JOIN %s", TBLUSER, TBLUSERBINARY);
            String s2 = String.format(" ON %s.UserUUID = %s.UserUUID", TBLUSER, TBLUSERBINARY);
            String s3 = String.format(" AND DataKey = '%s' WHERE %s.UserUUID IN %s", KEY_USERDETAILS, TBLUSER, ids);
            String sql = s1 + s2 + s3;
            DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                try (Connection con = this.conFactoryHolder.getFactory().getConnection();
                     Statement stm = con.createStatement();
                     ResultSet rs = stm.executeQuery(sql);){
                    UserAccount userAccount = null;
                    while (result.size() < limit && (userAccount = this.loadFromResultSet(rs)) != null) {
                        result.add(userAccount);
                    }
                }
                return null;
            });
        };
        try {
            accountIDs = accountIDs.subList(0, Math.min(accountIDs.size(), limit));
            new SubListTaskExecutor().executeParallelForEachSubList(accountIDs, 900, task, 5000L);
            return plainResult;
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    private Object getFieldValue(ResultSet rs, UserField<Object> field, String columnName) throws SQLException {
        Class valueType = field.getValueType();
        if (valueType.equals(Integer.class)) {
            return rs.getInt(columnName);
        }
        if (valueType.equals(String.class)) {
            return rs.getString(columnName);
        }
        if (valueType.equals(Double.class)) {
            return rs.getDouble(columnName);
        }
        String msg = String.format("Could not handle value of field %s with type %s", field.getKey(), valueType.toString());
        throw new PersistenceException(msg);
    }

    public Iterator<GUID> getUserAccountIdIterator(@Nullable String key) {
        this.conFactoryHolder.waitOnConnectionEstablished();
        ArrayList<GUID> userIDs = new ArrayList<GUID>();
        try (Connection con = this.conFactoryHolder.getFactory().getConnection();){
            ResultSet rs;
            Statement stm;
            if (key == null) {
                sql = String.format("SELECT UserUUID FROM %s", TBLUSER);
                stm = con.createStatement();
                rs = stm.executeQuery(sql);
            } else {
                sql = String.format("SELECT UserUUID FROM %s WHERE DataKey = ?", TBLUSERBINARY);
                PreparedStatement pr = con.prepareStatement(sql);
                stm = pr;
                pr.setString(1, key);
                rs = pr.executeQuery();
            }
            while (rs.next()) {
                try {
                    GUID userUUID = GUID.valueOf((String)rs.getString(1));
                    userIDs.add(userUUID);
                }
                catch (IllegalArgumentException ex) {
                    HDLogger.error("Found user account with invalid ID:");
                    HDLogger.error(ex);
                }
            }
            rs.close();
            stm.close();
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        return userIDs.iterator();
    }

    /*
     * Exception decompiling
     */
    public boolean hasUserDataFor(GUID accountID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public InputStream loadBinaryData(GUID accountID, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void saveBinaryData(GUID accountID, String key, InputStream in, int length) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                this.saveBinaryData(connection, accountID, key, in, length);
                return null;
            });
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    private void saveBinaryData(Connection connection, GUID accountID, String key, InputStream in, int length) throws SQLException {
        String keyLowerCase = key.toLowerCase();
        this.deleteBinaryData(connection, accountID, keyLowerCase);
        String sql = String.format("INSERT INTO %s (UserUUID, DataKey, Data) VALUES (?, ?, ?)", TBLUSERBINARY);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setString(1, accountID.toString());
            pstm.setString(2, keyLowerCase);
            if (length != -1) {
                pstm.setBinaryStream(3, in, length);
            } else {
                pstm.setBinaryStream(3, in);
            }
            DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                pstm.executeUpdate();
                return null;
            });
        }
    }

    public void deleteBinaryData(GUID accountID, String key) {
        this.conFactoryHolder.throwIfNoConnection();
        try (Connection connection = this.conFactoryHolder.getFactory().getConnection();){
            this.deleteBinaryData(connection, accountID, key.toLowerCase());
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    private void deleteBinaryData(Connection connection, GUID accountID, String key) throws SQLException {
        String sql = String.format("DELETE FROM %s WHERE UserUUID = ? AND DataKey = ?", TBLUSERBINARY);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setString(1, accountID.toString());
            pstm.setString(2, key);
            DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                pstm.executeUpdate();
                return null;
            });
        }
    }

    private void updateFieldValue(ResultSet rs, UserField<?> field, Object value) throws SQLException {
        Field oldField = HDFieldLocator.getOldDbFieldForNewField(field);
        if (oldField == null || !this.getBaseUserFields().contains(field)) {
            return;
        }
        String columnName = oldField.getKey();
        Class valueType = field.getValueType();
        if (valueType.equals(Integer.class)) {
            rs.updateInt(columnName, (int)((Integer)value));
        } else if (valueType.equals(String.class)) {
            rs.updateString(columnName, (String)value);
        } else if (valueType.equals(Double.class)) {
            rs.updateDouble(columnName, (double)((Double)value));
        } else {
            String msg = String.format("Could not handle value of field %s with type %s", field.getKey(), valueType.toString());
            throw new PersistenceException(msg);
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is built from GUID-parameter")
    private void updateTblUser(Connection connection, GUID accountID, long lastModified, UserDataRowUpdater updater) throws SQLException {
        String sql = String.format("SELECT * FROM %s WHERE UserUUID = %s", TBLUSER, accountID.toSQLString());
        DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
            try (Statement stm = connection.createStatement(1005, 1008);
                 ResultSet rs = stm.executeQuery(sql);){
                if (!rs.next()) {
                    throw new PersistenceException(UsersAndGroups.MSG.getMsg("error.accountDoesNotExist", new Object[]{accountID}));
                }
                rs.updateTimestamp(TBLUSER_AENDERUNG, new Timestamp(lastModified));
                updater.updateRow(rs);
                rs.updateRow();
            }
            return null;
        });
    }

    public long getAccountFileSize(GUID accountId) {
        long l;
        block9: {
            this.conFactoryHolder.throwIfNoConnection();
            Connection connection = this.conFactoryHolder.getFactory().getConnection();
            try {
                long size = 0L;
                String string = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.DB_CONFIGS);
                DatabaseConfigInfo databaseConfigInfo = DatabaseConfigInfoList.valueOf(string).get("HDS");
                if (databaseConfigInfo == null) {
                    throw new PersistenceException("No HDS");
                }
                DatabaseConfigInfo.DatabaseType type = databaseConfigInfo.getDriver();
                size += this.sumTblUser(connection, accountId, type);
                size += this.sumTblUserBinary(connection, accountId, type);
                l = size += this.sumTblUserDictionary(connection, accountId, type);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            connection.close();
        }
        return l;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    private long sumTblUserBinary(Connection connection, GUID accountId, DatabaseConfigInfo.DatabaseType type) throws SQLException {
        long sum = 0L;
        Object sql = switch (type) {
            case DatabaseConfigInfo.DatabaseType.inetdae7 -> "select ISNULL(DATALENGTH(UserUUID),0) + ISNULL(DATALENGTH(DataKey),0) + ISNULL(DATALENGTH(Data),0)";
            case DatabaseConfigInfo.DatabaseType.mysql, DatabaseConfigInfo.DatabaseType.mariadb -> "select IFNULL(length(UserUUID),0) + IFNULL(length(DataKey),0) + IFNULL(length(Data),0)";
            case DatabaseConfigInfo.DatabaseType.inetora -> "select nvl(vsize(UserUUID),0) + nvl(vsize(DataKey),0) + 12*1024";
            default -> throw new IllegalArgumentException("Cannot work with database type " + String.valueOf((Object)type));
        };
        sql = (String)sql + String.format(" rowlen from %s WHERE UserUUID = ?", TBLUSERBINARY);
        try (PreparedStatement pSt = connection.prepareStatement(((String)sql).toString());){
            pSt.setString(1, accountId.toString());
            try (ResultSet query = pSt.executeQuery();){
                while (query.next()) {
                    sum += query.getLong("rowlen");
                }
            }
        }
        return sum;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    private long sumTblUserDictionary(Connection connection, GUID accountId, DatabaseConfigInfo.DatabaseType type) throws SQLException {
        long sum = 0L;
        Object sql = switch (type) {
            case DatabaseConfigInfo.DatabaseType.inetdae7 -> "select ISNULL(DATALENGTH(UsrID),0) + ISNULL(DATALENGTH(SprID),0) + ISNULL(DATALENGTH(DictionaryEntries),0)";
            case DatabaseConfigInfo.DatabaseType.mysql, DatabaseConfigInfo.DatabaseType.mariadb -> "select IFNULL(length(UsrID),0) + IFNULL(length(SprID),0) + IFNULL(length(DictionaryEntries),0)";
            case DatabaseConfigInfo.DatabaseType.inetora -> "select nvl(vsize(UsrID),0) + nvl(vsize(SprID),0) + 50*1024";
            default -> throw new IllegalArgumentException("Cannot work with database type " + String.valueOf((Object)type));
        };
        sql = (String)sql + String.format(" rowlen from %s WHERE UsrID = ?", TBLUSERDICTIONARY);
        try (PreparedStatement pSt = connection.prepareStatement(((String)sql).toString());){
            pSt.setInt(1, HDUsersAndGroups.getUserID(accountId));
            try (ResultSet query = pSt.executeQuery();){
                while (query.next()) {
                    sum += query.getLong("rowlen");
                }
            }
        }
        return sum;
    }

    private long sumTblUser(Connection connection, GUID accountId, DatabaseConfigInfo.DatabaseType type) throws SQLException {
        String column;
        StringBuilder sql = new StringBuilder("select ");
        switch (type) {
            case inetdae7: {
                column = "ISNULL(DATALENGTH(%s),0)";
                sql.append(String.format(column, "Properties"));
                break;
            }
            case mysql: 
            case mariadb: {
                column = "IFNULL(length(%s),0)";
                sql.append(String.format(column, "Properties"));
                break;
            }
            case inetora: {
                column = "nvl(vsize(%s),0)";
                sql.append("10*1024");
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot work with database type " + String.valueOf((Object)type));
            }
        }
        for (String columnName : COLUMNS_FOR_PROFILE_SIZE) {
            sql.append(" + ");
            sql.append(String.format(column, columnName));
        }
        sql.append(" rowlen");
        sql.append(String.format(" from %s where UserUUID = ?", TBLUSER));
        try (PreparedStatement pSt = connection.prepareStatement(sql.toString());){
            pSt.setString(1, accountId.toString());
            try (ResultSet query = pSt.executeQuery();){
                if (query.next()) {
                    long l = query.getLong("rowlen");
                    return l;
                }
            }
        }
        return 0L;
    }

    public Iterator<Map.Entry<String, InputStream>> getBinaryDataIterator(GUID accountID) {
        this.conFactoryHolder.waitOnConnectionEstablished();
        String sql = String.format("SELECT DataKey, Data FROM %s WHERE UserUUID = ?", TBLUSERBINARY);
        HashMap<String, InputStream> binaryDataMap = new HashMap<String, InputStream>();
        try (Connection con = this.conFactoryHolder.getFactory().getConnection();
             PreparedStatement pstm = con.prepareStatement(sql);){
            pstm.setQueryTimeout(30);
            pstm.setString(1, accountID.toString());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    String key = rs.getString(1);
                    InputStream inputStream = rs.getBinaryStream(2);
                    binaryDataMap.put(key, inputStream);
                }
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
        return binaryDataMap.entrySet().iterator();
    }

    private static interface UserDataRowUpdater {
        public void updateRow(ResultSet var1) throws SQLException;
    }
}

