/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.shared.communication.UserGroupDataAccess;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ui.fields.user.HDUserFieldDefinition;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.SelectFieldValue;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UserClassUserFieldDefinition
extends SelectUserFieldDefinition<Integer>
implements HDUserFieldDefinition {
    public UserClassUserFieldDefinition(int prio) {
        super("user.masterdata", (UserField)HDUsersAndGroups.FIELD_CLASS_ID, prio);
    }

    public SelectOption getValue(UserAccount userAccount) {
        UserAccount currentUserAccount;
        Integer value = null;
        if (userAccount != null) {
            value = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
        }
        if ((Integer)HDUsersAndGroups.CONFIG_MANDANTEN.get() == 2 && !SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN, HdPermissions.DISPATCHER}) && (currentUserAccount = UserManager.getInstance().getCurrentUserAccount()) != null) {
            value = (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
        }
        if (value == null) {
            value = (Integer)HDUsersAndGroups.FIELD_CLASS_ID.getDefaultValue();
        }
        if (value == null) {
            value = 0;
        }
        Map supervisableGroups = HDUsersAndGroups.FIELD_CLASS_ID.getSearchTag().getMapData();
        String suffix = ((UserClassVO)UserClassManager.getInstance().get(value)).isDeleted() ? " (" + Tickets.MSG.getMsg("value.deleted", new Object[0]) + ")" : "";
        return new SelectOption(value.toString(), (String)supervisableGroups.get(value) + suffix);
    }

    public SelectOptionResult getOptions(UserAccount userAccount, String searchTerm, int currentSize, int chunkSize) {
        Map<Integer, String> supervisableGroups;
        UserGroupDataAccess userGroupDataAccess = (UserGroupDataAccess)ServerPluginManager.getInstance().getSingleInstance(UserGroupDataAccess.class);
        try {
            supervisableGroups = userGroupDataAccess.getAllDisplayNames(true);
        }
        catch (IOException e) {
            supervisableGroups = new HashMap<Integer, String>();
        }
        if ((Integer)HDUsersAndGroups.CONFIG_MANDANTEN.get() == 2 && !SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN, HdPermissions.DISPATCHER})) {
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            if (currentUserAccount == null) {
                supervisableGroups.clear();
            } else {
                HashSet<Integer> groupIDs = new HashSet<Integer>();
                Integer supervisorGroup = (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
                if (supervisorGroup != null) {
                    groupIDs.add(supervisorGroup);
                }
                List<UserClassVO> groupsWhereUserIsSupervisor = UserClassManager.getInstance().getTeamsWhereUserIsSupervisor(currentUserAccount.getID());
                groupIDs.addAll(groupsWhereUserIsSupervisor.stream().map(g -> g.getId()).collect(Collectors.toSet()));
                supervisableGroups.keySet().removeIf(key -> !groupIDs.contains(key));
            }
        }
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, supervisableGroups);
    }

    public Integer convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            try {
                return Integer.valueOf(option.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public SelectFieldValue getFieldValue(UserAccount userAccount) {
        SelectFieldValue result = super.getFieldValue(userAccount);
        boolean enabled = this.isEnabled();
        if (userAccount != null && (Integer)HDUsersAndGroups.CONFIG_MANDANTEN.get() == 2 && !SystemPermissionChecker.checkAccess((Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN, HdPermissions.DISPATCHER})) {
            enabled = false;
        }
        result.setEnabled(enabled);
        return result;
    }

    public boolean isBatchEditable() {
        return true;
    }
}

