/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.CustomFieldDefinitionEditInformations;
import com.inet.helpdesk.usersandgroups.ui.fields.user.HDUserFieldDefinition;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;

public class OpenTextQueryUserFieldDefinition
extends SelectUserFieldDefinition<String>
implements HDUserFieldDefinition {
    private final UserField<String> userField;

    public OpenTextQueryUserFieldDefinition(String groupKey, UserField<String> userField, int prio) {
        super(groupKey, userField, prio);
        this.userField = userField;
    }

    public SelectOption getValue(UserAccount userAccount) {
        String value = null;
        if (userAccount != null) {
            value = (String)userAccount.getValue(this.userField);
        }
        if (value == null) {
            value = (String)this.userField.getDefaultValue();
        }
        return new SelectOption(value, value);
    }

    public SelectOptionResult getOptions(UserAccount userAccount, String searchTerm, int currentSize, int chunkSize) {
        ArrayList<SelectOption> list = new ArrayList<SelectOption>();
        SelectOptionResult data = CustomFieldDefinitionEditInformations.getData(UserManager.getInstance().getCurrentUserAccount(), this.userField, true);
        if (data != null) {
            List allOptions = data.getOptions();
            for (SelectOption option : allOptions) {
                String label = option.getLabel();
                if (label == null) {
                    label = "";
                }
                if (searchTerm != null && !label.toLowerCase().contains(searchTerm.toLowerCase())) continue;
                list.add(option);
            }
        }
        if (list.size() < currentSize) {
            return new SelectOptionResult(0, new ArrayList());
        }
        List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
        return new SelectOptionResult(list.size(), subList);
    }

    public String convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            return option.getValue();
        }
        return "";
    }

    public boolean allowsCustomValue() {
        FreifeldSetting editInformation = CustomFieldDefinitionEditInformations.getEditInformation(UserManager.getInstance().getCurrentUserAccount(), this.userField);
        return editInformation != null && editInformation.getFreifeldType() == FreifeldType.Editable;
    }

    public boolean allowsMultipleValues() {
        FreifeldSetting editInformation = CustomFieldDefinitionEditInformations.getEditInformation(UserManager.getInstance().getCurrentUserAccount(), this.userField);
        return editInformation != null && editInformation.getFreifeldType() == FreifeldType.Multi;
    }

    public boolean isBatchEditable() {
        return true;
    }
}

