/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.helpdesk.usersandgroups.ui.fields.user.HDUserFieldDefinition;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.CurrencyUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.CurrencyFieldValue;
import com.inet.usersandgroups.api.user.UserAccount;

public class LumpSumUserFieldDefinition
extends CurrencyUserFieldDefinition
implements HDUserFieldDefinition {
    public LumpSumUserFieldDefinition(String groupKey, UserField<Double> field, int prio) {
        super(groupKey, field, prio);
    }

    public boolean isBatchEditable() {
        return true;
    }

    public Double convertFromString(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NullPointerException | NumberFormatException nfe) {
            return 0.0;
        }
    }

    public CurrencyFieldValue getFieldValue(UserAccount userAccount) {
        CurrencyFieldValue fieldValue = super.getFieldValue(userAccount);
        String val = fieldValue.getValue();
        if (val != null) {
            try {
                if (Double.valueOf(val) <= 0.0) {
                    fieldValue.setVisibleInPreview(false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return fieldValue;
    }
}

