/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups.persistence;

import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.usersandgroups.ConnectionFactoryHolder;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.ResultSetBasedIterator;
import com.inet.helpdesk.usersandgroups.groups.persistence.HelpDeskUserGroupDetails;
import com.inet.helpdesk.usersandgroups.groups.persistence.ResourceData;
import com.inet.helpdesk.usersandgroups.groups.persistence.ResourcePersistence;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociationMap;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupMembership;
import com.inet.usersandgroups.api.groups.persistence.UserGroupPersistence;
import com.inet.usersandgroups.api.groups.persistence.UserGroupPersistenceUtils;
import com.inet.usersandgroups.api.user.UserAccount;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;

public class HelpDeskUserGroupPersistence
implements UserGroupPersistence {
    public static final int NAME_LENGTH_LIMIT = 100;
    private static String TBLGROUP = "tblGroup";
    private static String TBLGROUPMEMBERSHIPS = "tblGroupMemberships";
    private final ResourcePersistence resourcePersistence = new ResourcePersistence();
    private Map<String, GroupTypeDef> groupTypes;
    private final ConnectionFactoryHolder conFactoryHolder = new ConnectionFactoryHolder();

    public void connectionCreated(ConnectionFactory connectionFactory) {
        this.conFactoryHolder.setConnectionFactory(connectionFactory);
    }

    public void init(Set<GroupTypeDef> groupTypes) {
        if (groupTypes == null) {
            throw new IllegalArgumentException("group types must not be null");
        }
        if (groupTypes.isEmpty()) {
            throw new IllegalArgumentException("there must be at least one group type");
        }
        if (this.groupTypes != null) {
            throw new IllegalStateException("persistence is already initialized");
        }
        this.groupTypes = new HashMap<String, GroupTypeDef>();
        for (GroupTypeDef type : groupTypes) {
            this.groupTypes.put(type.getGroupType().getName(), type);
        }
    }

    public UserGroupInfo saveNew(@Nonnull GUID groupID, @Nullable GUID parentID, String groupName, GroupType groupType, long lastModified, MutableUserGroupData groupData) {
        this.conFactoryHolder.throwIfNoConnection();
        GroupTypeDef typeDef = this.groupTypes.get(groupType.getName());
        if (typeDef == null) {
            throw new IllegalArgumentException("unsupported group type: " + groupType.getName());
        }
        boolean isResource = this.isResource(typeDef);
        this.throwIfGroupNameLenghtExceedsLengthLimit(groupName, isResource);
        if (isResource) {
            MutableUserGroupData baseGroupData = groupData.copyWithSpecifiedFieldsOnly(HDUsersAndGroups.getResourceGroupFieldsWithValuesInTblRessourcen(), true);
            MutableUserGroupData additionalGroupData = groupData.copyWithSpecifiedFieldsOnly(this.getFieldsForResourceGroupsToStoreAsDetails(), true);
            String jsonizedDetails = HelpDeskUserGroupDetails.toJsonizedDetails(additionalGroupData, Collections.emptySet());
            Function<String, String> createErrorMsg = cause -> String.format("group with name \"%s\" and type \"%s\" can not be created because %s", groupName, typeDef.getDisplayName(), cause);
            try {
                DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                    Integer resID;
                    boolean isSubRes;
                    Integer parentResID = (Integer)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_PARENT_ID);
                    boolean bl = isSubRes = parentResID != null && !parentResID.equals(HDUsersAndGroups.RES_FIELD_PARENT_ID.getDefaultValue());
                    if (isSubRes) {
                        if (parentID == null) {
                            String msg = String.format("ID of parent group must not be missing, in case of groups that represent sub-resources (specified parentResourceID is \"%d\")", (int)parentResID);
                            throw new IllegalArgumentException((String)createErrorMsg.apply(msg));
                        }
                        Integer resIdFromParentGroup = this.findResourceByGroupIdOrThrow(connection, parentID);
                        if (!parentResID.equals(resIdFromParentGroup)) {
                            String msg = String.format("specified parentResourceID \"%d\" does not match ID \"%d\" of resource which is represented by specified parent group with ID \"%s\"", parentResID, (int)resIdFromParentGroup, parentID);
                            throw new IllegalArgumentException((String)createErrorMsg.apply(msg));
                        }
                    }
                    if ((resID = (Integer)groupData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_ID)) == null) {
                        if (parentID != null && !isSubRes) {
                            String msg = String.format("ID of parent resource must not be missing if parent group is specified (parentGroupID is \"%s\")", parentID);
                            throw new IllegalArgumentException((String)createErrorMsg.apply(msg));
                        }
                        this.insertIntoTblGroup(connection, groupID, parentID, groupName, groupType.getName(), lastModified, true, jsonizedDetails);
                        this.resourcePersistence.insertIntoTblRessourcen(connection, groupID, groupName, baseGroupData);
                        return null;
                    }
                    String resourceName = this.resourcePersistence.loadNameOfResourceWithoutAssociatedGroupOrElseThrow(connection, resID);
                    this.insertIntoTblGroup(connection, groupID, parentID, resourceName, groupType.getName(), lastModified, true, jsonizedDetails);
                    this.resourcePersistence.updateGroupID(connection, resID, groupID);
                    return null;
                });
            }
            catch (JsonException | SQLException ex) {
                throw new PersistenceException(ex);
            }
            this.reloadResourceCacheAndUpdateSwingClients();
            return this.load(groupID);
        }
        String jsonizedDetails = HelpDeskUserGroupDetails.toJsonizedDetails(groupData, Collections.emptySet());
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                this.insertIntoTblGroup(connection, groupID, parentID, groupName, groupType.getName(), lastModified, true, jsonizedDetails);
                return null;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        return this.load(groupID);
    }

    private List<UserGroupField<Object>> getFieldsForResourceGroupsToStoreAsDetails() {
        ArrayList<UserGroupField<Object>> additionaFields = new ArrayList<UserGroupField<Object>>(FieldAndGroupTypeAssociationMap.getFieldsFor((GroupType)HDUsersAndGroups.RESOURCE));
        additionaFields.removeAll(HDUsersAndGroups.getResourceGroupFieldsWithValuesInTblRessourcen());
        return additionaFields;
    }

    private GUID insertIntoTblGroup(Connection connection, @Nonnull GUID groupID, @Nullable GUID parentID, String groupName, String groupType, long lastModified, boolean active, String jsonizedDetails) throws SQLException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonizedDetails.getBytes(StandardCharsets.UTF_8));
        String sql = String.format("SELECT GroupUUID, ParentUUID, GroupName, GroupType, LastModified, Active FROM %s WHERE 1 = 0", TBLGROUP);
        try (Statement stm = connection.createStatement(1005, 1008);
             ResultSet rs = stm.executeQuery(sql);){
            rs.moveToInsertRow();
            rs.updateString("GroupUUID", groupID.toString());
            if (parentID != null) {
                rs.updateString("ParentUUID", parentID.toString());
            }
            rs.updateString("GroupName", groupName);
            rs.updateString("GroupType", groupType);
            rs.updateTimestamp("LastModified", new Timestamp(lastModified));
            rs.updateBoolean("Active", active);
            rs.insertRow();
        }
        String updateSql = String.format("UPDATE %s SET Details = ? WHERE GroupUUID = ?", TBLGROUP);
        try (PreparedStatement pstm = connection.prepareStatement(updateSql);){
            pstm.setBinaryStream(1, inputStream);
            pstm.setString(2, groupID.toString());
            pstm.executeUpdate();
        }
        return groupID;
    }

    public UserGroupInfo setGroupName(GUID groupID, String newGroupName, long lastModified) {
        boolean renamedResource;
        this.conFactoryHolder.throwIfNoConnection();
        try {
            renamedResource = DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                String groupType = this.loadGroupType(connection, groupID);
                GroupTypeDef groupTypeDef = this.getGroupTypeOrThrowIfUnsupported(groupID, groupType);
                boolean isResource = this.isResource(groupTypeDef);
                this.throwIfGroupNameLenghtExceedsLengthLimit(newGroupName, isResource);
                if (isResource) {
                    this.resourcePersistence.updateResourceName(connection, groupID, newGroupName);
                }
                this.updateTblGroup(connection, groupID, lastModified, rs -> rs.updateString("GroupName", newGroupName));
                return isResource;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        if (renamedResource) {
            this.reloadResourceCacheAndUpdateSwingClients();
        }
        return this.load(groupID);
    }

    public UserGroupInfo updateGroupData(GUID groupID, long lastModified, MutableUserGroupData groupData) {
        boolean updatedResourceData;
        this.conFactoryHolder.throwIfNoConnection();
        if (groupData.containsField((UserGroupField)HDUsersAndGroups.RES_FIELD_ID)) {
            String msg = String.format("data of the group with ID %s can not be updated: ID of associated resource can be defined only during creation of the group", groupID);
            throw new IllegalArgumentException(msg);
        }
        if (groupData.containsField((UserGroupField)HDUsersAndGroups.RES_FIELD_PARENT_ID)) {
            String msg = String.format("data of the group with ID %s can not be updated: ID of associated parent-resource can be redefined only using dedicated method, i.e. setParentGroup", groupID);
            throw new IllegalArgumentException(msg);
        }
        try {
            updatedResourceData = DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                String groupType = this.loadGroupType(connection, groupID);
                GroupTypeDef groupTypeDef = this.getGroupTypeOrThrowIfUnsupported(groupID, groupType);
                boolean foundDifferences = false;
                MutableUserGroupData newGroupDataForDetails = groupData;
                if (this.isResource(groupTypeDef)) {
                    MutableUserGroupData newDataForTblResource = newGroupDataForDetails.copyWithSpecifiedFieldsOnly(HDUsersAndGroups.getResourceGroupFieldsWithValuesInTblRessourcen(), false);
                    newGroupDataForDetails = newGroupDataForDetails.copyWithSpecifiedFieldsOnly(this.getFieldsForResourceGroupsToStoreAsDetails(), false);
                    ResourceData resourceData = this.resourcePersistence.loadResourceData(connection, groupID);
                    MutableUserGroupData dataToUpdate = resourceData.getData();
                    for (UserGroupField field : newDataForTblResource.getIncludedFields()) {
                        Object newValue;
                        Object oldValue = dataToUpdate.get(field);
                        if (Objects.equals(oldValue, newValue = newDataForTblResource.get(field))) continue;
                        dataToUpdate.put(field, newValue);
                        foundDifferences = true;
                    }
                    if (foundDifferences) {
                        this.resourcePersistence.updateResourceData(connection, groupID, dataToUpdate);
                        this.updateTblGroup(connection, groupID, lastModified, rs -> {});
                    }
                }
                HelpDeskUserGroupDetails details = this.loadDetailsOrThrow(connection, groupID);
                HashMap<String, String> jsonizedGroupData = new HashMap<String, String>();
                for (UserGroupField field : newGroupDataForDetails.getIncludedFields()) {
                    Object value = newGroupDataForDetails.get(field);
                    String jsonData = new Json().toJson(value);
                    jsonizedGroupData.put(field.getKey(), jsonData);
                }
                if (UserGroupPersistenceUtils.hasDifferencesBetweenValues(details.getFields(), jsonizedGroupData)) {
                    String jsonizedDetails;
                    HashMap<String, String> updatedFields = new HashMap<String, String>(details.getFields());
                    updatedFields.putAll(jsonizedGroupData);
                    try {
                        HelpDeskUserGroupDetails updatedDetails = new HelpDeskUserGroupDetails(updatedFields, details.getPermissions());
                        jsonizedDetails = new Json().toJson((Object)updatedDetails);
                    }
                    catch (JsonException ex) {
                        throw new PersistenceException((Throwable)ex);
                    }
                    this.updateDetails(connection, groupID, lastModified, jsonizedDetails);
                }
                return foundDifferences;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        if (updatedResourceData) {
            this.reloadResourceCacheAndUpdateSwingClients();
        }
        return this.load(groupID);
    }

    private HelpDeskUserGroupDetails loadDetailsOrThrow(Connection connection, GUID groupID) throws SQLException {
        String sql = String.format("SELECT Details FROM %s WHERE GroupUUID = ?", TBLGROUP);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            HelpDeskUserGroupDetails helpDeskUserGroupDetails;
            block13: {
                pstm.setString(1, groupID.toString());
                ResultSet rs = pstm.executeQuery();
                try {
                    if (!rs.next()) {
                        this.throwThatGroupDoesNotExist(groupID);
                    }
                    InputStream inputStream = rs.getBinaryStream(1);
                    helpDeskUserGroupDetails = this.readDetailsFrom(inputStream);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return helpDeskUserGroupDetails;
        }
    }

    public UserGroupInfo updateMembers(GUID groupID, long lastModified, Map<GUID, Set<MembershipType>> membersToAdd, Map<GUID, Set<MembershipType>> membersToRemove) {
        boolean updatedResourceMembers;
        this.conFactoryHolder.throwIfNoConnection();
        try {
            updatedResourceMembers = DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                String groupType = this.loadGroupType(connection, groupID);
                GroupTypeDef groupTypeDef = this.getGroupTypeOrThrowIfUnsupported(groupID, groupType);
                MemberToTypeCardinality cardinality = groupTypeDef.getMemberToTypeCardinality();
                boolean isResource = this.isResource(groupTypeDef);
                if (isResource) {
                    int resID = this.findResourceByGroupIdOrThrow(connection, groupID);
                    Map<GUID, Set<String>> membersMap = this.resourcePersistence.loadMembersMap(connection, resID);
                    UserGroupPersistenceUtils.updateMembersMapAndThrowIfInvalid((GUID)groupID, membersMap, (Map)membersToAdd, (Map)membersToRemove, (MemberToTypeCardinality)cardinality);
                    Map<GUID, Boolean> membershipData = ResourcePersistence.convertToResourceMembershipMap(membersMap);
                    this.resourcePersistence.updateMembershipData(connection, resID, membershipData);
                } else {
                    Map<GUID, Set<String>> membersMap = this.loadMembersMap(connection, groupID);
                    UserGroupPersistenceUtils.updateMembersMapAndThrowIfInvalid((GUID)groupID, membersMap, (Map)membersToAdd, (Map)membersToRemove, (MemberToTypeCardinality)cardinality);
                    this.updateMembershipData(connection, groupID, membersMap);
                }
                this.updateTblGroup(connection, groupID, lastModified, rs -> {});
                return isResource;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        if (updatedResourceMembers) {
            this.reloadResourceCacheAndUpdateSwingClients();
        }
        return this.load(groupID);
    }

    private String loadGroupType(Connection connection, GUID groupID) throws SQLException {
        String sqlSelect = String.format("SELECT GroupType FROM %s WHERE GroupUUID = ?", TBLGROUP);
        try (PreparedStatement pstm = connection.prepareStatement(sqlSelect);){
            String string;
            block13: {
                pstm.setString(1, groupID.toString());
                ResultSet rs = pstm.executeQuery();
                try {
                    if (!rs.next()) {
                        this.throwThatGroupDoesNotExist(groupID);
                    }
                    string = rs.getString(1);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return string;
        }
    }

    private Map<GUID, Set<String>> loadMembersMap(Connection connection, GUID groupID) throws SQLException {
        HashMap<GUID, Set<String>> membersMap = new HashMap<GUID, Set<String>>();
        String sql = String.format("SELECT UserUUID, MembershipType FROM %s WHERE GroupUUID = ?", TBLGROUPMEMBERSHIPS);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setString(1, groupID.toString());
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    GUID userUUID;
                    try {
                        userUUID = GUID.valueOf((String)rs.getString(1));
                    }
                    catch (IllegalArgumentException ex) {
                        UsersAndGroups.LOGGER.error((Object)String.format("Account ID of the group member is invalid. Group ID = \"%s\".", groupID));
                        UsersAndGroups.LOGGER.error((Throwable)ex);
                        continue;
                    }
                    String membershipType = rs.getString(2);
                    if (!membersMap.containsKey(userUUID)) {
                        membersMap.put(userUUID, new HashSet());
                    }
                    if (membershipType.trim().isEmpty()) continue;
                    ((Set)membersMap.get(userUUID)).add(membershipType);
                }
            }
        }
        return membersMap;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="the values are internal object and not set by the user")
    private void updateMembershipData(Connection connection, GUID groupID, Map<GUID, Set<String>> updatedMembersMap) throws SQLException {
        String sqlDelete = String.format("DELETE FROM %s WHERE GroupUUID = ?", TBLGROUPMEMBERSHIPS);
        try (PreparedStatement pstm = connection.prepareStatement(sqlDelete);){
            pstm.setString(1, groupID.toString());
            pstm.executeUpdate();
        }
        String sqlInsert = String.format("INSERT INTO %s (GroupUUID, UserUUID, MembershipType) VALUES (?, ?, ?)", TBLGROUPMEMBERSHIPS);
        try (PreparedStatement pstm = connection.prepareStatement(sqlInsert);){
            for (GUID memberID : updatedMembersMap.keySet()) {
                pstm.setString(1, groupID.toString());
                pstm.setString(2, memberID.toString());
                Set<String> membershipTypes = updatedMembersMap.get(memberID);
                if (membershipTypes.isEmpty()) {
                    pstm.setString(3, " ");
                    pstm.executeUpdate();
                    continue;
                }
                for (String type : membershipTypes) {
                    pstm.setString(3, type);
                    pstm.executeUpdate();
                }
            }
        }
    }

    private void updateTblGroup(Connection connection, GUID groupID, long lastModified, GroupDataRowUpdater updater) throws SQLException {
        String sql = String.format("SELECT * FROM %s WHERE GroupUUID = ?", TBLGROUP);
        try (PreparedStatement stm = connection.prepareStatement(sql, 1005, 1008);){
            stm.setString(1, groupID.toString());
            try (ResultSet rs = stm.executeQuery();){
                if (!rs.next()) {
                    this.throwThatGroupDoesNotExist(groupID);
                }
                rs.updateTimestamp("LastModified", new Timestamp(lastModified));
                updater.updateRow(rs);
                rs.updateRow();
            }
        }
    }

    private void updateDetails(Connection connection, GUID groupID, long lastModified, String jsonizedDetails) throws SQLException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonizedDetails.getBytes(StandardCharsets.UTF_8));
        String sql = String.format("UPDATE %s SET LastModified = ?, Details = ? WHERE GroupUUID = ?", TBLGROUP);
        try (PreparedStatement pstm = connection.prepareStatement(sql);){
            pstm.setTimestamp(1, new Timestamp(lastModified));
            pstm.setBinaryStream(2, inputStream);
            pstm.setString(3, groupID.toString());
            pstm.executeUpdate();
        }
    }

    public UserGroupInfo updatePermissions(GUID groupID, long lastModified, Set<String> permissionsToAdd, Set<String> permissionsToRemove) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                HelpDeskUserGroupDetails details = this.loadDetailsOrThrow(connection, groupID);
                HashSet<String> updatedPermissions = new HashSet<String>(details.getPermissions());
                updatedPermissions.addAll(permissionsToAdd);
                updatedPermissions.removeAll(permissionsToRemove);
                HelpDeskUserGroupDetails updatedDetails = new HelpDeskUserGroupDetails(details.getFields(), updatedPermissions);
                String jsonizedDetails = new Json().toJson((Object)updatedDetails);
                this.updateDetails(connection, groupID, lastModified, jsonizedDetails);
                return null;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        return this.load(groupID);
    }

    public UserGroupInfo setParentGroup(GUID groupID, GUID parentID, long lastModified) {
        this.conFactoryHolder.throwIfNoConnection();
        boolean updatedResource = false;
        try {
            updatedResource = DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                String groupType = this.loadGroupType(connection, groupID);
                GroupTypeDef groupTypeDef = this.getGroupTypeOrThrowIfUnsupported(groupID, groupType);
                boolean isResource = this.isResource(groupTypeDef);
                if (isResource) {
                    int resID = this.findResourceByGroupIdOrThrow(connection, groupID);
                    int parentResID = 0;
                    if (parentID != null) {
                        parentResID = this.findResourceByGroupIdOrThrow(connection, parentID);
                    }
                    this.resourcePersistence.setParentResourceID(connection, resID, parentResID);
                }
                this.updateTblGroup(connection, groupID, lastModified, rs -> {
                    if (parentID == null) {
                        rs.updateNull("ParentUUID");
                    } else {
                        rs.updateString("ParentUUID", parentID.toString());
                    }
                });
                return isResource;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        if (updatedResource) {
            this.reloadResourceCacheAndUpdateSwingClients();
        }
        return this.load(groupID);
    }

    public void delete(GUID groupID) {
        boolean deactivatedResource;
        this.conFactoryHolder.throwIfNoConnection();
        try {
            deactivatedResource = DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                String groupType = this.loadGroupType(connection, groupID);
                GroupTypeDef groupTypeDef = this.getGroupTypeOrThrowIfUnsupported(groupID, groupType);
                boolean isResource = this.isResource(groupTypeDef);
                if (isResource) {
                    throw new IllegalArgumentException("Groups representing resources can not be deleted. GroupID = \"" + groupID.toString() + "\".");
                }
                String sql = String.format("DELETE FROM %s WHERE GroupUUID = ?", TBLGROUP);
                try (PreparedStatement pstm = connection.prepareStatement(sql);){
                    pstm.setString(1, groupID.toString());
                    pstm.executeUpdate();
                }
                return isResource;
            });
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        if (deactivatedResource) {
            this.reloadResourceCacheAndUpdateSwingClients();
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQl query is fixed")
    public void deleteAll() {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                this.resourcePersistence.deleteAllResourcesWithMembershipData(connection);
                try (Statement stm = connection.createStatement();){
                    stm.executeUpdate("DELETE FROM " + TBLGROUP);
                }
                return null;
            });
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        this.reloadResourceCacheAndUpdateSwingClients();
    }

    public UserGroupInfo deactivate(GUID groupID, boolean removeMembershipData, long lastModified) {
        boolean deactivatedResource;
        this.conFactoryHolder.throwIfNoConnection();
        try {
            deactivatedResource = DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                String groupType = this.loadGroupType(connection, groupID);
                GroupTypeDef groupTypeDef = this.getGroupTypeOrThrowIfUnsupported(groupID, groupType);
                boolean isResource = this.isResource(groupTypeDef);
                if (isResource) {
                    this.resourcePersistence.deactivateResource(connection, groupID, removeMembershipData);
                } else if (removeMembershipData) {
                    this.updateMembershipData(connection, groupID, new HashMap<GUID, Set<String>>());
                }
                this.updateTblGroup(connection, groupID, lastModified, rs -> rs.updateBoolean("Active", false));
                return isResource;
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
        if (deactivatedResource) {
            this.reloadResourceCacheAndUpdateSwingClients();
        }
        return this.load(groupID);
    }

    public UserGroupInfo load(GUID groupID) {
        this.conFactoryHolder.throwIfNoConnection();
        try {
            return DatabaseTransactionUtils.executeAsTransaction(this.conFactoryHolder.getFactory(), connection -> {
                String sqlSelect = String.format("SELECT * FROM %s WHERE GroupUUID = ?", TBLGROUP);
                try (PreparedStatement pstm = connection.prepareStatement(sqlSelect);){
                    UserGroupInfo userGroupInfo;
                    block19: {
                        ResultSet rs;
                        block17: {
                            UserGroupInfo userGroupInfo2;
                            block18: {
                                pstm.setString(1, groupID.toString());
                                rs = pstm.executeQuery();
                                try {
                                    if (rs.next()) break block17;
                                    userGroupInfo2 = null;
                                    if (rs == null) break block18;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return userGroupInfo2;
                        }
                        GUID parentGroupUUID = null;
                        String parentGroupID = rs.getString("ParentUUID");
                        if (parentGroupID != null) {
                            try {
                                parentGroupUUID = GUID.valueOf((String)parentGroupID);
                            }
                            catch (IllegalArgumentException ex) {
                                UsersAndGroups.LOGGER.error((Object)String.format("ParentGroupID of the group with ID \"%s\" is invalid. It will be ignored.", groupID));
                                UsersAndGroups.LOGGER.error((Throwable)ex);
                            }
                        }
                        String groupName = rs.getString("GroupName");
                        String groupType = rs.getString("GroupType");
                        GroupTypeDef groupTypeDef = this.getGroupTypeOrThrowIfUnsupported(groupID, groupType);
                        long lastModified = rs.getTimestamp("LastModified").getTime();
                        boolean active = rs.getBoolean("Active");
                        InputStream inputStream = rs.getBinaryStream("Details");
                        HelpDeskUserGroupDetails details = this.readDetailsFrom(inputStream);
                        userGroupInfo = this.loadRemainingData(connection, parentGroupUUID, groupID, groupName, groupTypeDef, lastModified, active, details);
                        if (rs == null) break block19;
                        rs.close();
                    }
                    return userGroupInfo;
                }
            });
        }
        catch (JsonException | SQLException ex) {
            throw new PersistenceException(ex);
        }
    }

    private UserGroupInfo loadRemainingData(Connection connection, @Nullable GUID parentID, GUID groupID, String groupName, GroupTypeDef groupTypeDef, long lastModified, boolean active, HelpDeskUserGroupDetails details) throws SQLException {
        if (this.isResource(groupTypeDef)) {
            int resID = this.findResourceByGroupIdOrThrow(connection, groupID);
            Map<GUID, Set<String>> membersMap = this.resourcePersistence.loadMembersMap(connection, resID);
            UserGroupMembership membership = UserGroupPersistenceUtils.convertToUserGroupMembershipOrThrowIfInvalid((GUID)groupID, (GroupTypeDef)groupTypeDef, membersMap);
            ResourceData resourceData = this.resourcePersistence.loadResourceData(connection, groupID);
            MutableUserGroupData groupData = UserGroupPersistenceUtils.convertToMutableUserGroupData((GUID)groupID, this.getFieldsForResourceGroupsToStoreAsDetails(), details.getFields());
            MutableUserGroupData resourceDataFields = resourceData.getData();
            resourceDataFields.getIncludedFields().forEach(fieldFromResource -> groupData.put(fieldFromResource, resourceDataFields.get(fieldFromResource)));
            Set permissions = UserGroupPersistenceUtils.convertKeysToPermissions(details.getPermissions());
            return UserGroupInfo.create((GUID)parentID, (GUID)groupID, (String)resourceData.getName(), (GroupType)groupTypeDef.getGroupType(), (long)lastModified, (UserGroupMembership)membership, (MutableUserGroupData)groupData, (Set)permissions, (boolean)active);
        }
        Map<GUID, Set<String>> membersMap = this.loadMembersMap(connection, groupID);
        UserGroupMembership membership = UserGroupPersistenceUtils.convertToUserGroupMembershipOrThrowIfInvalid((GUID)groupID, (GroupTypeDef)groupTypeDef, membersMap);
        List fieldsToInclude = FieldAndGroupTypeAssociationMap.getFieldsFor((GroupType)groupTypeDef.getGroupType());
        MutableUserGroupData groupData = UserGroupPersistenceUtils.convertToMutableUserGroupData((GUID)groupID, (List)fieldsToInclude, details.getFields());
        Set permissions = UserGroupPersistenceUtils.convertKeysToPermissions(details.getPermissions());
        return UserGroupInfo.create((GUID)parentID, (GUID)groupID, (String)groupName, (GroupType)groupTypeDef.getGroupType(), (long)lastModified, (UserGroupMembership)membership, (MutableUserGroupData)groupData, (Set)permissions, (boolean)active);
    }

    private HelpDeskUserGroupDetails readDetailsFrom(InputStream inputStream) {
        if (inputStream == null) {
            return new HelpDeskUserGroupDetails(new HashMap<String, String>(), new HashSet<String>());
        }
        try {
            return (HelpDeskUserGroupDetails)new Json().fromJson(inputStream, HelpDeskUserGroupDetails.class, new HashMap(), null);
        }
        catch (JsonException | IOException ex) {
            throw new PersistenceException(ex);
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is fixed")
    public Iterator<UserGroupInfo> getUserGroupInfoIterator() {
        this.conFactoryHolder.waitOnConnectionEstablished();
        try {
            Connection connection = this.conFactoryHolder.getFactory().getConnection();
            Statement stm = connection.createStatement();
            stm.setFetchSize(1000);
            String sql = "SELECT * FROM " + TBLGROUP;
            ResultSet rs = stm.executeQuery(sql);
            Function<ResultSet, UserGroupInfo> readFromRS = resultSet -> {
                try {
                    while (rs.next()) {
                        String groupType = rs.getString("GroupType");
                        GroupTypeDef groupTypeDef = this.groupTypes.get(groupType);
                        if (groupTypeDef == null) continue;
                        GUID groupUUID = null;
                        try {
                            groupUUID = GUID.valueOf((String)rs.getString("GroupUUID"));
                        }
                        catch (IllegalArgumentException ex) {
                            UsersAndGroups.LOGGER.error((Object)"Found user group with invalid ID:");
                            UsersAndGroups.LOGGER.error((Throwable)ex);
                            continue;
                        }
                        GUID parentGroupUUID = null;
                        String parentGroupID = rs.getString("ParentUUID");
                        if (parentGroupID != null) {
                            try {
                                parentGroupUUID = GUID.valueOf((String)parentGroupID);
                            }
                            catch (IllegalArgumentException ex) {
                                UsersAndGroups.LOGGER.error((Object)String.format("ParentGroupID of the group with ID \"%s\" is invalid. It will be ignored.", groupUUID));
                                UsersAndGroups.LOGGER.error((Throwable)ex);
                            }
                        }
                        String groupName = rs.getString("GroupName");
                        long lastModified = rs.getTimestamp("LastModified").getTime();
                        boolean active = rs.getBoolean("Active");
                        InputStream inputStream = rs.getBinaryStream("Details");
                        try {
                            HelpDeskUserGroupDetails details = this.readDetailsFrom(inputStream);
                            return this.loadRemainingData(connection, parentGroupUUID, groupUUID, groupName, groupTypeDef, lastModified, active, details);
                        }
                        catch (Exception ex) {
                            UsersAndGroups.LOGGER.error((Object)String.format("Could not read data of group with ID \"%s\".", groupUUID));
                            UsersAndGroups.LOGGER.error((Throwable)ex);
                        }
                    }
                    return null;
                }
                catch (JsonException | SQLException ex) {
                    throw new PersistenceException(ex);
                }
            };
            Runnable execOnFinish = () -> {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    stm.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            };
            return new ResultSetBasedIterator<UserGroupInfo>(rs, readFromRS, execOnFinish);
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public void moveTicketsFromResourceAndItsSubResources(int ticketSourceResource, int ticketTargetResource, UserAccount responsibleUser) throws SQLException {
        this.conFactoryHolder.throwIfNoConnection();
        ArrayList<Integer> resAndSubResIDs = new ArrayList<Integer>();
        try (Connection con = this.conFactoryHolder.getFactory().getConnection();
             PreparedStatement pstm = con.prepareStatement("SELECT ResID FROM tblRessourcen WHERE ResID = ? OR ParentRes = ?");){
            pstm.setInt(1, ticketSourceResource);
            pstm.setInt(2, ticketSourceResource);
            try (ResultSet rs = pstm.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt(1);
                    resAndSubResIDs.add(id);
                }
            }
        }
        TicketManager.getMaintenance().moveAllTicketsFromDeletedResources(resAndSubResIDs, ticketTargetResource);
    }

    public int findResourceByGroupIdOrThrow(GUID groupID) {
        int n;
        block8: {
            this.conFactoryHolder.throwIfNoConnection();
            Connection connection = this.conFactoryHolder.getFactory().getConnection();
            try {
                n = this.findResourceByGroupIdOrThrow(connection, groupID);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new PersistenceException((Throwable)ex);
                }
            }
            connection.close();
        }
        return n;
    }

    private int findResourceByGroupIdOrThrow(Connection connection, GUID groupID) throws SQLException {
        return this.resourcePersistence.findResourceByGroupId(connection, groupID).orElseThrow(() -> new IllegalArgumentException("there is no resource matching group with ID " + String.valueOf(groupID)));
    }

    private boolean isResource(GroupTypeDef groupTypeDef) {
        return HDUsersAndGroups.RESOURCE.equals((Object)groupTypeDef.getGroupType());
    }

    private GroupTypeDef getGroupTypeOrThrowIfUnsupported(GUID groupID, String groupType) {
        GroupTypeDef typeDef = this.groupTypes.get(groupType);
        if (typeDef == null) {
            throw new IllegalArgumentException(String.format("group with ID %s has unsupported type: %s", groupID, groupType));
        }
        return typeDef;
    }

    private void throwIfGroupNameLenghtExceedsLengthLimit(String groupName, boolean isResource) {
        if (groupName != null && groupName.length() > 100) {
            String msg = String.format("length of the %s name must not exceed limit of %d characters: %s", isResource ? "resource" : "group", 100, groupName);
            throw new IllegalArgumentException(msg);
        }
    }

    private void throwThatGroupDoesNotExist(GUID groupID) {
        throw new PersistenceException(UsersAndGroups.MSG.getMsg("error.groupDoesNotExist", new Object[]{groupID}));
    }

    private void reloadResourceCacheAndUpdateSwingClients() {
        try {
            ServerUtilities.conti.noticeClientChanges(64);
            ServerUtilities.conti.noticeClientChanges(4096);
        }
        catch (Throwable t) {
            UsersAndGroups.LOGGER.error(t);
        }
    }

    private static interface GroupDataRowUpdater {
        public void updateRow(ResultSet var1) throws SQLException;
    }
}

