/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.config.ConfigValue;
import com.inet.field.Field;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.groups.IHelpDeskUserGroupManager;
import com.inet.helpdesk.usersandgroups.groups.fields.GroupFieldAllowedActions;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldEmail;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldEscalationResourceID;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldHourlyRate;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldID;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldNotificationSettings;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldParentID;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldSettings;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.helpdesk.usersandgroups.user.fields.FieldAllowedActions;
import com.inet.helpdesk.usersandgroups.user.fields.FieldClientDetails;
import com.inet.helpdesk.usersandgroups.user.fields.FieldComputerName;
import com.inet.helpdesk.usersandgroups.user.fields.FieldCostCentre;
import com.inet.helpdesk.usersandgroups.user.fields.FieldCustomUserField;
import com.inet.helpdesk.usersandgroups.user.fields.FieldDepartment;
import com.inet.helpdesk.usersandgroups.user.fields.FieldImportName;
import com.inet.helpdesk.usersandgroups.user.fields.FieldLanguage;
import com.inet.helpdesk.usersandgroups.user.fields.FieldLocationID;
import com.inet.helpdesk.usersandgroups.user.fields.FieldLumpSum;
import com.inet.helpdesk.usersandgroups.user.fields.FieldRoom;
import com.inet.helpdesk.usersandgroups.user.fields.FieldUserClassID;
import com.inet.helpdesk.usersandgroups.user.fields.FieldUserID;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.PermissionCheckScope;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociation;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.user.UF_Visibility;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class HDUsersAndGroups {
    public static final FieldUserID FIELD_USER_ID = new FieldUserID();
    public static final FieldComputerName FIELD_COMPUTER_NAME = new FieldComputerName();
    public static final FieldCostCentre FIELD_COST_CENTRE = new FieldCostCentre();
    public static final FieldDepartment FIELD_DEPARTMENT = new FieldDepartment();
    public static final FieldImportName FIELD_IMPORT_NAME = new FieldImportName();
    public static final FieldLanguage FIELD_LANGUAGE = new FieldLanguage();
    public static final FieldRoom FIELD_ROOM = new FieldRoom();
    public static final FieldLumpSum FIELD_LUMP_SUM_1 = FieldLumpSum.createFirst();
    public static final FieldLumpSum FIELD_LUMP_SUM_2 = FieldLumpSum.createSecond();
    public static final FieldLumpSum FIELD_LUMP_SUM_3 = FieldLumpSum.createThird();
    public static final FieldCustomUserField FIELD_CUSTOM_1 = FieldCustomUserField.createFirst();
    public static final FieldCustomUserField FIELD_CUSTOM_2 = FieldCustomUserField.createSecond();
    public static final FieldCustomUserField FIELD_CUSTOM_3 = FieldCustomUserField.createThird();
    public static final FieldCustomUserField FIELD_CUSTOM_4 = FieldCustomUserField.createFourth();
    public static final FieldCustomUserField FIELD_CUSTOM_5 = FieldCustomUserField.createFifth();
    public static final FieldCustomUserField FIELD_CUSTOM_6 = FieldCustomUserField.createSixth();
    public static final FieldUserClassID FIELD_CLASS_ID = new FieldUserClassID();
    public static final FieldLocationID FIELD_LOCATION_ID = new FieldLocationID();
    public static final FieldClientDetails FIELD_CLIENT_DETAILS = new FieldClientDetails();
    public static final FieldAllowedActions FIELD_ALLOWED_ACTIONS = new FieldAllowedActions();
    public static final GroupType RESOURCE = GroupType.of((String)"resource");
    public static final MembershipType RESOURCE_MEMBERSHIPTYPE_READ = new MembershipType("read", () -> HDFieldDisplayNameProvider.MSG.getMsg("resource.membershipType.readOnly", new Object[0]));
    public static final MembershipType RESOURCE_MEMBERSHIPTYPE_WRITE = new MembershipType("write", () -> HDFieldDisplayNameProvider.MSG.getMsg("resource.membershipType.write", new Object[0]));
    public static final GroupTypeDef GROUPTYPEDEF_RESOURCE = HDUsersAndGroups.createResourceGroupTypeDef();
    public static final GroupType GROUPTYPE_SUPPORTERS = GroupType.of((String)"supporters");
    public static final GroupTypeDef GROUPTYPEDEF_SUPPORTERS = HDUsersAndGroups.createSupportersGroupTypeDef();
    public static final UserGroupKey GROUP_SUPPORTERS = UserGroupKey.of((String)"supporters", (GroupType)GROUPTYPE_SUPPORTERS);
    public static final GUID GROUPID_SUPPORTERS = GUID.valueOf((String)"sys09dlmeidonrthlu42m0jcc");
    public static final GroupType GROUPTYPE_ENDUSER = GroupType.of((String)"endusers");
    public static final GroupTypeDef GROUPTYPEDEF_ENDUSER = HDUsersAndGroups.createEndusersGroupTypeDef();
    public static final UserGroupKey GROUP_ENDUSER = UserGroupKey.of((String)"endusers", (GroupType)GROUPTYPE_ENDUSER);
    public static final GUID GROUPID_ENDUSER = GUID.valueOf((String)"sys10fee317ztmp0ztlgyy502");
    public static final ResourceFieldID RES_FIELD_ID = new ResourceFieldID();
    public static final ResourceFieldParentID RES_FIELD_PARENT_ID = new ResourceFieldParentID();
    public static final ResourceFieldEmail RES_FIELD_EMAIL = new ResourceFieldEmail();
    public static final ResourceFieldEscalationResourceID RES_FIELD_ESC_RES_ID = new ResourceFieldEscalationResourceID();
    public static final ResourceFieldHourlyRate RES_FIELD_HOURLY_RATE = new ResourceFieldHourlyRate();
    public static final ResourceFieldSettings RES_FIELD_SETTINGS = new ResourceFieldSettings();
    public static final ResourceFieldNotificationSettings RES_FIELD_NOTIF_SETTINGS = new ResourceFieldNotificationSettings();
    public static final ResourceFieldWorkingHours RES_FIELD_WORKING_HOURS = new ResourceFieldWorkingHours();
    public static final GroupFieldAllowedActions GROUP_FIELD_ALLOWED_ACTIONS = new GroupFieldAllowedActions();
    private static final int CHECK_RESOURCE_READ = 1;
    private static final int CHECK_RESOURCE_WRITE = 2;
    private static final int CHECK_RESOURCE_READ_OR_WRITE = 3;
    public static final Permission[] SUPPORTER_PERMISSIONS = new Permission[]{HdPermissions.DISPATCHER, HdPermissions.TICKET_RESOURCES_READ};
    public static final String PROP_SHOW_FIELD_FOR_NEW_USER = "showFieldForNewUser";
    public static final UF_Visibility VISIBILITY_FOR_SUPPORTER = new UF_Visibility("ForSupporter"){

        public boolean isVisible() {
            return HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount());
        }

        public String getLabel() {
            return HDFieldDisplayNameProvider.MSG.getMsg("visibility.forSupporter", new Object[0]);
        }
    };
    public static final ConfigValue<Integer> CONFIG_MANDANTEN = new ConfigValue(HDConfigKeys.USER_ACCESS_FILTER);

    private static GroupTypeDef createResourceGroupTypeDef() {
        HashSet<MembershipType> membershipTypes = new HashSet<MembershipType>();
        membershipTypes.add(RESOURCE_MEMBERSHIPTYPE_READ);
        membershipTypes.add(RESOURCE_MEMBERSHIPTYPE_WRITE);
        return new GroupTypeDef(500, RESOURCE, membershipTypes, MemberToTypeCardinality.One, new GroupTypeDef.GroupTypeRestrictions[0]){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.resources", new Object[0]);
            }

            public URL getIconURL(int size) {
                if (size <= 32) {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/resourcegroups_32.png");
                }
                return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/resourcegroups_96.png");
            }

            public String getDescription() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.resources.description", new Object[0]);
            }

            public String getCreateLabel() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.resources.createlabel", new Object[0]);
            }

            public boolean allowsNonUniqueNames() {
                return true;
            }

            public boolean inheritsMembershipsFromParent() {
                return true;
            }

            public int getMaxTreeLevel() {
                return 2;
            }
        };
    }

    private static GroupTypeDef createSupportersGroupTypeDef() {
        return new GroupTypeDef(40, GROUPTYPE_SUPPORTERS, new GroupTypeDef.GroupTypeRestrictions[]{GroupTypeDef.GroupTypeRestrictions.PreventCreation, GroupTypeDef.GroupTypeRestrictions.PreventDeactivation, GroupTypeDef.GroupTypeRestrictions.PreventRenaming, GroupTypeDef.GroupTypeRestrictions.PreventMembershipEditing, GroupTypeDef.GroupTypeRestrictions.PreventRemoval}){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.supporters", new Object[0]);
            }

            public String getDescription() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.supporters.description", new Object[0]);
            }

            public URL getIconURL(int size) {
                if (size <= 32) {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/supportergroup_32.png");
                }
                return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/supportergroup_96.png");
            }

            public boolean isSystemGroup() {
                return true;
            }
        };
    }

    private static GroupTypeDef createEndusersGroupTypeDef() {
        return new GroupTypeDef(40, GROUPTYPE_ENDUSER, new GroupTypeDef.GroupTypeRestrictions[]{GroupTypeDef.GroupTypeRestrictions.PreventCreation, GroupTypeDef.GroupTypeRestrictions.PreventDeactivation, GroupTypeDef.GroupTypeRestrictions.PreventRenaming, GroupTypeDef.GroupTypeRestrictions.PreventMembershipEditing, GroupTypeDef.GroupTypeRestrictions.PreventRemoval}){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.endusers", new Object[0]);
            }

            public String getDescription() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.endusers.description", new Object[0]);
            }

            public URL getIconURL(int size) {
                if (size <= 32) {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/usergroups_32.png");
                }
                return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/usergroups_96.png");
            }

            public boolean isSystemGroup() {
                return true;
            }
        };
    }

    public static Set<GroupTypeDef> getGroupTypeDefinitionsForRegistration() {
        HashSet<GroupTypeDef> defs = new HashSet<GroupTypeDef>();
        defs.add(GROUPTYPEDEF_RESOURCE);
        defs.add(GROUPTYPEDEF_SUPPORTERS);
        defs.add(GROUPTYPEDEF_ENDUSER);
        return defs;
    }

    public static Set<PredefinedUserGroup> getPredefinedUserGroupsForRegistration() {
        HashSet<PredefinedUserGroup> groups = new HashSet<PredefinedUserGroup>();
        groups.add(new PredefinedUserGroup(GROUP_SUPPORTERS, GROUPID_SUPPORTERS, new MutableUserGroupData()){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("group.supporter", new Object[0]);
            }
        });
        groups.add(new PredefinedUserGroup(GROUP_ENDUSER, GROUPID_ENDUSER, new MutableUserGroupData()){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("group.endusers", new Object[0]);
            }
        });
        return groups;
    }

    @Nonnull
    public static List<UserField<?>> getUserFieldsForRegistration() {
        ArrayList result = new ArrayList(HDUsersAndGroups.getFieldsWithValuesInTblUser());
        result.add(FIELD_CLIENT_DETAILS);
        result.add(FIELD_ALLOWED_ACTIONS);
        return result;
    }

    @Nonnull
    public static List<UserGroupField<?>> getGroupFieldsForRegistration() {
        ArrayList result = new ArrayList(HDUsersAndGroups.getResourceGroupFieldsWithValuesInTblRessourcen());
        result.add(GROUP_FIELD_ALLOWED_ACTIONS);
        return result;
    }

    public static List<UserGroupField<?>> getResourceGroupFieldsWithValuesInTblRessourcen() {
        return Arrays.asList(new UserGroupField[]{RES_FIELD_ID, RES_FIELD_PARENT_ID, RES_FIELD_EMAIL, RES_FIELD_ESC_RES_ID, RES_FIELD_HOURLY_RATE, RES_FIELD_SETTINGS, RES_FIELD_NOTIF_SETTINGS, RES_FIELD_WORKING_HOURS});
    }

    public static List<FieldAndGroupTypeAssociation> getFieldAndGroupTypeAssociationsForRegistration() {
        Set fieldKeys = HDUsersAndGroups.getGroupFieldsForRegistration().stream().map(Field::getKey).collect(Collectors.toSet());
        FieldAndGroupTypeAssociation resourceFieldBundle = new FieldAndGroupTypeAssociation(RESOURCE, fieldKeys);
        FieldAndGroupTypeAssociation standardFieldBundle = new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_STANDARD, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        FieldAndGroupTypeAssociation allUsersFieldBundle = new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ALLUSERS, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        FieldAndGroupTypeAssociation authFieldBundle = new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_AUTH, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        FieldAndGroupTypeAssociation supportersFieldBundle = new FieldAndGroupTypeAssociation(GROUPTYPE_SUPPORTERS, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        FieldAndGroupTypeAssociation endusersFieldBundle = new FieldAndGroupTypeAssociation(GROUPTYPE_ENDUSER, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        ArrayList<FieldAndGroupTypeAssociation> bundles = new ArrayList<FieldAndGroupTypeAssociation>();
        bundles.add(resourceFieldBundle);
        bundles.add(standardFieldBundle);
        bundles.add(allUsersFieldBundle);
        bundles.add(authFieldBundle);
        bundles.add(supportersFieldBundle);
        bundles.add(endusersFieldBundle);
        return bundles;
    }

    @Nonnull
    public static List<UserField<?>> getFieldsWithValuesInTblUser() {
        ArrayList fields = new ArrayList();
        fields.add(FIELD_USER_ID);
        fields.add(FIELD_COMPUTER_NAME);
        fields.add(FIELD_COST_CENTRE);
        fields.add(FIELD_DEPARTMENT);
        fields.add(FIELD_IMPORT_NAME);
        fields.add(FIELD_LANGUAGE);
        fields.add(FIELD_ROOM);
        fields.add(FIELD_LUMP_SUM_1);
        fields.add(FIELD_LUMP_SUM_2);
        fields.add(FIELD_LUMP_SUM_3);
        fields.add(FIELD_CUSTOM_1);
        fields.add(FIELD_CUSTOM_2);
        fields.add(FIELD_CUSTOM_3);
        fields.add(FIELD_CUSTOM_4);
        fields.add(FIELD_CUSTOM_5);
        fields.add(FIELD_CUSTOM_6);
        fields.add(FIELD_CLASS_ID);
        fields.add(FIELD_LOCATION_ID);
        return fields;
    }

    public static boolean isResourceMember(@Nonnull UserAccount account) {
        return HDUsersAndGroups.isResourceMember(account.getID());
    }

    public static boolean isResourceMember(@Nonnull GUID accountID) {
        Set groups = UserGroupManager.getInstance().getGroupsForUser(accountID);
        for (UserGroupInfo group : groups) {
            if (group.getType() != RESOURCE) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWritePermissionInResource(GUID userId, UserGroupInfo resourceGroup) {
        Set membershipTypes = resourceGroup.getMembershipTypes(userId);
        if (membershipTypes != null && membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_WRITE)) {
            return true;
        }
        return HDUsersAndGroups.hasPermissionByParentResource(userId, resourceGroup, 2);
    }

    public static boolean hasAccessInResource(GUID userId, UserGroupInfo resourceGroup) {
        Set membershipTypes = resourceGroup.getMembershipTypes(userId);
        if (membershipTypes != null && (membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_READ) || membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_WRITE))) {
            return true;
        }
        return HDUsersAndGroups.hasPermissionByParentResource(userId, resourceGroup, 3);
    }

    public static boolean hasReadPermissionInResource(GUID userId, UserGroupInfo resourceGroup) {
        Set membershipTypes = resourceGroup.getMembershipTypes(userId);
        if (membershipTypes != null && membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_READ)) {
            return true;
        }
        return HDUsersAndGroups.hasPermissionByParentResource(userId, resourceGroup, 1);
    }

    private static boolean hasPermissionByParentResource(GUID userId, UserGroupInfo resourceGroup, int checkWhat) {
        UserGroupInfo parentGroup;
        GUID parentID = resourceGroup.getParentID();
        if (parentID != null && !resourceGroup.hasMembers() && (parentGroup = UserGroupManager.getInstance().getGroup(parentID)) != null) {
            Set membershipTypes = parentGroup.getMembershipTypes(userId);
            if (membershipTypes != null) {
                if ((checkWhat & 1) == 1 && membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_READ)) {
                    return true;
                }
                if ((checkWhat & 2) == 2 && membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_WRITE)) {
                    return true;
                }
            }
            if (HDUsersAndGroups.hasPermissionByParentResource(userId, parentGroup, checkWhat)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNamedUser(@Nonnull UserAccount account) {
        if (account.getAccountType() == UserAccountType.Temp) {
            return false;
        }
        return HDUsersAndGroups.isResourceMember(account) || SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])HdPermissions.getNamedUserLicensePermissions());
    }

    public static boolean isDispatcher(@Nonnull UserAccount account) {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.DISPATCHER});
    }

    public static boolean isSupporter() {
        GUID accountID = UserManager.getInstance().getCurrentUserAccountID();
        if (accountID == null) {
            return false;
        }
        return HDUsersAndGroups.isSupporter(accountID);
    }

    public static boolean isSupporter(@Nonnull UserAccount account) {
        return HDUsersAndGroups.isSupporter(account.getID());
    }

    public static boolean isSupporter(@Nonnull GUID accountID) {
        return SystemPermissionChecker.hasAnyPermission((GUID)accountID, (Permission[])SUPPORTER_PERMISSIONS) || HDUsersAndGroups.isResourceMember(accountID);
    }

    public static boolean isSupporter(@Nullable GUID userAccountID, final @Nonnull Set<UserGroupInfo> groupsForUser) {
        UserAccount userAccount;
        UserAccount userAccount2 = userAccount = userAccountID == null ? null : UserManager.getRecoveryEnabledInstance().getUserAccount(userAccountID);
        if (!((Boolean)SystemPermissionChecker.SYSTEMPERMISSION_ENABLED.get()).booleanValue()) {
            boolean temporaryAccount;
            boolean bl = temporaryAccount = userAccount != null && userAccount.getAccountType() == UserAccountType.Temp;
            if (!temporaryAccount) {
                return true;
            }
        }
        if (userAccount == null) {
            return false;
        }
        if (groupsForUser.stream().anyMatch(g -> g.getType() == RESOURCE && g.isActive())) {
            return true;
        }
        PermissionCheckScope scope = new PermissionCheckScope(){

            public UserAccount getUserAccount() {
                return userAccount;
            }

            public UserGroupInfo getAllUsersGroup() {
                return groupsForUser.stream().filter(g -> UsersAndGroups.GROUPID_ALLUSERS.equals((Object)g.getID())).findFirst().orElse(null);
            }

            public Set<UserGroupInfo> getUserGroups() {
                return groupsForUser;
            }
        };
        return SystemPermissionChecker.hasAnyPermission((PermissionCheckScope)scope, (Permission[])new Permission[]{HdPermissions.DISPATCHER, HdPermissions.TICKET_RESOURCES_READ});
    }

    public static int getUserID(GUID accountID) {
        return HDUsersAndGroups.getUserID(UserManager.getInstance().getUserAccount(accountID));
    }

    public static int getUserID(UserAccount userAccount) {
        if (userAccount == null) {
            return -1;
        }
        Integer value = (Integer)userAccount.getValue((UserField)FIELD_USER_ID);
        if (value == null) {
            return -1;
        }
        return value;
    }

    @Nullable
    public static UserAccount getUserAccount(int userID) {
        UserManager manager = UserManager.getInstance();
        return HDUsersAndGroups.getUserAccount(userID, manager);
    }

    @Nonnull
    public static UserAccount getUserAccountSave(int userID) {
        UserManager manager = UserManager.getInstance();
        return HDUsersAndGroups.getUserAccountSave(userID, manager);
    }

    @Nonnull
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Integer cannot inject sql code")
    public static UserAccount getUserAccountSave(int userID, UserManager manager) {
        UserAccount userAccount;
        GUID accountID;
        block24: {
            if (userID < 0) {
                throw new IllegalArgumentException("userID=" + userID);
            }
            SearchCommand command = new SearchCommand(new SearchExpression[]{new SearchCondition("usrid", SearchCondition.SearchTermOperator.Equals, (Object)userID)});
            SearchResult result = manager.getSearchEngine().search(command);
            List entries = result.getEntries();
            if (entries.isEmpty()) {
                UserManager.getInstance().getSearchEngine().reIndexAsync();
                try (Connection c = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
                     PreparedStatement pstm = c.prepareStatement("SELECT UserUUID FROM tblUser WHERE UsrID = " + userID);
                     ResultSet rs = pstm.executeQuery();){
                    if (rs.next()) {
                        accountID = GUID.valueOf((String)rs.getString("UserUUID"));
                        HDLogger.warn("User-Index seems to be corrupted, reindexing triggered");
                        break block24;
                    }
                    throw new IllegalStateException("Cannot find user with ID " + userID + ". Index seems to be corrupted. Reindexing was triggered. Please try again later.");
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
            accountID = (GUID)((SearchResultEntry)entries.get(0)).getId();
        }
        if ((userAccount = manager.getUserAccount(accountID)) == null) {
            UserManager.getInstance().getSearchEngine().reIndexAsync();
            throw new IllegalStateException("Cannot find user with ID " + userID + ". Index or user-manager seems to be corrupted. Reindexing was triggered. Please try again later.");
        }
        return userAccount;
    }

    @Nullable
    public static UserAccount getUserAccount(int userID, UserManager manager) {
        if (userID < 0) {
            return null;
        }
        SearchCommand command = new SearchCommand(new SearchExpression[]{new SearchCondition("usrid", SearchCondition.SearchTermOperator.Equals, (Object)userID)});
        SearchResult result = manager.getSearchEngine().search(command);
        List entries = result.getEntries();
        if (entries.isEmpty()) {
            return null;
        }
        GUID accountID = (GUID)((SearchResultEntry)entries.get(0)).getId();
        return manager.getUserAccount(accountID);
    }

    public static Set<GUID> getMembersInResource(GUID resourceId, MembershipType membershipType) {
        UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resourceId);
        Set memberIDs = resource.getMemberIDs(membershipType);
        if (resource.getParentID() != null && memberIDs.isEmpty()) {
            UserGroupInfo resourceParent = UserGroupManager.getInstance().getGroup(resource.getParentID());
            memberIDs = resourceParent.getMemberIDs(membershipType);
        }
        return memberIDs;
    }

    @Nullable
    public static GUID getResourceGroupUUID(int resID) {
        if (resID <= 0) {
            return null;
        }
        UserGroupInfo res = HDUsersAndGroups.getResource(resID);
        if (res == null) {
            HDLogger.error(new Throwable("User Group representing resource with ID =\"" + resID + "\" could not be found."));
            return null;
        }
        return res.getID();
    }

    public static UserGroupInfo getResource(int resID) {
        return ((IHelpDeskUserGroupManager)UserGroupManager.getInstance()).getUserGroupInfoForResourceId(resID);
    }

    public static int getResourceId(GUID resourceGroupId) {
        UserGroupInfo group = UserGroupManager.getRecoveryEnabledInstance().getGroup(resourceGroupId);
        if (group == null) {
            throw new IllegalArgumentException("No resource found for " + String.valueOf(resourceGroupId));
        }
        Integer resId = (Integer)group.getValue((UserGroupField)RES_FIELD_ID);
        if (resId == null) {
            throw new IllegalStateException(String.valueOf(group) + " (" + group.getName() + ") " + group.getDisplayName() + " " + String.valueOf(group.getID()) + " " + group.getType().getName() + " has no RES_FIELD_ID!");
        }
        return resId;
    }

    public static UserGroupInfo getResourceFromRecoveryEnabledManager(int resID) {
        return ((IHelpDeskUserGroupManager)UserGroupManager.getRecoveryEnabledInstance()).getUserGroupInfoForResourceId(resID);
    }

    public static String getResourceIconKey(UserGroupInfo ressourceGroup) {
        if (ressourceGroup == null || !ressourceGroup.isActive()) {
            return "deleted";
        }
        if (SystemPermissionChecker.checkAccess((Permission)HdPermissions.TICKET_RESOURCES_READ_WRITE)) {
            return "write";
        }
        if (HDUsersAndGroups.hasWritePermissionInResource(UserManager.getInstance().getCurrentUserAccountID(), ressourceGroup)) {
            return "write";
        }
        if (SystemPermissionChecker.checkAccess((Permission)HdPermissions.TICKET_RESOURCES_READ)) {
            return "read";
        }
        if (HDUsersAndGroups.hasReadPermissionInResource(UserManager.getInstance().getCurrentUserAccountID(), ressourceGroup)) {
            return "read";
        }
        return "blocked";
    }

    public static UserGroupInfo getFirstActiveResourceMatchedByName(String resourceName) {
        Set resources = UserGroupManager.getInstance().getGroups(RESOURCE);
        return resources.stream().filter(ugi -> resourceName.equalsIgnoreCase(ugi.getName())).findFirst().orElse(null);
    }

    public static boolean isPrivilegedUser(int userId) {
        return userId == Integer.MAX_VALUE;
    }

    public static boolean isPrivilegedUser(GUID userId) {
        return userId == UserManager.PRIVILEGED_ACCOUNT_ID;
    }

    public static Set<Integer> getEffectiveAllowedActionsForUser(UserAccount account) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (account.getAccountType() == UserAccountType.Administrator) {
            return ActionManager.getInstance().getAllValidIds();
        }
        result.addAll((Collection)account.getValue((UserField)FIELD_ALLOWED_ACTIONS));
        for (UserGroupInfo group : UserGroupManager.getInstance().getGroupsForUser(account.getID())) {
            if (!group.isActive()) continue;
            if (group.getID().equals((Object)UsersAndGroups.GROUPID_ADMIN)) {
                return ActionManager.getInstance().getAllValidIds();
            }
            result.addAll((Collection)group.getValue((UserGroupField)GROUP_FIELD_ALLOWED_ACTIONS));
        }
        return result;
    }
}

