/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.userfields;

import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.user.UserFieldSettingsManager;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.SearchTag;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class UserFieldSettingManagerHD
extends UserFieldSettingsManager {
    protected String setSpecificDefaultValues(UserFieldDefinition def, Map<String, String> properties) {
        String defaultValue = super.setSpecificDefaultValues(def, properties);
        if (def == null) {
            properties.putIfAbsent("showFieldForNewUser", "false");
        } else {
            ArrayList<String> defaultActivatedKeys = new ArrayList<String>();
            defaultActivatedKeys.add(UsersAndGroups.FIELD_EMAIL.getKey());
            defaultActivatedKeys.add(UsersAndGroups.FIELD_FIRSTNAME.getKey());
            defaultActivatedKeys.add(UsersAndGroups.FIELD_LASTNAME.getKey());
            defaultActivatedKeys.add(HDUsersAndGroups.FIELD_CLASS_ID.getKey());
            defaultActivatedKeys.add(HDUsersAndGroups.FIELD_LOCATION_ID.getKey());
            if (defaultActivatedKeys.contains(def.getFieldKey())) {
                properties.putIfAbsent("showFieldForNewUser", "true");
            } else {
                properties.putIfAbsent("showFieldForNewUser", "false");
            }
        }
        return defaultValue;
    }

    protected <T> Map.Entry<UserFieldDefinition, UserField<?>> createAndRegisterForCustom(GenericFieldSetting setting) {
        Map.Entry result = super.createAndRegisterForCustom(setting);
        AbstractTicketFieldDefinitionForTicketOwner extra = new AbstractTicketFieldDefinitionForTicketOwner((UserFieldDefinition)result.getKey(), 200 + setting.getSortPriority());
        DynamicExtensionManager.getInstance().register(TicketFieldDefinition.class, (Object)extra);
        return result;
    }

    protected UserField unregisterForCustom(GenericFieldSetting setting) {
        UserField result = super.unregisterForCustom(setting);
        String ownerFieldkey = "ticketowner." + setting.getKey();
        DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class).forEach(def -> {
            if (ownerFieldkey.equals(def.getFieldKey())) {
                DynamicExtensionManager.getInstance().unregister(TicketFieldDefinition.class, def);
                return;
            }
        });
        return result;
    }

    protected void sendExternalSignal(List<UserField<?>> removedInfos, List<UserField<?>> addedInfos) {
        List<String> tags;
        super.sendExternalSignal(removedInfos, addedInfos);
        List removedSearchTags = removedInfos.stream().map(f -> {
            if (f != null) {
                return f.getSearchTag();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List addedSearchTags = addedInfos.stream().map(f -> {
            if (f != null) {
                return f.getSearchTag();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!addedInfos.isEmpty()) {
            tags = addedSearchTags.stream().map(SearchTag::getTag).toList();
            JoinTokenMatcher.addToIndex(TicketManager.getReader().getSearchEngine(), (String)"ownerid", (IndexSearchEngine)UserManager.getInstance().getSearchEngine(), tags, (boolean)true);
        }
        if (!removedSearchTags.isEmpty()) {
            tags = removedSearchTags.stream().map(SearchTag::getTag).toList();
            JoinTokenMatcher.removeFromIndex(TicketManager.getReader().getSearchEngine(), (String)"ownerid", tags);
        }
    }
}

