/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewState;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.command.JoinSearchCondition;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserFieldSubViewGrouping
extends SimpleSubViewGrouping {
    private UserField<?> field;

    public UserFieldSubViewGrouping(@Nonnull UserField<?> field) {
        super("ownerid");
        this.field = field;
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.field.getKey();
    }

    @Override
    @Nonnull
    public String getRelatedFieldKey() {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        return HDUsersAndGroups.isSupporter(userAccount) ? "ownerid" : "";
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.field.getSearchTag().getDisplayName();
    }

    @Override
    @Nonnull
    public String getDescription() {
        return Tickets.MSG.getMsg("view.description." + this.getKey(), new Object[0]);
    }

    @Override
    public List<SubView<?>> getSubViews(@Nonnull TicketViewFactory parent, @Nonnull GUID accountID, Locale locale, @Nonnull Set<Integer> ticketIDs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendSubViewStates(TicketViewState parentState, @Nonnull TicketViewFactory parentFactory, @Nonnull GUID accountID, @Nonnull Set<Integer> result, @Nullable Set<Integer> unreadResult, IndexSearchEngine<Integer> engine, @Nullable IndexSearchEngine<SlaveInfo> slaveInfoEngine) {
        Map displayNames = this.field.getSearchTag().getMapData();
        HashSet<Integer> tickets = new HashSet<Integer>(result);
        TicketViewManager manager = TicketViewManager.getInstance();
        UserManager userManager = UserManager.getInstance();
        IndexSearchEngine userSearchEngine = userManager.getSearchEngine();
        while (tickets.size() > 0 && parentState.size() < 100) {
            UserAccount owner;
            GUID ownerGUID;
            Integer ticketID = Collections.max(tickets);
            TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketID);
            if (ticket != null && (ownerGUID = ticket.getValue(Tickets.FIELD_OWNER_GUID)) != null && (owner = userManager.getUserAccount(ownerGUID)) != null) {
                Object fieldValue = owner.getValue(this.field);
                Set users = userSearchEngine.simpleSearch(new SearchCommand(this.field.getKey(), SearchCondition.SearchTermOperator.Equals, fieldValue));
                SearchCommand command = new SearchCommand(new SearchExpression[]{new PrefilteredSearchExpression(tickets), new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)users)});
                Set subResult = engine.simpleSearch(command);
                tickets.removeAll(subResult);
                manager.convertToBunIdsIfNeeded(slaveInfoEngine, subResult, accountID);
                int totalTicketCount = subResult.size();
                if (totalTicketCount > 0) {
                    int unreadTicketCount = 0;
                    if (unreadResult != null) {
                        for (Integer aufId : subResult) {
                            if (!unreadResult.contains(aufId)) continue;
                            ++unreadTicketCount;
                        }
                    }
                    final String displayName = (String)displayNames.get(fieldValue);
                    TicketViewState subState = new TicketViewState(parentFactory.getID() + "." + String.valueOf(fieldValue), totalTicketCount, unreadTicketCount, parentFactory, parentState){

                        @Override
                        public String getDisplayName() {
                            return displayName;
                        }
                    };
                    parentState.add(subState);
                }
            }
            tickets.remove(ticketID);
        }
        parentState.sort((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getDisplayName(), b.getDisplayName()));
    }

    @Override
    protected Supplier<SearchExpression> getConditionSupplier(@Nonnull String subID, boolean hideSubnodeTickets) {
        try {
            Integer value = Integer.valueOf(subID);
            return () -> {
                IndexSearchEngine userEngine = UserManager.getInstance().getSearchEngine();
                SearchCommand ownerCommand = new SearchCommand(this.field.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)value);
                return new JoinSearchCondition("ownerid", userEngine, ownerCommand);
            };
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

