/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.standardviews;

import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.net.URL;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SharedWithMeTicketViewDefinition
implements TicketViewFactory {
    public static final String KEY = "sharedWithMe";
    private final SubViewGroupingDefinition subViewGrouping;

    public SharedWithMeTicketViewDefinition() {
        this(null);
    }

    SharedWithMeTicketViewDefinition(@Nullable SubViewGroupingDefinition subViewGrouping) {
        this.subViewGrouping = subViewGrouping;
    }

    @Override
    public SubViewGroupingDefinition getSubViewGrouping() {
        return this.subViewGrouping;
    }

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getCategoryKey() {
        return "globalviews";
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        return HelpDeskServer.class.getResource("images/ticketview/sharedwithme.png");
    }

    @Override
    public SearchCommand createSearchCommand(@Nonnull GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
        SearchCommand command;
        SearchExpression expressionWithoutAdditionaSharings = GlobalSearchViewDefinition.getGlobalSearchExpressionWithoutAdditionaSharings(accountID, locale);
        if (expressionWithoutAdditionaSharings == null) {
            command = new SearchCommand("additionalAccessUsers", SearchCondition.SearchTermOperator.Equals, (Object)"0");
        } else {
            AndSearchExpression and = new AndSearchExpression();
            and.add(0, (Object)SharedWithMeTicketViewDefinition.getSharedTickets(accountID));
            and.add((SearchExpression)new SubtractSearchExpression(expressionWithoutAdditionaSharings));
            command = new SearchCommand(new SearchExpression[]{and});
        }
        if (this.subViewGrouping != null) {
            this.subViewGrouping.appendMarker(command);
        }
        return command;
    }

    @Nonnull
    public static AndSearchExpression getSharedTickets(GUID accountID) {
        AndSearchExpression topAnd = new AndSearchExpression();
        OrSearchExpression topOr = new OrSearchExpression();
        topAnd.add((SearchExpression)topOr);
        Set groupsForUser = UserGroupManager.getInstance().getGroupsForUser(accountID);
        topOr.add((Object)new SearchCondition("additionalAccessGroups", SearchCondition.SearchTermOperator.IN, groupsForUser.stream().map(UserGroupInfo::getID).collect(Collectors.toSet())));
        topOr.add((Object)new SearchCondition("additionalAccessUsers", SearchCondition.SearchTermOperator.Equals, (Object)accountID));
        CustomTicketViewDefinition.addCondition_forEndUserFromTicketNumber(accountID, topAnd);
        return topAnd;
    }
}

