/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketfieldsettings.fields.CustomTicketField;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewVisibility;
import com.inet.helpdesk.ticketview.CustomTicketViewFactory;
import com.inet.helpdesk.ticketview.TicketViewTree;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

class TicketViewDefGlobalCache {
    private static final String CLOSED_TICKETS_VIEW_ID = "closedtickets";
    @Nonnull
    private static final CopyOnWriteArrayList<CustomTicketViewDefinition> TICKET_VIEWS_VALUE;
    @Nonnull
    private static final List<TicketViewVisibility> VIEW_VISIBILITITY_VALUE;

    TicketViewDefGlobalCache() {
    }

    static void addViewsForGroups(Set<UserGroupInfo> groups, List<TicketViewFactory> result, TicketViewTree tree) {
        try (UserAccountScope scope = UserAccountScope.create((GUID)tree.getAccountID());){
            HashSet<String> groupIDs = new HashSet<String>();
            for (UserGroupInfo group : groups) {
                groupIDs.add(group.getID().toString());
            }
            CopyOnWriteArrayList<CustomTicketViewDefinition> list = TICKET_VIEWS_VALUE;
            block6: for (CustomTicketViewDefinition view : list) {
                List<String> neededGroups = view.getUserGroups();
                if (neededGroups == null) continue;
                for (String groupID : neededGroups) {
                    if (!groupIDs.contains(groupID)) continue;
                    CustomTicketViewFactory factory = new CustomTicketViewFactory(view, tree);
                    String subViewGroupingKey = view.getSubViewGroupingKey();
                    if (subViewGroupingKey != null && factory.getSubViewGrouping() == null) continue block6;
                    result.add(factory);
                    continue block6;
                }
            }
        }
    }

    static List<CustomTicketViewDefinition> getViews() {
        return Collections.unmodifiableList(TICKET_VIEWS_VALUE);
    }

    private static void checkGlobalPermmission() throws AccessDeniedException {
        if (!SystemPermissionChecker.checkAccess((Permission)HdPermissions.TEMPLATE_DEFINITION)) {
            throw new AccessDeniedException(HdPermissions.TEMPLATE_DEFINITION);
        }
        if (!SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER)) {
            throw new AccessDeniedException(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
        }
    }

    private static void checkTemplateDefPermmission() throws AccessDeniedException {
        if (!SystemPermissionChecker.checkAccess((Permission)HdPermissions.TEMPLATE_DEFINITION)) {
            throw new AccessDeniedException(HdPermissions.TEMPLATE_DEFINITION);
        }
    }

    static synchronized void putView(CustomTicketViewDefinition view) {
        TicketViewDefGlobalCache.checkTemplateDefPermmission();
        CopyOnWriteArrayList<CustomTicketViewDefinition> list = TICKET_VIEWS_VALUE;
        String id = view.getID();
        boolean checkGlobal = true;
        for (CustomTicketViewDefinition oldView : list) {
            if (!Objects.equals(oldView.getID(), id)) continue;
            ArrayList<String> userGroupsOld = new ArrayList<String>(oldView.getUserGroups());
            ArrayList<String> userGroups = new ArrayList<String>(view.getUserGroups());
            for (String entry : userGroupsOld) {
                if (userGroups.contains(entry)) {
                    userGroups.remove(entry);
                    continue;
                }
                userGroups.add(entry);
            }
            checkGlobal = userGroups.size() > 0;
            list.remove(oldView);
            break;
        }
        if (checkGlobal) {
            TicketViewDefGlobalCache.checkGlobalPermmission();
        }
        list.add(view);
        TicketViewDefGlobalCache.save(list);
    }

    static synchronized boolean removeView(String id) {
        CopyOnWriteArrayList<CustomTicketViewDefinition> list = TICKET_VIEWS_VALUE;
        if (TicketViewDefGlobalCache.removeFromList(list, id, () -> TicketViewDefGlobalCache.checkGlobalPermmission(), () -> TicketViewDefGlobalCache.checkTemplateDefPermmission())) {
            TicketViewDefGlobalCache.save(list);
            return true;
        }
        return false;
    }

    static boolean removeFromList(List<CustomTicketViewDefinition> list, String id, Runnable checkPermission, Runnable checkTemplateDefPermmission) {
        for (CustomTicketViewDefinition view : list) {
            if (!Objects.equals(view.getID(), id)) continue;
            if (view.getOriginalCreator() != null && view.getOriginalCreator().equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
                checkTemplateDefPermmission.run();
                list.remove(view);
                return true;
            }
            checkPermission.run();
            list.remove(view);
            return true;
        }
        return false;
    }

    private static void save(@Nonnull List<CustomTicketViewDefinition> data) {
        String str = new Json().toJson(Objects.requireNonNull(data));
        MutableUserGroupData groupData = new MutableUserGroupData();
        groupData.put(TicketViewManager.GLOBAL_TICKET_VIEW, (Object)str);
        UserGroupManager.getInstance().updateGroupData(UsersAndGroups.GROUPID_ALLUSERS, groupData);
    }

    static List<TicketViewVisibility> getViewVisibilities() {
        return VIEW_VISIBILITITY_VALUE;
    }

    static {
        UserGroupInfo allUsers = UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ALLUSERS);
        String value = (String)allUsers.getValue(TicketViewManager.GLOBAL_TICKET_VIEW);
        List views = null;
        ArrayList defaultCustomViews = null;
        try {
            if (!StringFunctions.isEmpty((String)value)) {
                views = (List)new Json().fromJson(value, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{CustomTicketViewDefinition.class}));
            } else {
                List<@Nonnull GUID> forAllUsers = Collections.singletonList(UsersAndGroups.GROUPID_ALLUSERS);
                List<GUID> forSupporters = Collections.singletonList(HDUsersAndGroups.GROUPID_SUPPORTERS);
                views = new ArrayList();
                defaultCustomViews = views;
                views.add(CustomTicketViewDefinition.createGlobalView("statusid:>=\"100\" statusid:<=\"101\"", null, forSupporters));
                views.add(CustomTicketViewDefinition.createGlobalView("lastchanged:7d", null, forSupporters));
                views.add(CustomTicketViewDefinition.createGlobalView("terminvereinbarungdate:>1d", null, forSupporters));
                views.add(CustomTicketViewDefinition.createGlobalView("statusid:\"150\"", null, forSupporters));
                views.add(CustomTicketViewDefinition.createGlobalView("opentickets|lastchanged:<1m", null, forSupporters));
                views.add(CustomTicketViewDefinition.createGlobalView("opentickets|inquirydate:<1m", null, forAllUsers));
                views.add(CustomTicketViewDefinition.createGlobalView("statusid:>=\"300\" closeddate:14d", null, forAllUsers, CLOSED_TICKETS_VIEW_ID));
                views.add(CustomTicketViewDefinition.createGlobalView("opentickets|tickettags:\"0\"", null, forSupporters));
                views.add(CustomTicketViewDefinition.createGlobalView("opentickets|tickettags:\"2\"", null, forSupporters));
                views.add(CustomTicketViewDefinition.createGlobalView("opentickets|tickettags:\"3\"", null, forSupporters));
                views.add(CustomTicketViewDefinition.createGlobalView("opentickets|sumtime:>300", null, forSupporters));
                block16: for (SubViewGroupingDefinition group : DynamicExtensionManager.getInstance().get(SubViewGroupingDefinition.class)) {
                    String key;
                    switch (key = group.getKey()) {
                        case "supervisor": 
                        case "custom1": 
                        case "custom2": 
                        case "custom3": 
                        case "custom4": 
                        case "custom5": 
                        case "custom6": 
                        case "custom7": 
                        case "myresourceid": {
                            continue block16;
                        }
                    }
                    TicketField field = Tickets.getFieldByKey(group.getKey());
                    if (field != null && field instanceof CustomTicketField) continue;
                    String phrase = group.getPreconfiguredDefaultSearchPhrase();
                    if (phrase == null) {
                        phrase = "opentickets|";
                    }
                    views.add(CustomTicketViewDefinition.createGlobalView(phrase, group, forAllUsers, null, group.getPreconfiguredDefaultViewName()));
                }
            }
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
        if (views == null) {
            views = Collections.emptyList();
        }
        TICKET_VIEWS_VALUE = new CopyOnWriteArrayList(views);
        HashSet<String> knownIDs = new HashSet<String>();
        ArrayList<TicketViewVisibility> visibility = new ArrayList<TicketViewVisibility>();
        String[] activeIDs = new String[]{"newtickets", "opentickets", "lasteditor", CLOSED_TICKETS_VIEW_ID, "mytickets", CustomTicketViewDefinition.createGlobalView("opentickets|", ResourceSubViewGrouping.INSTANCE, Collections.emptyList()).getID(), "supervisor"};
        for (String id : activeIDs) {
            knownIDs.add(id);
            visibility.add(new TicketViewVisibility(id, true));
        }
        for (TicketViewFactory viewFactory : ServerPluginManager.getInstance().get(TicketViewFactory.class)) {
            String id = viewFactory.getID();
            if (knownIDs.contains(id)) continue;
            knownIDs.add(id);
            visibility.add(new TicketViewVisibility(id, false));
        }
        if (defaultCustomViews != null) {
            for (CustomTicketViewDefinition view : defaultCustomViews) {
                String id = view.getID();
                if (knownIDs.contains(id)) continue;
                knownIDs.add(id);
                visibility.add(new TicketViewVisibility(id, false));
            }
        }
        VIEW_VISIBILITITY_VALUE = Collections.unmodifiableList(visibility);
    }
}

