/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeHasAttachments;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.search.SearchTagBundleSlave;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketMap
extends AbstractMap<String, Object> {
    static final List<String> SPECIAL_KEYS = Collections.unmodifiableList(Arrays.asList("bundleslave", "reasteptext", "tickettags"));
    private final TicketVO ticket;
    private final Supplier<Set<ReaStepTextVO>> reaStepTextsProvider;
    private final Map<String, TicketField> fieldMap;
    private final Map<String, TicketAttribute> attributeMap;
    private final Map<String, PluggableTicketSearchTag> pluggableSearchTagMap;
    private final List<SearchTagTicketTags.TicketTag> ticketTags;
    private Set<Map.Entry<String, Object>> entrySet;

    public TicketMap(@Nonnull TicketVO ticket, @Nonnull Supplier<Set<ReaStepTextVO>> reaStepTextsProvider, @Nonnull Map<String, TicketField> fieldMap, @Nonnull Map<String, TicketAttribute> attributeMap, @Nonnull List<PluggableTicketSearchTag> pluggableSearchTags, @Nonnull List<SearchTagTicketTags.TicketTag> ticketTags) {
        this.ticket = ticket;
        this.reaStepTextsProvider = reaStepTextsProvider;
        this.fieldMap = fieldMap;
        this.attributeMap = attributeMap;
        this.pluggableSearchTagMap = pluggableSearchTags.stream().collect(Collectors.toMap(pst -> pst.getSearchTag().getTag(), pst -> pst));
        this.ticketTags = ticketTags;
    }

    @Override
    @Nullable
    public Object get(Object key) {
        TicketField field = this.fieldMap.get(key);
        if (field != null) {
            return this.ticket.getValue(field);
        }
        TicketAttribute attribute = this.attributeMap.get(key);
        if (attribute != null) {
            return this.convertAttributeValueIfNeeded(attribute, this.ticket.getAttribute(attribute));
        }
        return this.getSpecial((String)key);
    }

    @Nullable
    private Object getSpecial(String key) {
        switch (key) {
            case "bundleslave": {
                return SearchTagBundleSlave.valueAsInt(this.ticket.isSlaveInBundle());
            }
            case "reasteptext": {
                return Collections.unmodifiableSet(this.reaStepTextsProvider.get());
            }
            case "tickettags": {
                return this.getTicketTags();
            }
        }
        if (this.pluggableSearchTagMap.containsKey(key)) {
            return this.pluggableSearchTagMap.get(key).getValue(this.ticket);
        }
        return null;
    }

    private Set<Integer> getTicketTags() {
        HashSet<Integer> tags = new HashSet<Integer>();
        for (SearchTagTicketTags.TicketTag tag : this.ticketTags) {
            if (!tag.checkFor(this.ticket)) continue;
            tags.add((Integer)tag.getKey());
        }
        return Collections.unmodifiableSet(tags);
    }

    @Override
    public boolean containsKey(Object key) {
        TicketField field = this.fieldMap.get(key);
        if (field != null) {
            return true;
        }
        TicketAttribute attribute = this.attributeMap.get(key);
        if (attribute != null) {
            return true;
        }
        Object val = this.getSpecial((String)key);
        if (val != null) {
            return true;
        }
        PluggableTicketSearchTag pluggableTicketSearchTag = this.pluggableSearchTagMap.get(key);
        if (pluggableTicketSearchTag != null) {
            return pluggableTicketSearchTag.getValue(this.ticket) != null;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            Object val;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (TicketField ticketField : this.fieldMap.values()) {
                Object value = this.ticket.getValue(ticketField);
                map.put(ticketField.getKey(), value);
            }
            for (TicketAttribute ticketAttribute : this.attributeMap.values()) {
                Object attValue = this.convertAttributeValueIfNeeded(ticketAttribute, this.ticket.getAttribute(ticketAttribute));
                map.put(ticketAttribute.getKey(), attValue);
            }
            for (String string : SPECIAL_KEYS) {
                val = this.getSpecial(string);
                if (val == null) continue;
                map.put(string, val);
            }
            for (Map.Entry entry : this.pluggableSearchTagMap.entrySet()) {
                val = ((PluggableTicketSearchTag)entry.getValue()).getValue(this.ticket);
                if (val == null) continue;
                map.put((String)entry.getKey(), val);
            }
            this.entrySet = Collections.unmodifiableSet(map.entrySet());
        }
        return this.entrySet;
    }

    private Object convertAttributeValueIfNeeded(TicketAttribute attribute, Object value) {
        if (attribute == Tickets.ATTRIBUTE_ATTACHMENTS && value != null) {
            return TicketAttributeHasAttachments.valueAsInt((Boolean)value);
        }
        return value;
    }
}

