/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;

public class SearchTagReaStepText
extends SearchTag {
    public static final String KEY = "reasteptext";

    public SearchTagReaStepText() {
        super(KEY, SearchTagReaStepText.createTokenizer(), 100, () -> HDFieldDisplayNameProvider.getStaticTicketFieldDisplayName(KEY));
    }

    @Nonnull
    private static SearchTokenizer createTokenizer() {
        return (value, type) -> {
            switch (type) {
                case 1: 
                case 2: {
                    return TextSearchTokenizer.DEFAULT.tokens(value, type);
                }
            }
            if (value == null) {
                return Collections.emptySet();
            }
            if (value.getClass() == ReaStepTextVO.class) {
                String plainText = SearchTagReaStepText.getPlainTextFrom((ReaStepTextVO)value);
                return TextSearchTokenizer.DEFAULT.tokens((Object)plainText, type);
            }
            HashSet tokens = new HashSet();
            Collection reaStepTexts = (Collection)value;
            for (ReaStepTextVO stepText : reaStepTexts) {
                String plainText = SearchTagReaStepText.getPlainTextFrom(stepText);
                tokens.addAll(TextSearchTokenizer.DEFAULT.tokens((Object)plainText, type));
            }
            return tokens;
        };
    }

    private static String getPlainTextFrom(ReaStepTextVO stepText) {
        if (stepText.hasHtmlContent()) {
            return HtmlConverter.html2text((String)stepText.getText());
        }
        return stepText.getText();
    }

    public boolean isPhraseContainsIn(String normalizePhrase, Object val) {
        for (ReaStepTextVO stepText : (Collection)val) {
            String plainText = SearchTagReaStepText.getPlainTextFrom(stepText);
            if (!super.isPhraseContainsIn(normalizePhrase, (Object)plainText)) continue;
            return true;
        }
        return false;
    }
}

