/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class RegisteredTicketFieldsContainer {
    private List<TicketField<Object>> baseFields;
    private List<TicketField<Object>> additionalFields;
    private List<TicketAttribute<Object>> additionalAttributes;
    private List<ReaStepField> reaStepAdditionalFields;
    private List<ReaStepField> reaStepDefaultFields;

    public RegisteredTicketFieldsContainer() {
        this(DynamicExtensionManager.getInstance().get(TicketField.class), DynamicExtensionManager.getInstance().get(ReaStepField.class), ServerPluginManager.getInstance().get(TicketAttribute.class));
    }

    protected RegisteredTicketFieldsContainer(@Nonnull List<TicketField> registeredFields, @Nonnull List<ReaStepField> reaStepFields, @Nonnull List<TicketAttribute> registeredAttributes) {
        List<TicketField<TicketField>> fieldWithValuesInOwnColumns = Tickets.getFieldsWithValuesInOwnColumns();
        registeredFields.stream().filter(f -> f.getStorageLocationInfo() != null).forEach(f -> fieldWithValuesInOwnColumns.add((TicketField<TicketField>)((Object)f)));
        fieldWithValuesInOwnColumns.retainAll(registeredFields);
        this.baseFields = Collections.unmodifiableList(fieldWithValuesInOwnColumns);
        ArrayList<TicketField> otherFields = new ArrayList<TicketField>(registeredFields);
        otherFields.removeAll(this.baseFields);
        this.additionalFields = Collections.unmodifiableList(otherFields);
        ArrayList<ReaStepField> reaFields = new ArrayList<ReaStepField>(reaStepFields);
        ArrayList extraReaFields = new ArrayList();
        reaFields.removeIf(f -> {
            if (f == ReaStepVO.FIELD_DESC || f == ReaStepVO.FIELD_EMAIL_AN || f == ReaStepVO.FIELD_EMAIL_BCC || f == ReaStepVO.FIELD_EMAIL_CC || f == ReaStepVO.FIELD_EMAIL_IN || f == ReaStepVO.FIELD_PROCESSING_TIME || f == ReaStepVO.FIELD_USER_DISPLAY_NAME) {
                return false;
            }
            extraReaFields.add(f);
            return true;
        });
        this.reaStepAdditionalFields = Collections.unmodifiableList(extraReaFields);
        this.reaStepDefaultFields = Collections.unmodifiableList(reaFields);
        List<TicketAttribute<TicketAttribute>> attributesWithValuesInOwnColumns = Tickets.getAttributesWithValuesInOwnColumn();
        registeredAttributes.stream().filter(f -> f.getStorageLocationInfo() != null).forEach(f -> attributesWithValuesInOwnColumns.add((TicketAttribute<TicketAttribute>)((Object)f)));
        attributesWithValuesInOwnColumns.retainAll(registeredAttributes);
        ArrayList<TicketAttribute> otherAttributes = new ArrayList<TicketAttribute>(registeredAttributes);
        otherAttributes.removeAll(attributesWithValuesInOwnColumns);
        this.additionalAttributes = Collections.unmodifiableList(otherAttributes);
    }

    public List<TicketField<Object>> getBaseFields() {
        return this.baseFields;
    }

    public List<TicketField<Object>> getAdditionalFields() {
        return this.additionalFields;
    }

    public List<TicketField<Object>> getAllFields() {
        ArrayList<TicketField<Object>> allFields = new ArrayList<TicketField<Object>>();
        allFields.addAll(this.baseFields);
        allFields.addAll(this.additionalFields);
        return Collections.unmodifiableList(allFields);
    }

    public List<ReaStepField> getReaStepAdditionalFields() {
        return this.reaStepAdditionalFields;
    }

    public List<ReaStepField> getReaStepDefaultFields() {
        return this.reaStepDefaultFields;
    }

    public List<TicketAttribute<Object>> getAdditionalAttributes() {
        return this.additionalAttributes;
    }
}

