/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.model;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.ticketmanager.TicketManipulatorSync;
import com.inet.helpdesk.ticketmanager.internal.IDGenerator;
import com.inet.helpdesk.ticketmanager.model.OperationChangedTicketImpl;
import com.inet.thread.ServerLock;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OperationModelImpl
implements TicketOperationModel,
Closeable {
    private List<OperationChangedTicket> changedTickets = new ArrayList<OperationChangedTicket>();
    private List<ServerLock> acquiredLocks = new ArrayList<ServerLock>();
    private IDGenerator idGenerator;

    public OperationModelImpl(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<OperationChangedTicket> getChangedTickets() {
        return Collections.unmodifiableList(this.changedTickets);
    }

    @Override
    public OperationChangedTicket changeExistingTicket(int ticketId) {
        Optional<OperationChangedTicket> first = this.changedTickets.stream().filter(t -> t.getTicketId() == ticketId).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        if (this.changedTickets.isEmpty()) {
            this.acquiredLocks.add(TicketManipulatorSync.getTicketLock(ticketId));
        } else {
            this.acquiredLocks.add(TicketManipulatorSync.tryTicketLock(ticketId));
        }
        TicketVO vo = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (vo == null) {
            throw new IllegalArgumentException("Ticket does not exist: " + ticketId);
        }
        OperationChangedTicket ticket = OperationChangedTicketImpl.createForTicket(vo, this);
        this.changedTickets.add(ticket);
        return ticket;
    }

    @Override
    public OperationChangedTicket createNewTicket(MutableTicketData ticketData, MutableTicketAttributes attributes) {
        OperationChangedTicket ticket = OperationChangedTicketImpl.createForNewTicket(ticketData, attributes, this);
        this.changedTickets.add(ticket);
        return ticket;
    }

    public IDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public String toString() {
        return "ChangedTickets: " + this.changedTickets.toString();
    }

    public void releaseAllLocks() {
        for (ServerLock lock : this.acquiredLocks) {
            try {
                lock.close();
            }
            catch (Throwable e) {
                HDLogger.warn(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.releaseAllLocks();
    }
}

