/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationAfterWriteAction;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.Actions;
import com.inet.helpdesk.ticketmanager.model.OperationChangedReaStepImpl;
import com.inet.helpdesk.ticketmanager.model.OperationModelImpl;
import com.inet.helpdesk.ticketmanager.model.OperationNewReaStepImpl;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OperationChangedTicketImpl
implements OperationChangedTicket {
    private final MutableTicketData newTicketData = new FieldsImpl();
    private final MutableTicketAttributes newTicketAttributes = new MutableTicketAttributes();
    private List<OperationNewReaStep> addedReaSteps = new ArrayList<OperationNewReaStep>();
    private List<OperationChangedReaStep> changedReaSteps = new ArrayList<OperationChangedReaStep>();
    private List<OperationAfterWriteAction> afterWriteOperations = new ArrayList<OperationAfterWriteAction>();
    private Map<TicketField<?>, OperationNewReaStep> fieldChangeReaSteps = new HashMap();
    private TicketVO oldTicket;
    private final int ticketId;
    @Nonnull
    private OperationModelImpl parentModel;

    private OperationChangedTicketImpl(int ticketId) {
        this.ticketId = ticketId;
    }

    public static OperationChangedTicket createForTicket(TicketVO oldTicket, OperationModelImpl model) {
        if (oldTicket == null) {
            throw new IllegalArgumentException("ticket cannot be null!");
        }
        OperationChangedTicketImpl ticket = new OperationChangedTicketImpl(oldTicket.getID());
        ticket.oldTicket = oldTicket;
        ticket.parentModel = model;
        return ticket;
    }

    public static OperationChangedTicket createForNewTicket(MutableTicketData ticketData, MutableTicketAttributes attributes, OperationModelImpl model) {
        OperationChangedTicketImpl ticket = new OperationChangedTicketImpl(model.getIdGenerator().generateNewTicketID());
        ticket.newTicketData.putAll(ticketData);
        ticket.newTicketAttributes.putAll(attributes);
        ticket.parentModel = model;
        return ticket;
    }

    @Override
    public MutableTicketData getNewTicketData() {
        return this.newTicketData;
    }

    @Override
    public MutableTicketAttributes getNewTicketAttributes() {
        return this.newTicketAttributes;
    }

    @Override
    public List<OperationNewReaStep> getAddedReaSteps() {
        return Collections.unmodifiableList(this.addedReaSteps);
    }

    @Override
    public OperationNewReaStep addReaStep(int actionId, @Nonnull MutableReaStepData fields, @Nullable MutableReaStepText text) {
        MutableReaStepAttributes attributes = new MutableReaStepAttributes();
        attributes.put(ReaStepVO.ATTRIBUTE_ACTION_ID, actionId);
        return this.addReaStep(attributes, fields, text);
    }

    @Override
    public OperationNewReaStep addReaStep(@Nonnull MutableReaStepAttributes attributes, @Nonnull MutableReaStepData fields, @Nullable MutableReaStepText text) {
        Integer actionid = attributes.get(ReaStepVO.ATTRIBUTE_ACTION_ID);
        if (actionid == null) {
            throw new IllegalArgumentException("ActionId must be specified in attributes!");
        }
        MutableReaStepData additionalReaStepData = WithAdditionalReaStepData.getAdditionalReaStepData();
        if (additionalReaStepData != null) {
            additionalReaStepData.putAll(fields);
            fields = additionalReaStepData;
        } else {
            fields = fields.copy();
        }
        this.setBunIdAndBundleVisibleAttributeForNewReaStep(this, actionid, attributes);
        if (!attributes.containsAttribute(ReaStepVO.ATTRIBUTE_USER_ID)) {
            attributes.put(ReaStepVO.ATTRIBUTE_USER_ID, this.replaceWithNullIfPrivileged(OperationChangedTicketImpl.getCurrentUserAccountOrThrowISE().getID()));
        }
        if (!fields.containsField(ReaStepVO.FIELD_PROCESSING_TIME)) {
            fields.put(ReaStepVO.FIELD_PROCESSING_TIME, ProcessingTime.ofEffort(0));
        }
        OperationNewReaStepImpl step = new OperationNewReaStepImpl(this.parentModel.getIdGenerator().generateNewReaStepID(), attributes, fields, text);
        this.addedReaSteps.add(step);
        return step;
    }

    private GUID replaceWithNullIfPrivileged(GUID accountID) {
        if (UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)accountID)) {
            return null;
        }
        return accountID;
    }

    public static UserAccount getCurrentUserAccountOrThrowISE() throws IllegalStateException {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account == null) {
            throw new IllegalStateException("No user is logged in.");
        }
        return account;
    }

    private void setBunIdAndBundleVisibleAttributeForNewReaStep(OperationChangedTicket ticket, int actionId, MutableReaStepAttributes attributes) {
        if (attributes.containsAttribute(ReaStepVO.ATTRIBUTE_ORG_BUN_ID) || attributes.containsAttribute(ReaStepVO.ATTRIBUTE_BUN_ID)) {
            if (!attributes.containsAttribute(ReaStepVO.ATTRIBUTE_ORG_BUN_ID) || !attributes.containsAttribute(ReaStepVO.ATTRIBUTE_BUN_ID)) {
                throw new IllegalArgumentException("BunId and OrgBunID must be specified together, or none of both to use the default");
            }
        } else if (ticket.isNew()) {
            attributes.put(ReaStepVO.ATTRIBUTE_BUN_ID, ticket.getTicketId());
            attributes.put(ReaStepVO.ATTRIBUTE_ORG_BUN_ID, ticket.getTicketId());
        } else if (!ticket.isNew()) {
            attributes.put(ReaStepVO.ATTRIBUTE_BUNDLE_VISIBLE, ticket.getOldTicket().get().isMasterInBundle() && Actions.isVisibleForBundleEnduser(actionId));
            attributes.put(ReaStepVO.ATTRIBUTE_BUN_ID, Actions.isMoveReaStepWithActionFromBundleSlaveToMaster(actionId) ? ticket.getOldTicket().get().getBundleID() : ticket.getOldTicket().get().getID());
            attributes.put(ReaStepVO.ATTRIBUTE_ORG_BUN_ID, ticket.getOldTicket().get().getID());
        }
    }

    @Override
    public List<OperationChangedReaStep> getChangedReaSteps() {
        return Collections.unmodifiableList(this.changedReaSteps);
    }

    public OperationChangedReaStep changeReaStep(int reaStepId, int bunId) {
        OperationChangedReaStep step = this.changeReaStep(reaStepId);
        ((OperationChangedReaStepImpl)step).setBunId(bunId);
        return step;
    }

    @Override
    public OperationChangedReaStep changeReaStep(int reaStepId, MutableReaStepText text) {
        OperationChangedReaStep step = this.changeReaStep(reaStepId);
        step.setText(text);
        return step;
    }

    @Override
    public OperationChangedReaStep changeReaStep(int reaStepId) {
        Optional<OperationChangedReaStep> first = this.changedReaSteps.stream().filter(t -> reaStepId == t.getReaStepId()).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        OperationChangedReaStepImpl step = new OperationChangedReaStepImpl(reaStepId);
        this.changedReaSteps.add(step);
        return step;
    }

    @Override
    public List<OperationAfterWriteAction> getAfterWriteOperations() {
        return this.afterWriteOperations;
    }

    @Override
    public Optional<TicketVO> getOldTicket() {
        return Optional.ofNullable(this.oldTicket);
    }

    @Override
    public boolean isNew() {
        return this.oldTicket == null;
    }

    @Override
    public <X> X getFieldValue(TicketField<X> field) {
        if (this.newTicketData.containsKey(field)) {
            return this.newTicketData.get(field);
        }
        if (!this.isNew()) {
            return this.oldTicket.getValue(field);
        }
        return null;
    }

    @Override
    public <X> X getAttributeValue(TicketAttribute<X> field) {
        if (this.newTicketAttributes.containsAttribute(field)) {
            return this.newTicketAttributes.get(field);
        }
        if (!this.isNew()) {
            return this.oldTicket.getAttribute(field);
        }
        return null;
    }

    @Override
    public TicketOperationModel getParentModel() {
        return this.parentModel;
    }

    @Override
    public int getTicketId() {
        return this.ticketId;
    }

    @Override
    public void remove(OperationNewReaStep reaStep) {
        this.addedReaSteps.remove(reaStep);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNew()) {
            sb.append("New Ticket");
            if (this.ticketId != -1) {
                sb.append(" ID=" + this.ticketId);
            }
        } else {
            sb.append("Existing ticket " + this.ticketId);
        }
        sb.append("\n");
        sb.append("new Attributes: ").append(this.newTicketAttributes.toString());
        sb.append("\n");
        sb.append("new Fields: ").append(this.newTicketData.toString());
        sb.append("\n");
        sb.append("new ReaSteps: ").append(this.addedReaSteps.toString());
        sb.append("\n");
        sb.append("modified ReaSteps: ").append(this.changedReaSteps.toString());
        sb.append("\n");
        sb.append("AfterWrite-Operations: ").append(this.afterWriteOperations.size());
        return sb.toString();
    }

    @Override
    public void createFieldChangeReaStepsIfNeeded(MutableReaStepData additionalReaStepData) {
        if (this.isNew()) {
            return;
        }
        TicketVO old = this.getOldTicket().get();
        Set<TicketField<Object>> fieldsWeMayNeedReaStepFor = this.getNewTicketData().getIncludedFields();
        fieldsWeMayNeedReaStepFor.removeAll(this.fieldChangeReaSteps.keySet());
        if (fieldsWeMayNeedReaStepFor.isEmpty()) {
            return;
        }
        ArrayList<TicketField<Object>> listSort = new ArrayList<TicketField<Object>>(fieldsWeMayNeedReaStepFor);
        Collections.sort(listSort, (o1, o2) -> Integer.compare(o1.getSortPrio(), o2.getSortPrio()));
        for (TicketField ticketField : listSort) {
            this.createFieldChangeReaStepIfNeeded(ticketField, additionalReaStepData);
        }
    }

    private <VALUE> void createFieldChangeReaStepIfNeeded(TicketField<VALUE> field, MutableReaStepData additionalReaStepData) {
        OperationNewReaStep step;
        VALUE newVal;
        VALUE old = this.getOldTicket().get().getFieldOrAttributeValue(field);
        if (!Objects.equals(old, newVal = this.getNewTicketData().get(field)) && (step = field.createStringFieldChangeReaStep(old, newVal, additionalReaStepData, this)) != null) {
            this.fieldChangeReaSteps.put(field, step);
        }
    }

    private class FieldsImpl
    extends MutableTicketData {
        private FieldsImpl() {
        }

        @Override
        public <VALUE> void put(TicketField<VALUE> attribute, VALUE value) {
            this.beforePut(attribute, value);
            super.put(attribute, value);
        }

        @Override
        public void putAll(MutableTicketData fields) {
            fields.getIncludedFields().forEach(ta -> this.beforePut((TicketField)((Object)ta), fields.get(ta)));
            super.putAll(fields);
        }

        @Override
        public <VALUE> void putValidOrDefaultValue(TicketField<VALUE> field, VALUE value) {
            value = field.getValidOrDefaultValue(value, null);
            this.beforePut(field, value);
            super.putValidOrDefaultValue(field, value);
        }

        private <VALUE> void beforePut(TicketField<VALUE> field, VALUE value) {
            OperationNewReaStep reaStep;
            if (!Objects.equals(value, this.get(field)) && (reaStep = OperationChangedTicketImpl.this.fieldChangeReaSteps.get(field)) != null) {
                OperationChangedTicketImpl.this.fieldChangeReaSteps.remove(field);
                OperationChangedTicketImpl.this.addedReaSteps.remove(reaStep);
            }
        }
    }
}

