/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MandatoryFieldsManagerImpl
implements MandatoryFieldsManager {
    private static final ActionVO DUMMY_UPDATE_TICKETDATA_ACTION = new ActionVO(-22333, "Update ticket data", -100, true, 0, 0, 0.0, false, 0, true);
    private static final int ENDUSER = 0;
    private static final int DISPATCHER = 1;
    private static final int RESOURCE = 2;

    public static MandatoryFieldsManagerImpl getInstance() {
        return (MandatoryFieldsManagerImpl)ServerPluginManager.getInstance().getSingleInstance(MandatoryFieldsManager.class);
    }

    private <T> MandatoryFieldVO<T> createFieldVO(TicketField<T> field) {
        TicketFieldDefinition def = Tickets.getFieldDefinitionByKey(field.getKey());
        if (def != null && def.getVisibility() == TicketFieldDefinition.FIELD_VISIBILITY.HIDDEN) {
            return new MandatoryFieldVO<Object>(field, false, false, MandatoryFieldVO.MandatoryType.HIDDEN, null, false, false);
        }
        return new MandatoryFieldVO<Object>(field, field.isMandatoryForDispatcher(), field.isMandatoryForResourceMember(), field.getEnduserEditability(), field.getDefaultValue(), field.isDefaultMustBeChangedForDispatcher(), field.isDefaultMustBeChangedForResourceMember());
    }

    public void checkMandatoryFieldsForUpdateTicketData(TicketVO ticket, MutableTicketData ticketData, ExtensionArguments extArgs) {
        Map<TicketField<?>, String> fields = this.getMandatoryFields(ticket, DUMMY_UPDATE_TICKETDATA_ACTION, f -> ticketData.get(f), TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID()), extArgs);
        if (!fields.isEmpty()) {
            throw new IllegalArgumentException(fields.values().iterator().next());
        }
    }

    public void checkMandatoryUserValuesOnTicketCreation(MutableTicketData ticketData, ExtensionArguments extArgs) {
        ActionVO action = (ActionVO)ActionManager.getInstance().get(4);
        Map<TicketField<?>, String> fields = this.getMandatoryFields(null, action, f -> ticketData.get(f), TicketPermissionContext.artificialTicketOwner(), extArgs);
        if (!fields.isEmpty()) {
            throw new IllegalArgumentException(fields.values().iterator().next());
        }
    }

    public void checkMandatoryDispatcherValuesOnTicketCreation(MutableTicketData ticketData, ExtensionArguments extArgs) {
        ActionVO action = (ActionVO)ActionManager.getInstance().get(5);
        Map<TicketField<?>, String> fields = this.getMandatoryFields(null, action, f -> ticketData.get(f), TicketPermissionContext.artificialDispatcherForInquiry(), extArgs);
        if (!fields.isEmpty()) {
            throw new IllegalArgumentException(fields.values().iterator().next());
        }
    }

    public void checkMandatoryFields(TicketVO ticket, ActionVO action, MutableTicketData finalTicketData, TicketPermissionContext ticketPermissionInfo, ExtensionArguments extensionArgs) {
        Map<TicketField<?>, String> fields = this.getMandatoryFields(ticket, action, f -> finalTicketData.get(f), ticketPermissionInfo, extensionArgs);
        if (!fields.isEmpty()) {
            throw new IllegalArgumentException(fields.values().iterator().next());
        }
    }

    private Map<TicketField<?>, String> getMandatoryFields(@Nullable TicketVO ticket, ActionVO action, Function<TicketField<?>, ?> valueProvider, TicketPermissionContext ticketPermissionInfo, ExtensionArguments extensionArgs) {
        int modus;
        Predicate<MandatoryFieldVO> filter;
        HashMap requiredFields = new HashMap();
        if (ticket != null && MandatoryFieldsManagerImpl.mustCheckMandatorySupporterFields(ticket, ticketPermissionInfo, action)) {
            filter = vo -> vo.isRequiredForSupporter() || vo.isDefaultMustBeChangedSupporter();
            modus = 2;
        } else if (action.getId() == 5 || ticket != null && ticket.isInquiry() && Status.isClosedStatus(action.getStatusID())) {
            filter = vo -> vo.isRequiredForDispatcher() || vo.isDefaultMustBeChangedDispatcher();
            modus = 1;
        } else if (action.getId() == 4) {
            filter = f -> f.getUserMandatorySetting() == MandatoryFieldVO.MandatoryType.REQUIRED;
            modus = 0;
        } else {
            modus = 0;
            filter = f -> false;
        }
        DynamicExtensionManager.getInstance().get(TicketField.class).stream().map(f -> this.createFieldVO((TicketField)((Object)f))).filter(filter).forEach(mandatField -> {
            boolean fieldIsRequired;
            String message = this.checkValueInternal(mandatField.getTicketField(), valueProvider.apply(mandatField.getTicketField()), fieldIsRequired, switch (modus) {
                case 0 -> {
                    fieldIsRequired = mandatField.getUserMandatorySetting() == MandatoryFieldVO.MandatoryType.REQUIRED;
                    yield mandatField.getDefaultValueToBeChanged();
                }
                case 1 -> {
                    fieldIsRequired = mandatField.isRequiredForDispatcher();
                    yield mandatField.isDefaultMustBeChangedDispatcher() ? mandatField.getDefaultValueToBeChanged() : null;
                }
                case 2 -> {
                    fieldIsRequired = mandatField.isRequiredForSupporter();
                    yield mandatField.isDefaultMustBeChangedSupporter() ? mandatField.getDefaultValueToBeChanged() : null;
                }
                default -> throw new IllegalStateException(String.valueOf(modus));
            });
            if (message != null) {
                requiredFields.put(mandatField.getTicketField(), message);
            }
        });
        ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class).forEach(factory -> requiredFields.putAll(factory.checkForMandatoryFields(ticket, action, f -> {
            String message = this.checkValueInternal((TicketField<?>)((Object)((Object)f)), valueProvider.apply((TicketField<?>)((Object)f)), true, null);
            if (message != null) {
                requiredFields.put((TicketField<?>)((Object)f), message);
            }
        }, extensionArgs)));
        return requiredFields;
    }

    @Override
    public Map<TicketField<?>, String> getInfoAboutFieldsToChangeBeforeAction(TicketVO ticket, ActionVO actionToApply) {
        return this.getInfoAboutFieldsToChangeBeforeActionWithExtArgs(ticket, actionToApply, ExtensionArguments.create());
    }

    @Override
    public Map<TicketField<?>, String> getInfoAboutFieldsToChangeBeforeActionWithExtArgs(TicketVO ticket, ActionVO actionToApply, ExtensionArguments extArgs) {
        return this.getMandatoryFields(ticket, actionToApply, f -> ticket.getValue(f), TicketManager.getTicketPermissionChecker().getTicketPermissionInfo(ticket.getID()), extArgs);
    }

    private String checkValueInternal(TicketField<?> field, Object value, boolean fieldIsRequired, Object noValue) {
        if (fieldIsRequired && (value == null || value instanceof String && ((String)value).isBlank() || this.classificationSonderhack(field, value))) {
            return Tickets.MSG.getMsg("error.missingFieldValue", new Object[]{field.getLabel(ClientLocale.getThreadLocale())});
        }
        if (!(noValue == null || noValue instanceof String && ((String)noValue).isBlank() || !noValue.equals(value))) {
            return Tickets.MSG.getMsg("error.defaultValueMustBeChanged", new Object[]{field.getLabel()});
        }
        return null;
    }

    private boolean classificationSonderhack(TicketField<?> field, Object value) {
        return field == Tickets.FIELD_CLASSIFICATION_ID && value instanceof Integer && (Integer)value == 0;
    }

    @Override
    public List<MandatoryFieldVO> getMandatoryFieldSettings() {
        return DynamicExtensionManager.getInstance().get(TicketField.class).stream().map(f -> this.createFieldVO((TicketField)((Object)f))).collect(Collectors.toList());
    }

    public static boolean mustCheckMandatorySupporterFields(TicketVO ticket, TicketPermissionContext ticketPermissionInfo, ActionVO action) {
        int status;
        int n = status = action.getStatusID() >= 0 ? action.getStatusID() : ticket.getStatusID();
        if (Status.isDeletedStatus(status)) {
            return false;
        }
        if (action.getId() == -22) {
            return false;
        }
        if (action.getId() == -33) {
            return false;
        }
        if (action.getId() == -16) {
            return false;
        }
        if (!ticketPermissionInfo.hasResourceAccessToTicket()) {
            return false;
        }
        if (!ticket.isOpenAndDispatched()) {
            return false;
        }
        if (!(ticket instanceof TicketVOSingle)) {
            return false;
        }
        return !HDUsersAndGroups.isPrivilegedUser(UserManager.getInstance().getCurrentUserAccountID());
    }
}

