/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.access;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.IllegalArgumentExceptionWithErrorCode;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.ticketmanager.internal.MandatoryFieldsManagerImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import javax.annotation.Nullable;

public class TicketActionValidator {
    public static void validate(OperationChangedTicket changedTicket, ActionVO action, MutableReaStepData reaStepData, @Nullable ReaStepTextVO text, @Nullable ExtensionArguments extensionArgs, TicketPermissionContext ticketPermissionInfo) {
        TicketVO ticket = changedTicket.createIntermediateTicketVO();
        if (extensionArgs == null) {
            extensionArgs = ExtensionArguments.create();
        }
        if (!Boolean.TRUE.equals(extensionArgs.get(ExtensionArguments.EXTARG_IMPLICIT_AUTO_ACTION))) {
            if ((action.getSpecial() & 2) == 2 && (text == null || text.isEmpty())) {
                throw new IllegalArgumentExceptionWithErrorCode(Tickets.MSG.getMsg("error.actionRequiresText", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_FIELD_VALUE_NOT_VALID);
            }
            if (ServerOptions.isOptionSet(0x800000) && TicketActionValidator.actionRequiresEffort(action) && (ticketPermissionInfo.hasResourceAccessToTicket() || ticketPermissionInfo.hasDispatcherAccessToTicket()) && !reaStepData.containsField(ReaStepVO.FIELD_PROCESSING_TIME)) {
                throw new IllegalArgumentExceptionWithErrorCode(Tickets.MSG.getMsg("error.effortRequired", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_FIELD_VALUE_NOT_VALID);
            }
        }
        MutableTicketData data = TicketActionValidator.generateFinalTicketData(ticket, extensionArgs);
        MandatoryFieldsManagerImpl.getInstance().checkMandatoryFields(ticket, action, data, ticketPermissionInfo, extensionArgs);
        int actionid = action.getId();
        switch (actionid) {
            case -22: {
                if (!extensionArgs.containsExtArg(ExtensionArguments.EXTARG_CHANGED_REA_STEP)) {
                    throw new IllegalArgumentException("ExtensionArguments.EXTARG_CHANGED_REA_STEP must be set in the ExtensionArguments");
                }
                ExtensionArguments.EditReastepTextActionExtensionData changeReaStepData = extensionArgs.get(ExtensionArguments.EXTARG_CHANGED_REA_STEP);
                if (changeReaStepData instanceof ExtensionArguments.EditReastepTextActionExtensionData) break;
                throw new IllegalArgumentException("ExtensionArguments.EXTARG_CHANGED_REA_STEP must be of type ExtensionArguments.EditReastepTextActionExtensionData");
            }
            case 7: {
                if (!ticketPermissionInfo.hasEnduserAccessToTicket() || text != null && !text.isEmpty()) break;
                UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                if (currentUserAccount != null && HDUsersAndGroups.isSupporter(currentUserAccount)) {
                    throw new IllegalArgumentExceptionWithErrorCode(Tickets.MSG.getMsg("error.deleteRequiresText.whenEnduserAccessAsSupporter", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_FIELD_VALUE_NOT_VALID);
                }
                throw new IllegalArgumentExceptionWithErrorCode(Tickets.MSG.getMsg("error.actionRequiresText", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_FIELD_VALUE_NOT_VALID);
            }
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                Long deadline = ticket.getDeadline();
                if (deadline != null && deadline < System.currentTimeMillis()) {
                    throw new IllegalArgumentException(Tickets.MSG.getMsg("error.deadlineInPast", new Object[0]));
                }
                String subject = ticket.getSubject();
                ReaStepTextVO initReaStepText = changedTicket.createIntermediateInitialReaStepTextVO();
                if ((subject == null || subject.isEmpty()) && (initReaStepText == null || initReaStepText.isEmpty())) {
                    throw new IllegalArgumentExceptionWithErrorCode(Tickets.MSG.getMsg("error.missingSubjectOrTicketText", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_FIELD_VALUE_NOT_VALID);
                }
                ExtensionArguments.DispatchNow dn = extensionArgs.get(ExtensionArguments.EXTARG_DISPATCH_NOW);
                if (dn != ExtensionArguments.DispatchNow.ALWAYS || ticketPermissionInfo.isDispatcher()) break;
                throw new IllegalArgumentException("Can only specify DispatchNow.ALWAYS for an inquiry if the user is dispatcher!");
            }
            default: {
                if (action.getId() != -7 && action.getStatusID() != 211) break;
                if (text == null || text.isEmpty()) {
                    throw new IllegalArgumentExceptionWithErrorCode(Tickets.MSG.getMsg("error.emailRequiresText", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_FIELD_VALUE_NOT_VALID);
                }
                if (!extensionArgs.containsExtArg(ExtensionArguments.EXTARG_APPLY_ANSWER)) {
                    throw new IllegalArgumentException("ExtensionArguments.EXTARG_APPLY_ANSWER must be set in the ExtensionArguments");
                }
                ExtensionArguments.AdditionalEmailAction applyAnswerData = extensionArgs.get(ExtensionArguments.EXTARG_APPLY_ANSWER);
                if (!(applyAnswerData instanceof ExtensionArguments.AdditionalEmailAction)) {
                    throw new IllegalArgumentException("ExtensionArguments.EXTARG_APPLY_ANSWER must be of type ExtensionArguments.AdditionalEmailAction");
                }
                String receiversTo = reaStepData.get(ReaStepVO.FIELD_EMAIL_AN);
                String receiversCc = reaStepData.get(ReaStepVO.FIELD_EMAIL_CC);
                String receiversBcc = reaStepData.get(ReaStepVO.FIELD_EMAIL_BCC);
                if (!(receiversTo != null && !receiversTo.isEmpty() || receiversCc != null && !receiversCc.isEmpty() || receiversBcc != null && !receiversBcc.isEmpty())) {
                    throw new IllegalArgumentExceptionWithErrorCode(Tickets.MSG.getMsg("error.emailRequiresReceiver", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_FIELD_VALUE_NOT_VALID);
                }
                String senderAddress = reaStepData.get(ReaStepVO.FIELD_EMAIL_IN);
                if (senderAddress != null && !senderAddress.isEmpty()) break;
                throw new IllegalArgumentExceptionWithErrorCode(Tickets.MSG.getMsg("error.emailRequiresSender", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_FIELD_VALUE_NOT_VALID);
            }
        }
    }

    private static MutableTicketData generateFinalTicketData(TicketVO ticket, ExtensionArguments extensionArgs) {
        MutableTicketData data = extensionArgs != null && extensionArgs.containsExtArg(ExtensionArguments.EXTARG_TICKET_DATA) ? extensionArgs.get(ExtensionArguments.EXTARG_TICKET_DATA).copy() : new MutableTicketData();
        ticket.getIncludedFields().stream().forEach(f -> {
            if (!data.containsKey((TicketField<?>)((Object)f))) {
                data.put(f, ticket.getValue(f));
            }
        });
        return data;
    }

    private static boolean actionRequiresEffort(ActionVO action) {
        switch (action.getId()) {
            case -12: 
            case -3: 
            case -2: 
            case 7: 
            case 8: 
            case 10: {
                return false;
            }
        }
        switch (action.getStatusID()) {
            case 101: 
            case 150: 
            case 260: {
                return false;
            }
        }
        return !action.isInternal();
    }
}

