/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.access;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.BundleBehavior;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ItilLinkManager;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketActionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.WithTicketGUID;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.ticketmanager.TicketReaderImpl;
import com.inet.helpdesk.ticketmanager.access.TicketPermissionCheckerImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldSettings;
import com.inet.id.GUID;
import com.inet.mail.api.BaseEmail;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.mail.Mail;

public class TicketActionCheckerImpl
implements TicketActionChecker {
    private TicketPermissionCheckerImpl ticketPermissionChecker;
    private TicketReaderImpl readDAO = null;
    private static final ConfigValue<BundleBehavior> BUNDLE_BEHAVIOR_VALUE = new ConfigValue(HDConfigKeys.BUNDLE_BEHAVIOR);
    private static final ConfigValue<Integer> CONTENT_CHANGEABLE = new ConfigValue(HDConfigKeys.PROCESSING_CONTENT_CHANGEABLE_WHEN_CLOSED);

    public TicketActionCheckerImpl(TicketReaderImpl readDAO, TicketPermissionCheckerImpl permissionChecker) {
        this.readDAO = readDAO;
        this.ticketPermissionChecker = permissionChecker;
    }

    @Override
    public List<ActionVO> getAllPossibleActionsForTicket(int ticketid) {
        TicketPermissionContext ticketPermissionInfo = this.ticketPermissionChecker.getTicketPermissionInfo(ticketid);
        if (ticketPermissionInfo == null) {
            return Collections.emptyList();
        }
        TicketVO ticket = this.readDAO.getTicket(ticketid, ticketPermissionInfo);
        ArrayList<ActionVO> possibleActions = new ArrayList<ActionVO>();
        List actions = ActionManager.getInstance().getAll(true);
        HDLogger.debug("Actions available " + actions.size());
        List extensionFactories = ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class);
        for (TicketActionExtensionFactory ticketActionExtensionFactory : extensionFactories) {
            List<ActionVO> result = ticketActionExtensionFactory.additionalActionsForTicket(ticket);
            actions.addAll(result);
        }
        UserRole userrole = this.determineUserRole(ticket, ticketPermissionInfo);
        for (ActionVO actionVO : actions) {
            if (this.checkAction(actionVO, ticket, ticketPermissionInfo) == null) {
                HDLogger.debug("Action Add: " + actionVO.getDisplayValue() + " internal: " + actionVO.isInternal() + " hidden: " + actionVO.isHidden() + " deleted: " + actionVO.isDeleted());
                possibleActions.add(actionVO);
                continue;
            }
            HDLogger.debug("Action not available: " + actionVO.getDisplayValue() + " " + String.valueOf((Object)userrole));
        }
        return possibleActions;
    }

    public ActionCheckError checkAction(ActionVO action, int ticketid, TicketPermissionContext ticketPermissionInfo) {
        TicketVO ticket = this.readDAO.getTicket(ticketid, ticketPermissionInfo);
        if (ticket == null) {
            throw new IllegalArgumentException("Ticket does not exists: " + ticketid);
        }
        return this.checkAction(action, ticket, ticketPermissionInfo);
    }

    private ActionCheckError createTicketSettingMismatchError(String messageKey, Object ... params) {
        return ActionCheckError.createForTicketSettingMismatch(Tickets.MSG.getMsg(messageKey, params));
    }

    private ActionCheckError createAccessDeniedError(String messageKey, Object ... params) {
        return ActionCheckError.createForAccessDenied(Tickets.MSG.getMsg(messageKey, params));
    }

    private ActionCheckError createAccessDeniedErrorActionNotForUser(String actionName) {
        return this.createAccessDeniedError("actionchecker.actionNotForEnduser", actionName);
    }

    private ActionCheckError createAccessDeniedErrorNotModifyInquiry(Integer ticketid) {
        return this.createAccessDeniedError("actionchecker.notModifyInquiry", ticketid);
    }

    private ActionCheckError createIllegalTicketStateError(String messageKey, Object ... params) {
        return ActionCheckError.createForIllegalTicketState(Tickets.MSG.getMsg(messageKey, params));
    }

    private ActionCheckError createIllegalTicketStateErrorForTicketNotOpen(Integer ticketid) {
        return this.createIllegalTicketStateError("actionchecker.ticketNotOpen", ticketid);
    }

    private ActionCheckError createIllegalTicketStateErrorTicketMustNotBeSlave(String actionName, Integer ticketid) {
        return this.createIllegalTicketStateError("actionchecker.ticketMustNotBeSlave", actionName, ticketid);
    }

    @Override
    public ActionCheckError checkAction(ActionVO action, @Nonnull TicketVO ticket, TicketPermissionContext ticketPermissionInfo) {
        int ticketid = ticket.getID();
        if (action == null) {
            return ActionCheckError.createForIllegalArgument(Tickets.MSG.getMsg("error.actionNotSpecified", new Object[0]));
        }
        if (ticketPermissionInfo == null) {
            return ActionCheckError.createForIllegalArgument(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{ticketid}));
        }
        if (UserManager.getInstance().getCurrentUserAccount() == null) {
            return ActionCheckError.createForNotLoggedIn("Login required");
        }
        String actionName = action.getDisplayValue();
        if (action.isDeleted()) {
            return this.createTicketSettingMismatchError("actionchecker.actionIsDeleted", actionName);
        }
        String result = null;
        List extensionFactories = ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class);
        for (TicketActionExtensionFactory ticketActionExtensionFactory : extensionFactories) {
            result = ticketActionExtensionFactory.checkActionPreconditions(ticket, action, ticketPermissionInfo);
            if (result == null) continue;
            return ActionCheckError.createForIllegalTicketState(result);
        }
        if (!this.checkCurrentUserHasPermissionToExecuteAction(action.getId())) {
            return this.createAccessDeniedError("actionchecker.userHasNoPermissionForAction", actionName);
        }
        UserRole userrole = this.determineUserRole(ticket, ticketPermissionInfo);
        if (!(userrole != UserRole.none || this.isInGUIDScope(ticket) && (action.getSpecial() & 4) > 0)) {
            return this.createAccessDeniedError("actionchecker.ticketNoWriteAccess", ticketid);
        }
        return this.checkActionIsValidInTicketAndConfig(action, ticket, ticketPermissionInfo, userrole);
    }

    private ActionCheckError checkActionIsValidInTicketAndConfig(ActionVO action, TicketVO ticket, TicketPermissionContext ticketPermissionInfo, UserRole userrole) {
        int ticketid = ticket.getID();
        String actionName = action.getDisplayValue();
        int contentChangeable = (Integer)CONTENT_CHANGEABLE.get();
        int C_NONE = 0;
        boolean C_TEXT = true;
        int C_ALL = 2;
        block0 : switch (action.getId()) {
            case 4: {
                switch (userrole) {
                    case privileged: {
                        break block0;
                    }
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case -6: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable != C_NONE) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                }
                break;
            }
            case -21: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable != C_NONE) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                }
                break;
            }
            case -14: {
                switch (userrole) {
                    case privileged: {
                        break block0;
                    }
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case 5: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.getStatusID() == -217) break;
                    }
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isInquiry()) {
                            return this.createIllegalTicketStateError("actionchecker.ticketNotAnInquiry", ticketid);
                        }
                        if (this.ticketPermissionChecker.isDispatcher()) break block0;
                        return this.createAccessDeniedError("actionchecker.authorizeAsDispatcher", ticketid);
                    }
                    case dispatcher: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 1: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 2: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateError("actionchecker.slavesCanNotBeClosedOrDeleted", new Object[0]);
                    }
                    case dispatcher: {
                        if (!Status.isClosedOrDeletedStatus(ticket.getStatusID())) break block0;
                        return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                    }
                    case enduser: {
                        if (Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                        }
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateError("actionchecker.slavesCanNotBeClosedOrDeleted", new Object[0]);
                        }
                        if (!ticket.isMasterInBundle()) break block0;
                        return this.createAccessDeniedError("actionchecker.endusersNotCloseOrDeleteTicketInBundles", new Object[0]);
                    }
                }
                break;
            }
            case -10: {
                switch (userrole) {
                    case privileged: {
                        break;
                    }
                    case supporter: {
                        GUID resourceID = ticket.getResourceID();
                        if (resourceID != null) {
                            if (!this.ticketPermissionChecker.checkCanChangeOwnerInTicket(ticketid)) {
                                return this.createTicketSettingMismatchError("actionchecker.noUserChangeInResource", ticketid);
                            }
                        } else {
                            return this.createIllegalTicketStateError("actionchecker.noResourceForTicket", ticketid);
                        }
                    }
                    case dispatcher: {
                        if (this.checkTicketIsDeleted(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable == C_ALL) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -31: {
                switch (userrole) {
                    case privileged: {
                        break;
                    }
                    case supporter: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                        }
                    }
                    case dispatcher: {
                        if (this.checkTicketIsDeleted(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable == C_ALL) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -1: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -17: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                        }
                    }
                    case dispatcher: {
                        if (this.checkTicketIsDeleted(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable == C_ALL) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -5: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    default: {
                        return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
                    }
                }
            }
            case -41: {
                break;
            }
            case -40: {
                if (!this.checkTicketIsDeleted(ticket)) break;
                return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
            }
            case -22: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!Status.isClosedOrDeletedStatus(ticket.getStatusID()) || contentChangeable != C_NONE) break block0;
                        return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -7: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (BaseEmail.isSmtpConfigured()) break block0;
                        return this.createTicketSettingMismatchError("actionchecker.noSmtpHostConfigured", new Object[0]);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -11: 
            case -9: {
                switch (userrole) {
                    case privileged: {
                        break block0;
                    }
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case -13: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (ticket.isMasterInBundle()) break block0;
                        return this.createIllegalTicketStateError("actionchecker.ticketNotMaster", ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 6: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    default: {
                        return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
                    }
                }
            }
            case -15: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                        }
                    }
                    case dispatcher: {
                        if (this.checkTicketIsDeleted(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (this.checkTicketIsClosed(ticket) && contentChangeable != C_ALL) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        MutableTicketData data = new MutableTicketData();
                        data.put(Tickets.FIELD_ITIL_ID, ticket.getValue(Tickets.FIELD_ITIL_ID));
                        ActionCheckError changeNotAllowed = this.checkITILChange(data);
                        if (changeNotAllowed == null) break block0;
                        return changeNotAllowed;
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -28: 
            case -27: 
            case -26: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                        }
                    }
                    case dispatcher: {
                        if (this.checkTicketIsDeleted(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable == C_ALL) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -12: {
                if (Status.isDeletedStatus(ticket.getStatusID())) {
                    return this.createAccessDeniedError("actionchecker.ticketAlreadyDeleted", ticketid);
                }
                switch (userrole) {
                    case dispatcher: 
                    case supporter: {
                        if (!ticketPermissionInfo.isTicketOwner()) {
                            return this.createAccessDeniedError("actionchecker.onlyEnduserComment", ticketid);
                        }
                    }
                    case privileged: 
                    case enduser: {
                        if (!Status.isClosedStatus(ticket.getStatusID())) break block0;
                        if (ticket.getStatusID() >= 360 && ticket.getStatusID() <= 364) {
                            return this.createIllegalTicketStateError("actionchecker.noReactivateOnClosedTicket", ticketid);
                        }
                        if (ticket.getStatusID() >= 365 && ticket.getStatusID() <= 369 && !this.ticketPermissionChecker.isDispatcher()) {
                            return this.createAccessDeniedError("actionchecker.reactivateOnClosedTicketAsDispatcher", ticketid);
                        }
                        if (!TicketActionCheckerImpl.isReactivationTimeExpired(ticket, System.currentTimeMillis())) break block0;
                        return this.createIllegalTicketStateError("actionchecker.noCommentOnClosedTicketAnymore", ticketid);
                    }
                }
                break;
            }
            case 7: {
                switch (userrole) {
                    case supporter: {
                        UserGroupInfo res;
                        GUID resID = ticket.getResourceID();
                        if (resID != null && (res = UserGroupManager.getInstance().getGroup(ticket.getResourceID())) != null && !ResourceFieldSettings.isSet((Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS), 1)) {
                            return this.createTicketSettingMismatchError("actionchecker.resourceDeleteTicketDisabledInConfig", new Object[0]);
                        }
                        if ((ticket.getStatusID() >= 365 && ticket.getStatusID() <= 369 || ticket.isInquiry()) && !this.ticketPermissionChecker.isDispatcher()) {
                            return this.createAccessDeniedError("actionchecker.reactivateOnClosedTicketAsDispatcher", ticketid);
                        }
                    }
                    case privileged: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateError("actionchecker.slavesCanNotBeClosedOrDeleted", new Object[0]);
                        }
                    }
                    case dispatcher: {
                        if (Status.isDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyDeleted", ticketid);
                        }
                        if (ticket.getStatusID() < 360 || ticket.getStatusID() > 364) break block0;
                        return this.createIllegalTicketStateError("actionchecker.noReactivateOnClosedTicket", ticketid);
                    }
                    case enduser: {
                        if (Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                        }
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateError("actionchecker.slavesCanNotBeClosedOrDeleted", new Object[0]);
                        }
                        if (ticket.isMasterInBundle()) {
                            return this.createIllegalTicketStateError("actionchecker.endusersNotCloseOrDeleteTicketInBundles", new Object[0]);
                        }
                        if (ticket.getStatusID() < 360 || ticket.getStatusID() > 369) break block0;
                        return this.createAccessDeniedError("actionchecker.reactivateOnClosedTicketAsDispatcher", ticketid);
                    }
                }
                break;
            }
            case 8: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 3: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                        }
                    }
                    case dispatcher: {
                        if (this.checkTicketIsDeleted(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable == C_ALL) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -36: 
            case -34: 
            case -19: {
                if (ServerPluginManager.getInstance().isPluginLoaded("ticketprocess")) break;
                return ActionCheckError.createForTicketSettingMismatch(String.format("The action %s cannot be used without Process plugin", action.getDisplayValue()));
            }
            case -18: {
                break;
            }
            case -2: {
                switch (userrole) {
                    case supporter: 
                    case enduser: {
                        if (ticket.getStatusID() >= 365 && ticket.getStatusID() <= 369 && !this.ticketPermissionChecker.isDispatcher()) {
                            return this.createAccessDeniedError("actionchecker.reactivateOnClosedTicketAsDispatcher", ticketid);
                        }
                    }
                    case privileged: 
                    case dispatcher: {
                        if (!Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketMustBeClosedOrDeleted", ticketid);
                        }
                        if (ticket.getStatusID() < 360 || ticket.getStatusID() > 364) break block0;
                        return this.createIllegalTicketStateError("actionchecker.noReactivateOnClosedTicket", ticketid);
                    }
                }
                break;
            }
            case -30: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                        }
                    }
                    case dispatcher: {
                        if (this.checkTicketIsDeleted(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable == C_ALL) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -16: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        break block0;
                    }
                }
                return this.createAccessDeniedErrorActionNotForUser(actionName);
            }
            case -25: {
                if (ticket.isSlaveInBundle()) {
                    return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                }
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (ticket.getAttribute(Tickets.ATTRIBUTE_WIEDERVORLAGEDATE) == null && ticket.getAttribute(Tickets.ATTRIBUTE_TERMINVEREINBARUNG) == null) {
                            return this.createIllegalTicketStateError("actionchecker.terminEntfernenOnlyIfTermin", ticketid);
                        }
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                    default: {
                        return this.createAccessDeniedError("actionchecker.ticketNoWriteAccess", ticketid);
                    }
                }
            }
            case 10: {
                if (ticket.isSlaveInBundle()) {
                    return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                }
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -35: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!this.checkTicketIsDeleted(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -29: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                        }
                    }
                    case dispatcher: {
                        if (this.checkTicketIsDeleted(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!this.checkTicketIsClosed(ticket) || contentChangeable == C_ALL) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 9: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -24: {
                switch (userrole) {
                    case privileged: {
                        break block0;
                    }
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case -3: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -33: {
                switch (userrole) {
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        break block0;
                    }
                }
                break;
            }
            default: {
                if (action.getStatusID() == 211) {
                    return this.checkActionIsValidInTicketAndConfig((ActionVO)ActionManager.getInstance().get(-7), ticket, ticketPermissionInfo, userrole);
                }
                if (action.getStatusID() == 101) {
                    return this.checkActionIsValidInTicketAndConfig((ActionVO)ActionManager.getInstance().get(8), ticket, ticketPermissionInfo, userrole);
                }
                if (action.getStatusID() == 150) {
                    return this.checkActionIsValidInTicketAndConfig((ActionVO)ActionManager.getInstance().get(-3), ticket, ticketPermissionInfo, userrole);
                }
                if (action.getStatusID() == 260) {
                    return this.checkActionIsValidInTicketAndConfig((ActionVO)ActionManager.getInstance().get(10), ticket, ticketPermissionInfo, userrole);
                }
                switch (userrole) {
                    case enduser: {
                        if (action.getId() <= 10) break block0;
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                    case privileged: 
                    case dispatcher: {
                        if (action.getId() >= 0 && ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (action.getId() >= 0 && !this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        int folgeStatus = action.getStatusID();
                        if (!action.isInternal() && (folgeStatus > 100 || folgeStatus == -100) && folgeStatus < 300 && folgeStatus != 150) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                }
            }
        }
        return null;
    }

    private UserRole determineUserRole(TicketVO ticket, TicketPermissionContext ticketPermissionInfo) {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account != null && Objects.equals(UserManager.PRIVILEGED_ACCOUNT_ID, account.getID())) {
            return UserRole.privileged;
        }
        if (ticket.isInquiry() && ticketPermissionInfo.getDispatcherAccess() == TicketPermissionContext.TicketAccess.READWRITE) {
            return UserRole.dispatcher;
        }
        if (ticketPermissionInfo.getResourceAccess() == TicketPermissionContext.TicketAccess.READWRITE) {
            return UserRole.supporter;
        }
        if (ticketPermissionInfo.getEnduserAccess() == TicketPermissionContext.TicketAccess.READWRITE) {
            return UserRole.enduser;
        }
        return UserRole.none;
    }

    @Override
    public ActionCheckError checkAction(ActionVO action, int ticketid) {
        return this.checkAction(action, ticketid, this.ticketPermissionChecker.getTicketPermissionInfo(ticketid));
    }

    private boolean checkTicketIsClosed(TicketVO ticket) {
        return Status.isClosedOrDeletedStatus(ticket.getStatusID());
    }

    private boolean checkTicketIsDeleted(TicketVO ticket) {
        return Status.isDeletedStatus(ticket.getStatusID());
    }

    private boolean checkTicketIsOpen(TicketVO ticket) {
        return Status.isOpenStatus(ticket.getStatusID());
    }

    @Override
    public ActionCheckError checkAktionBuendeln(int masterid, List<Integer> slaveTicketIDs) {
        return this.checkAktionBuendeln(masterid, slaveTicketIDs, this.ticketPermissionChecker.getTicketPermissionInfo(masterid));
    }

    public ActionCheckError checkAktionBuendeln(int masterid, List<Integer> slaveTicketIDs, TicketPermissionContext ticketPermissionInfo) throws IllegalArgumentException {
        if (ticketPermissionInfo == null) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{masterid}));
        }
        if (slaveTicketIDs == null) {
            throw new IllegalArgumentException("list of ticket IDs must not be null");
        }
        if (slaveTicketIDs.contains(null)) {
            throw new IllegalArgumentException("list of ticket IDs must not contain null");
        }
        if (slaveTicketIDs.isEmpty()) {
            throw new IllegalArgumentException("list of ticket IDs must not be empty");
        }
        if (slaveTicketIDs.contains(masterid)) {
            throw new IllegalArgumentException(String.format("tickets can not be bundled with themself, ticketID=\"%d\".", masterid));
        }
        ActionCheckError error = this.checkAction((ActionVO)ActionManager.getInstance().get(-1), masterid);
        if (error != null) {
            return error;
        }
        ArrayList<TicketVO> masterTicket = new ArrayList<TicketVO>();
        masterTicket.add(TicketManager.getReader().getTicket(masterid));
        for (Integer slaveid : slaveTicketIDs) {
            error = this.checkAction((ActionVO)ActionManager.getInstance().get(-1), slaveid);
            if (error != null) {
                return error;
            }
            TicketVO slaveticket = this.readDAO.getTicket(slaveid, this.ticketPermissionChecker.getTicketPermissionInfo(slaveid));
            masterTicket.add(slaveticket);
            TicketAttribute processAttribute = Tickets.getAttributeByKey("process.activity");
            if (processAttribute != null && (slaveticket.getAttribute(processAttribute) != null || slaveticket.getAttribute(Tickets.getAttributeByKey("process.mainticketid")) != null)) {
                return this.createIllegalTicketStateError("actionchecker.cannotBundleProcessTicketAsSlave", slaveid);
            }
            ItilLinkManager lm = (ItilLinkManager)ServerPluginManager.getInstance().getSingleInstance(ItilLinkManager.class);
            if (lm.getItilMasterOf(slaveid) != null) {
                return this.createIllegalTicketStateError("actionchecker.ticketAlreadyItilSlave", slaveid);
            }
            if (lm.getItilSlavesLinkedTo(slaveid).isEmpty()) continue;
            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyItilMaster", slaveid);
        }
        BundleBehavior bundleBehavior = (BundleBehavior)((Object)BUNDLE_BEHAVIOR_VALUE.get());
        switch (bundleBehavior) {
            case sameEmailDomainOnly: {
                ArrayList<String[]> allEmails = new ArrayList<String[]>();
                boolean allSameUser = true;
                GUID initialUserGuid = null;
                boolean alreadySetInitialUserGuid = false;
                for (TicketVO s : masterTicket) {
                    GUID o = s.getOwnerID();
                    if (!alreadySetInitialUserGuid) {
                        initialUserGuid = o;
                        alreadySetInitialUserGuid = true;
                    } else if (initialUserGuid != null && o == null || initialUserGuid == null && o != null || initialUserGuid != null && !initialUserGuid.equals((Object)o)) {
                        allSameUser = false;
                    }
                    String email = o == null ? null : (String)UserManager.getInstance().getUserAccount(o).getValue((UserField)UsersAndGroups.FIELD_EMAIL);
                    String[] addresses = Mail.convertToAddressArray(email);
                    allEmails.add(addresses);
                }
                if (allSameUser) {
                    return null;
                }
                String[] masterEmails = (String[])allEmails.get(0);
                boolean sameDomainFound = false;
                for (String emailToTry : masterEmails) {
                    String domainPartToTry = emailToTry.substring(emailToTry.lastIndexOf(64));
                    boolean foundThisDomainInAllUsers = true;
                    for (String[] userEmails : allEmails) {
                        boolean foundForThisUser = false;
                        for (String userEmail : userEmails) {
                            if (!userEmail.endsWith(domainPartToTry)) continue;
                            foundForThisUser = true;
                            break;
                        }
                        if (foundForThisUser) continue;
                        foundThisDomainInAllUsers = false;
                        break;
                    }
                    if (!foundThisDomainInAllUsers) continue;
                    sameDomainFound = true;
                    break;
                }
                if (sameDomainFound) break;
                return this.createIllegalTicketStateError("actionchecker.bundleNotSameDomain", new Object[0]);
            }
            case sameLocationOnly: {
                Integer loc = null;
                boolean alreadySetInitialLocation = false;
                for (TicketVO s : masterTicket) {
                    GUID o = s.getOwnerID();
                    if (!alreadySetInitialLocation) {
                        loc = o == null ? null : (Integer)UserManager.getInstance().getUserAccount(o).getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                        alreadySetInitialLocation = true;
                        continue;
                    }
                    Integer l = o == null ? null : (Integer)UserManager.getInstance().getUserAccount(o).getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                    if (Objects.equals(loc, l)) continue;
                    return this.createIllegalTicketStateError("actionchecker.bundleNotSameLocation", new Object[0]);
                }
                break;
            }
            case sameOwnerOnly: {
                GUID owner = null;
                boolean alreadySetInitialOwner = false;
                for (TicketVO s : masterTicket) {
                    GUID o = s.getOwnerID();
                    if (!alreadySetInitialOwner) {
                        owner = o;
                        alreadySetInitialOwner = true;
                        continue;
                    }
                    if (Objects.equals(owner, o)) continue;
                    return this.createIllegalTicketStateError("actionchecker.bundleNotSameOwner", new Object[0]);
                }
                break;
            }
        }
        return null;
    }

    @Override
    public ActionCheckError checkAktionEditReastepText(int reaid) {
        return this.checkAktionEditReastepText(reaid, null);
    }

    public ActionCheckError checkAktionEditReastepText(int reaid, TicketPermissionContext context) throws IllegalArgumentException {
        ReaStepVO reaVo = TicketManager.getReaderForSystem().getReaStep(reaid);
        if (reaVo == null) {
            throw new IllegalArgumentException("ReaStep does not exists: " + reaid);
        }
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(reaVo.getBunID());
        return this.checkAction((ActionVO)ActionManager.getInstance().get(-22), ticket.getID());
    }

    @Override
    public ActionCheckError checkAktionUpdateTicketData(int ticketId) {
        return this.checkAktionUpdateTicketData(ticketId, null);
    }

    @Override
    public ActionCheckError checkAktionUpdateTicketData(int ticketId, MutableTicketData fields) {
        TicketVO ticket = this.readDAO.getTicket(ticketId, this.ticketPermissionChecker.getTicketPermissionInfo(ticketId));
        return this.checkAktionUpdateTicketData(ticket, fields);
    }

    @Override
    public ActionCheckError checkAktionUpdateTicketData(TicketVO ticket, MutableTicketData fields) {
        ActionCheckError err;
        int ticketId = ticket.getID();
        TicketPermissionContext ticketPermissionInfo = this.ticketPermissionChecker.getTicketPermissionInfo(ticket);
        if (ticketPermissionInfo == null) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{ticketId}));
        }
        boolean isInGUIDScope = this.isInGUIDScope(ticket);
        if (!isInGUIDScope && !ticketPermissionInfo.hasSupporterWriteAccessToTicket()) {
            return this.createAccessDeniedError("actionchecker.ticketNoWriteAccess", ticketId);
        }
        GUID currentUserAccountID = UserManager.getInstance().getCurrentUserAccountID();
        if (this.checkTicketIsDeleted(ticket) && !HDUsersAndGroups.isPrivilegedUser(currentUserAccountID) && (fields == null || fields.getIncludedFields().size() != 1 || fields.get(Tickets.FIELD_ADDITIONAL_ACCESS) == null)) {
            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyDeleted", ticketId);
        }
        if (ticket.isSlaveInBundle() && !TicketActionChecker.ticketDataOnlyContainsTicketLinkings(fields)) {
            return this.createIllegalTicketStateError("actionchecker.updateTicketDataNotForSlave", ticketId);
        }
        if (fields == null) {
            return null;
        }
        if (!(!fields.containsKey(Tickets.FIELD_RESOURCE_GUID) || ticket.isInquiry() || Status.isClosedStatus(ticket.getStatusID()) && (Integer)CONTENT_CHANGEABLE.get() == 2 || this.checkAction((ActionVO)ActionManager.getInstance().get(8), ticketId, ticketPermissionInfo) == null)) {
            return this.createIllegalTicketStateError("actionChecker.resourceCanOnlyBeChangedByEscalation", ticketId);
        }
        if (fields.containsKey(Tickets.FIELD_ITIL_ID) && (err = this.checkITILChange(fields)) != null) {
            return err;
        }
        if (!isInGUIDScope) {
            for (TicketField<Object> field : fields.getIncludedFields()) {
                ActionCheckError msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, field, fields.get(field), ticketPermissionInfo);
                if (msg == null) continue;
                return msg;
            }
        }
        return null;
    }

    private boolean isInGUIDScope(TicketVO ticket) {
        GUID currentTicketGUID = WithTicketGUID.getCurrentTicketGUID();
        return Objects.equals(ticket.getGUID(), currentTicketGUID);
    }

    private ActionCheckError checkITILChange(MutableTicketData fields) {
        ItilManager instance;
        Integer newItil = fields.get(Tickets.FIELD_ITIL_ID);
        if (newItil != null && !(instance = ItilManager.getInstance()).isUsableByCurrentUser(newItil)) {
            ItilVO i = (ItilVO)instance.get(newItil);
            String itilDisplay = i == null ? "???" : i.getDisplayValue();
            return this.createIllegalTicketStateError("actionChecker.itilIsRestricted", itilDisplay);
        }
        return null;
    }

    private ActionCheckError checkIfFieldIsChangedAndNotAllowed(TicketVO ticket, TicketField<?> fieldToChange, Object fieldValue, TicketPermissionContext permissionInfo) {
        if (!Objects.equals(ticket.getValue(fieldToChange), fieldValue)) {
            ActionVO action = (ActionVO)ActionManager.getInstance().get(fieldToChange.getFieldChangeReaStepActionId());
            if (action == null) {
                throw new IllegalStateException("Action does not exists: " + fieldToChange.getFieldChangeReaStepActionId());
            }
            ActionCheckError msg = TicketManager.getTicketActionChecker().checkAction(action, ticket, permissionInfo);
            if (msg != null) {
                return ActionCheckError.createForGivenCode(Tickets.MSG.getMsg("actionchecker.cannotChangeFieldValue", new Object[0]) + " " + msg.getErrorMessage(), msg.getErrorCode());
            }
        }
        return null;
    }

    @Override
    public ActionVO getActionByUniqueID(String uniqueID, int ticketId) {
        List actions = ActionManager.getInstance().getAll(false);
        for (ActionVO actionVO : actions) {
            if (!actionVO.getUniqueID().equals(uniqueID)) continue;
            return actionVO;
        }
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (ticket == null) {
            return null;
        }
        for (TicketActionExtensionFactory ticketActionExtensionFactory : ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class)) {
            List<ActionVO> result = ticketActionExtensionFactory.additionalActionsForTicket(ticket);
            for (ActionVO actionVO : result) {
                if (!actionVO.getUniqueID().equals(uniqueID)) continue;
                return actionVO;
            }
        }
        return null;
    }

    @Override
    public boolean checkCurrentUserHasPermissionToExecuteAction(int actionId) {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account == null || !account.isActive()) {
            HDLogger.debug("ActionChecker: Account is not active");
            return false;
        }
        if (account.getAccountType() == UserAccountType.Administrator) {
            return true;
        }
        if (((Set)account.getValue((UserField)HDUsersAndGroups.FIELD_ALLOWED_ACTIONS)).contains(actionId)) {
            return true;
        }
        for (UserGroupInfo group : UserGroupManager.getInstance().getGroupsForUser(account.getID())) {
            HDLogger.debug("ActionChecker: check group:" + group.getDisplayName() + " " + String.valueOf(group.getValue((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS)));
            if (!group.isActive()) continue;
            if (group.getID().equals((Object)UsersAndGroups.GROUPID_ADMIN)) {
                return true;
            }
            if (!((Set)group.getValue((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS)).contains(actionId)) continue;
            return true;
        }
        ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId);
        return actionVO != null && (actionVO.getSpecial() & 4) > 0;
    }

    public static boolean isReactivationTimeExpired(TicketVO ticket, long timeToCompare) {
        Integer ticket_react_time = (Integer)HDConfigKeys.DEFAULT_TICKET_REACTIVATION_TIME.getCurrent();
        Long closeDate = ticket.getAttribute(Tickets.ATTRIBUTE_CLOSE_DATE);
        if (ticket_react_time != null && closeDate != null) {
            if (ticket_react_time == 0) {
                return true;
            }
            long timeout = closeDate + (long)ticket_react_time.intValue() * 86400000L;
            return timeToCompare > timeout;
        }
        return false;
    }

    @Override
    public Set<Integer> getEffectiveAllowedActionsForCurrentUser() {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        return HDUsersAndGroups.getEffectiveAllowedActionsForUser(account);
    }

    public ActionCheckError checkCreateNewTicket(@Nullable ExtensionArguments extensionArgs) {
        if (extensionArgs != null && extensionArgs.containsExtArg(ExtensionArguments.EXTARG_EMAIL_DATA)) {
            return null;
        }
        if (!this.checkCurrentUserHasPermissionToExecuteAction(4)) {
            return ActionCheckError.createForAccessDenied(Tickets.MSG.getMsg("actionchecker.createTicketNotAllowed", new Object[0]));
        }
        return null;
    }

    public boolean checkActionIndirectlyAllowedAsPriviliged(ActionVO action, int ticketId) {
        try (UserAccountScope p = UserAccountScope.createPrivileged();){
            boolean bl = this.checkActionIndirectlyAllowed(action, ticketId);
            return bl;
        }
    }

    @Override
    public boolean checkActionIndirectlyAllowed(ActionVO action, int ticketId) {
        TicketPermissionContext ticketPermissionInfo = this.ticketPermissionChecker.getTicketPermissionInfo(ticketId);
        if (ticketPermissionInfo == null) {
            return false;
        }
        TicketVO ticket = this.readDAO.getTicket(ticketId, ticketPermissionInfo);
        return this.checkActionIndirectlyAllowed(action, ticket, ticketPermissionInfo);
    }

    public boolean checkActionIndirectlyAllowed(ActionVO action, TicketVO ticket, TicketPermissionContext ticketPermissionInfo) {
        ActionCheckError checkAction = this.checkAction(action, ticket, ticketPermissionInfo);
        if (checkAction == null) {
            return true;
        }
        ArrayList possibleActions = new ArrayList(ActionManager.getInstance().getAll(true));
        List extensionFactories = ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class);
        for (TicketActionExtensionFactory ticketActionExtensionFactory : extensionFactories) {
            List<ActionVO> result = ticketActionExtensionFactory.additionalActionsForTicket(ticket);
            possibleActions.addAll(result);
        }
        possibleActions.removeIf(a -> a.getId() != action.getId());
        for (ActionVO actionVO : possibleActions) {
            if (this.checkAction(actionVO, ticket, ticketPermissionInfo) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public ActionCheckError checkEditReastepData(TicketVOSingle ticket) {
        TicketPermissionContext ticketPermissionInfo = this.ticketPermissionChecker.getTicketPermissionInfo(ticket.getID());
        if (!ticketPermissionInfo.hasSupporterWriteAccessToTicket()) {
            return this.createAccessDeniedError("actionchecker.ticketNoWriteAccess", ticket.getID());
        }
        int contentChangeable = (Integer)CONTENT_CHANGEABLE.get();
        if (this.checkTicketIsClosed(ticket) && contentChangeable != 2) {
            return this.createIllegalTicketStateErrorForTicketNotOpen(ticket.getID());
        }
        if (this.checkTicketIsDeleted(ticket)) {
            return this.createIllegalTicketStateErrorForTicketNotOpen(ticket.getID());
        }
        return null;
    }

    private static enum UserRole {
        none,
        enduser,
        dispatcher,
        supporter,
        privileged;

    }
}

