/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.swing;

import com.inet.helpdesk.core.servlets.rpc.ProxyPacketHandler;
import com.inet.helpdesk.core.ticketmanager.TicketActionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketLinking;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.shared.communication.UpdateTicketLinks;
import java.util.HashSet;

public class UpdateTicketLinksImpl
extends ProxyPacketHandler
implements UpdateTicketLinks {
    public static final int LINK_TO = 2;
    public static final int LINK_FROM = 1;

    @Override
    public Integer createTicketlinks(int linkTyp, int orderID, final int toOrderID) {
        TicketLinking ticketLinking = TicketManager.getTicketLinking();
        TicketVO fromTicket = TicketManager.getReader().getTicket(orderID);
        TicketVO toTicket = TicketManager.getReader().getTicket(toOrderID);
        TicketActionChecker a = TicketManager.getTicketActionChecker();
        MutableTicketData data = new MutableTicketData();
        data.put(Tickets.FIELD_LINKS, new HashSet<Integer>(){
            {
                this.add(toOrderID);
            }
        });
        ActionCheckError error = a.checkAktionUpdateTicketData(fromTicket, data);
        if (error != null) {
            return 4711;
        }
        boolean hasToLink = fromTicket.getLinkedTickets().contains(toOrderID);
        boolean hasBackLink = toTicket.getLinkedTickets().contains(orderID);
        int returnVal = 0;
        if ((linkTyp & 2) > 0 && !hasToLink) {
            returnVal = -1;
        } else if (((linkTyp & 2) > 0 && hasToLink || (linkTyp & 2) == 0) && ((linkTyp & 1) > 0 && hasBackLink || (linkTyp & 1) == 0)) {
            return 1;
        }
        if ((linkTyp & 2) > 0) {
            ticketLinking.addUniDirectionalLink(orderID, toOrderID);
        }
        if ((linkTyp & 1) > 0) {
            ticketLinking.addUniDirectionalLink(toOrderID, orderID);
        }
        return returnVal;
    }

    @Override
    public Class<?> getRemoteInterface() {
        return UpdateTicketLinks.class;
    }

    @Override
    public void removeAllLinksFromTicket(int ticketID) {
        TicketVO fromTicket = TicketManager.getReader().getTicket(ticketID);
        for (Integer linked : fromTicket.getLinkedTickets()) {
            TicketManager.getTicketLinking().removeUniDirectionalLinkBetween(ticketID, linked);
        }
    }

    @Override
    public void removeLink(int fromTicketID, int toTicketID) {
        TicketManager.getTicketLinking().removeUniDirectionalLinkBetween(fromTicketID, toTicketID);
    }
}

