/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.rpc.RPCUtils;
import java.io.Serializable;

@JsonData
public class DataField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Field fieldInstance;
    private String field;
    private String jsonValue;
    private transient boolean fieldResolved = false;

    private DataField() {
        this.field = null;
        this.jsonValue = null;
    }

    public DataField(Field field, Object value) {
        this.fieldInstance = field;
        this.field = field.name();
        this.jsonValue = RPCUtils.toJson(value);
    }

    public DataField(String key, Object value) {
        this.fieldInstance = null;
        this.field = key;
        this.jsonValue = RPCUtils.toJson(value);
    }

    public Field getField() {
        if (this.fieldInstance == null && !this.fieldResolved) {
            this.fieldResolved = true;
            try {
                this.fieldInstance = Field.valueOf(this.field);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.fieldInstance;
    }

    public String getKey() {
        return this.field;
    }

    public <T> T getValue(Class<T> dataClass) {
        return RPCUtils.fromJson(this.jsonValue, dataClass);
    }

    public String getJsonValue() {
        return this.jsonValue;
    }

    public void setJsonValue(String jsonValue) {
        this.jsonValue = jsonValue;
    }

    public String toString() {
        return this.field + "=" + this.jsonValue;
    }
}

