/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared;

import java.util.Map;
import java.util.Properties;

public class LicenceInfo {
    public static final String MAX_USERS = "MaxUsers";
    public static final String MAX_NAMED_USERS = "NamedUsersLicence";
    public static final String NAMED_USERS_COUNT = "NamedUsersCount";
    public static final String USERS_COUNT = "CountOfUsers";
    private static LicenceInfo instance;
    private String version;
    private int usersLicence = 0;
    private int usersCount = 0;
    private int namedUsersLicence = 0;
    private int namedUsersCount = 0;
    private Properties currentSettings;

    private LicenceInfo() {
    }

    public static LicenceInfo getInstance() {
        if (instance == null) {
            instance = new LicenceInfo();
        }
        return instance;
    }

    public void requestLicenceInformations(Properties props) {
        props.put("licencedata", this.version);
    }

    public void updateLicenceInformations(Properties props) {
        if (props.getProperty(MAX_USERS) != null) {
            this.usersLicence = Integer.parseInt(props.getProperty(MAX_USERS));
            this.namedUsersLicence = Integer.parseInt(props.getProperty(MAX_NAMED_USERS));
            this.namedUsersCount = Integer.parseInt(props.getProperty(NAMED_USERS_COUNT));
            this.usersCount = Integer.parseInt(props.getProperty(USERS_COUNT));
            this.version = props.getProperty("licencedata");
            this.currentSettings = props;
        }
    }

    public void setLicenceInformations(Properties props) {
        props.putAll((Map<?, ?>)this.currentSettings);
    }

    public String getVersion() {
        return this.version;
    }

    public String getI18nProblemKey() {
        return this.isNamedUserLicence() ? "msgLizenzNamed" : "msgLizenzUser";
    }

    public boolean gotLicenceProblem() {
        return this.usersCount > this.usersLicence && this.usersLicence != -1 || this.isNamedUserLicence() && this.namedUsersCount > this.namedUsersLicence;
    }

    public boolean isNamedUserLicence() {
        return this.namedUsersLicence > 0;
    }

    public boolean isLicenceValid() {
        return this.usersLicence != 0;
    }

    public boolean newUserPossible() {
        return this.usersLicence > this.usersCount || this.usersLicence == -1;
    }

    public int getNamedUserLicenceCount() {
        return this.namedUsersLicence;
    }

    public int getNamedUserCount() {
        return this.namedUsersCount;
    }

    public int getLicenceCount() {
        if (this.isNamedUserLicence()) {
            return this.getNamedUserLicenceCount();
        }
        return this.usersLicence;
    }

    public int getUsedLicences() {
        if (this.isNamedUserLicence()) {
            return this.getNamedUserCount();
        }
        return this.usersCount;
    }
}

