/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets.rpc.handler;

import com.inet.helpdesk.core.servlets.rpc.ProxyPacketHandler;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.shared.communication.BundleTickets;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BundleTicketsHandler
extends ProxyPacketHandler
implements BundleTickets {
    protected static final String BUNDLE_UPDATE = "UPDATE tblBuendel SET Indiziert = 0, subAuftraege = 1, Bearbeiter = ?, LastEditorID = ?, BearbeitungsDatum = ?, Anlagen = ? WHERE BunID = ?";
    protected static final String REA_RESULTSET = "SELECT * FROM tblRealisierung WHERE 1=0";
    private TicketManipulator manipulator;

    void setManipulator(TicketManipulator manipulator) {
        this.manipulator = manipulator;
    }

    @Override
    public void executeBundlingTickets(Integer masterTicket, String subTickets, boolean attFlag, Integer sessionId) throws IOException {
        if (this.manipulator == null) {
            this.manipulator = TicketManager.getManipulator();
        }
        List<Integer> slaveTicketIDs = Arrays.stream(subTickets.split(",")).map(str -> Integer.valueOf(str.trim())).collect(Collectors.toList());
        this.manipulator.bundleTickets(masterTicket, slaveTicketIDs);
    }

    @Override
    public Class<?> getRemoteInterface() {
        return BundleTickets.class;
    }
}

