/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets.rpc;

import com.inet.authentication.base.LoginManager;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerInitializerStatus;
import com.inet.helpdesk.core.error.IllegalStateExceptionWithErrorCode;
import com.inet.helpdesk.core.servlets.rpc.AbstractPacketHandler;
import com.inet.helpdesk.core.servlets.rpc.HandlerResponseAccess;
import com.inet.helpdesk.core.servlets.rpc.PacketHandler;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.shared.rpc.Packet;
import com.inet.http.ClientMessageException;
import com.inet.http.PluginServlet;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.EncodedWriter;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoStatus;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;

public class JsonRpcServlet
extends HttpServlet
implements PluginServlet {
    private static final long serialVersionUID = 1L;
    private static final Hashtable<String, PacketHandler> HANDLERS = new Hashtable();
    private static final String WINDOWS_LOGIN = "/windowslogin";
    private final ServerInitializerStatus status;
    private Json json = new Json();

    public JsonRpcServlet(ServerInitializerStatus status) {
        this.status = status;
    }

    @Nonnull
    public String getPathSpec() {
        return "/rpc";
    }

    public void init() throws ServletException {
        super.init();
        ServerPluginManager m = ServerPluginManager.getInstance();
        List list = m.get(PacketHandler.class);
        for (PacketHandler packetHandler : list) {
            PacketHandler oldHandler = HANDLERS.put(packetHandler.getCommand(), packetHandler);
            if (oldHandler == null) continue;
            HDLogger.error("Duplicate Json RPC handler for command: " + packetHandler.getCommand() + " [" + String.valueOf(oldHandler) + "," + String.valueOf(packetHandler) + "]");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        block21: {
            try {
                Object reader;
                String contentType;
                VetoStatus currentVeto;
                if (this.status != null && (currentVeto = this.status.getCurrentVeto()) != null) {
                    String msg = currentVeto.getMessage();
                    resp.setStatus(503);
                    this.sendError(resp, msg);
                    return;
                }
                String cmd = request.getPathInfo();
                if (cmd != null && cmd.startsWith("/forceDbAuth")) {
                    cmd = cmd.substring("/forceDbAuth".length());
                }
                boolean needLogin = true;
                if (cmd != null && (WINDOWS_LOGIN.equals(cmd) || cmd.startsWith("/windowslogin/"))) {
                    cmd = cmd.substring(WINDOWS_LOGIN.length());
                } else if ("/mobile_gethelpdesktitle".equals(cmd)) {
                    needLogin = false;
                }
                if (needLogin && !LoginManager.forceLogin((HttpServletRequest)request, (HttpServletResponse)resp)) {
                    return;
                }
                Object input = request.getInputStream();
                String contentEncoding = request.getHeader("Content-Encoding");
                if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                    input = new GZIPInputStream((InputStream)input);
                }
                if ((contentType = request.getHeader("Content-Type")) != null && contentType.startsWith("multipart")) {
                    Part part = request.getPart("json");
                    reader = new EncodedReader(part.getInputStream());
                } else {
                    reader = new EncodedReader((InputStream)input);
                }
                boolean oldPackageStructureUsed = false;
                Packet paket = null;
                if (cmd != null && cmd.length() > 1) {
                    int idx = cmd.indexOf(47, 1);
                    if (idx < 0) {
                        idx = cmd.length();
                    }
                    cmd = cmd.substring(1, idx);
                } else {
                    paket = (Packet)this.json.fromJson((Reader)reader, Packet.class);
                    String paketJson = paket.getJson();
                    reader = new StringReader(paketJson);
                    cmd = paket.getCmd();
                    oldPackageStructureUsed = true;
                }
                PacketHandler handler = HANDLERS.get(cmd);
                if (handler != null) {
                    resp.setContentType("application/helpdesk-json");
                    ServletOutputStream out = resp.getOutputStream();
                    if (handler instanceof HandlerResponseAccess) {
                        EncodedWriter writer = handler.encryptionRequired() ? new EncodedWriter((OutputStream)out) : new UTF8StreamWriter((OutputStream)out);
                        ((HandlerResponseAccess)((Object)handler)).handle(request, resp, (Reader)reader, (Writer)writer);
                        writer.close();
                        break block21;
                    }
                    if (oldPackageStructureUsed) {
                        EncodedWriter writer = handler.encryptionRequired() ? new EncodedWriter((OutputStream)out) : new UTF8StreamWriter((OutputStream)out);
                        try {
                            Method method = handler.getClass().getMethod("handle", HttpServletRequest.class, Packet.class);
                            Object result = method.invoke((Object)handler, request, paket);
                            Packet resultPacket = (Packet)result;
                            AbstractPacketHandler.JSON.toJson((Object)resultPacket, (Appendable)writer);
                        }
                        catch (NoSuchMethodException nope) {
                            StringWriter stringWriter = new StringWriter();
                            handler.handle(request, (Reader)reader, stringWriter);
                            stringWriter.close();
                            Packet resultPacket = new Packet(cmd, "");
                            resultPacket.setJson(stringWriter.toString());
                            AbstractPacketHandler.JSON.toJson((Object)resultPacket, (Appendable)writer);
                        }
                        writer.close();
                        break block21;
                    }
                    EncodedWriter writer = handler.encryptionRequired() ? new EncodedWriter((OutputStream)out) : new UTF8StreamWriter((OutputStream)out);
                    handler.handle(request, (Reader)reader, (Writer)writer);
                    writer.close();
                    break block21;
                }
                this.sendError(resp, "The command cannot be found: " + cmd);
            }
            catch (ClientMessageException cme) {
                HDLogger.error(cme.getMessage());
                this.sendError(resp, cme.getMessage());
            }
            catch (Throwable t) {
                if (t instanceof IllegalStateExceptionWithErrorCode && ((IllegalStateExceptionWithErrorCode)t).getErrorCode() == 7101) {
                    this.sendError(resp, HelpdeskServerPlugin.MSG_SERVER.getMsg("ActionNotAllowedInCurrentState", new Object[0]));
                    return;
                }
                HDLogger.error(t);
                this.sendError(resp, "Exception occurred during handling the request on the server: " + t.toString());
            }
        }
    }

    private void sendError(HttpServletResponse resp, String msg) throws IOException {
        resp.setContentType("application/helpdesk-error-json");
        ServletOutputStream out = resp.getOutputStream();
        UTF8StreamWriter writer = new UTF8StreamWriter((OutputStream)out);
        Packet paket = new Packet("error", msg);
        this.json.toJson((Object)paket, (Appendable)writer);
        writer.close();
    }
}

