/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.search.user.tokenmatchers;

import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.search.user.tokenmatchers.UserConditionTokenMatcher;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SupporterUserConditionTokenMatcher
extends UserConditionTokenMatcher {
    public String getTag() {
        return "supporter";
    }

    @Nonnull
    public String getDisplayName() {
        return "supporter";
    }

    @Override
    @Nullable
    Set<GUID> getAccountIDs(@Nonnull String value) {
        switch (value.toLowerCase()) {
            case "named": {
                return SupporterUserConditionTokenMatcher.getUsersWithPermissions(true, HdPermissions.getNamedUserLicensePermissions());
            }
            case "supporter": 
            case "": {
                return SupporterUserConditionTokenMatcher.getUsersWithPermissions(true, HdPermissions.DISPATCHER, HdPermissions.TICKET_RESOURCES_READ);
            }
            case "dispatcher": {
                return SupporterUserConditionTokenMatcher.getDispatcherIDs();
            }
        }
        return new HashSet<GUID>();
    }

    @Nullable
    public static Set<GUID> getDispatcherIDs() {
        return SupporterUserConditionTokenMatcher.getUsersWithPermissions(false, HdPermissions.DISPATCHER);
    }

    @Nullable
    static Set<GUID> getUsersWithPermissions(boolean ressourceMembers, Permission ... permissions) {
        UserGroupManager groupManager = UserGroupManager.getRecoveryEnabledInstance();
        UserGroupInfo allUsersGroup = groupManager.getGroup(UsersAndGroups.GROUP_ALLUSERS);
        List<Permission> permissionsList = Arrays.asList(permissions);
        if (!((Boolean)SystemPermissionChecker.SYSTEMPERMISSION_ENABLED.get()).booleanValue()) {
            return null;
        }
        Set allUsersPermissions = allUsersGroup.getPermissions();
        if (permissionsList.stream().anyMatch(permissionToCheck -> {
            HashSet<Permission> permissionsPlusParents = new HashSet<Permission>();
            permissionsPlusParents.add((Permission)permissionToCheck);
            while (permissionToCheck.getParentKey() != null) {
                permissionToCheck = Permission.valueOfExistingOrCreate((String)permissionToCheck.getParentKey());
                permissionsPlusParents.add((Permission)permissionToCheck);
            }
            return allUsersPermissions.containsAll(permissionsPlusParents);
        })) {
            return null;
        }
        HashSet<GUID> userIDs = new HashSet<GUID>();
        Set groupResult = groupManager.getSearchEngine().simpleSearch(SupporterUserConditionTokenMatcher.createSearchCommand(permissionsList, true, ressourceMembers, false));
        for (GUID groupID : groupResult) {
            UserGroupInfo groupInfo = groupManager.getGroup(groupID);
            if (groupInfo == null || !groupInfo.isActive()) continue;
            userIDs.addAll(groupInfo.getMemberIDs());
        }
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        Set userResult = userManager.getSearchEngine().simpleSearch(SupporterUserConditionTokenMatcher.createSearchCommand(permissionsList, false, false, true));
        userIDs.addAll(userResult);
        return userIDs;
    }

    @Nonnull
    private static SearchCommand createSearchCommand(List<Permission> namedUserPermissions, boolean isGroup, boolean includeResources, boolean includeAdministartor) {
        OrSearchExpression or = new OrSearchExpression();
        for (Permission permission : namedUserPermissions) {
            or.add((Object)new SearchCondition("permissions", SearchCondition.SearchTermOperator.Equals, (Object)permission.getKey()));
        }
        if (isGroup) {
            or.add((Object)new SearchCondition("grouptype", SearchCondition.SearchTermOperator.Equals, (Object)UsersAndGroups.GROUPTYPE_ADMIN.getName()));
        }
        if (includeResources) {
            or.add((Object)new SearchCondition("grouptype", SearchCondition.SearchTermOperator.Equals, (Object)HDUsersAndGroups.RESOURCE.getName()));
        }
        if (includeAdministartor) {
            or.add((Object)new SearchCondition("useraccounttype", SearchCondition.SearchTermOperator.Equals, (Object)UserAccountType.Administrator.name()));
        }
        return new SearchCommand(new SearchExpression[]{or});
    }
}

