/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.valueprovider;

import com.inet.helpdesk.plugins.reporting.server.valueprovider.CategoryProvider;
import com.inet.helpdesk.plugins.reporting.server.valueprovider.CurrentUserIdValueProvider;
import com.inet.helpdesk.plugins.reporting.server.valueprovider.CurrentUserLocationIdValueProvider;
import com.inet.helpdesk.plugins.reporting.server.valueprovider.HelpdeskValueProvider;
import com.inet.helpdesk.plugins.reporting.server.valueprovider.LocationProvider;
import com.inet.helpdesk.plugins.reporting.server.valueprovider.ResourceProvider;
import com.inet.report.DynamicValueProvider;
import java.util.HashMap;
import java.util.Map;

public class ProviderManager {
    private static ProviderManager manager = new ProviderManager();
    private Map<String, HelpdeskValueProvider> providerMap = new HashMap<String, HelpdeskValueProvider>();

    private ProviderManager() {
        this.addProvider(new ResourceProvider());
        this.addProvider(new CategoryProvider());
        this.addProvider(new LocationProvider());
        this.addProvider(new CurrentUserIdValueProvider());
        this.addProvider(new CurrentUserLocationIdValueProvider());
    }

    private void addProvider(HelpdeskValueProvider hvp) {
        this.providerMap.put(hvp.getPromptName(), hvp);
    }

    public static ProviderManager getInstance() {
        return manager;
    }

    public DynamicValueProvider getProviderInstanceForName(String name) {
        return this.providerMap.get(name);
    }
}

