/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.userfunctions;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class UserDataFunctions
implements UserDefinedFunction {
    public Integer getCurrentUserLocationID() throws AccessDeniedException {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            HDLogger.error("User Login required for id check!");
            return -1;
        }
        return (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
    }

    public String getCurrentUserLocationName() {
        Integer locationID = this.getCurrentUserLocationID();
        return (String)HDUsersAndGroups.FIELD_LOCATION_ID.getSearchTag().getMapData().get(locationID);
    }

    public Integer getCurrentUserGroupID() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            HDLogger.error("User Login required for id check!");
            return -1;
        }
        return (Integer)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
    }

    public String getCurrentUserGroupName() {
        Integer groupID = this.getCurrentUserGroupID();
        return (String)HDUsersAndGroups.FIELD_CLASS_ID.getSearchTag().getMapData().get(groupID);
    }

    public String getCurrentUserCostCenter() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            HDLogger.error("User Login required for id check!");
            return "";
        }
        return (String)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_COST_CENTRE);
    }

    public String getCurrentUserDepartment() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            HDLogger.error("User Login required for id check!");
            return "";
        }
        return (String)currentUserAccount.getValue((UserField)HDUsersAndGroups.FIELD_DEPARTMENT);
    }

    public String getUserDisplayName(Integer id) {
        if (id == null) {
            return "nix";
        }
        return this.getUserDisplayName(HDUsersAndGroups.getUserAccount(id));
    }

    public String getUserDisplayName(String id) {
        if (id != null && id.length() > 0) {
            return this.getUserDisplayName(UserManager.getInstance().getUserAccount(new GUID(id)));
        }
        return id;
    }

    private String getUserDisplayName(UserAccount ua) {
        if (ua == null) {
            return "";
        }
        return ua.getDisplayName();
    }

    public String getUserDisplayNameFull(int id) {
        UserAccount ua = HDUsersAndGroups.getUserAccount(id);
        if (ua == null) {
            return "";
        }
        String displayName = ua.getDisplayName();
        List logins = ua.getLoginSettings();
        for (LoginSettings login : logins) {
            if (!"system".equals(login.getLoginSource()) || displayName.equals(login.getLoginID())) continue;
            return displayName + " (" + login.getLoginID() + ")";
        }
        return displayName;
    }

    public String getUserDisplayNameLoginVersion(int id) {
        UserAccount ua = HDUsersAndGroups.getUserAccount(id);
        if (ua == null) {
            return "";
        }
        String displayName = ua.getDisplayName();
        List logins = ua.getLoginSettings();
        for (LoginSettings login : logins) {
            if (!"system".equals(login.getLoginSource())) continue;
            return login.getLoginID() + " (" + displayName + ")";
        }
        return displayName;
    }

    public int getCurrentUserID() {
        int id = HDUsersAndGroups.getUserID(UserManager.getInstance().getCurrentUserAccount());
        if (id == -1) {
            HDLogger.error("User Login required for id check!");
        }
        return id;
    }

    public String htmlToText(String input) {
        return HtmlConverter.html2text((String)input);
    }

    public String getUserFieldValue(int id, String fieldKey) {
        UserAccount ua = HDUsersAndGroups.getUserAccount(id);
        if (ua != null) {
            Set includedFields = ua.getIncludedFields();
            Optional<UserField> findFirst = includedFields.stream().filter(c -> fieldKey.equals(c.getKey())).findFirst();
            if (findFirst.isPresent()) {
                Object value = ua.getValue(findFirst.get());
                if (value != null) {
                    HDLogger.debug("value for field is -" + String.valueOf(value) + "-");
                    if (value instanceof Long) {
                        DateFormat dF = DateFormat.getDateTimeInstance(1, 3);
                        return dF.format(new Date((Long)value));
                    }
                    return value.toString();
                }
                HDLogger.debug("No value available for field " + fieldKey + " " + id);
            } else {
                HDLogger.error("No field available for key " + fieldKey);
            }
        } else {
            HDLogger.error("No user available for id " + id);
        }
        return "";
    }
}

