/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.datasource;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeGUID;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.reporting.HDReporting;
import com.inet.helpdesk.core.reporting.TicketDataSourceConfigurationExtension;
import com.inet.helpdesk.core.reporting.server.datasource.ITicketDataSourceConfiguration;
import com.inet.helpdesk.core.reporting.server.dataview.DataViewConditions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.search.SearchTagBundleSlave;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Datasource;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class TicketDataSourceConfiguration
extends BaseDataFactory
implements ITicketDataSourceConfiguration {
    public boolean getReportDataPerInstance() {
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nonnull
    public TableData getTableSourceData(final @Nonnull TableSource ts) throws ReportException {
        ArrayList columns = new ArrayList();
        final List<Map.Entry<String, HDReporting.ColumnInfoWithLabel>> cols = this.getColumnPairs(ts.getDatabaseIdentifier());
        cols.stream().filter(c -> ((HDReporting.ColumnInfoWithLabel)((Object)((Object)c.getValue()))).getColumnType() == 3).forEach(c -> columns.add(((HDReporting.ColumnInfoWithLabel)((Object)((Object)c.getValue()))).getName()));
        List prompts = ts.getInputParameters();
        final Set<Object> searchResult = prompts.size() > 0 ? this.getTicketsByParameter(ts) : Collections.emptySet();
        final @Nonnull List extensions = ServerPluginManager.getInstance().get(TicketDataSourceConfigurationExtension.class);
        SimpleResultSet rs = new SimpleResultSet(columns.toArray(new String[columns.size()])){
            private final Iterator<Integer> ids;
            private TicketVO ticket;
            {
                super(arg0);
                this.ids = searchResult.iterator();
            }

            public boolean next() throws SQLException {
                while (this.ids.hasNext()) {
                    Integer id = this.ids.next();
                    this.ticket = TicketManager.getReader().getTicket(id);
                    if (this.ticket == null) continue;
                    this.getAllRows().add(new Object[0]);
                    return super.next();
                }
                return false;
            }

            public Object getObject(int columnIndex) throws SQLException {
                Object value;
                Map.Entry col = (Map.Entry)cols.get(columnIndex - 1);
                String key = (String)col.getKey();
                if (key.equals("ticketownerid")) {
                    return this.ticket.getOwnerID() == null ? null : Integer.valueOf(HDUsersAndGroups.getUserID(this.ticket.getOwnerID()));
                }
                if (key.equals("ticketText")) {
                    ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(this.ticket.getInitialReaStepID());
                    return reaStepText.getText();
                }
                if (key.equals("ticketTextIsHtml")) {
                    return TicketManager.getReader().getReaStepText(this.ticket.getInitialReaStepID()).hasHtmlContent();
                }
                for (TicketDataSourceConfigurationExtension ext : extensions) {
                    if (!ext.canHandle(key)) continue;
                    return ext.getColumnData(this.ticket, key);
                }
                TicketFieldDefinition def = Tickets.getFieldDefinitionByKey(key);
                Field<?> field = TicketDataSourceConfiguration.this.getFieldOrAttributeFromKey(key);
                if (field != null) {
                    value = this.ticket.getFieldOrAttributeValue(field);
                    if (ts.getDatabaseIdentifier().equals("TicketAdhoc") && !HDReporting.showDisplayValueForField(field) || !ts.getDatabaseIdentifier().equals("TicketAdhoc") && TicketDataSourceConfiguration.this.isKnownType(field.getFieldType())) {
                        if (value != null) {
                            value = HDReporting.convertFieldValueToReportingValue(value, field);
                        }
                    } else {
                        value = def.getDisplayValue(this.ticket);
                    }
                } else {
                    value = def.getDisplayValue(this.ticket);
                }
                return value;
            }
        };
        return new TableData((ResultSet)rs);
    }

    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        HashMap<String, TableSourceInfo> result = new HashMap<String, TableSourceInfo>();
        result.put("TicketById", new TableSourceInfo(null, null, "TicketById", 20));
        result.put("TicketAdhoc", new TableSourceInfo(null, null, "TicketAdhoc", 20));
        return result;
    }

    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        String table;
        switch (table = ts.getDatabaseIdentifier()) {
            case "TicketById": 
            case "TicketAdhoc": {
                break;
            }
            default: {
                HDLogger.debug(new IllegalArgumentException("[TicketDataSourceConfiguration] Illegal attempt to getColumns for unknown table " + table));
                return List.of();
            }
        }
        List<ColumnInfo> collect = this.getColumnPairs(table).stream().map(p -> (HDReporting.ColumnInfoWithLabel)((Object)((Object)p.getValue()))).collect(Collectors.toList());
        this.addPromptParameter(collect, ts);
        return collect;
    }

    private boolean isKnownType(FieldType<?> fieldType) {
        return fieldType instanceof FieldTypeDate || fieldType instanceof FieldTypeTime || fieldType instanceof FieldTypeGUID || fieldType instanceof FieldTypeCurrency || fieldType instanceof FieldTypeDouble || fieldType instanceof FieldTypeString || fieldType instanceof FieldTypeBoolean || fieldType instanceof FieldTypeSelect_String || fieldType instanceof FieldTypeSelect_Int || fieldType instanceof FieldTypeInteger;
    }

    private List<Map.Entry<String, HDReporting.ColumnInfoWithLabel>> getColumnPairs(String table) {
        ArrayList<Map.Entry<String, HDReporting.ColumnInfoWithLabel>> cols = new ArrayList<Map.Entry<String, HDReporting.ColumnInfoWithLabel>>();
        List list = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        Collections.sort(list, (d1, d2) -> d1.getPriority() - d2.getPriority());
        if (table.equals("TicketAdhoc")) {
            cols.add(Map.entry("ticketownerid", new HDReporting.ColumnInfoWithLabel("ticketownerid", "ticketownerid", 6)));
            cols.add(Map.entry(Tickets.ATTRIBUTE_CLOSE_DATE.getKey(), new HDReporting.ColumnInfoWithLabel(Tickets.ATTRIBUTE_CLOSE_DATE.getKey(), Tickets.ATTRIBUTE_CLOSE_DATE.getLabel(), 9)));
            cols.add(Map.entry("ticketText", new HDReporting.ColumnInfoWithLabel("ticketText", MSG.getMsg("column_ticketText", new Object[0]), 11)));
            cols.add(Map.entry("ticketTextIsHtml", new HDReporting.ColumnInfoWithLabel("ticketTextIsHtml", "ticketTextIsHtml", 8)));
        }
        for (TicketFieldDefinition fieldDef : list) {
            if (fieldDef.getDisplayType() == null || !fieldDef.isAvailable()) continue;
            Field<?> field = this.getFieldOrAttributeFromKey(fieldDef.getKey());
            if (table.equals("TicketAdhoc") && HDReporting.showDisplayValueForField(field)) {
                cols.add(Map.entry(fieldDef.getKey(), new HDReporting.ColumnInfoWithLabel(fieldDef.getKey(), fieldDef.getDisplayName(), 11)));
                continue;
            }
            int reportFieldType = field == null ? 11 : (field.getFieldType() instanceof FieldTypeDate ? (((FieldTypeDate)field.getFieldType()).isDateWithTime() ? 15 : 9) : (field.getFieldType() instanceof FieldTypeString ? 11 : (field.getFieldType() instanceof FieldTypeBoolean ? 8 : (field.getFieldType() instanceof FieldTypeInteger ? 6 : (field.getFieldType() instanceof FieldTypeSelect_Int ? 6 : (field.getFieldType() instanceof FieldTypeSelect_String ? 11 : (field.getFieldType() instanceof FieldTypeGUID ? 11 : (field.getFieldType() instanceof FieldTypeTime ? 10 : (field.getFieldType() instanceof FieldTypeCurrency ? 7 : (field.getFieldType() instanceof FieldTypeDouble ? 6 : (field.getFieldType() instanceof FieldTypeRating ? 6 : 11)))))))))));
            String columnName = table.equals("TicketById") ? fieldDef.getKey() : fieldDef.getLabel();
            cols.add(Map.entry(fieldDef.getKey(), new HDReporting.ColumnInfoWithLabel(fieldDef.getKey(), columnName, reportFieldType)));
        }
        ServerPluginManager.getInstance().get(TicketDataSourceConfigurationExtension.class).forEach(ext -> ext.patchColumns(cols));
        return cols;
    }

    private Field<?> getFieldOrAttributeFromKey(@Nonnull String fieldKey) {
        TicketField field = Tickets.getFieldByKey(fieldKey);
        if (field == null && (field = Tickets.getAttributeByKey(fieldKey)) == null && fieldKey.equals("ticketid")) {
            field = Tickets.ATTRIBUTE_TICKET_ID;
        }
        return field;
    }

    private Set<Integer> getTicketsByParameter(TableSource ts) throws ReportException {
        String databaseIdentifier = ts.getDatabaseIdentifier();
        if (databaseIdentifier != null) {
            if ("TicketById".equals(databaseIdentifier)) {
                PromptField promptField = (PromptField)ts.getInputParameters().get(0);
                Object value = promptField.getValue();
                Integer ticketId = ((Number)value).intValue();
                if (ticketId != null && TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketId)) {
                    return Set.of(ticketId);
                }
                return Set.of();
            }
            if ("TicketAdhoc".equals(databaseIdentifier)) {
                Optional<PromptField> promptField = ts.getInputParameters().stream().filter(f -> f.getName().equals("TicketSearchPhrase")).findFirst();
                if (promptField.isPresent()) {
                    Object value = promptField.get().getValue();
                    String json = (String)value;
                    DataViewConditions filter = (DataViewConditions)new Json().fromJson(json, DataViewConditions.class);
                    if (filter == null) {
                        return Set.of();
                    }
                    Function<String, Field<?>> hasSearchtag = column -> {
                        TicketField field = Tickets.getFieldByKey(column);
                        if (field != null) {
                            return field;
                        }
                        TicketAttribute att = Tickets.getAttributeByKey(column);
                        if (att != null) {
                            return att;
                        }
                        if ("ticketid".equals(column)) {
                            return Tickets.ATTRIBUTE_TICKET_ID;
                        }
                        return null;
                    };
                    AndSearchExpression expression = HDReporting.buildSearchPhraseExpression(filter, "TicketAdhoc", hasSearchtag, TicketManager.getReader().getSearchEngine());
                    SearchCommand comand2 = new SearchCommand(new SearchExpression[]{expression});
                    OrSearchExpression globalSearchExpressionForAllVisibleTickets = GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(UserManager.getInstance().getCurrentUserAccountID(), ClientLocale.getThreadLocale());
                    if (globalSearchExpressionForAllVisibleTickets != null) {
                        comand2.getSearchExpression().add((SearchExpression)globalSearchExpressionForAllVisibleTickets);
                    }
                    comand2.getSearchExpression().add((SearchExpression)new SearchCondition("bundleslave", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagBundleSlave.FALSE));
                    ServerPluginManager.getInstance().get(TicketDataSourceConfigurationExtension.class).forEach(ext -> ext.patchSearchCommand(comand2));
                    Set resultFromPrompt = TicketManager.getReader().getSearchEngine().simpleSearch(comand2);
                    return resultFromPrompt;
                }
                return Set.of();
            }
        }
        throw ReportExceptionFactory.createReportException((ErrorCode)ReportErrorCode.TableNotFound, (Object[])new Object[]{ts.getDatabaseIdentifier()});
    }

    private void addPromptParameter(List<ColumnInfo> cols, TableSource ts) throws ReportException {
        if (ts.getDatabaseIdentifier().equals("TicketById")) {
            cols.add(new ColumnInfo("TicketId", 6, 1, 4, 0));
        } else if (ts.getDatabaseIdentifier().equals("TicketAdhoc")) {
            cols.add(new ColumnInfo("TicketSearchPhrase", 11, 1, 12, 0));
        }
    }
}

