/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugin;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationChangeEvent;
import com.inet.config.ConfigurationChangeListener;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationManagerImpl;
import com.inet.config.ConfigurationModificationEvent;
import com.inet.config.recovery.RecoveryLauncher;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.HelpDeskInstanceName;
import java.awt.GraphicsEnvironment;
import java.security.AccessController;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;

public class HdStandaloneConfiguration
extends RecoveryLauncher {
    public static void main(String[] args) throws Exception {
        new HdStandaloneConfiguration().mainLoop(args);
    }

    protected void start() throws Exception {
        if (ConfigurationManager.getRecoveryConfiguration() == null) {
            String name = HelpDeskInstanceName.get();
            int scope = ConfigurationManagerImpl.isWriteable((int)1) ? 1 : 2;
            String fullName = ConfigurationManager.getScopeName((int)scope) + '/' + name;
            ConfigurationManager.setRecoveryConfiguration((String)fullName);
        }
        super.start();
    }

    protected Properties createProperties(boolean logFile) throws Exception {
        Properties props = super.createProperties(logFile);
        final ConfigurationManager manager = ConfigurationManager.getInstance();
        final Configuration configuration = manager.get(ConfigurationManager.getRecoveryConfiguration());
        if (configuration == null) {
            return props;
        }
        manager.addConfigurationChangeListener(new ConfigurationChangeListener(){

            public void configurationChanged(ConfigurationChangeEvent ev) {
                block3: {
                    String[] syncKeys;
                    block2: {
                        syncKeys = new String[]{HDConfigKeys.DB_CONFIGS.getKey(), ConfigKey.LICENSEKEY.getKey(), ConfigKey.APP_DATA_PATH.getKey()};
                        if (ev.getType() != 0) break block2;
                        for (String key : syncKeys) {
                            manager.getCurrent().put(key, configuration.get(key));
                        }
                        break block3;
                    }
                    if (ev.getType() != 2 || !configuration.getName().equals(ev.getChangedConfigurationName()) || configuration.getScope() != ev.getChangedConfigurationScope()) break block3;
                    List changedKeys = ((ConfigurationModificationEvent)ev).getChangedKeys();
                    for (String key : syncKeys) {
                        if (!changedKeys.contains(key)) continue;
                        manager.getCurrent().put(key, configuration.get(key));
                    }
                }
            }
        });
        return props;
    }

    static {
        try {
            AccessController.doPrivileged(() -> {
                String str = System.getProperty("java.vm.specification.version");
                double version = Double.parseDouble(str);
                String msg = version < 17.0 ? "Your Java version " + str + " is too old. Please try a newer version of Java. The minimum version is " + 17 + "\nCurrent Java installation directory: " + System.getProperty("java.home") : (version >= 25.0 ? "Your Java version " + str + " is too new and has never been tested with this software. Please update to the latest version of the product or switch to Java version " + 24 + "\nCurrent Java installation directory: " + System.getProperty("java.home") : null);
                if (msg != null) {
                    if (GraphicsEnvironment.isHeadless()) {
                        System.err.println(msg);
                    } else {
                        JOptionPane.showMessageDialog(null, msg, "Setup Error", 0);
                    }
                }
                return null;
            });
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
    }
}

