/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.helpdesk.core.ticketmanager.extension.EmailReceivedArgument;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.mail.reader.ProcessingMailData;
import com.inet.helpdesk.mail.reader.RawReadMailData;
import com.inet.helpdesk.mail.reader.ResponseType;
import com.inet.mail.api.AttachedFile;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.List;
import javax.annotation.Nullable;

public class TMReceivedMailDataArgument
implements EmailReceivedArgument {
    private Integer ticketStatusChangedByTrigger = null;
    private long receivedDate;
    private String senderMail;
    private String senderName;
    private UserAccount senderAccount;
    private String receiverMail;
    private String receiverCCMail;
    private MutableReaStepText contentText;
    private String subject;
    private String acknowledgeString;
    private MutableTicketData changedTicketFields;
    private List<AttachedFile> attachments;
    private long wiedervorlageDateChangedByTrigger;
    private ResponseType responseType;
    private String messageId;
    private String referenceId;

    public TMReceivedMailDataArgument(ProcessingMailData mailData, RawReadMailData rawData) {
        this.ticketStatusChangedByTrigger = mailData.getTicketStatusChangedByTrigger();
        this.receivedDate = mailData.getReceivedDate();
        this.senderMail = mailData.getSenderMail();
        this.senderName = mailData.getSenderName();
        this.receiverMail = rawData.getReceiverMail();
        this.receiverCCMail = rawData.getReceiverCCMail();
        this.contentText = mailData.getContentText();
        this.subject = mailData.getSubject();
        this.acknowledgeString = mailData.getAcknowledgeString();
        this.changedTicketFields = mailData.getChangedTicketFields();
        this.senderAccount = mailData.getSenderUserAccount();
        this.attachments = rawData.getAttachments();
        this.wiedervorlageDateChangedByTrigger = mailData.getWiedervorlageDateChangedByTrigger();
        this.responseType = mailData.getResponseType();
        this.messageId = rawData.getHeaderValues().get("Message-ID".toLowerCase());
        this.referenceId = rawData.getHeaderValues().get("References".toLowerCase());
    }

    @Nullable
    public Integer getTicketStatusChangedByTrigger() {
        return this.ticketStatusChangedByTrigger;
    }

    public long getReceivedDate() {
        return this.receivedDate;
    }

    public String getSenderMail() {
        return this.senderMail;
    }

    @Nullable
    public String getSenderName() {
        return this.senderName;
    }

    public String getReceiverMail() {
        return this.receiverMail;
    }

    public String getReceiverCCMail() {
        return this.receiverCCMail;
    }

    public MutableReaStepText getContentText() {
        return this.contentText;
    }

    public MutableTicketData getChangedTicketFields() {
        return this.changedTicketFields;
    }

    public String getReaStepDescriptionString() {
        String description = this.subject;
        if (description != null && description.length() > 255) {
            description = description.substring(0, 255);
        }
        return description;
    }

    @Nullable
    public String getAcknowledgeString() {
        return this.acknowledgeString;
    }

    @Nullable
    public UserAccount getSenderAccount() {
        return this.senderAccount;
    }

    @Override
    public List<AttachedFile> getAttachments() {
        return this.attachments;
    }

    public long getWiedervorlageDateChangedByTrigger() {
        return this.wiedervorlageDateChangedByTrigger;
    }

    public ResponseType getResponseType() {
        return this.responseType;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }
}

