/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.mail.reader.EmailReader_HDProcessing;
import com.inet.helpdesk.mail.reader.MailType;
import com.inet.helpdesk.mail.reader.RawReadMailData;
import com.inet.helpdesk.mail.reader.ResponseType;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProcessingMailData {
    private Integer ticketStatusChangedByTrigger = null;
    private long receivedDate;
    private String senderMail;
    private String senderName;
    private String recipient;
    private MutableReaStepText contentText;
    private String subject;
    private MutableTicketData changedticketFields = new MutableTicketData();
    private MutableUserData changedUserFields = new MutableUserData();
    private Integer ticketId;
    private Map<String, String> customParameterMap = new HashMap<String, String>();
    private ResponseType responseType = new ResponseType();
    private UserAccount senderUserAccount;
    private boolean isBounceMail;
    private boolean newUserCanBeCreated;
    private EmailAccount readInAccount;
    private ProcessingMailData backup;
    private String acknowledgeString;
    private long wiedervorlageDate;
    private GUID fallbackOwnerGUID;

    public ProcessingMailData(@Nonnull EmailAccount emailAccount, RawReadMailData rawData) {
        this.readInAccount = emailAccount;
        this.setSenderMail(rawData.getSenderMail());
        this.setSenderName(rawData.getSenderName());
        this.setRecipient(rawData.getReceiverMail());
        this.setSubject(rawData.getSubject());
        this.setResourceId(emailAccount.getResID() == 0 ? null : Integer.valueOf(emailAccount.getResID()));
        this.setContentText(MutableReaStepText.of(rawData.getContent(), rawData.getMailType() == MailType.HTML));
        long received = (Boolean)EmailReader_HDProcessing.MAIL_USE_RECEIVED_DATE.get() != false ? rawData.getReceiveDate() : System.currentTimeMillis();
        this.setReceivedDate(received);
        this.setAcknowledgeStringIfNotSetYet(rawData.getAcknowledgeString());
        this.setNewUserCanBeCreated(emailAccount.getNewUser());
    }

    private ProcessingMailData() {
    }

    private void setResourceId(@Nullable Integer resId) {
        if (resId == null) {
            this.changedticketFields.remove(Tickets.FIELD_RESOURCE_GUID);
        } else {
            this.changedticketFields.put(Tickets.FIELD_RESOURCE_GUID, HDUsersAndGroups.getResourceGroupUUID(resId));
        }
    }

    public void setTicketStatusChangedByTrigger(Integer status) {
        this.ticketStatusChangedByTrigger = status;
    }

    public void setReceivedDate(long receivedDate) {
        this.receivedDate = receivedDate;
    }

    public void setSenderMail(@Nonnull String senderMail) {
        this.senderMail = senderMail;
    }

    public void setSenderName(@Nullable String senderName) {
        this.senderName = senderName != null ? senderName.trim() : null;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setContentText(MutableReaStepText contentText) {
        this.contentText = contentText;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Integer getTicketStatusChangedByTrigger() {
        return this.ticketStatusChangedByTrigger;
    }

    @Nonnull
    public String getSenderMail() {
        return this.senderMail;
    }

    protected String getRecipient() {
        return this.recipient;
    }

    public long getReceivedDate() {
        return this.receivedDate;
    }

    @Nullable
    public String getSenderName() {
        return this.senderName;
    }

    @Nonnull
    public MutableReaStepText getContentText() {
        return this.contentText;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @Nonnull
    public MutableTicketData getChangedTicketFields() {
        return this.changedticketFields;
    }

    @Nullable
    public Integer getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(Integer ticketId) {
        if (ticketId != null && ticketId < 0) {
            throw new IllegalArgumentException(String.valueOf(ticketId));
        }
        this.ticketId = ticketId;
    }

    @Nullable
    public GUID getResourceId() {
        return this.changedticketFields.get(Tickets.FIELD_RESOURCE_GUID);
    }

    public Map<String, String> getCustomParameterMap() {
        return this.customParameterMap;
    }

    @Nonnull
    public ResponseType getResponseType() {
        return this.responseType;
    }

    @Nullable
    public UserAccount getSenderUserAccount() {
        return this.senderUserAccount;
    }

    public void setSenderUserAccountAndUpdateSenderName(@Nonnull UserAccount senderUserAccount) {
        if (senderUserAccount == null) {
            throw new IllegalArgumentException();
        }
        this.senderUserAccount = senderUserAccount;
        this.setSenderName(senderUserAccount.getDisplayName());
    }

    public boolean isNewUserCanBeCreated() {
        return this.newUserCanBeCreated;
    }

    public void setNewUserCanBeCreated(boolean newUserCanBeCreated) {
        this.newUserCanBeCreated = newUserCanBeCreated;
    }

    @Nonnull
    public EmailAccount getReadInAccount() {
        return this.readInAccount;
    }

    public boolean isBounceMail() {
        return this.isBounceMail;
    }

    public void setBounceMail(boolean isBounceMail) {
        this.isBounceMail = isBounceMail;
    }

    public void backup() {
        this.backup = new ProcessingMailData();
        this.backup.changedticketFields = new MutableTicketData();
        this.backup.changedticketFields.putAll(this.changedticketFields);
        this.backup.changedUserFields = new MutableUserData();
        this.changedUserFields.getIncludedFields().forEach(f -> this.backup.changedUserFields.put(f, this.changedUserFields.get(f)));
        this.backup.contentText = MutableReaStepText.of(this.contentText.getText(), this.contentText.isHtml());
        this.backup.customParameterMap = new HashMap<String, String>(this.customParameterMap);
        this.backup.isBounceMail = this.isBounceMail;
        this.backup.newUserCanBeCreated = this.newUserCanBeCreated;
        this.backup.readInAccount = this.readInAccount;
        this.backup.receivedDate = this.receivedDate;
        this.backup.responseType = this.responseType;
        this.backup.senderMail = this.senderMail;
        this.backup.senderName = this.senderName;
        this.backup.senderUserAccount = this.senderUserAccount;
        this.backup.subject = this.subject;
        this.backup.ticketId = this.ticketId;
        this.backup.ticketStatusChangedByTrigger = this.ticketStatusChangedByTrigger;
    }

    public void restoreFromBackup() {
        if (this.backup == null) {
            throw new IllegalStateException("Kein Backup angelegt!");
        }
        this.changedticketFields = this.backup.changedticketFields;
        this.changedUserFields = this.backup.changedUserFields;
        this.contentText = this.backup.contentText;
        this.customParameterMap = this.backup.customParameterMap;
        this.isBounceMail = this.backup.isBounceMail;
        this.newUserCanBeCreated = this.backup.newUserCanBeCreated;
        this.readInAccount = this.backup.readInAccount;
        this.receivedDate = this.backup.receivedDate;
        this.responseType = this.backup.responseType;
        this.senderMail = this.backup.senderMail;
        this.senderName = this.backup.senderName;
        this.senderUserAccount = this.backup.senderUserAccount;
        this.subject = this.backup.subject;
        this.ticketId = this.backup.ticketId;
        this.ticketStatusChangedByTrigger = this.backup.ticketStatusChangedByTrigger;
        this.backup = null;
    }

    public MutableUserData getChangedUserFields() {
        return this.changedUserFields;
    }

    public String getAcknowledgeString() {
        return this.acknowledgeString;
    }

    public void setAcknowledgeStringIfNotSetYet(String acknowledgeString) {
        if (this.acknowledgeString == null) {
            this.acknowledgeString = acknowledgeString;
        }
    }

    public void setWiedervorlageDateByTrigger(long time) {
        this.wiedervorlageDate = time;
    }

    public long getWiedervorlageDateChangedByTrigger() {
        return this.wiedervorlageDate;
    }

    public void setFallbackAccountForTicketOwner(GUID fallbackOwnerGUID) {
        this.fallbackOwnerGUID = fallbackOwnerGUID;
    }

    public GUID getFallbackOwnerGUID() {
        return this.fallbackOwnerGUID;
    }
}

