/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.mail.reader.EmailReader_HDProcessing;
import com.inet.helpdesk.mail.reader.EmailReader_Job;
import com.inet.logging.Logger;
import com.inet.persistence.MaintenanceMode;
import com.inet.thread.job.Job;
import com.inet.thread.job.manager.JobManager;
import java.util.HashMap;
import java.util.Map;
import srv.HdLicenseObserver;
import srv.ServerUtilities;
import srv.WriteThreadDump;
import srv.mail.CombinationCheck;
import srv.mail.MailConnectionErrorNotification;

public class EmailReader_Main {
    private static final ConfigValue<Boolean> MAIL_ACCOUNTS_DISABLED = new ConfigValue(HDConfigKeys.MAIL_ACCOUNTS_DISABLED);
    public static final ConfigValue<EmailAccountList> MAIL_ACCOUNTS = new ConfigValue<EmailAccountList>(HDConfigKeys.MAIL_ACCOUNTS){

        protected void setValue(String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            ServerUtilities.realizeImapChange();
        }
    };
    public static final Logger LOGGER = EmailReader_HDProcessing.LOGGER;
    public static final String ERROR_MAILS = "HD_Error_Messages";
    private CombinationCheck mailCombiner = new CombinationCheck();
    public static final ThreadLocal<Integer> usersCount;
    private Map<String, EmailReader_Job> activeJobs = new HashMap<String, EmailReader_Job>();
    private Map<String, Integer> hangingJobsWithMessageIndexOfLastIteration = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMails() {
        if (((Boolean)MAIL_ACCOUNTS_DISABLED.get()).booleanValue()) {
            return;
        }
        if (MaintenanceMode.getState() != MaintenanceMode.NONE) {
            return;
        }
        this.mailCombiner.cleanUp();
        LOGGER.debug((Object)("Start Mail Debug " + LOGGER.isDebug()));
        EmailAccountList accounts = (EmailAccountList)MAIL_ACCOUNTS.get();
        for (EmailAccount account : accounts) {
            String accountId = account.getID();
            JobManager jobManager = JobManager.instance();
            Map<String, EmailReader_Job> map = this.activeJobs;
            synchronized (map) {
                if (this.activeJobs.containsKey(accountId)) {
                    this.handleHangingJob(account, jobManager);
                    continue;
                }
                EmailReader_Job job = new EmailReader_Job(account, this.mailCombiner, () -> {
                    Map<String, EmailReader_Job> map = this.activeJobs;
                    synchronized (map) {
                        this.activeJobs.remove(accountId);
                        this.hangingJobsWithMessageIndexOfLastIteration.remove(accountId);
                        if (this.activeJobs.isEmpty()) {
                            MailConnectionErrorNotification.clearUnusedErrors();
                        }
                    }
                });
                this.activeJobs.put(accountId, job);
                JobManager.JobSubmitData data = jobManager.submitManagedJob((Job)job);
                job.setJobData((JobManager.JobSubmitData<Void>)data);
            }
        }
    }

    private void handleHangingJob(EmailAccount account, JobManager jobManager) {
        LOGGER.error((Object)String.format("Email reading process for account %s is still running!", account.getDisplayString()));
        EmailReader_Job hanging = this.activeJobs.get(account.getID());
        Integer lastMessageIndex = this.hangingJobsWithMessageIndexOfLastIteration.get(account.getID());
        if (lastMessageIndex != null && hanging.getCurrentMessageIndex() == lastMessageIndex.intValue()) {
            LOGGER.error((Object)String.format("Try terminate Email-Reading process for account %s!", account.getDisplayString()));
            jobManager.terminateJob(hanging.getJobData().getUuid());
            new WriteThreadDump();
            return;
        }
        this.hangingJobsWithMessageIndexOfLastIteration.put(account.getID(), hanging.getCurrentMessageIndex());
    }

    static {
        System.setProperty("mail.mime.encodefilename", "true");
        System.setProperty("mail.mime.encodeparameters", "false");
        System.setProperty("mail.mime.charset", "UTF-8");
        System.setProperty("mail.mime.decodetext.strict", "false");
        System.setProperty("mail.mime.base64.ignoreerrors", "true");
        usersCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                int currentActiveUserCount = HdLicenseObserver.getCurrentActiveUserCount();
                if (currentActiveUserCount == -1) {
                    LOGGER.fatal((Object)"Error trying to count active users");
                    throw new IllegalStateException("Error trying to count active users");
                }
                return currentActiveUserCount;
            }
        };
    }
}

