/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.EmailProtocol;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.TempDirectory;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.mail.reader.EmailReader_ErrorHandler;
import com.inet.helpdesk.mail.reader.EmailReader_HDProcessing;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.mail.reader.EmailReader_RawReader;
import com.inet.helpdesk.mail.reader.RawReadMailData;
import com.inet.helpdesk.mail.reader.ReadMailResult;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.plugins.attachments.server.AttachmentsServerPlugin;
import com.inet.lib.util.StringFunctions;
import com.inet.mail.api.AttachedFile;
import com.inet.mail.api.BaseEmail;
import com.inet.mail.api.processor.InMailProcessor;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.job.Job;
import com.inet.thread.job.TerminatedBy;
import com.inet.thread.job.manager.JobManager;
import com.inet.thread.job.manager.JobStore;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import srv.mail.CombinationCheck;
import srv.mail.MailConnectionCreator;
import srv.mail.MailFileMethods;

public class EmailReader_Job
implements Job<Void> {
    private MailFileMethods mailFileMethods = new MailFileMethods();
    private EmailReader_RawReader rawRaeder = new EmailReader_RawReader(this.mailFileMethods);
    private EmailReader_HDProcessing readLogic = new EmailReader_HDProcessing();
    private EmailReader_ErrorHandler errorHandler = new EmailReader_ErrorHandler();
    private final EmailAccount emailAccount;
    private final CombinationCheck mailCombiner;
    private final MailConnectionCreator.SessionStoreStatus status = new MailConnectionCreator.SessionStoreStatus();
    private Folder folder;
    private int currentMessageIndex;
    private Message currentMessage;
    private boolean running;
    private boolean terminating;
    private BaseRunnableSession session = new BaseRunnableSession();
    private JobManager.JobSubmitData<Void> jobData;
    private double progress = 0.0;
    private double progressPerMail;
    private static final Object LOCK_UPDATE_ERROR_IN_MAIL_ACCOUNT = new Object();
    private Runnable finallyBlock;

    public EmailReader_Job(EmailAccount emailAccount, CombinationCheck mailCombiner, Runnable finallyBlock) {
        this.emailAccount = emailAccount;
        this.mailCombiner = mailCombiner;
        this.finallyBlock = finallyBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void call() throws Exception {
        this.running = true;
        try {
            Thread.currentThread().setContextClassLoader(BaseEmail.class.getClassLoader());
            this.folder = MailConnectionCreator.getConnectedFolder(this.emailAccount, this.status, 30000, 30000);
            int messageCount = this.folder.getMessageCount();
            if (messageCount > 0) {
                int start;
                Message[] msgs;
                if (messageCount > 1) {
                    EmailReader_HDProcessing.LOGGER.info((Object)("EMail: " + messageCount + " neue E-Mails in " + this.emailAccount.getDisplayString()));
                } else {
                    EmailReader_HDProcessing.LOGGER.info((Object)("EMail: eine neue E-Mail in " + this.emailAccount.getDisplayString()));
                }
                this.progressPerMail = 100.0 / (double)messageCount;
                HashSet<Integer> idsOfProcessedTickets = new HashSet<Integer>();
                int end = messageCount;
                while (end > 0 && this.process50Mails(msgs = this.folder.getMessages(start = end > 50 ? end - 50 : 1, end), this.emailAccount, idsOfProcessedTickets, end)) {
                    end = start - 1;
                }
            }
            this.saveErrorMessageInEmailAccountIfHasChanged("");
        }
        catch (HelpDeskServerException connectError) {
            connectError = new HelpDeskServerException("Error from Mail server: " + connectError.getMessage(), (Throwable)connectError, connectError.getErrorCode());
            this.errorHandler.connectFailed(this.emailAccount, connectError.getMessage());
            this.saveErrorMessageInEmailAccountIfHasChanged(connectError.getMessage());
            EmailReader_HDProcessing.LOGGER.error((Throwable)connectError);
        }
        catch (Exception e2) {
            MessagingException e2;
            if (e2 instanceof MessagingException) {
                e2 = new MessagingException("Error from Mail server: " + e2.getMessage(), e2);
            }
            EmailReader_HDProcessing.LOGGER.error((Object)String.format("Exception while reading E-mails from %s. Reading of emails stopped!", this.emailAccount.getDisplayString()));
            EmailReader_HDProcessing.LOGGER.error((Throwable)e2);
            this.errorHandler.unexpectedReadError(this.emailAccount, e2.getMessage());
        }
        finally {
            if (!this.terminating) {
                this.closeEmailFolderAndStore();
            }
            this.running = false;
            this.finallyBlock.run();
        }
        return null;
    }

    private void closeEmailFolderAndStore() {
        if (this.folder != null && this.folder.isOpen()) {
            try {
                this.folder.close(true);
            }
            catch (Throwable mex) {
                EmailReader_HDProcessing.LOGGER.error(mex);
            }
        }
        if (this.status.getStore() != null && this.status.getStore().isConnected()) {
            try {
                this.status.getStore().close();
            }
            catch (Throwable mex) {
                EmailReader_HDProcessing.LOGGER.error(mex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveErrorMessageInEmailAccountIfHasChanged(String error) {
        Object object = LOCK_UPDATE_ERROR_IN_MAIL_ACCOUNT;
        synchronized (object) {
            EmailAccountList accounts = (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
            EmailAccount emailAccount2 = accounts.getById(this.emailAccount.getID());
            if (emailAccount2 != null && !Objects.equals(error, emailAccount2.getErrorMessage())) {
                if (emailAccount2.getErrorMessage() != null && !emailAccount2.getErrorMessage().isBlank() && (error == null || error.isBlank())) {
                    this.errorHandler.connectionRestored(this.emailAccount);
                }
                emailAccount2.setErrorMessage(error);
                ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.MAIL_ACCOUNTS.getKey(), accounts.toString());
            }
        }
    }

    private boolean process50Mails(Message[] msgs, EmailAccount account, Set<Integer> idsOfProcessedTickets, int endIndex) throws MessagingException {
        if (endIndex < msgs.length) {
            throw new IllegalArgumentException("endIndex=" + endIndex + " msgs=" + msgs.length);
        }
        List processors = ServerPluginManager.getInstance().get(InMailProcessor.class);
        int i = msgs.length - 1;
        while (i >= 0) {
            this.currentMessageIndex = endIndex;
            Message msg = this.currentMessage = msgs[i];
            ReadMailResult actionForMail = this.readSingleMail(msg, account, processors, idsOfProcessedTickets);
            this.progress += this.progressPerMail;
            JobStore.get((Job)this).getJobProgressUpdater().updateProgress((int)this.progress);
            if (actionForMail == ReadMailResult.ERROR_STOP_READING) {
                return false;
            }
            if (actionForMail == ReadMailResult.ERROR_DROP_MAIL || actionForMail == ReadMailResult.SUCCESS_REMOVE_MAIL) {
                this.currentMessage.setFlags(new Flags(Flags.Flag.DELETED), true);
                if (account.getProtocol() != EmailProtocol.POP3 || !StringFunctions.isEmpty((String)account.getProvider())) {
                    this.folder.expunge();
                }
            } else {
                String problemMessage = actionForMail.getMessage();
                this.moveProblematicMailToErrorFolder(problemMessage);
                this.errorHandler.readMailFailed(this.emailAccount, problemMessage);
            }
            --i;
            --endIndex;
        }
        this.currentMessage = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadMailResult readSingleMail(Message msg, EmailAccount account, List<InMailProcessor> processors, Set<Integer> idsOfProcessesTickets) {
        ReadMailResult actionForMail;
        block9: {
            try {
                InMailProcessor processor;
                Iterator<InMailProcessor> iterator = processors.iterator();
                while (iterator.hasNext() && (msg = (processor = iterator.next()).process(msg)) != null) {
                }
                if (msg == null) {
                    actionForMail = ReadMailResult.ERROR_DROP_MAIL;
                    break block9;
                }
                RawReadMailData readRawMailData = this.rawRaeder.readRawMailData(msg, account);
                try {
                    actionForMail = this.readLogic.readMail(readRawMailData, this.mailCombiner, account, idsOfProcessesTickets);
                    if (!actionForMail.is_Move_Mail_To_Error_Folder() && readRawMailData.isErrorInAttachments()) {
                        this.moveProblematicMailToErrorFolder("Could not read attachments");
                    }
                }
                finally {
                    this.deleteReferencedFilesFromDirAttachmentsPuffer(readRawMailData.getAttachments());
                }
            }
            catch (CancellationException aborted) {
                EmailReader_HDProcessing.LOGGER.error((Throwable)aborted);
                actionForMail = ReadMailResult.ERROR_STOP_READING;
            }
            catch (Throwable th) {
                EmailReader_HDProcessing.LOGGER.error(th);
                actionForMail = ReadMailResult.ERROR_MOVE_MAIL_TO_ERROR_FOLDER(th.getMessage());
            }
        }
        return actionForMail;
    }

    private void deleteReferencedFilesFromDirAttachmentsPuffer(List<AttachedFile> attachmentFiles) {
        for (AttachedFile att : attachmentFiles) {
            File file = att.getFile();
            File parentFile = file.getParentFile();
            if (parentFile == null || !TempDirectory.ATTACHMENTS_PUFFER.endsWith(parentFile.toPath())) continue;
            try {
                file.delete();
            }
            catch (Exception ex) {
                AttachmentsServerPlugin.LOGGER.error((Throwable)new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.ATTACHMENT_FILE_ERROR));
            }
        }
    }

    private void moveProblematicMailToErrorFolder(String errorAdditionals) {
        this.moveProblematicMailToErrorFolder(this.currentMessage, errorAdditionals);
    }

    private void moveProblematicMailToErrorFolder(Message currentMessage, String errorAdditionals) {
        if (this.emailAccount.getProtocol() != EmailProtocol.POP3) {
            try {
                String errorFolderName = "HD Error Messages";
                Folder errorFolder = this.folder.getParent().getFolder(errorFolderName);
                if (!(errorFolder.exists() || errorFolder.create(1) || (errorFolder = this.folder.getFolder(errorFolderName)).exists() || errorFolder.create(1))) {
                    EmailReader_HDProcessing.LOGGER.error((Object)"Cannot create folder for error message!!");
                }
                Message[] msgsToCopy = new Message[]{currentMessage};
                currentMessage.setFlags(new Flags(Flags.Flag.DELETED), false);
                this.folder.copyMessages(msgsToCopy, errorFolder);
                currentMessage.setFlags(new Flags(Flags.Flag.DELETED), true);
                this.folder.expunge();
            }
            catch (Throwable errx) {
                EmailReader_HDProcessing.LOGGER.error(errx);
            }
        } else {
            PersistenceEntry errorMails = AppDataLocation.getAttachmentDirectory().resolve("HD_Error_Messages");
            PersistenceEntry file = errorMails.resolve(System.currentTimeMillis() + ".mim");
            try {
                this.mailFileMethods.writePartToFile(file, (Part)currentMessage, false, null, null);
                currentMessage.setFlags(new Flags(Flags.Flag.DELETED), true);
            }
            catch (Throwable ex) {
                try {
                    EmailReader_HDProcessing.LOGGER.error((Object)("Emailreader: : Message: \"" + currentMessage.getSubject() + "\" failed to save in HD_Error_Messages"));
                }
                catch (Exception logEx) {
                    EmailReader_HDProcessing.LOGGER.error(ex);
                }
            }
        }
    }

    public RunnableSession getSession() {
        return this.session;
    }

    public int estimatedMemory() {
        return 1;
    }

    public long memorySize() {
        return 0x100000L;
    }

    public long swapSize() {
        return 0L;
    }

    public void terminate(TerminatedBy terminatedBy) {
        try {
            this.terminating = true;
            EmailReader_HDProcessing.LOGGER.error((Object)String.format("Terminate Email-Reading process for account %s!", this.emailAccount.getDisplayString()));
            this.tryAbortEmailReading(this.currentMessage);
            this.closeEmailFolderAndStore();
            this.errorHandler.stopHangingMail(this.emailAccount, "Forced interruption of the import process");
            this.waitForReadingToStop(60000L);
        }
        finally {
            this.finallyBlock.run();
        }
        EmailReader_HDProcessing.LOGGER.error((Object)String.format("Termination of hanging E-mail process for account %s ended", this.emailAccount.getDisplayString()));
    }

    private void waitForReadingToStop(long timeoutMillis) {
        long timeout = System.currentTimeMillis() + timeoutMillis;
        while (System.currentTimeMillis() < timeout) {
            if (!this.running) {
                EmailReader_HDProcessing.LOGGER.debug((Object)("Stopped " + this.name()));
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                EmailReader_HDProcessing.LOGGER.error((Throwable)e);
            }
        }
        EmailReader_HDProcessing.LOGGER.fatal((Object)String.format("Timed out waiting for %s to stop ", this.name()));
    }

    private void tryAbortEmailReading(Message message) {
        if (message == null) {
            EmailReader_HDProcessing.LOGGER.warn((Object)"No mail is being read");
            return;
        }
        EmailReader_HDProcessing.LOGGER.info((Object)"Try abort email reading");
        this.rawRaeder.abortReading();
        if (this.mailFileMethods.isOutputStreamUsed()) {
            try {
                EmailReader_HDProcessing.LOGGER.error((Object)"Killing Outputstream!");
                this.mailFileMethods.closeOutputStream();
            }
            catch (Throwable e) {
                EmailReader_HDProcessing.LOGGER.error(e);
            }
        }
        this.moveProblematicMailToErrorFolder(message, "Forced interruption of the import process");
    }

    public long objectHandles() {
        return 10000L;
    }

    public String name() {
        return HelpdeskServerPlugin.MSG_SERVER.getMsg("emailreader.job.name", new Object[]{this.emailAccount.getDisplayString()});
    }

    public String jobType() {
        return HelpdeskServerPlugin.MSG_SERVER.getMsg("emailreader.job.type", new Object[0]);
    }

    public int getCurrentMessageIndex() {
        return this.currentMessageIndex;
    }

    public JobManager.JobSubmitData<Void> getJobData() {
        return this.jobData;
    }

    public void setJobData(JobManager.JobSubmitData<Void> jobData) {
        this.jobData = jobData;
    }
}

